/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.upgradeservice.util.FaPermissionUpgradeServiceImpl;

public class FaButtonPermissionUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(FaButtonPermissionUpgradeService.class);
    private static final String FA = "83bfebc800001aac";
    private static final String SELECT = "47150e89000000ac";
    private static final String TRACK_DOWN = "0K6+MBJ9Z/Y2";
    private static final String IMAGE_REVIEW = "/KT4ZAX6VRY0";
    private static final String VIEW_FLOWCHART = "0K6+MBJ9Z+KL";
    private static final String SUBMIT = "804f6478000000ac";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updatePermission("fa_card_real", TRACK_DOWN);
            this.updatePermission("fa_engineeringbill", TRACK_DOWN);
            this.updatePermission("fa_dispatch_in", IMAGE_REVIEW);
            this.updatePermission("fa_dispatch", IMAGE_REVIEW);
            this.updatePermission("fa_asset_requisition", SUBMIT, VIEW_FLOWCHART);
            this.updatePermission("fa_asset_apply", VIEW_FLOWCHART);
            log.info("UPGRADE_PERMISSION_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_PERMISSION_ERROR");
            result.setErrorInfo("UPGRADE_PERMISSION_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void updatePermission(String entityName, String ... newPermItem) {
        FaPermissionUpgradeServiceImpl upgradeService = new FaPermissionUpgradeServiceImpl();
        ArrayList<String> existPermInfoList = new ArrayList<String>(1);
        existPermInfoList.add(String.join((CharSequence)"_split_", SELECT, entityName, FA));
        List<String> newPermItemList = Arrays.asList(newPermItem);
        upgradeService.addPermItemsByExistPermItem(existPermInfoList, entityName, FA, newPermItemList);
    }
}

