/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaBizUtils;

public class FaChangeBillUpgradeServices2
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.fa.upgradeservice.FaChangeBillUpgradeServices2");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult realt = new UpgradeResult();
        try {
            this.upgrayChangebill();
            realt.setSuccess(true);
            log.info("UPGRADE_CHANGEBILL_SUCCESS");
        }
        catch (Exception e) {
            realt.setSuccess(false);
            log.info("UPGRADE_CHANGEBILL_ERROR");
            realt.setErrorInfo("UPGRADE_CHANGEBILL_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return realt;
    }

    public void upgrayChangebill() {
        DynamicObjectCollection chanegBillIds = QueryServiceHelper.query((String)"fa_change_dept", (String)"id", null);
        boolean defaultValue = false;
        Object[] deptBillIds = this.collectionToArray(chanegBillIds);
        if (deptBillIds != null) {
            DynamicObject[] changebills;
            block0: for (DynamicObject changebill : changebills = BusinessDataServiceHelper.load((Object[])deptBillIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_change_dept"))) {
                log.info("dept:" + changebill.getLong("id"));
                DynamicObjectCollection fieldentrys = changebill.getDynamicObjectCollection("fieldentry");
                DynamicObject org = changebill.getDynamicObject("org");
                QFilter forg = new QFilter("org", "=", org.getPkValue());
                for (DynamicObject fieldentry : fieldentrys) {
                    IDataEntityProperty dp = (IDataEntityProperty)fieldentry.getDataEntityType().getProperties().get((Object)"isadjustdepre1");
                    if (dp == null) {
                        DataEntityPropertyCollection dpcs = fieldentry.getDataEntityType().getProperties();
                        for (IDataEntityProperty dpc : dpcs) {
                            log.info("dept!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!:" + dpc.getName());
                        }
                    }
                    fieldentry.set("isadjustdepre1", (Object)defaultValue);
                    DynamicObject realCard = fieldentry.getDynamicObject("realcard1");
                    DynamicObject finCard = fieldentry.getDynamicObject("fincard1");
                    if (finCard == null) continue block0;
                    DynamicObject assetBook = finCard.getDynamicObject("assetbook");
                    DynamicObject depreuse = finCard.getDynamicObject("depreuse");
                    List assetPolicyInfo = AssetPolicyUtil.getAssetPolicyInfoByBookId((Object)assetBook.getPkValue());
                    Object catLongNo2 = realCard.getDynamicObject("assetcat").getPkValue();
                    DynamicObject assetcat = BusinessDataServiceHelper.loadSingle((Object)catLongNo2, (String)"fa_assetcategory");
                    String catLongNo = assetcat.getString("longnumber");
                    DynamicObject assetPolicyEntry = AssetPolicyUtil.getByAssetPolicyInfoAndCateLongNumber((String)catLongNo, (List)assetPolicyInfo);
                    assetBook = BusinessDataServiceHelper.loadSingle((Object)assetBook.getPkValue(), (String)"fa_assetbook");
                    DynamicObject curPeriod = assetBook.getDynamicObject("curperiod");
                    DynamicObject nextPeriod = FaBizUtils.queryNeighborPeriod((Object)curPeriod.getPkValue(), (int)1);
                    Date bizDate = null;
                    bizDate = assetPolicyEntry.getString("depreeffect").equals("CUR") ? curPeriod.getDate("begindate") : nextPeriod.getDate("begindate");
                    fieldentry.set("bizdate1", (Object)bizDate);
                    DynamicObjectCollection realentries = changebill.getDynamicObjectCollection("realentry");
                    for (DynamicObject realentry : realentries) {
                        long realCardId;
                        DynamicObject realEntryCard = realentry.getDynamicObject("realcard");
                        long realEntryCardId = realEntryCard.getLong("masterid");
                        if (realEntryCardId != (realCardId = realCard.getLong("masterid"))) continue;
                        this.upgeayRealchangeFinEntry(realCardId, realentry, bizDate, depreuse.getLong("id"));
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])changebills);
            log.info("DEPT_SUCCECC:" + changebills.length);
        }
    }

    private void upgeayRealchangeFinEntry(long realcardMasterid, DynamicObject RealEntryRow, Date bizDate, long realDepreuseId) {
        DynamicObjectCollection finentries = RealEntryRow.getDynamicObjectCollection("finentry");
        boolean defaultValue = false;
        for (DynamicObject finentry : finentries) {
            finentry.set("isadjustdepre", (Object)defaultValue);
            DynamicObject depreuse = finentry.getDynamicObject("depreuse");
            long depreuseId = depreuse.getLong("id");
            if (depreuseId != realDepreuseId) continue;
            finentry.set("bizdate", (Object)bizDate);
        }
    }

    public Long[] collectionToArray(DynamicObjectCollection idCollection) {
        if (idCollection == null || idCollection.size() == 0) {
            return null;
        }
        ArrayList<Long> idlist = new ArrayList<Long>();
        for (DynamicObject idDyn : idCollection) {
            idlist.add(idDyn.getLong("id"));
        }
        return idlist.toArray(new Long[0]);
    }
}

