/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class FaEngineerBillUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.fa.upgradeservice.FaEngineerBillUpgradeService");
    private static final String algoKey = "kd.fi.fa.upgradeservice.FaEngineerBillUpgradeService";
    private static final String QUERY = "select A.fid,A.fassetcatid,A.fassetname,A.funitid,A.fassetqty,A.fmodel,A.fstoreplaceid,A.fusedepartmentid,B.fcurrencyid,B.total from t_fa_engineeringbill A left join (select fcurrencyid,fid,sum(ftotalamount) total from t_fa_engineeringbillentry group by fid,fcurrencyid) B on A.fid=B.fid where A.fbusinesstype = ' ';";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.engineerBill();
            result.setSuccess(true);
            log.info("UPGRADE_FaEngineerBillUpgradeService_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_FaEngineerBillUpgradeService_ERROR");
            result.setErrorInfo("UPGRADE_FaEngineerBillUpgradeService_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void engineerBill() {
        DataSet engineerDs = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fa"), (String)QUERY);
        ArrayList<Object[]> paramAddEntryList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramBillList = new ArrayList<Object[]>(16);
        for (Row rowEntry : engineerDs) {
            paramAddEntryList.add(new Object[]{rowEntry.get("fassetcatid"), rowEntry.get("fassetname"), rowEntry.get("funitid"), rowEntry.get("fassetqty"), rowEntry.get("fmodel"), rowEntry.get("fstoreplaceid"), rowEntry.get("fusedepartmentid"), rowEntry.get("total"), rowEntry.get("fid"), this.getId()});
            paramBillList.add(new Object[]{rowEntry.get("fcurrencyid"), rowEntry.get("fid")});
        }
        String entrySql = "insert into t_fa_assetinfoaddentry (fassetcat,fassetname,funit,fassetqty,fmodel,fstoreplaceid,fusedepartmentid,foriginalval,fid,fentryid) values(?,?,?,?,?,?,?,?,?,?);";
        if (paramAddEntryList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)entrySql, paramAddEntryList);
        }
        String billSql = "update t_fa_engineeringbill set fcurrencyfieldid = ? ,fbusinesstype = '0' where fid = ? and fbusinesstype = ' ';";
        if (paramBillList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)billSql, paramBillList);
        }
    }

    private Long getId() {
        return DB.genLongId((String)"fa_engineeringbill");
    }
}

