/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class FaFileServicePictureUploadServiceImpl
implements IUpgradeService {
    private static final String[] PICTURES = new String[]{"fa_computercase_0_mS5Mj7klG7myMz48tZ_G7mfuvQK.png", "fa_delldisplay_0_CFxd0zWOvz7yiSeAFy_Xjdn5oQd.png", "fa_notebook_0_wMh7soRyMrsA6LmBhH_JeSwNmc8.png", "fa_otherasset_0_ZO5vdJCImg35yV6Ajx_wyal8Hzm.png"};

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle handle = TX.required();){
            try {
                for (String picture : PICTURES) {
                    this.fileServicePictureUpload(picture);
                }
                handle.commit();
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("fileServicePicture update failed :" + e.getMessage());
                handle.markRollback();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileServicePictureUpload(String fileName) throws IOException {
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream("/file/" + fileName);
            if (in == null) {
                throw new FileNotFoundException("classpath resource file not found:" + fileName);
            }
            byte[] data = new byte[in.available()];
            in.read(data);
            TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String url = tempFile.saveAsUrl(fileName, data, data.length);
            String path = "/FI/FA/";
            service.upload(new FileItem(fileName, path + fileName, tempFile.getInputStream(url)));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

