/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.common.util.Fa;

public class FaFinCardOriginalvalChgUpgradeServices
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.upgrade();
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo("UPGRADE_ORIVAL_CHG_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    public void upgrade() {
        String fields = Fa.comma((String[])new String[]{"realcard.masterid", "assetbook.id", Fa.dot((String[])new String[]{"assetbook", "startperiod"}), "bizperiod.id", "bizperiod.periodnumber", "finaccountdate", "originalval", "monthorigvalchg", "yearorigvalchg"});
        DynamicObject[] allfincards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)fields, (QFilter[])new QFilter[]{new QFilter("endperiod", ">", (Object)0L), new QFilter("finaccountdate", "!=", null), new QFilter(Fa.dot((String[])new String[]{"assetbook"}), ">", (Object)0L), new QFilter(Fa.dot((String[])new String[]{"assetbook", "startperiod"}), ">", (Object)0L)});
        Set periodIds = Stream.of(allfincards).map(v -> v.get(Fa.dot((String[])new String[]{"assetbook", "startperiod", "id"}))).collect(Collectors.toSet());
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,periodoutline.outlinebegindate", (QFilter[])new QFilter("id", "in", periodIds).toArray());
        HashMap<Object, Date> periodMap = new HashMap<Object, Date>();
        for (DynamicObject period : periods) {
            periodMap.put(period.get("id"), period.getDate("periodoutline.outlinebegindate"));
        }
        ArrayList<DynamicObject> FINCARD_ALTERED = new ArrayList<DynamicObject>();
        Map<Object, List<DynamicObject>> grp = Stream.of(allfincards).collect(Collectors.groupingBy(v -> v.get("realcard.masterid")));
        Collection<List<DynamicObject>> values = grp.values();
        for (List<DynamicObject> fincards_real : values) {
            grp = fincards_real.stream().collect(Collectors.groupingBy(v -> v.get("assetbook_id")));
            values = grp.values();
            for (List<DynamicObject> fincards : values) {
                fincards.sort((v1, v2) -> Integer.parseInt(v1.getLong("bizperiod_id") - v2.getLong("bizperiod_id") + ""));
                Date yearbegindate = (Date)periodMap.get(fincards.get(0).get(Fa.dot((String[])new String[]{"assetbook", "startperiod", "id"})));
                BigDecimal ORIGINALVAL = BigDecimal.ZERO;
                BigDecimal YEAR_VAL_CHG = BigDecimal.ZERO;
                if (fincards.get(0).getLong("bizperiod_id") == 0L) {
                    DynamicObject initCard = fincards.remove(0);
                    ORIGINALVAL = initCard.getBigDecimal("originalval");
                    Date finaccountdate = initCard.getDate("finaccountdate");
                    if (finaccountdate.compareTo(yearbegindate) >= 0) {
                        YEAR_VAL_CHG = ORIGINALVAL;
                        if (initCard.getBigDecimal("yearorigvalchg").compareTo(YEAR_VAL_CHG) != 0) {
                            initCard.set("yearorigvalchg", (Object)YEAR_VAL_CHG);
                            FINCARD_ALTERED.add(initCard);
                        }
                    }
                }
                for (DynamicObject fincard : fincards) {
                    BigDecimal month_originalval_chg = fincard.getBigDecimal("originalval").subtract(ORIGINALVAL);
                    YEAR_VAL_CHG = fincard.getInt("bizperiod.periodnumber") == 1 ? month_originalval_chg : YEAR_VAL_CHG.add(month_originalval_chg);
                    boolean altered = false;
                    if (fincard.getBigDecimal("monthorigvalchg").compareTo(month_originalval_chg) != 0) {
                        fincard.set("monthorigvalchg", (Object)month_originalval_chg);
                        altered = true;
                    }
                    if (fincard.getBigDecimal("yearorigvalchg").compareTo(YEAR_VAL_CHG) != 0) {
                        fincard.set("yearorigvalchg", (Object)YEAR_VAL_CHG);
                        altered = true;
                    }
                    if (altered) {
                        FINCARD_ALTERED.add(fincard);
                    }
                    ORIGINALVAL = fincard.getBigDecimal("originalval");
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])FINCARD_ALTERED.toArray(new DynamicObject[0]));
    }
}

