/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class FaInterestDetailEntryDailyRateUpgradeService
implements IUpgradeService {
    private static final String DB_ROUT_FA = "fa";
    private static final String QUERY_INTEREST_DETAIL = "select a.fdailyrate, b.fentryid, b.frealdailyrate from t_fa_interest_detail a left join t_fa_interest_detail_e  b on a.fid = b.fid;";
    private static final String UPDATE_INTEREST_DETAIL = "update t_fa_interest_detail_e set frealdailyrate = ? where fentryid = ?;";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        List updateParams;
        DBRoute fa;
        Throwable throwable;
        TXHandle handle;
        UpgradeResult result;
        block17: {
            UpgradeResult upgradeResult;
            block18: {
                block19: {
                    result = new UpgradeResult();
                    handle = TX.requiresNew();
                    throwable = null;
                    fa = DBRoute.of((String)DB_ROUT_FA);
                    updateParams = (List)DB.query((DBRoute)fa, (String)QUERY_INTEREST_DETAIL, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

                        public List<Object[]> handle(ResultSet rs) throws Exception {
                            ArrayList<Object[]> result = new ArrayList<Object[]>(32);
                            while (rs.next()) {
                                BigDecimal entryRate = rs.getBigDecimal("frealdailyrate");
                                if (entryRate != null && BigDecimal.ZERO.compareTo(entryRate) < 0) continue;
                                Object[] param = new Object[]{rs.getBigDecimal("fdailyrate"), rs.getLong("fentryid")};
                                result.add(param);
                            }
                            return result;
                        }
                    });
                    if (updateParams != null && !updateParams.isEmpty()) break block17;
                    result.setSuccess(true);
                    result.setLog("haven't interest detail, needn't update data.");
                    upgradeResult = result;
                    if (handle == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                handle.close();
            }
            return upgradeResult;
        }
        try {
            try {
                int[] successNum = DB.executeBatch((DBRoute)fa, (String)UPDATE_INTEREST_DETAIL, (List)updateParams);
                result.setLog("update success count: " + successNum.length);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("update failed :" + e.getMessage());
                handle.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    handle.close();
                }
            }
        }
        return result;
    }
}

