/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.upgradeservice.util.FaPermissionUpgradeServiceImpl;

public class FaInventDifferUpdatePermUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(FaInventDifferUpdatePermUpgradeService.class);
    private static final String FA = "83bfebc800001aac";
    private static final String SELECT = "47150e89000000ac";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updatePermission("fa_card_fin", SELECT, "fa_invdiffer", SELECT);
            log.info("UPGRADE_PERMISSION_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_PERMISSION_ERROR");
            result.setErrorInfo("UPGRADE_PERMISSION_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void updatePermission(String oldEntityName, String permItem, String newEntityName, String ... newPermItem) {
        FaPermissionUpgradeServiceImpl upgradeService = new FaPermissionUpgradeServiceImpl();
        ArrayList<String> existPermInfoList = new ArrayList<String>(1);
        existPermInfoList.add(String.join((CharSequence)"_split_", permItem, oldEntityName, FA));
        List<String> newPermItemList = Arrays.asList(newPermItem);
        upgradeService.addPermItemsByExistPermItem(existPermInfoList, newEntityName, FA, newPermItemList);
    }
}

