/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Tuple;

public class FaLeaseChangePushStatusUpgradeService
implements IUpgradeService {
    private static final DBRoute FA = DBRoute.of((String)"fa");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Iterator<Map.Entry<Long, Set<Long>>> iterator;
        HashSet<Long> needCheckIds;
        HashSet<Long> noPushDownIds;
        HashSet<Long> specialChangeItemIds;
        HashSet<Long> existsMappingChangeItemIds;
        Map<Long, Set<Long>> changeId2ChangeItemIds;
        HashSet<Long> alreadyPushIds;
        HashMap<Long, Tuple<Long, Long>> changeId2BefLeaseId2AftLeaseId;
        UpgradeResult result;
        TXHandle handle = TX.requiresNew();
        Throwable throwable = null;
        try {
            ArrayList<Object> leaseChangeIds;
            block27: {
                UpgradeResult upgradeResult;
                block28: {
                    block25: {
                        UpgradeResult upgradeResult2;
                        block26: {
                            result = new UpgradeResult();
                            changeId2BefLeaseId2AftLeaseId = new HashMap<Long, Tuple<Long, Long>>(512);
                            leaseChangeIds = new ArrayList<Object>(512);
                            this.queryAuditLeaseChangeBill(changeId2BefLeaseId2AftLeaseId, leaseChangeIds);
                            if (!leaseChangeIds.isEmpty()) break block25;
                            upgradeResult2 = result;
                            if (handle == null) return upgradeResult2;
                            if (throwable == null) break block26;
                            try {
                                handle.close();
                                return upgradeResult2;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return upgradeResult2;
                            }
                        }
                        handle.close();
                        return upgradeResult2;
                    }
                    alreadyPushIds = new HashSet<Long>(leaseChangeIds.size(), 1.0f);
                    this.queryHasPushBill(leaseChangeIds, alreadyPushIds);
                    if (!leaseChangeIds.isEmpty()) break block27;
                    this.updateLeaseChangePushStatus(alreadyPushIds, null);
                    upgradeResult = result;
                    if (handle == null) return upgradeResult;
                    if (throwable == null) break block28;
                    try {
                        handle.close();
                        return upgradeResult;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                        return upgradeResult;
                    }
                }
                handle.close();
                return upgradeResult;
            }
            try {
                changeId2ChangeItemIds = this.queryLeaseChangeItem(leaseChangeIds);
                String queryChangeItemMapping = "select fleaseitemid from t_fa_change_mapping";
                DataSet changeItemMappingDataSet = DB.queryDataSet((String)"query change item mapping:", (DBRoute)FA, (String)queryChangeItemMapping);
                existsMappingChangeItemIds = new HashSet<Long>(16, 1.0f);
                while (changeItemMappingDataSet.hasNext()) {
                    existsMappingChangeItemIds.add(changeItemMappingDataSet.next().getLong("fleaseitemid"));
                }
                String queryPayRuleChangeItem = "select fid, fnumber from t_fa_change_item where fnumber in ('payruleentryentity', 'leaseenddate')";
                DataSet payRuleChangeItemDataSet = DB.queryDataSet((String)"query pay rule change item:", (DBRoute)FA, (String)queryPayRuleChangeItem);
                specialChangeItemIds = new HashSet<Long>(4);
                while (payRuleChangeItemDataSet.hasNext()) {
                    specialChangeItemIds.add(payRuleChangeItemDataSet.next().getLong("fid"));
                }
                noPushDownIds = new HashSet<Long>(leaseChangeIds.size());
                needCheckIds = new HashSet<Long>(leaseChangeIds.size());
                iterator = changeId2ChangeItemIds.entrySet().iterator();
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo("FaLeaseChangePushStatusUpgradeService_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                handle.markRollback();
                return result;
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        while (iterator.hasNext()) {
            Map.Entry<Long, Set<Long>> map = iterator.next();
            Long leaseChangeId = map.getKey();
            Set<Long> changeItemIds = map.getValue();
            if (Collections.disjoint(changeItemIds, existsMappingChangeItemIds)) {
                noPushDownIds.add(leaseChangeId);
                continue;
            }
            needCheckIds.add(leaseChangeId);
        }
        this.checkLeaseChangeNeedPush(changeId2BefLeaseId2AftLeaseId, changeId2ChangeItemIds, existsMappingChangeItemIds, specialChangeItemIds, noPushDownIds, needCheckIds);
        this.updateLeaseChangePushStatus(alreadyPushIds, noPushDownIds);
        return result;
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    handle.close();
                }
            }
        }
    }

    private void checkLeaseChangeNeedPush(Map<Long, Tuple<Long, Long>> changeId2BefLeaseId2AftLeaseId, Map<Long, Set<Long>> changeId2ChangeItemIds, Set<Long> existsMappingChangeItemIds, Set<Long> specialChangeItemIds, Set<Long> noPushDownIds, Set<Long> needCheckIds) {
        if (!needCheckIds.isEmpty()) {
            ArrayList<Object> leaseContractIds = new ArrayList<Object>(FaUtils.getInitialCapacity43((int)(needCheckIds.size() * 2)));
            for (Long needCheckId : needCheckIds) {
                Tuple<Long, Long> tuple = changeId2BefLeaseId2AftLeaseId.get(needCheckId);
                leaseContractIds.add(tuple.item1);
                leaseContractIds.add(tuple.item2);
            }
            SqlBuilder queryLeaseContract = new SqlBuilder();
            queryLeaseContract.appendIn("select fid, fleaseassets, fdepremonths, fisexempt from t_fa_lease_contract_new where fid ", leaseContractIds);
            DataSet leaseContractDataSet = DB.queryDataSet((String)"query lease contract lease asset:", (DBRoute)FA, (SqlBuilder)queryLeaseContract);
            HashMap<Long, Tuple> id2Asset = new HashMap<Long, Tuple>(leaseContractIds.size(), 1.0f);
            HashSet<Long> isExemptLeaseContractIds = new HashSet<Long>(leaseContractIds.size(), 1.0f);
            while (leaseContractDataSet.hasNext()) {
                Row next = leaseContractDataSet.next();
                Long id = next.getLong("fid");
                String isExempt = next.getString("fisexempt");
                if ("1".equals(isExempt)) {
                    isExemptLeaseContractIds.add(id);
                    continue;
                }
                BigDecimal asset = next.getBigDecimal("fleaseassets");
                BigDecimal depMonths = next.getBigDecimal("fdepremonths");
                id2Asset.put(id, new Tuple((Object)asset, (Object)depMonths));
            }
            for (Long needCheckId : needCheckIds) {
                Tuple<Long, Long> tuple = changeId2BefLeaseId2AftLeaseId.get(needCheckId);
                Long befContractId = (Long)tuple.item1;
                Long aftContractId = (Long)tuple.item2;
                if (isExemptLeaseContractIds.contains(befContractId) || isExemptLeaseContractIds.contains(aftContractId)) {
                    noPushDownIds.add(needCheckId);
                    continue;
                }
                Set<Long> changeItemIds = changeId2ChangeItemIds.get(needCheckId);
                boolean disjoint = Collections.disjoint(changeItemIds, specialChangeItemIds);
                if (disjoint) continue;
                Tuple bef = (Tuple)id2Asset.get(befContractId);
                if (bef == null) {
                    noPushDownIds.add(needCheckId);
                    continue;
                }
                Tuple aft = (Tuple)id2Asset.get(aftContractId);
                if (aft == null) {
                    noPushDownIds.add(needCheckId);
                    continue;
                }
                BigDecimal befAssetValue = (BigDecimal)bef.item1;
                BigDecimal aftAssetValue = (BigDecimal)aft.item1;
                BigDecimal befDepMonthsValue = (BigDecimal)bef.item2;
                BigDecimal aftDepMonthsValue = (BigDecimal)aft.item2;
                if (befAssetValue == null || aftAssetValue == null || befDepMonthsValue == null || aftDepMonthsValue == null) {
                    noPushDownIds.add(needCheckId);
                    continue;
                }
                if (befAssetValue.compareTo(aftAssetValue) != 0 || befDepMonthsValue.compareTo(aftDepMonthsValue) != 0) continue;
                changeItemIds.removeAll(specialChangeItemIds);
                disjoint = Collections.disjoint(changeItemIds, existsMappingChangeItemIds);
                if (!disjoint) continue;
                noPushDownIds.add(needCheckId);
            }
        }
    }

    private Map<Long, Set<Long>> queryLeaseChangeItem(List<Object> leaseChangeIds) {
        SqlBuilder queryLeaseChangeItem = new SqlBuilder();
        queryLeaseChangeItem.appendIn("select fid, fbasedataid from t_fa_lease_chg_items where fid ", leaseChangeIds);
        DataSet leaseChangeItemDataSet = DB.queryDataSet((String)"query lease change item:", (DBRoute)FA, (SqlBuilder)queryLeaseChangeItem);
        HashMap<Long, Set<Long>> changeId2ChangeItemIds = new HashMap<Long, Set<Long>>(leaseChangeIds.size(), 1.0f);
        while (leaseChangeItemDataSet.hasNext()) {
            Row next = leaseChangeItemDataSet.next();
            Long changeId = next.getLong("fid");
            Long changeItemId = next.getLong("fbasedataid");
            Set changeItemIds = changeId2ChangeItemIds.computeIfAbsent(changeId, v -> new HashSet(4));
            changeItemIds.add(changeItemId);
        }
        return changeId2ChangeItemIds;
    }

    private void queryHasPushBill(List<Object> leaseChangeIds, Set<Long> alreadyPushIds) {
        SqlBuilder queryChangeBill = new SqlBuilder();
        queryChangeBill.appendIn("select fsourceid from t_fa_changebill where fsourceid ", leaseChangeIds);
        DataSet changeBillDataSet = DB.queryDataSet((String)"query change bill:", (DBRoute)FA, (SqlBuilder)queryChangeBill);
        while (changeBillDataSet.hasNext()) {
            alreadyPushIds.add(changeBillDataSet.next().getLong("fsourceid"));
        }
        if (!alreadyPushIds.isEmpty()) {
            leaseChangeIds.removeAll(alreadyPushIds);
        }
    }

    private void queryAuditLeaseChangeBill(Map<Long, Tuple<Long, Long>> changeId2BefLeaseId2AftLeaseId, List<Object> leaseChangeIds) {
        String queryLeaseChange = "select fid, fbefcontractid, faftcontractid from t_fa_lease_change_bill where fbillstatus = 'C'";
        DataSet leaseChangeDataSet = DB.queryDataSet((String)"query lease change for audit:", (DBRoute)FA, (String)queryLeaseChange);
        while (leaseChangeDataSet.hasNext()) {
            Row next = leaseChangeDataSet.next();
            Long changeBillId = next.getLong("fid");
            Long befContractId = next.getLong("fbefcontractid");
            Long aftContractId = next.getLong("faftcontractid");
            changeId2BefLeaseId2AftLeaseId.put(changeBillId, (Tuple<Long, Long>)new Tuple((Object)befContractId, (Object)aftContractId));
            leaseChangeIds.add(changeBillId);
        }
    }

    private void updateLeaseChangePushStatus(Set<Long> alreadyPushIds, Set<Long> noPushDownIds) {
        if (alreadyPushIds != null && !alreadyPushIds.isEmpty()) {
            SqlBuilder updateHasPush = new SqlBuilder();
            updateHasPush.appendIn("update t_fa_lease_change_bill set fpushstatus = 'C' where fid ", alreadyPushIds.toArray());
            DB.execute((DBRoute)FA, (SqlBuilder)updateHasPush);
        }
        if (noPushDownIds != null && !noPushDownIds.isEmpty()) {
            SqlBuilder updateNoPush = new SqlBuilder();
            updateNoPush.appendIn("update t_fa_lease_change_bill set fpushstatus = 'B' where fid ", noPushDownIds.toArray());
            DB.execute((DBRoute)FA, (SqlBuilder)updateNoPush);
        }
    }
}

