/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Tuple;

public class FaLeasePayRuleTaxUpgradeService
implements IUpgradeService {
    private static final DBRoute DB_FA = DBRoute.of((String)"fa");
    private static final String SELECT_PAY_RULE = "SELECT fid, fentryid, fpayitemid, fstartdate FROM t_fa_lease_pay_rule WHERE ftax IS NULL OR ftax = 0;";
    private static final String SELECT_PAY_PLAN = "SELECT fid, fpayitemid, fstartdate, ftax FROM t_fa_lease_pay_plan WHERE fid = ? AND fpayitemid = ? AND fstartdate = ?;";
    private static final String UPDATE_PAY_RULE = "UPDATE t_fa_lease_pay_rule SET ftax = ? WHERE fentryid = ?;";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ArrayList<Object[]> updatePayRuleParams;
        Throwable throwable;
        TXHandle handle;
        UpgradeResult result;
        block19: {
            UpgradeResult upgradeResult;
            block20: {
                block21: {
                    result = new UpgradeResult();
                    handle = TX.requiresNew();
                    throwable = null;
                    List<Object[]> payRuleList = this.queryPayRuleList();
                    HashMap<String, Long> payRuleMap = new HashMap<String, Long>(payRuleList.size());
                    ArrayList<Object[]> queryPayPlanParams = new ArrayList<Object[]>(payRuleList.size());
                    SimpleDateFormat format = DateUtil.getShortDate();
                    for (Object[] objectArray : payRuleList) {
                        long id = (Long)objectArray[0];
                        long entryId = (Long)objectArray[1];
                        long payItemId = (Long)objectArray[2];
                        Date startDate = (Date)objectArray[3];
                        if (startDate == null) continue;
                        payRuleMap.put(id + "_" + payItemId + "_" + format.format(startDate), entryId);
                        queryPayPlanParams.add(new Object[]{id, payItemId, startDate});
                    }
                    updatePayRuleParams = new ArrayList<Object[]>(queryPayPlanParams.size());
                    for (Object[] params : queryPayPlanParams) {
                        Tuple<String, BigDecimal> taxTuple = this.queryPayPlanTaxTuple(params);
                        if (taxTuple == null) continue;
                        Long entryId = (Long)payRuleMap.get(taxTuple.item1);
                        updatePayRuleParams.add(new Object[]{taxTuple.item2, entryId});
                    }
                    if (!updatePayRuleParams.isEmpty()) break block19;
                    result.setSuccess(true);
                    result.setLog("lease contract pay rule needn't update");
                    upgradeResult = result;
                    if (handle == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                handle.close();
            }
            return upgradeResult;
        }
        try {
            try {
                int[] nArray = DB.executeBatch((DBRoute)DB_FA, (String)UPDATE_PAY_RULE, updatePayRuleParams);
                result.setLog("lease contract pay rule update success count: " + nArray.length);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("lease contract pay rule update failed :" + e.getMessage());
                handle.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable3) {
            throw throwable3;
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    handle.close();
                }
            }
        }
        return result;
    }

    private List<Object[]> queryPayRuleList() {
        return (List)DB.query((DBRoute)DB_FA, (String)SELECT_PAY_RULE, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> result = new ArrayList<Object[]>(16);
                while (rs.next()) {
                    Object[] param = new Object[]{rs.getLong("fid"), rs.getLong("fentryid"), rs.getLong("fpayitemid"), rs.getDate("fstartdate")};
                    result.add(param);
                }
                return result;
            }
        });
    }

    private Tuple<String, BigDecimal> queryPayPlanTaxTuple(Object[] params) {
        final SimpleDateFormat format = DateUtil.getShortDate();
        return (Tuple)DB.query((DBRoute)DB_FA, (String)SELECT_PAY_PLAN, (Object[])params, (ResultSetHandler)new ResultSetHandler<Tuple<String, BigDecimal>>(){

            public Tuple<String, BigDecimal> handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    long fid = rs.getLong("fid");
                    long payItemId = rs.getLong("fpayitemid");
                    Date startDate = rs.getDate("fstartdate");
                    BigDecimal tax = rs.getBigDecimal("ftax");
                    if (startDate == null) {
                        return null;
                    }
                    return new Tuple((Object)(fid + "_" + payItemId + "_" + format.format(startDate)), (Object)tax);
                }
                return null;
            }
        });
    }
}

