/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.business.utils.FaCardBotpUtil;

public class FaOriRealCardTCUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(FaOriRealCardTCUpgradeService.class);
    private static final int BATCH_MAX_SIZE = 100000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            SqlBuilder queryParamSql = new SqlBuilder();
            queryParamSql.append("select forgid from t_fa_billparam where fparam = 'split.currentperiod.enable' and fvalue = 'true';", new Object[0]);
            HashSet<Long> orgIds = new HashSet<Long>();
            try (DataSet dataSet = DB.queryDataSet((String)"FaOriRealCardTCUpgradeService_queryParamSql", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)queryParamSql);){
                for (Row row : dataSet) {
                    orgIds.add(row.getLong("forgid"));
                }
            }
            if (CollectionUtils.isEmpty(orgIds)) {
                log.info("FaOriRealCardTCUpgradeService -> orgIds is empty!");
                return result;
            }
            HashMap<Long, Long> sourceId2TargetIdMap = new HashMap<Long, Long>(100000);
            SqlBuilder queryCardSql = new SqlBuilder();
            queryCardSql.append("select fid,fmasterid from t_fa_card_real where foriginaldata = '1' and ", new Object[0]);
            queryCardSql.appendIn(" forgid ", (Object[])orgIds.toArray(new Long[0]));
            int i = 0;
            try (DataSet dataSet = DB.queryDataSet((String)"FaOriRealCardTCUpgradeService_queryCardSql", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)queryCardSql);){
                int batchSize = 0;
                for (Row row : dataSet) {
                    Long id = row.getLong("fid");
                    Long masterId = row.getLong("fmasterid");
                    sourceId2TargetIdMap.put(masterId, id);
                    ++i;
                    if (++batchSize != 100000) continue;
                    FaCardBotpUtil.copyRepairTC(sourceId2TargetIdMap, (String)"fa_card_real");
                    sourceId2TargetIdMap = new HashMap(100000);
                    batchSize = 0;
                }
                if (!sourceId2TargetIdMap.isEmpty()) {
                    FaCardBotpUtil.copyRepairTC(sourceId2TargetIdMap, (String)"fa_card_real");
                }
            }
            log.info("FaOriRealCardTCUpgradeService -> sourceId2TargetIdMap size is : {}", (Object)i);
        }
        catch (Exception e) {
            log.error("FaOriRealCardTCUpgradeService error is : ", (Throwable)e);
            result.setSuccess(false);
            result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }
}

