/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class FaPurchaseBillUpgradeFinInfoService
implements IUpgradeService {
    private static final String DB_ROUT_FA = "fa";
    private static final String DB_ROUT_SYS = "SYS";
    private static final String QUERY_ASSETBOOK_BASECURRENCY = "SELECT DISTINCT FORGID,FBASECURRENCYID FROM T_FA_ASSETBOOK  WHERE FISMAINBOOK = '1';";
    private static final String UPDATE_PURCHASE = "UPDATE T_FA_PURCHASEBILL SET FBASECURRENCYID = ? , FPURCHASECURRENCYID = ?, FEXCHANGERATE = '1'  WHERE FORGID = ? AND FPURCHASECURRENCYID = 0;";
    private static final String QUERY_PURCHASEBILLENTRY = "SELECT BILL.FBASECURRENCYID, ENTRY.FENTRYID, ENTRY.FTOTALAMOUNT,ENTRY.FASSETQTY  FROM T_FA_PURCHASEBILLENTRY ENTRY, T_FA_PURCHASEBILL BILL WHERE ENTRY.FID = BILL.FID ;";
    private static final String UPDATE_PURCHASEBILLENTRY = "UPDATE T_FA_PURCHASEBILLENTRY SET FNEWUNITPRICE = ? WHERE FENTRYID = ? ;";
    private static final String QUERY_CURRENCY = "SELECT FID,FAMTPRECISION FROM  T_BD_CURRENCY ";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        List orgAndBasecurrency;
        DBRoute sys;
        DBRoute fa;
        Throwable throwable;
        TXHandle handle;
        UpgradeResult result;
        block20: {
            UpgradeResult upgradeResult;
            block21: {
                block22: {
                    result = new UpgradeResult();
                    handle = TX.requiresNew();
                    throwable = null;
                    fa = DBRoute.of((String)DB_ROUT_FA);
                    sys = DBRoute.of((String)DB_ROUT_SYS);
                    final HashSet currencyIdSet = new HashSet(16);
                    orgAndBasecurrency = (List)DB.query((DBRoute)fa, (String)QUERY_ASSETBOOK_BASECURRENCY, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

                        public List<Object[]> handle(ResultSet rs) throws Exception {
                            ArrayList<Object[]> result = new ArrayList<Object[]>(16);
                            while (rs.next()) {
                                Object[] param = new Object[3];
                                param[0] = rs.getLong("fbasecurrencyid");
                                param[1] = rs.getLong("fbasecurrencyid");
                                currencyIdSet.add(rs.getLong("fbasecurrencyid"));
                                param[2] = rs.getLong("forgid");
                                result.add(param);
                            }
                            return result;
                        }
                    });
                    if (orgAndBasecurrency != null && !orgAndBasecurrency.isEmpty()) break block20;
                    result.setSuccess(true);
                    result.setLog("haven't assetbook, needn't update data.");
                    upgradeResult = result;
                    if (handle == null) break block21;
                    if (throwable == null) break block22;
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                handle.close();
            }
            return upgradeResult;
        }
        try {
            try {
                Map currencyMap = (Map)DB.query((DBRoute)sys, (String)QUERY_CURRENCY, (ResultSetHandler)new ResultSetHandler<Map<Long, Integer>>(){

                    public Map<Long, Integer> handle(ResultSet rs) throws Exception {
                        HashMap<Long, Integer> result = new HashMap<Long, Integer>(16);
                        while (rs.next()) {
                            result.put(rs.getLong("fid"), rs.getInt("famtprecision"));
                        }
                        return result;
                    }
                });
                int[] successNum = DB.executeBatch((DBRoute)fa, (String)UPDATE_PURCHASE, (List)orgAndBasecurrency);
                result.setLog("purchase update success count: " + successNum.length);
                result.setSuccess(true);
                List entries = (List)DB.query((DBRoute)fa, (String)QUERY_PURCHASEBILLENTRY, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

                    public List<Object[]> handle(ResultSet rs) throws Exception {
                        ArrayList<Object[]> result = new ArrayList<Object[]>(16);
                        while (rs.next()) {
                            if (BigDecimal.ZERO.compareTo(rs.getBigDecimal("fassetqty")) == 0) continue;
                            Object[] param = new Object[]{rs.getLong("fentryid"), rs.getBigDecimal("ftotalamount"), rs.getBigDecimal("fassetqty"), rs.getLong("fbasecurrencyid")};
                            result.add(param);
                        }
                        return result;
                    }
                });
                ArrayList<Object[]> entryIdAndNewUnitprice = new ArrayList<Object[]>(16);
                for (Object[] entry : entries) {
                    int amt = 2;
                    long baseCurrencyId = Long.parseLong(entry[3].toString());
                    for (Map.Entry mapEntry : currencyMap.entrySet()) {
                        if (baseCurrencyId != (Long)mapEntry.getKey()) continue;
                        amt = (Integer)mapEntry.getValue();
                        break;
                    }
                    BigDecimal totalAmount = new BigDecimal(entry[1].toString());
                    BigDecimal assetqty = new BigDecimal(entry[2].toString());
                    BigDecimal newUnitPirce = totalAmount.divide(assetqty, amt, RoundingMode.HALF_UP);
                    Object[] res = new Object[]{newUnitPirce, entry[0]};
                    entryIdAndNewUnitprice.add(res);
                }
                if (entryIdAndNewUnitprice != null && entryIdAndNewUnitprice.size() > 0) {
                    int[] res = DB.executeBatch((DBRoute)fa, (String)UPDATE_PURCHASEBILLENTRY, entryIdAndNewUnitprice);
                    result.setLog("update purchaseEntry success count: " + res.length);
                    result.setSuccess(true);
                }
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("purchase basecurrency update failed :" + e.getMessage());
                handle.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    handle.close();
                }
            }
        }
        return result;
    }
}

