/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;

public class FaRealcardPriceUpgradeServices
implements IUpgradeService {
    private String algoKey = this.getClass().getName();
    private static final Log log = LogFactory.getLog((String)"kd.fi.fa.upgradeservice.FaRealcardPriceUpgradeServices");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult realt = new UpgradeResult();
        try {
            this.upRealCardPrice();
            realt.setSuccess(true);
            log.info("UPGRADE_REALCARDPRICE_SUCCESS");
        }
        catch (Exception e) {
            realt.setSuccess(false);
            log.info("UPGRADE_REALCARDPRICE_ERROR");
            realt.setErrorInfo("UPGRADE_REALCARDPRICE_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return realt;
    }

    private void upRealCardPrice() {
        QFilter fMainBook = new QFilter("ismainbook", "=", (Object)true);
        DynamicObjectCollection mainBook = QueryServiceHelper.query((String)"fa_assetbook", (String)"org,depreuse", (QFilter[])new QFilter[]{fMainBook});
        HashMap<Integer, QFilter> filterMap = new HashMap<Integer, QFilter>(16);
        int i = 1;
        for (Object mainBookBill : mainBook) {
            Long org = mainBookBill.getLong("org");
            Long depreuse = mainBookBill.getLong("depreuse");
            QFilter qorg = new QFilter("org", "=", (Object)org);
            QFilter qdepreuse = new QFilter("depreuse", "=", (Object)depreuse);
            filterMap.put(i, qorg.and(qdepreuse));
            ++i;
        }
        HashMap<Long, BigDecimal> realMap = new HashMap<Long, BigDecimal>(16);
        for (QFilter f : filterMap.values()) {
            DataSet finCardDs = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"fa_card_fin", (String)"realcard.masterid,originalval,period,bizperiod", (QFilter[])new QFilter[]{f}, null).filter("period = bizperiod");
            for (Row fin : finCardDs) {
                long realCardMasterId = fin.getLong("realcard.masterid");
                BigDecimal originalval = fin.getBigDecimal("originalval");
                realMap.put(realCardMasterId, originalval);
            }
        }
        String realCardBillSql = "select fmasterid,fprice from t_fa_card_real where fbillstatus = 'C'";
        DataSet realCardBillDs = DB.queryDataSet((String)this.algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)realCardBillSql);
        ArrayList<Object[]> paramLst = new ArrayList<Object[]>(16);
        for (Row realCard : realCardBillDs) {
            if (null == realMap.get(realCard.getLong("fmasterid"))) continue;
            paramLst.add(new Object[]{realMap.get(realCard.getLong("fmasterid")), realCard.getLong("fmasterid")});
        }
        if (!paramLst.isEmpty()) {
            String updateSql = "update T_FA_CARD_REAL set fprice = ? where fmasterid = ?;";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)updateSql, paramLst);
        }
        realCardBillDs.close();
    }
}

