/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class FaSortTerminaLeaseInterestEntryServiceImpl
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute faRoute = DBRoute.of((String)"fa");
        try (TXHandle handle = TX.requiresNew();){
            try {
                Long contractid;
                String queryInterestDetail = "select L.fid contractid,L.fnumber,E.fentryid,E.fdate,E.fseq from t_fa_lease_contract_new L left join t_fa_interest_detail D on L.fid = D.fleasecontractid left join t_fa_interest_detail_e E on E.fid = D.fid where E.fsourcetype ='B'order by contractid,e.fseq;";
                String updateInterestDetailEntry = "update t_fa_interest_detail_e set fseq = ? where fentryid = ?;";
                int paramMaxSize = 1000;
                DataSet leaseInterestDetailDs = DB.queryDataSet((String)"FaUpdateLeaseInterestDetailServiceImpl", (DBRoute)faRoute, (String)queryInterestDetail);
                HashMap<Long, Integer> seqMap = new HashMap<Long, Integer>(32);
                DataSet copyLeaseInterestDetailDs = leaseInterestDetailDs.copy();
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>(paramMaxSize);
                ArrayList<Long> updateEntryId = new ArrayList<Long>(paramMaxSize);
                ArrayList<Integer> updateSeq = new ArrayList<Integer>(paramMaxSize);
                for (Row row : leaseInterestDetailDs) {
                    contractid = row.getLong("contractid");
                    Long interestDetailEntryId = row.getLong("fentryid");
                    Integer seq = row.getInteger("fseq");
                    seqMap.put(contractid, seq);
                    updateEntryId.add(interestDetailEntryId);
                }
                for (Row row : copyLeaseInterestDetailDs) {
                    contractid = row.getLong("contractid");
                    Integer maxSeq = (Integer)seqMap.get(contractid);
                    updateSeq.add(maxSeq);
                    Integer n = maxSeq;
                    Integer n2 = maxSeq = Integer.valueOf(maxSeq - 1);
                    seqMap.put(contractid, maxSeq);
                }
                for (int x = 0; x < updateEntryId.size(); ++x) {
                    Integer seq = (Integer)updateSeq.get(x);
                    Long entryId = (Long)updateEntryId.get(x);
                    Object[] param = new Object[]{seq, entryId};
                    updateParams.add(param);
                    if (updateParams.size() != paramMaxSize) continue;
                    DB.executeBatch((DBRoute)faRoute, (String)updateInterestDetailEntry, updateParams);
                    updateParams.clear();
                }
                if (!updateParams.isEmpty()) {
                    DB.executeBatch((DBRoute)faRoute, (String)updateInterestDetailEntry, updateParams);
                }
                handle.commit();
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("interestDetail seq update failed :" + e.getMessage());
                handle.markRollback();
            }
        }
        return result;
    }
}

