/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SplitBillDataWriteBackUpgradeService
implements IUpgradeService {
    private static final String AL_GO = "kd.fi.fa.upgradeservice.SplitBillDataWriteBackUpgradeService";
    private static final Log log = LogFactory.getLog(SplitBillDataWriteBackUpgradeService.class);
    private static final DBRoute FA_DB_ROUTE = DBRoute.of((String)"fa");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        TXHandle handle = null;
        try {
            handle = TX.required();
            if (this.noRun()) {
                result.setSuccess(Boolean.TRUE.booleanValue());
                result.setLog("split bill data write finish");
                UpgradeResult upgradeResult = result;
                return upgradeResult;
            }
            this.updateSplitBillData();
            this.insertBillParam();
            handle.commit();
        }
        catch (Throwable e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorInfo(e.getMessage());
            result.setLog("split bill data write failed :" + e.getMessage());
            if (Objects.nonNull(handle)) {
                handle.markRollback();
            }
        }
        finally {
            if (Objects.nonNull(handle)) {
                handle.close();
            }
        }
        return result;
    }

    public void insertBillParam() {
        SqlBuilder insertBillParamTypeSqlBuilder = new SqlBuilder();
        insertBillParamTypeSqlBuilder.append("INSERT INTO T_FA_BILLPARAM_TYPE(FID,FBIZAPPID,FDESCRIPTION,FBIZCLOUDID,FNUMBER,FNAME)", new Object[0]);
        insertBillParamTypeSqlBuilder.append("VALUES (1723328973255325987,'83bfebc800001aac',' ','83bfebc8000002ac'," + ResManager.loadKDString((String)"'split.bill.history.data.upgrade.limit','\u62c6\u5206\u5355\u5386\u53f2\u6570\u636e\u5347\u7ea7\u9650\u5236');", (String)"SplitBillDataWriteBackUpgradeService_0", (String)"fi-fa-upgradeservice", (Object[])new Object[0]), new Object[0]);
        DB.execute((DBRoute)FA_DB_ROUTE, (SqlBuilder)insertBillParamTypeSqlBuilder);
        SqlBuilder insertBillParamSqlBuilder = new SqlBuilder();
        insertBillParamSqlBuilder.append("INSERT INTO T_FA_BILLPARAM", new Object[0]);
        insertBillParamSqlBuilder.append("(FID, FPARAM, FVALUE, FDESCRIPTION, FBIZCLOUDID, FBIZAPPID, FPARAMTYPEID, FENABLE)", new Object[0]);
        insertBillParamSqlBuilder.append("VALUES(1716861765398084573, 'SPLIT_BILL_HISTORY_DATA_UPGRADE', " + ResManager.loadKDString((String)"'true', '\u62c6\u5206\u5355\u5386\u53f2\u6570\u636e\u5347\u7ea7\u662f\u5426\u6210\u529f', '83bfebc8000002ac', '83bfebc800001aac', 1723328973255325987, '1');", (String)"SplitBillDataWriteBackUpgradeService_1", (String)"fi-fa-upgradeservice", (Object[])new Object[0]), new Object[0]);
        DB.execute((DBRoute)FA_DB_ROUTE, (SqlBuilder)insertBillParamSqlBuilder);
    }

    public void updateSplitBillData() {
        DataSet baseDataSet = this.getBaseDataSet();
        DataSet assetSplitEntryDepreUseIdDS = this.getAssetSplitEntryDepreUseIdDataSet();
        this.updateAssetSplitEntry(assetSplitEntryDepreUseIdDS);
        DataSet finish = baseDataSet.leftJoin(assetSplitEntryDepreUseIdDS).on("fentryid", "fentryid").select(baseDataSet.getRowMeta().getFieldNames(), new String[]{"fdepreuseid"}).finish();
        this.updateAssetSplitEntryD(finish);
        this.updateSplitEntryDBarCode();
    }

    private void updateSplitEntryDBarCode() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT c.fdetailid,d.fbarcode FROM t_fa_assetsplitbill a", new Object[0]);
        sqlBuilder.append("INNER JOIN t_fa_assetsplitentry b", new Object[0]);
        sqlBuilder.append("ON a.fid = b.fid", new Object[0]);
        sqlBuilder.append("INNER JOIN t_fa_assetsplitentry_d c", new Object[0]);
        sqlBuilder.append("ON b.fentryid = c.fentryid", new Object[0]);
        sqlBuilder.append("INNER JOIN t_fa_card_real d", new Object[0]);
        sqlBuilder.append("ON c.frealcardid = d.fid;", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)AL_GO, (DBRoute)FA_DB_ROUTE, (SqlBuilder)sqlBuilder);
        log.info("\u5f00\u59cb\u66f4\u65b0\u62c6\u5206\u540e\u5206\u5f55\u7684\u6761\u5f62\u7801");
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        for (Row row : dataSet.copy()) {
            String fbarcode = row.getString("fbarcode");
            Long fdetailid = row.getLong("fdetailid");
            updateParams.add(new Object[]{fbarcode, fdetailid});
        }
        if (updateParams.isEmpty()) {
            log.info("\u66f4\u65b0\u62c6\u5206\u540e\u5206\u5f55\u7684\u6761\u5f62\u7801\u7ed3\u675f, \u4e00\u5171\u66f4\u65b0\u6570\u636e\uff1a0 \u6761");
            return;
        }
        String updateSql = "UPDATE t_fa_assetsplitentry_d SET fbarcode = ? WHERE fdetailid = ? ";
        DB.executeBatch((DBRoute)FA_DB_ROUTE, (String)updateSql, updateParams);
        log.info("\u66f4\u65b0\u62c6\u5206\u540e\u5206\u5f55\u7684\u6761\u5f62\u7801\u7ed3\u675f, \u4e00\u5171\u66f4\u65b0\u6570\u636e\uff1a" + updateParams.size() + " \u6761");
    }

    private void updateAssetSplitEntryD(DataSet dataSet) {
        log.info("\u5f00\u59cb\u66f4\u65b0\u62c6\u5206\u5355\u62c6\u5206\u540e\u7684\u6570\u636e");
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        for (Row row : dataSet) {
            int fseq = row.getInteger("fseq") == null ? 0 : row.getInteger("fseq");
            String fissourcecard = row.getString("fissourcecard") == null ? "0" : row.getString("fissourcecard");
            long fassetcatid = row.getLong("fassetcatid") == null ? 0L : row.getLong("fassetcatid");
            Date frealaccountdate = row.getDate("frealaccountdate");
            long foriginmethodid = row.getLong("foriginmethodid") == null ? 0L : row.getLong("foriginmethodid");
            long fsupplierid = row.getLong("fsupplierid") == null ? 0L : row.getLong("fsupplierid");
            long fstoreplaceid = row.getLong("fstoreplaceid") == null ? 0L : row.getLong("fstoreplaceid");
            long fusestatusid = row.getLong("fusestatusid") == null ? 0L : row.getLong("fusestatusid");
            long fheadusepersonid = row.getLong("fheadusepersonid") == null ? 0L : row.getLong("fheadusepersonid");
            long fheadusedeptid = row.getLong("fheadusedeptid") == null ? 0L : row.getLong("fheadusedeptid");
            long fcostcentrerid = row.getLong("fcostcentrerid") == null ? 0L : row.getLong("fcostcentrerid");
            long fproductlineid = row.getLong("fproductlineid") == null ? 0L : row.getLong("fproductlineid");
            String fisfacility = row.getString("fisfacility") == null ? "0" : row.getString("fisfacility");
            String fisstoraged = row.getString("fisstoraged") == null ? "0" : row.getString("fisstoraged");
            long fdepreuseid = row.getLong("fdepreuseid") == null ? 0L : row.getLong("fdepreuseid");
            Date ffinaccountdate = row.getDate("ffinaccountdate");
            BigDecimal fpreusingamount = row.getBigDecimal("fpreusingamount") == null ? BigDecimal.ZERO : row.getBigDecimal("fpreusingamount");
            BigDecimal fmonthaccumdeprechg = row.getBigDecimal("fmonthaccumdeprechg") == null ? BigDecimal.ZERO : row.getBigDecimal("fmonthaccumdeprechg");
            String model = row.getString("fmodel") == null ? " " : row.getString("fmodel");
            long forg = row.getLong("forg") == null ? 0L : row.getLong("forg");
            long fassetunitid = row.getLong("fassetunitid") == null ? 0L : row.getLong("fassetunitid");
            Long fcurrencyid = row.getLong("fcurrencyid");
            String fremark = row.getString("fremark") == null ? " " : row.getString("fremark");
            Long fdepremethodid = row.getLong("fdepremethodid");
            BigDecimal fdepredamount = row.getBigDecimal("fdepredamount") == null ? BigDecimal.ZERO : row.getBigDecimal("fdepredamount");
            String fpicturepath = row.getString("fpicturepath") == null ? " " : row.getString("fpicturepath");
            long fdetailid = row.getLong("fdetailid") == null ? 0L : row.getLong("fdetailid");
            updateParams.add(new Object[]{fseq, fissourcecard, fassetcatid, frealaccountdate, foriginmethodid, fsupplierid, fstoreplaceid, fusestatusid, fheadusepersonid, fheadusedeptid, fcostcentrerid, fproductlineid, fisfacility, fisstoraged, fdepreuseid, ffinaccountdate, fpreusingamount, fmonthaccumdeprechg, model, forg, fassetunitid, fcurrencyid, fremark, fdepremethodid, fdepredamount, fpicturepath, fdetailid});
        }
        if (updateParams.isEmpty()) {
            log.info("\u66f4\u65b0\u62c6\u5206\u5355\u62c6\u5206\u540e\u7684\u6570\u636e\u7ed3\u675f, \u4e00\u5171\u66f4\u65b0\u6570\u636e\uff1a0 \u6761");
            return;
        }
        String updateSql = "UPDATE t_fa_assetsplitentry_d SET findex = ?, fissourcecard = ?, fassetcatid = ?, frealaccountdate = ?, foriginmethodid = ?, fsupplierid = ?, fstoreplaceid = ?, fusestatusid = ?, fheadusepersonid = ?, fheadusedeptid = ?, fcostcentrerid = ?, fproductlineid = ?, fisfacility = ?, fisstoraged = ?, fdepreuseid = ?, ffinaccountdate = ?, fpreusingamount = ?, fmonthaccumdeprechg = ?, fmodel = ?, forgid = ?, fassetunitid = ?, fcurrencyid = ?, fremark = ?, fdepremethodid = ?, fdepredamount = ?, fpicturepath = ?WHERE fdetailid = ? ";
        DB.executeBatch((DBRoute)FA_DB_ROUTE, (String)updateSql, updateParams);
        log.info("\u66f4\u65b0\u62c6\u5206\u5355\u62c6\u5206\u540e\u7684\u6570\u636e\u7ed3\u675f, \u4e00\u5171\u66f4\u65b0\u6570\u636e\uff1a" + updateParams.size() + " \u6761");
    }

    private DataSet getAssetSplitEntryDepreUseIdDataSet() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT", new Object[0]);
        sqlBuilder.append("a.fentryid,", new Object[0]);
        sqlBuilder.append("b.fdepreuseid", new Object[0]);
        sqlBuilder.append("FROM t_fa_assetsplitentry a", new Object[0]);
        sqlBuilder.append("LEFT JOIN t_fa_card_fin b", new Object[0]);
        sqlBuilder.append("ON a.ffincardid = b.fid", new Object[0]);
        sqlBuilder.append("WHERE a.ffincardid IS NOT NULL AND b.fdepreuseid IS NOT NULL", new Object[0]);
        return DB.queryDataSet((String)AL_GO, (DBRoute)FA_DB_ROUTE, (SqlBuilder)sqlBuilder);
    }

    private void updateAssetSplitEntry(DataSet assetSplitEntryDepreUseIdDS) {
        log.info("\u5f00\u59cb\u66f4\u65b0\u62c6\u5206\u524d\u5206\u5f55\u7684\u6298\u65e7\u7528\u9014");
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        for (Row row : assetSplitEntryDepreUseIdDS.copy()) {
            Long fdepreuseid = row.getLong("fdepreuseid");
            Long fentryid = row.getLong("fentryid");
            updateParams.add(new Object[]{fdepreuseid, fentryid});
        }
        if (updateParams.isEmpty()) {
            log.info("\u66f4\u65b0\u62c6\u5206\u524d\u5206\u5f55\u7684\u6298\u65e7\u7528\u9014\u7ed3\u675f, \u4e00\u5171\u66f4\u65b0\u6570\u636e\uff1a0 \u6761");
            return;
        }
        String updateSql = "UPDATE t_fa_assetsplitentry SET fdepreuseid = ? WHERE fentryid = ? ";
        DB.executeBatch((DBRoute)FA_DB_ROUTE, (String)updateSql, updateParams);
        log.info("\u66f4\u65b0\u62c6\u5206\u524d\u5206\u5f55\u7684\u6298\u65e7\u7528\u9014\u7ed3\u675f, \u4e00\u5171\u66f4\u65b0\u6570\u636e\uff1a" + updateParams.size() + " \u6761");
    }

    private DataSet getBaseDataSet() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT", new Object[0]);
        sqlBuilder.append("c.fdetailid,", new Object[0]);
        sqlBuilder.append("c.fentryid,", new Object[0]);
        sqlBuilder.append("c.fseq,", new Object[0]);
        sqlBuilder.append("CASE WHEN c.fseq = 1 THEN 1 ELSE 0 END fissourcecard,", new Object[0]);
        sqlBuilder.append("e.fpicturepath,", new Object[0]);
        sqlBuilder.append("CASE WHEN c.fseq = 1 then c.faccumdepre - b.faccumdepre ELSE c.faccumdepre END fmonthaccumdeprechg,", new Object[0]);
        sqlBuilder.append("d.fassetcatid,", new Object[0]);
        sqlBuilder.append("e.frealaccountdate,", new Object[0]);
        sqlBuilder.append("e.foriginmethodid,", new Object[0]);
        sqlBuilder.append("e.fsupplierid,", new Object[0]);
        sqlBuilder.append("e.fstoreplaceid,", new Object[0]);
        sqlBuilder.append("e.fusestatusid,", new Object[0]);
        sqlBuilder.append("e.fheadusepersonid,", new Object[0]);
        sqlBuilder.append("e.fheadusedeptid,", new Object[0]);
        sqlBuilder.append("e.fcostcentrerid,", new Object[0]);
        sqlBuilder.append("e.fproductlineid,", new Object[0]);
        sqlBuilder.append("e.fisfacility,", new Object[0]);
        sqlBuilder.append("e.fisstoraged,", new Object[0]);
        sqlBuilder.append("d.ffinaccountdate,", new Object[0]);
        sqlBuilder.append("d.fpreusingamount,", new Object[0]);
        sqlBuilder.append("e.fmodel,", new Object[0]);
        sqlBuilder.append("d.forg,", new Object[0]);
        sqlBuilder.append("e.fassetunitid,", new Object[0]);
        sqlBuilder.append("d.fcurrencyid,", new Object[0]);
        sqlBuilder.append("e.fremark,", new Object[0]);
        sqlBuilder.append("d.fdepremethodid,", new Object[0]);
        sqlBuilder.append("d.fdepredamount", new Object[0]);
        sqlBuilder.append("FROM t_fa_assetsplitbill a", new Object[0]);
        sqlBuilder.append("INNER JOIN t_fa_assetsplitentry b", new Object[0]);
        sqlBuilder.append("ON a.fid = b.fid", new Object[0]);
        sqlBuilder.append("INNER JOIN t_fa_assetsplitentry_d c", new Object[0]);
        sqlBuilder.append("ON b.fentryid = c.fentryid", new Object[0]);
        sqlBuilder.append("INNER JOIN t_fa_card_fin d", new Object[0]);
        sqlBuilder.append("ON b.ffincardid = d.fid", new Object[0]);
        sqlBuilder.append("INNER JOIN t_fa_card_real e", new Object[0]);
        sqlBuilder.append("ON b.frealcardid = e.fid", new Object[0]);
        sqlBuilder.append("WHERE a.fbillstatus IN ('A','B','C');", new Object[0]);
        return DB.queryDataSet((String)AL_GO, (DBRoute)FA_DB_ROUTE, (SqlBuilder)sqlBuilder);
    }

    public boolean noRun() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT fvalue FROM t_fa_billparam WHERE fid = 1716861765398084573", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)AL_GO, (DBRoute)FA_DB_ROUTE, (SqlBuilder)sqlBuilder);
        if (dataSet.hasNext()) {
            String fvalue = dataSet.next().getString("fvalue");
            return "true".equals(fvalue);
        }
        return Boolean.FALSE;
    }
}

