/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.upgradeservice;

import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SplitBillUpdateVoucherFlagUpgradeService
implements IUpgradeService {
    private static final String AL_GO = "kd.fi.fa.upgradeservice.SplitBillUpdateVoucherFlagUpgradeService";
    private static final Log log = LogFactory.getLog(SplitBillUpdateVoucherFlagUpgradeService.class);
    private static final DBRoute FA_DB_ROUTE = DBRoute.of((String)"fa");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        TXHandle handle = null;
        try {
            handle = TX.required();
            if (this.noRun()) {
                result.setSuccess(Boolean.TRUE.booleanValue());
                result.setLog("split bill update voucher flag finish");
                UpgradeResult upgradeResult = result;
                return upgradeResult;
            }
            this.updateVoucherFlag();
            this.insertBillParam();
            handle.commit();
        }
        catch (Throwable e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorInfo(e.getMessage());
            result.setLog("split bill update voucher flag failed :" + e.getMessage());
            if (Objects.nonNull(handle)) {
                handle.markRollback();
            }
        }
        finally {
            if (Objects.nonNull(handle)) {
                handle.close();
            }
        }
        return result;
    }

    public void insertBillParam() {
        SqlBuilder insertBillParamTypeSqlBuilder = new SqlBuilder();
        insertBillParamTypeSqlBuilder.append("INSERT INTO T_FA_BILLPARAM_TYPE(FID,FBIZAPPID,FDESCRIPTION,FBIZCLOUDID,FNUMBER,FNAME)", new Object[0]);
        insertBillParamTypeSqlBuilder.append("VALUES (1785474173255325987,'83bfebc800001aac',' ','83bfebc8000002ac'," + ResManager.loadKDString((String)"'split.bill.voucher.flag.data.upgrade.limit','\u62c6\u5206\u5355\u8bb0\u8d26\u6807\u8bc6\u5386\u53f2\u6570\u636e\u5347\u7ea7\u9650\u5236');", (String)"SplitBillUpdateVoucherFlagUpgradeService_0", (String)"fi-fa-upgradeservice", (Object[])new Object[0]), new Object[0]);
        DB.execute((DBRoute)FA_DB_ROUTE, (SqlBuilder)insertBillParamTypeSqlBuilder);
        SqlBuilder insertBillParamSqlBuilder = new SqlBuilder();
        insertBillParamSqlBuilder.append("INSERT INTO T_FA_BILLPARAM", new Object[0]);
        insertBillParamSqlBuilder.append("(FID, FPARAM, FVALUE, FDESCRIPTION, FBIZCLOUDID, FBIZAPPID, FPARAMTYPEID, FENABLE)", new Object[0]);
        insertBillParamSqlBuilder.append("VALUES(1716861765398171111, 'SPLIT_BILL_VOUCHER_FLAG_DATA_WRITE_BACK', " + ResManager.loadKDString((String)"'true', '\u62c6\u5206\u5355\u8bb0\u8d26\u6807\u8bc6\u5386\u53f2\u6570\u636e\u5347\u7ea7\u662f\u5426\u6210\u529f', '83bfebc8000002ac', '83bfebc800001aac', 1785474173255325987, '1');", (String)"SplitBillUpdateVoucherFlagUpgradeService_1", (String)"fi-fa-upgradeservice", (Object[])new Object[0]), new Object[0]);
        DB.execute((DBRoute)FA_DB_ROUTE, (SqlBuilder)insertBillParamSqlBuilder);
    }

    public boolean noRun() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT fvalue FROM t_fa_billparam WHERE fid = 1716861765398171111", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)AL_GO, (DBRoute)FA_DB_ROUTE, (SqlBuilder)sqlBuilder);
        if (dataSet.hasNext()) {
            String fvalue = dataSet.next().getString("fvalue");
            return "true".equals(fvalue);
        }
        return Boolean.FALSE;
    }

    private void updateVoucherFlag() {
        log.info("\u5f00\u59cb\u66f4\u65b0\u8bb0\u8d26\u6807\u8bc6");
        SqlBuilder updateVoucherFlagASqlBuilder = new SqlBuilder();
        updateVoucherFlagASqlBuilder.append("UPDATE t_fa_assetsplitbill", new Object[0]);
        updateVoucherFlagASqlBuilder.append("SET fvoucherflag = 'A'", new Object[0]);
        updateVoucherFlagASqlBuilder.append("WHERE fbillstatus = 'C'", new Object[0]);
        DB.execute((DBRoute)FA_DB_ROUTE, (SqlBuilder)updateVoucherFlagASqlBuilder);
        log.info("\u66f4\u65b0\u8bb0\u8d26\u6807\u8bc6\u7ed3\u675f");
    }
}

