/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.card.DepreciationRptQueryServiceHelper;
import kd.fi.fa.service.FaDepreciationRptQueryService;

public class FaDepreciationRptQueryServiceImpl
implements FaDepreciationRptQueryService {
    private static final String ALGO_KEY = FaDepreciationRptQueryServiceImpl.class.getName();

    public List<Map<String, Object>> query(Map<String, Object> queryParam) {
        HashSet<String> otherFinFieldSet = new HashSet<String>(16);
        ReportQueryParam rptQueryParam = this.checkAndInitParam(queryParam, otherFinFieldSet);
        DataSet dataSet = DepreciationRptQueryServiceHelper.queryFullDepreciationData((String)ALGO_KEY, (ReportQueryParam)rptQueryParam, otherFinFieldSet);
        return this.formatResult(dataSet, otherFinFieldSet);
    }

    private ReportQueryParam checkAndInitParam(Map<String, Object> queryParam, Set<String> otherFinFieldSet) {
        Object otherFinFieldsObj;
        ReportQueryParam rptQueryParam = new ReportQueryParam();
        ArrayList<String> errInfo = new ArrayList<String>(10);
        FilterInfo filterInfo = new FilterInfo();
        rptQueryParam.setFilter(filterInfo);
        Object orgIdObj = queryParam.get("orgIds");
        if (orgIdObj == null) {
            errInfo.add(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570[orgIds]\uff0c\u7c7b\u578b\u4e3aLong[]\u3002", (String)"FaDepreciationRptQueryServiceImpl_0", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else if (!(orgIdObj instanceof Long[])) {
            errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aLong[]\u7684\u53c2\u6570[orgIds]\u3002", (String)"FaDepreciationRptQueryServiceImpl_1", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else {
            Object[] orgIds = (Long[])orgIdObj;
            if (orgIds.length == 0) {
                errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570[orgIds]\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaDepreciationRptQueryServiceImpl_2", (String)"fi-fa-mservice", (Object[])new Object[0]));
            } else {
                Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])orgIds, (String)"bos_org");
                Set existOrgIdSet = orgMap.keySet();
                boolean existOrgNotFind = false;
                for (Object orgId : orgIds) {
                    if (existOrgIdSet.contains(orgId)) continue;
                    errInfo.add(String.format(ResManager.loadKDString((String)"id\u4e3a[%s]\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FaDepreciationRptQueryServiceImpl_3", (String)"fi-fa-mservice", (Object[])new Object[0]), orgId));
                    existOrgNotFind = true;
                }
                if (!existOrgNotFind) {
                    MainEntityType bosOrgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
                    DynamicObjectCollection orgList = new DynamicObjectCollection((DynamicObjectType)bosOrgType, null);
                    orgList.addAll(orgMap.values());
                    filterInfo.addFilterItem("q_org", (Object)orgList);
                }
            }
        }
        Object depreUseIdObj = queryParam.get("depreUseId");
        if (depreUseIdObj == null) {
            errInfo.add(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570[depreUseId]\uff0c\u7c7b\u578b\u4e3aLong\u3002", (String)"FaDepreciationRptQueryServiceImpl_4", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else if (!(depreUseIdObj instanceof Long)) {
            errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aLong\u7684\u53c2\u6570[depreUseId]\u3002", (String)"FaDepreciationRptQueryServiceImpl_5", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else {
            DynamicObject depreUse = BusinessDataServiceHelper.loadSingleFromCache((Object)depreUseIdObj, (String)"fa_depreuse");
            if (depreUse == null) {
                errInfo.add(String.format(ResManager.loadKDString((String)"id\u4e3a[%s]\u7684\u6298\u65e7\u7528\u9014\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FaDepreciationRptQueryServiceImpl_6", (String)"fi-fa-mservice", (Object[])new Object[0]), depreUseIdObj.toString()));
            } else {
                filterInfo.addFilterItem("depreuse", (Object)depreUse);
            }
        }
        Object startPeriodIdObj = queryParam.get("startPeriodId");
        if (startPeriodIdObj == null) {
            errInfo.add(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570[startPeriodId]\uff0c\u7c7b\u578b\u4e3aLong\u3002", (String)"FaDepreciationRptQueryServiceImpl_7", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else if (!(startPeriodIdObj instanceof Long)) {
            errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aLong\u7684\u53c2\u6570[startPeriodId]\u3002", (String)"FaDepreciationRptQueryServiceImpl_8", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else {
            DynamicObject startPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)startPeriodIdObj, (String)"bd_period");
            if (startPeriod == null) {
                errInfo.add(String.format(ResManager.loadKDString((String)"id\u4e3a[%s]\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FaDepreciationRptQueryServiceImpl_9", (String)"fi-fa-mservice", (Object[])new Object[0]), startPeriodIdObj.toString()));
            } else {
                filterInfo.addFilterItem("period_start", (Object)startPeriod);
            }
        }
        Object endPeriodIdObj = queryParam.get("endPeriodId");
        if (endPeriodIdObj == null) {
            errInfo.add(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570[endPeriodId]\uff0c\u7c7b\u578b\u4e3aLong\u3002", (String)"FaDepreciationRptQueryServiceImpl_10", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else if (!(endPeriodIdObj instanceof Long)) {
            errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aLong\u7684\u53c2\u6570[endPeriodId]\u3002", (String)"FaDepreciationRptQueryServiceImpl_11", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else {
            DynamicObject endPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriodIdObj, (String)"bd_period");
            if (endPeriod == null) {
                errInfo.add(String.format(ResManager.loadKDString((String)"id\u4e3a[%s]\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FaDepreciationRptQueryServiceImpl_9", (String)"fi-fa-mservice", (Object[])new Object[0]), endPeriodIdObj.toString()));
            } else {
                filterInfo.addFilterItem("period_end", (Object)endPeriod);
            }
        }
        Object showExceptZeroObj = queryParam.get("showExceptZero");
        if (showExceptZeroObj == null) {
            errInfo.add(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570[showExceptZero]\uff0c\u7c7b\u578b\u4e3aBoolean\u3002", (String)"FaDepreciationRptQueryServiceImpl_12", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else if (!(showExceptZeroObj instanceof Boolean)) {
            errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aBoolean\u7684\u53c2\u6570[showExceptZero]\u3002", (String)"FaDepreciationRptQueryServiceImpl_13", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else {
            Boolean showExceptZero = (Boolean)showExceptZeroObj;
            filterInfo.addFilterItem("showexcept0", (Object)showExceptZero);
        }
        Object finCardFilterObj = queryParam.get("finCardFilter");
        if (finCardFilterObj != null) {
            if (!(finCardFilterObj instanceof String)) {
                errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aString\u7684\u53c2\u6570[finCardFilter]\u3002", (String)"FaDepreciationRptQueryServiceImpl_14", (String)"fi-fa-mservice", (Object[])new Object[0]));
            } else {
                String finCardFilterStr = (String)finCardFilterObj;
                QFilter finCardFilter = QFilter.of((String)finCardFilterStr, (Object[])new Object[0]);
                HashMap<String, QFilter> commFilter = new HashMap<String, QFilter>(1);
                commFilter.put("fa_card_fin", finCardFilter);
                filterInfo.setCommFilter(commFilter);
            }
        }
        if ((otherFinFieldsObj = queryParam.get("otherFinFields")) != null) {
            if (!(otherFinFieldsObj instanceof String[])) {
                errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aString[]\u7684\u53c2\u6570[otherFinFields]\u3002", (String)"FaDepreciationRptQueryServiceImpl_15", (String)"fi-fa-mservice", (Object[])new Object[0]));
            } else {
                String[] otherFinFields = (String[])otherFinFieldsObj;
                otherFinFieldSet.addAll(Arrays.asList(otherFinFields));
            }
        }
        if (!errInfo.isEmpty()) {
            String msg = String.join((CharSequence)"\r\n", errInfo);
            throw new KDBizException(msg);
        }
        return rptQueryParam;
    }

    private List<Map<String, Object>> formatResult(DataSet dataSet, Set<String> otherFinFieldSet) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        if (dataSet == null) {
            return rowList;
        }
        Field[] fields = dataSet.getRowMeta().getFields();
        for (Row row : dataSet) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>(16);
            rowList.add(rowMap);
            rowMap.put("basecurrency", row.get("basecurrency"));
            rowMap.put("org", row.get("org"));
            rowMap.put("period", row.get("period"));
            rowMap.put("category", row.get("category"));
            rowMap.put("number", row.get("number"));
            rowMap.put("realcard", row.get("realcard"));
            rowMap.put("fid", row.get("fid"));
            rowMap.put("prepare_use_amount", row.get("prepare_use_amount"));
            rowMap.put("depreciation_amount", row.get("depreciation_amount"));
            rowMap.put("depreciation_method", row.get("depreciation_method"));
            rowMap.put("depreciation_rate", row.get("depreciation_rate"));
            rowMap.put("original_value_begin", row.get("original_value_begin"));
            rowMap.put("accumulated_depre_begin", row.get("accumulated_depre_begin"));
            rowMap.put("depre_reserves_begin", row.get("depre_reserves_begin"));
            rowMap.put("net_value_begin", row.get("net_value_begin"));
            rowMap.put("original_adjust", row.get("original_adjust"));
            rowMap.put("accumulated_depre_adjust", row.get("accumulated_depre_adjust"));
            rowMap.put("depre_adjust", row.get("depre_adjust"));
            rowMap.put("bef_adjust_depreciation", row.get("bef_adjust_depreciation"));
            rowMap.put("actual_depreciation", row.get("actual_depreciation"));
            rowMap.put("year_depreciation", row.get("year_depreciation"));
            rowMap.put("original_value_end", row.get("original_value_end"));
            rowMap.put("accumulated_depre_end", row.get("accumulated_depre_end"));
            rowMap.put("depre_reserves_end", row.get("depre_reserves_end"));
            rowMap.put("net_value_end", row.get("net_value_end"));
            rowMap.put("summarytype", row.get("summarytype"));
            if (otherFinFieldSet.isEmpty()) continue;
            HashMap<String, Object> otherFinFieldsMap = new HashMap<String, Object>(8);
            rowMap.put("otherFinFieldsMap", otherFinFieldsMap);
            for (Field field : fields) {
                if (!otherFinFieldSet.contains(field.getName())) continue;
                otherFinFieldsMap.put(field.getName(), row.get(field.getName()));
            }
        }
        return rowList;
    }
}

