/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice.operation;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.fi.fa.business.change.ChangeBillOpImp;
import kd.fi.fa.mservice.operation.AbstractChangeBillService;

public class ChangeBillOpServiceImpl
extends AbstractChangeBillService {
    private static Log logger = LogFactory.getLog(ChangeBillOpServiceImpl.class);

    public List<String> createOriginValueChangeBill(String objs, String typeName) throws Exception {
        List<String> result = new ArrayList<String>();
        if (objs.isEmpty()) {
            return result;
        }
        try {
            result = this.doCreateOriginValueChangeBill(objs, typeName);
        }
        catch (Exception ex) {
            this.writeLog(ex);
            throw ex;
        }
        return result;
    }

    public List<String> doCreateOriginValueChangeBill(String objs, String typeName) {
        List<String> result = new ArrayList<String>();
        String entityTypeName = typeName.isEmpty() ? "ap_verifyrecord" : typeName;
        MainEntityType EntityType = EntityMetadataCache.getDataEntityType((String)entityTypeName);
        Object[] bills = DynamicObjectSerializeUtil.deserialize((String)objs, (DynamicObjectType)EntityType);
        if (bills == null || bills.length == 0) {
            return result;
        }
        DynamicObject[] newBizBills = new DynamicObject[bills.length];
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject bill;
            newBizBills[i] = bill = (DynamicObject)bills[i];
        }
        result = new ChangeBillOpImp().createOriginValueChangeBill(newBizBills);
        return result;
    }

    void writeLog(Exception ex) {
        String msg = String.format("%s:%s", "Error for ChangeBillOpService", ex.getMessage());
        logger.info(msg);
    }
}

