/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.fa.business.dao.IBdSystemStatusDao;
import kd.fi.fa.business.dao.IFaAssetBookDao;
import kd.fi.fa.business.dao.factory.BdSystemStatusDaoFactory;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.utils.FunctionMutexHelper;
import kd.fi.fa.common.batch.BatchOneByOne;
import kd.fi.fa.common.batch.BatchResult;

public class FaAntiCloseInitOpService
extends EntityOperateService {
    private static IFaAssetBookDao assetBookDao = FaAssetBookDaoFactory.getInstance();

    protected void executeOperate(DynamicObject[] objs) {
        this.antiCloseInitAssetBook(objs);
    }

    protected void preparePropertys(List<String> fieldKeys) {
        fieldKeys.add("startperiod");
        fieldKeys.add("curperiod");
        fieldKeys.add("status");
        fieldKeys.add("depreuse");
        fieldKeys.add("org");
    }

    public BatchResult<DynamicObject, Void> antiCloseInitAssetBook(DynamicObject[] assetBookObjs) {
        BatchOneByOne batch = new BatchOneByOne((Object[])assetBookObjs);
        BatchResult result = batch.execute(v -> FaAntiCloseInitOpService.withMutex(v, FaAntiCloseInitOpService::unableByAssetBookObj), v -> v.getString("name"));
        this.handleBatchResult((BatchResult<DynamicObject, Void>)result);
        return result;
    }

    private static void unableByAssetBookObj(DynamicObject assetBookObj) {
        try (TXHandle h = TX.requiresNew();){
            try {
                FaAntiCloseInitOpService.doUnableValidator(assetBookObj);
                FaAntiCloseInitOpService.delAutoSwitchDynDepre(assetBookObj);
                FaAntiCloseInitOpService.setEnable(assetBookObj, BillStatus.B);
                IBdSystemStatusDao systemDao = BdSystemStatusDaoFactory.getInstance();
                systemDao.deleteByAssetBook(assetBookObj);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static void withMutex(DynamicObject assetBookObj, Consumer<DynamicObject> action) {
        FunctionMutexHelper.lockWithBook((String)"fa_assetbook", (DynamicObject)assetBookObj, () -> action.accept(assetBookObj));
    }

    private static void doUnableValidator(DynamicObject assetBook) {
        ArrayList<String> errMsgLst = new ArrayList<String>();
        Object status = assetBook.get("status");
        if ("B".equals(status)) {
            errMsgLst.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u672a\u542f\u7528\u3002", (String)"FaAntiCloseInitOpService_0", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else {
            DynamicObject enablePeriod = (DynamicObject)assetBook.get("startperiod");
            DynamicObject currentperiod = (DynamicObject)assetBook.get("curperiod");
            if (!enablePeriod.getPkValue().equals(currentperiod.getPkValue())) {
                errMsgLst.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u4e0d\u7b49\u4e8e\u542f\u7528\u671f\u95f4\u3002", (String)"FaAntiCloseInitOpService_1", (String)"fi-fa-mservice", (Object[])new Object[0]));
            }
        }
        if (errMsgLst.size() > 0) {
            throw new KDBizException(errMsgLst.stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    private static void delAutoSwitchDynDepre(DynamicObject assetBookObj) {
        Object bookId = assetBookObj.get("id");
        QFilter[] filters = new QFilter[]{new QFilter("changebillid", "=", bookId), new QFilter("entityname", "=", (Object)"fa_initAutoSwitch")};
        DeleteServiceHelper.delete((String)"fa_card_dynamic", (QFilter[])filters);
    }

    private static void setEnable(DynamicObject assetBook, BillStatus status) {
        Object bookId = assetBook.getPkValue();
        assetBookDao.updateStatus(bookId, status);
        if (status.compareTo((Enum)BillStatus.C) == 0) {
            assetBookDao.updateEnable(bookId, "1");
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("assetbook.id", "=", bookId), new QFilter("totaldepreamount", "=", (Object)0)};
            DeleteServiceHelper.delete((String)"fa_depre_sum", (QFilter[])filters);
            assetBookDao.updateEnable(bookId, "0");
        }
    }

    private void handleBatchResult(BatchResult<DynamicObject, Void> result) {
        if (result.hasFailure()) {
            OperationResult opResult = this.getOperationResult();
            opResult.setSuccess(Boolean.FALSE.booleanValue());
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(result.getDetailMessage(v -> v.getString("name")));
            errorInfo.setErrorLevel(ErrorLevel.FatalError.name());
            ArrayList<OperateErrorInfo> errorInfoes = new ArrayList<OperateErrorInfo>(1);
            errorInfoes.add(errorInfo);
            opResult.setAllErrorInfo(errorInfoes);
        }
    }
}

