/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice.operation;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.dao.IBdSystemStatusDao;
import kd.fi.fa.business.dao.IFaAssetBookDao;
import kd.fi.fa.business.dao.factory.BdSystemStatusDaoFactory;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.model.ReconciliationParam;
import kd.fi.fa.business.utils.FunctionMutexHelper;
import kd.fi.fa.common.batch.BatchOneByOne;
import kd.fi.fa.common.batch.BatchResult;
import kd.fi.fa.common.exception.FaException;
import kd.fi.fa.common.util.Fa;

public class FaCloseInitOpService
extends EntityOperateService {
    private static IFaAssetBookDao assetBookDao = FaAssetBookDaoFactory.getInstance();
    private static final String ALGO = "kd.fi.fa.opplugin.FaCloseInitOp";

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        fieldKeys.add("org");
        fieldKeys.add("startperiod");
        fieldKeys.add("ismainbook");
    }

    protected void executeOperate(DynamicObject[] objs) {
        BatchResult<DynamicObject, Void> result = FaCloseInitOpService.closeInitAssetBook(objs);
        this.handleBatchResult(result);
    }

    public static BatchResult<DynamicObject, Void> closeInitAssetBook(DynamicObject[] assetBooks) {
        HashMap<Long, DynamicObject> bookMap = new HashMap<Long, DynamicObject>();
        HashSet<Long> recSuccessBookIds = new HashSet<Long>();
        HashSet<Long> recfailureBookIds = new HashSet<Long>();
        HashMap<Long, String> bookErrMsg = new HashMap<Long, String>();
        if (assetBooks.length > 0) {
            for (DynamicObject assetBook : assetBooks) {
                long assetbookid = assetBook.getLong("id");
                bookMap.put(assetBook.getLong("id"), assetBook);
                ReconciliationParam parm = new ReconciliationParam();
                parm.setInit(true);
                parm.setAppNumber("fa");
                parm.setOrgId(Long.valueOf(assetBook.getLong("org.id")));
                parm.setBizBookId(Long.valueOf(assetbookid));
                parm.setPeriodId(Long.valueOf(assetBook.getLong("startperiod.id")));
                String parmJson = JSONObject.toJSONString((Object)parm);
                try {
                    FaCloseInitOpService.DoReconciliation(parmJson);
                    recSuccessBookIds.add(assetbookid);
                }
                catch (Exception e) {
                    if (e instanceof KDBizException) {
                        KDBizException kdex = (KDBizException)e;
                        if ("3".equals(kdex.getErrorCode().getCode())) {
                            recSuccessBookIds.add(assetbookid);
                            continue;
                        }
                        if ("2".equals(kdex.getErrorCode().getCode())) {
                            recfailureBookIds.add(assetbookid);
                            bookErrMsg.put(assetbookid, ResManager.loadKDString((String)"\u4e0e\u603b\u8d26\u521d\u59cb\u5316\u5bf9\u8d26\u4e0d\u5e73\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"FaCloseInitOpService_0", (String)"fi-fa-mservice", (Object[])new Object[0]));
                            continue;
                        }
                        if ("7".equals(kdex.getErrorCode().getCode())) {
                            recfailureBookIds.add(assetbookid);
                            bookErrMsg.put(assetbookid, kdex.getArgs()[0].toString());
                            continue;
                        }
                        recfailureBookIds.add(assetbookid);
                        bookErrMsg.put(assetbookid, kdex.getErrorCode().getMessage());
                        continue;
                    }
                    recSuccessBookIds.add(assetbookid);
                }
            }
        }
        Object[] assetBookObjs = assetBookDao.query(new QFilter("id", "in", recSuccessBookIds));
        BatchOneByOne batch = new BatchOneByOne(assetBookObjs);
        BatchResult result = batch.execute(v -> FaCloseInitOpService.withMutex(v, FaCloseInitOpService::enableByAssetBookObj), v -> v.getString("name"));
        for (Long recFailureBookId : recfailureBookIds) {
            FaException ex = new FaException((String)bookErrMsg.get(recFailureBookId));
            result.addFailureInfo(bookMap.get(recFailureBookId), (Exception)ex);
        }
        return result;
    }

    private static void withMutex(DynamicObject assetBookObj, Consumer<DynamicObject> action) {
        FunctionMutexHelper.lockWithBook((String)"fa_assetbook", (DynamicObject)assetBookObj, () -> action.accept(assetBookObj));
    }

    private static void enableByAssetBookObj(DynamicObject assetBookObj) {
        try (TXHandle h = TX.requiresNew();){
            try {
                FaCloseInitOpService.doValidator(assetBookObj);
                FaCloseInitOpService.switchDynDepre(assetBookObj);
                FaCloseInitOpService.setEnable(assetBookObj, BillStatus.C);
                IBdSystemStatusDao systemDao = BdSystemStatusDaoFactory.getInstance();
                systemDao.createByAssetBook(assetBookObj);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static void doValidator(DynamicObject assetBookObj) {
        Optional finCardNames;
        Object status;
        ArrayList<String> errMsgLst = new ArrayList<String>();
        if (assetBookObj.get("startperiod") == null || assetBookObj.get("curperiod") == null) {
            errMsgLst.add(ResManager.loadKDString((String)"\u542f\u7528\u671f\u95f4\u672a\u8bbe\u7f6e\u3002", (String)"FaCloseInitOpService_1", (String)"fi-fa-mservice", (Object[])new Object[0]));
        }
        if ("C".equals(status = assetBookObj.get("status"))) {
            errMsgLst.add(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"FaCloseInitOpService_2", (String)"fi-fa-mservice", (Object[])new Object[0]));
        }
        if ((finCardNames = FaFinCardDaoFactory.getInstance().checkExistInitCardUnAudited(assetBookObj.get("org.id"), assetBookObj.getPkValue())).isPresent()) {
            errMsgLst.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u521d\u59cb\u5316\u5b9e\u7269\u5361\u7247\u672a\u751f\u6210\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\u6216\u8005\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\u4e3a\u6682\u5b58\u72b6\u6001\uff1a%s\u3002", (String)"FaCloseInitOpService_3", (String)"fi-fa-mservice", (Object[])new Object[0]), finCardNames.get()));
        }
        FaCloseInitOpService.checkInitLeaseContractPushCard(assetBookObj, errMsgLst);
        if (errMsgLst.size() > 0) {
            throw new KDBizException(errMsgLst.stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    private static void checkInitLeaseContractPushCard(DynamicObject assetBook, List<String> errMsgLst) {
        if (assetBook.getBoolean("ismainbook")) {
            QFilter[] filters;
            long orgId = assetBook.getLong(Fa.id((String)"org"));
            long enablePeriodId = assetBook.getLong(Fa.id((String)"startperiod"));
            DynamicObject leaseInit = QueryServiceHelper.queryOne((String)"fa_lease_init", (String)"startperiod", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            if (leaseInit != null && enablePeriodId == leaseInit.getLong("startperiod") && QueryServiceHelper.exists((String)"fa_lease_contract_init", (QFilter[])(filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("sourcetype", "=", (Object)"B"), new QFilter("isexempt", "=", (Object)Boolean.FALSE), new QFilter("assetqtycreate", "=", (Object)1)}))) {
                errMsgLst.add(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5408\u540c\u672a\u4e0b\u63a8\u521d\u59cb\u5316\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"FaCloseInitOpService_4", (String)"fi-fa-mservice", (Object[])new Object[0]));
            }
        }
    }

    private static void switchDynDepre(DynamicObject assetBookObj) {
        Object bookId = assetBookObj.get("id");
        Object orgId = assetBookObj.get("org_id");
        Object depreuseId = assetBookObj.get("depreuse_id");
        Date beginDate = assetBookObj.getDate("startperiod.beginDate");
        String sql = "select t1.fid realcardId from t_fa_card_real t1 inner join t_fa_card_fin t2 on t1.fid=t2.frealcardid where t2.forg=? and t2.fdepreuseid=? and t2.fperiodid = 0 and t2.fdecval > 0 and t1.fid not in (select frealcardid from t_fa_card_dynamic where fassetbookid=? and fentityname='fa_dyndepre')";
        ArrayList<DynamicObject> dynamicCards = new ArrayList<DynamicObject>();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_card_dynamic");
        try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{orgId, depreuseId, bookId});){
            for (Row row : ds) {
                DynamicObject dynamicCard = new DynamicObject((DynamicObjectType)type);
                dynamicCard.set("realcard", row.get("realcardId"));
                dynamicCard.set("assetbook", bookId);
                dynamicCard.set("depreuse", depreuseId);
                dynamicCard.set("date", (Object)beginDate);
                dynamicCard.set("entityname", (Object)"fa_initAutoSwitch");
                dynamicCard.set("changebillid", bookId);
                dynamicCards.add(dynamicCard);
            }
        }
        if (dynamicCards.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicCards.toArray(new DynamicObject[0]));
        }
    }

    private static void setEnable(DynamicObject assetBook, BillStatus status) {
        Object bookId = assetBook.getPkValue();
        assetBookDao.updateStatus(bookId, status);
        if (status.compareTo((Enum)BillStatus.C) == 0) {
            assetBookDao.updateEnable(bookId, "1");
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("assetbook.id", "=", bookId), new QFilter("totaldepreamount", "=", (Object)0)};
            DeleteServiceHelper.delete((String)"fa_depre_sum", (QFilter[])filters);
            assetBookDao.updateEnable(bookId, "0");
        }
    }

    private void handleBatchResult(BatchResult<DynamicObject, Void> result) {
        if (result.hasFailure()) {
            OperationResult opResult = this.getOperationResult();
            opResult.setSuccess(Boolean.FALSE.booleanValue());
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(result.getDetailMessage(v -> v.getString("name")));
            errorInfo.setErrorLevel(ErrorLevel.FatalError.name());
            ArrayList<OperateErrorInfo> errorInfoes = new ArrayList<OperateErrorInfo>(1);
            errorInfoes.add(errorInfo);
            opResult.setAllErrorInfo(errorInfoes);
        }
    }

    private static void DoReconciliation(String parmJson) {
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{parmJson});
    }
}

