/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.service.FaQueryCurFinOpenService;

public class FaQueryCurFinOpenServiceImpl
implements FaQueryCurFinOpenService {
    private static final String selectFinFields = Fa.comma((String[])new String[]{"id", "number", "depreuse", "monthdepre", "accumdepre", "networth", "netamount", "originalval", "decval", "bizperiod", "endperiod"});

    public Map<String, Map<String, Object>> queryCurFinOpen(Long orgId, List<String> numbers, boolean isOpenDepre, boolean isNewPeriod) {
        DynamicObject mainBook = FaUtils.getMainBookByOrg((Long)orgId);
        if (mainBook == null) {
            return new HashMap<String, Map<String, Object>>(8);
        }
        long depreUseId = mainBook.getLong("depreuse");
        long currPeriodId = mainBook.getLong("curperiod");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter("number", "in", numbers));
        qFilters.add(new QFilter("depreuse", "=", (Object)depreUseId));
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        if (isNewPeriod) {
            qFilters.add(new QFilter("endperiod", "=", (Object)99999999999L));
        } else {
            qFilters.add(new QFilter("bizperiod", "<=", (Object)currPeriodId).and("endperiod", ">", (Object)currPeriodId));
        }
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFinFields, (QFilter[])qFilters.toArray(new QFilter[0]));
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(finCards.size());
        for (DynamicObject curFincard : finCards) {
            HashMap<String, Object> curFinMap = new HashMap<String, Object>(16);
            long bizPeriodId = curFincard.getLong("bizperiod");
            String number = curFincard.getString("number");
            BigDecimal monthdepre = curFincard.getBigDecimal("monthdepre");
            BigDecimal accumdepre = curFincard.getBigDecimal("accumdepre");
            BigDecimal netWorth = curFincard.getBigDecimal("networth");
            BigDecimal netAmount = curFincard.getBigDecimal("netamount");
            BigDecimal originalVal = curFincard.getBigDecimal("originalval");
            BigDecimal decval = curFincard.getBigDecimal("decval");
            if (isNewPeriod) {
                if (isOpenDepre) {
                    accumdepre = accumdepre.subtract(monthdepre);
                    netWorth = netWorth.add(monthdepre);
                    netAmount = netAmount.add(monthdepre);
                }
            } else if (bizPeriodId == currPeriodId && isOpenDepre) {
                accumdepre = accumdepre.subtract(monthdepre);
                netWorth = netWorth.add(monthdepre);
                netAmount = netAmount.add(monthdepre);
            }
            curFinMap.put("id", curFincard.getLong("id"));
            curFinMap.put("number", number);
            curFinMap.put("depreuse", depreUseId);
            curFinMap.put("openOrinigal", originalVal);
            curFinMap.put("openDecval", decval);
            curFinMap.put("openNetWorth", netWorth);
            curFinMap.put("openNetAmount", netAmount);
            curFinMap.put("openAccumdepre", accumdepre);
            result.put(number, curFinMap);
        }
        return result;
    }
}

