/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.common.batch;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.common.exception.FaException;

public class BatchResult<T, U> {
    private static final Log log = LogFactory.getLog((String)"kd.fi.fa.common.batch.BatchResult");
    public final Map<T, U> successElements = new HashMap<T, U>();
    public final Map<T, Exception> failureInfos = new HashMap<T, Exception>();

    public void addSuccessElement(T element, U actionResult) {
        this.successElements.put(element, actionResult);
    }

    public void addFailureInfo(T element, Exception ex) {
        this.failureInfos.put(element, ex);
    }

    public boolean hasSuccess() {
        return this.successElements.size() > 0;
    }

    public boolean hasFailure() {
        return !this.failureInfos.isEmpty();
    }

    public String getMessage(String actionName) {
        if (this.failureInfos.size() == 0) {
            return String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"BatchResult_0", (String)"fi-fa-common", (Object[])new Object[0]), actionName);
        }
        return String.format(ResManager.loadKDString((String)"%1$s\u6210\u529f%s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"BatchResult_1", (String)"fi-fa-common", (Object[])new Object[0]), actionName, this.successElements.size(), this.failureInfos.size());
    }

    public String getDetailMessage(Function<T, String> elementMapper, Function<Exception, String> failInfoMapper) {
        if (!this.hasFailure()) {
            return ResManager.loadKDString((String)"\u5168\u90e8\u6267\u884c\u6210\u529f", (String)"BatchResult_2", (String)"fi-fa-common", (Object[])new Object[0]);
        }
        StringBuilder detail = new StringBuilder();
        String fmt = "%s\uff1a%s" + System.lineSeparator();
        this.failureInfos.forEach((element, failInfo) -> detail.append(String.format(fmt, elementMapper.apply(element), failInfoMapper.apply((Exception)failInfo))));
        return detail.toString();
    }

    public String getDetailMessage(Function<T, String> elementMapper) {
        return this.getDetailMessage(elementMapper, ex -> {
            if (ex instanceof KDBizException) {
                return ex.getMessage();
            }
            if (ex instanceof FaException) {
                return ex.getMessage();
            }
            String errormsg = String.format(ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458%s", (String)"BatchResult_3", (String)"fi-fa-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            log.info(errormsg);
            return errormsg;
        });
    }
}

