/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.depresplits;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;

public class FaDepreSplitSchemaEntryPlugin
extends AbstractFormPlugin {
    private static final String SAVE = "save";
    private static final String ENTRY = "entryentity";
    private static final String CM = "cm";
    private static final String ASS = "assacty";
    private static final String REALCARD = "fa_card_real_base";
    private static final String FINCARD = "fa_card_fin_base";
    private static final String ORG = "cache_org";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SAVE});
        BasedataEdit ass = (BasedataEdit)this.getControl(ASS);
        final String org = this.getPageCache().get(ORG);
        ass.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                if (org != null) {
                    QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(org));
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object text = this.getView().getFormShowParameter().getCustomParam("text");
        Object org = this.getView().getFormShowParameter().getCustomParam("org");
        if (org != null) {
            this.setAssactyFilter(Long.parseLong(org.toString()));
        }
        this.setColumnForCM();
        if (text != null) {
            this.setEntryData(text.toString());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeItem;
        super.propertyChanged(e);
        switch (changeItem = e.getProperty().getName()) {
            case "assacty": {
                this.setSourceColumn();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSourceColumn();
    }

    private void setSourceColumn() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY);
        ArrayList vsc = new ArrayList(entryEntity.size());
        entryEntity.forEach(v -> {
            if (v.get(ASS) != null) {
                vsc.add(Long.parseLong(((DynamicObject)v.get(ASS)).getPkValue().toString()));
            }
        });
        if (vsc.isEmpty()) {
            return;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_asstacttype", (String)"valuetype,valuesource,assistanttype", (QFilter[])new QFilter("id", "in", vsc).toArray());
        ArrayList protysc = new ArrayList();
        Arrays.asList(load).stream().forEach(v -> {
            String valueType = v.getString("valuetype");
            String source = null;
            if ("1".equals(valueType)) {
                DynamicObject valueSourceObj = v.getDynamicObject("valuesource");
                source = valueSourceObj == null ? null : valueSourceObj.getPkValue().toString();
            } else {
                DynamicObject assistantTypeObj = v.getDynamicObject("assistanttype");
                String string = source = assistantTypeObj == null ? null : assistantTypeObj.getPkValue().toString();
            }
            if (source != null) {
                protysc.add(source);
            }
        });
        String cache = this.getPageCache().get("vsItems");
        if (cache == null) {
            return;
        }
        List items = (List)SerializationUtils.deSerializeFromBase64((String)cache);
        ArrayList<ComboItem> newitems = new ArrayList<ComboItem>();
        DataEntityPropertyCollection realCardProperties = MetadataServiceHelper.getDataEntityType((String)REALCARD).getProperties();
        DataEntityPropertyCollection finCardProperties = MetadataServiceHelper.getDataEntityType((String)FINCARD).getProperties();
        protysc.stream().forEach(v -> {
            ArrayList<String> props = new ArrayList<String>();
            this.filterCardProp((String)v, realCardProperties, (List<String>)props);
            this.filterCardProp((String)v, finCardProperties, (List<String>)props);
            for (ComboItem item : items) {
                String[] split;
                String value = item.getValue();
                if ("".equals(value) || !props.contains((split = value.split("\\."))[1])) continue;
                newitems.add(item);
            }
        });
        ComboEdit cmedit = (ComboEdit)this.getView().getControl(CM);
        cmedit.setComboItems(newitems);
        this.cleanIncorrectCm(newitems);
    }

    private void cleanIncorrectCm(List<ComboItem> newItems) {
        List itemVals = newItems.stream().map(ComboItem::getValue).collect(Collectors.toList());
        DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRY);
        if (CollectionUtils.isNotEmpty((Collection)entries)) {
            int i = 0;
            for (DynamicObject entry : entries) {
                String cm = entry.getString(CM);
                if (!itemVals.contains(cm)) {
                    this.getModel().setValue(CM, (Object)"", i);
                }
                ++i;
            }
        }
    }

    private void filterCardProp(String asstactType, DataEntityPropertyCollection properties, List<String> propList) {
        boolean isOrgProp = asstactType.contains("org");
        boolean isUserProp = asstactType.contains("user");
        for (IDataEntityProperty prop : properties) {
            if (isOrgProp && prop instanceof OrgProp) {
                propList.add(prop.getName());
                continue;
            }
            if (isUserProp && prop instanceof UserProp) {
                propList.add(prop.getName());
                continue;
            }
            if (prop instanceof BasedataProp && asstactType.equals(((BasedataProp)prop).getBaseEntityId())) {
                propList.add(prop.getName());
                continue;
            }
            if (!(prop instanceof AssistantProp) || !asstactType.equals(((AssistantProp)prop).getAsstTypeId())) continue;
            propList.add(prop.getName());
        }
    }

    private void setColumnForCM() {
        HashMap<String, String> cacheCol = new HashMap<String, String>();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        items.add(blankItem);
        DataEntityPropertyCollection properties = MetadataServiceHelper.getDataEntityType((String)REALCARD).getProperties();
        String realCardName = ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247", (String)"FaDepreSplitSchemaEntryPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        for (IDataEntityProperty prop : properties) {
            String alias = prop.getAlias();
            if (!StringUtils.isNotEmpty((CharSequence)alias) || !(prop instanceof BasedataProp) && !(prop instanceof OrgProp) && !(prop instanceof UserProp)) continue;
            ComboItem item = new ComboItem();
            String cc = realCardName + "." + prop.getDisplayName().toString();
            item.setCaption(new LocaleString(cc));
            item.setValue("realcard." + prop.getName());
            items.add(item);
            cacheCol.put("realcard." + prop.getName(), cc);
        }
        DataEntityPropertyCollection propertiess = MetadataServiceHelper.getDataEntityType((String)FINCARD).getProperties();
        String finCardName = ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247", (String)"FaDepreSplitSchemaEntryPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        for (IDataEntityProperty prop : propertiess) {
            String alias = prop.getAlias();
            if (!StringUtils.isNotEmpty((CharSequence)alias) || !(prop instanceof BasedataProp) && !(prop instanceof OrgProp) && !(prop instanceof UserProp)) continue;
            ComboItem item = new ComboItem();
            String cc = finCardName + "." + prop.getDisplayName().toString();
            item.setCaption(new LocaleString(cc));
            item.setValue("fincard." + prop.getName());
            items.add(item);
            cacheCol.put("fincard." + prop.getName(), cc);
        }
        ComboEdit cmedit = (ComboEdit)this.getView().getControl(CM);
        cmedit.setComboItems(items);
        this.getPageCache().put("vsItems", SerializationUtils.serializeToBase64(items));
        this.getPageCache().put("cacheColumn", SerializationUtils.toJsonString(cacheCol));
    }

    private void setEntryData(String str) {
        if (str != null && !str.equals("")) {
            IDataModel model = this.getModel();
            String[] ss = str.split(";");
            int indexc = 0;
            for (String cc : ss) {
                String[] split = cc.split(":");
                int index = model.createNewEntryRow(ENTRY);
                model.setValue(ASS, (Object)split[0], index - 1);
                model.setValue(CM, (Object)split[1], index - 1);
                indexc = index;
            }
            model.deleteEntryRow(ENTRY, indexc);
        }
    }

    private void setAssactyFilter(Long org) {
        this.getPageCache().put(ORG, String.valueOf(org));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "save": {
                this.validateData();
                this.returndata();
            }
        }
    }

    private void validateData() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRY);
        for (int rowIndex = 0; rowIndex < entryentity.size(); ++rowIndex) {
            DynamicObject changeRow = (DynamicObject)entryentity.get(rowIndex);
            DynamicObject assacty = changeRow.getDynamicObject(ASS);
            String originCardField = changeRow.getString(CM);
            if (StringUtils.isEmpty((CharSequence)originCardField)) {
                if (assacty != null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5355\u636e\u5b57\u6bb5\u672a\u8bbe\u7f6e\u3002", (String)"FaDepreSplitSchemaEntryPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowIndex + 1));
                }
                return;
            }
            if (assacty == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6838\u7b97\u7ef4\u5ea6\u672a\u8bbe\u7f6e\u3002", (String)"FaDepreSplitSchemaEntryPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowIndex + 1));
            }
            String cardField = null;
            DataEntityPropertyCollection cardProps = null;
            if (originCardField.startsWith("realcard")) {
                cardProps = MetadataServiceHelper.getDataEntityType((String)REALCARD).getProperties();
                cardField = originCardField.replaceFirst("realcard\\.", "");
            } else {
                cardProps = MetadataServiceHelper.getDataEntityType((String)FINCARD).getProperties();
                cardField = originCardField.replaceFirst("fincard\\.", "");
            }
            String finalCardField = cardField;
            IDataEntityProperty dataEntityProperty = cardProps.stream().filter(f -> finalCardField.equals(f.getName())).findFirst().get();
            String valuetype = assacty.getString("valuetype");
            if ("1".equals(valuetype)) {
                String valueSourceDataEntityId = assacty.getString("valuesource.number");
                if (!(dataEntityProperty instanceof BasedataProp)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6838\u7b97\u7ef4\u5ea6\u4e0e\u6240\u9009\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"FaDepreSplitSchemaEntryPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowIndex + 1));
                }
                BasedataProp basedataProp = (BasedataProp)dataEntityProperty;
                if ("bos_adminorg".equals(valueSourceDataEntityId)) {
                    valueSourceDataEntityId = "bos_org";
                }
                if (basedataProp.getBaseEntityId().equals(valueSourceDataEntityId)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6838\u7b97\u7ef4\u5ea6\u4e0e\u6240\u9009\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"FaDepreSplitSchemaEntryPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowIndex + 1));
            }
            if (!"2".equals(valuetype)) continue;
            String asstDataGroupId = assacty.getString("assistanttype.id");
            if (!(dataEntityProperty instanceof AssistantProp)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6838\u7b97\u7ef4\u5ea6\u4e0e\u6240\u9009\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"FaDepreSplitSchemaEntryPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowIndex + 1));
            }
            AssistantProp assistantProp = (AssistantProp)dataEntityProperty;
            String asstTypeId = assistantProp.getAsstTypeId();
            if (asstDataGroupId.equals(asstTypeId)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6838\u7b97\u7ef4\u5ea6\u4e0e\u6240\u9009\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"FaDepreSplitSchemaEntryPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
    }

    private void returndata() {
        Boolean cc = false;
        IDataModel model = this.getModel();
        StringBuilder text = new StringBuilder();
        StringBuilder show = new StringBuilder();
        DynamicObjectCollection entrys = model.getEntryEntity(ENTRY);
        String cacheCol = this.getPageCache().get("cacheColumn");
        ArrayList<Object> asstTypes = new ArrayList<Object>();
        for (DynamicObject entry : entrys) {
            Object ass = entry.get(ASS);
            Object cm = entry.get(CM);
            if (ass != null && cm != null) {
                String cmname = "";
                if (cacheCol != null) {
                    Map cachecol = (Map)SerializationUtils.fromJsonString((String)cacheCol, Map.class);
                    cmname = (String)cachecol.get(cm);
                }
                asstTypes.add(((DynamicObject)ass).getPkValue());
                text.append(((DynamicObject)ass).getPkValue().toString());
                text.append(":");
                text.append(cm.toString());
                text.append(";");
                show.append(((DynamicObject)ass).get("name").toString());
                show.append(":");
                show.append(cmname);
                show.append(";");
                continue;
            }
            cc = true;
        }
        if (cc.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u4e00\u884c\u7684\u6838\u7b97\u7ef4\u5ea6\u548c\u53d6\u5355\u636e\u5b57\u6bb5\u503c\u90fd\u9700\u8981\u6709\u503c\uff0c\u4e0d\u7136\u65e0\u6cd5\u7ec4\u6210\u5bf9\u5e94\u5173\u7cfb\uff0c\u8bf7\u5f55\u5165\u7f3a\u5c11\u7684\u503c\u3002", (String)"FaDepreSplitSchemaEntryPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("text", text.toString());
        result.put("show", show.toString());
        result.put("asstacttype", asstTypes);
        this.getView().returnDataToParent(result);
        this.getView().close();
    }
}

