/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.FaWorkLoadBatchEditPlugin;
import kd.fi.fa.formplugin.FaWorkLoadEditPlugin;

abstract class AbstractWorkLoadPlugin
extends AbstractFormPlugin {
    AbstractWorkLoadPlugin() {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OrgEdit orgCtrl = (OrgEdit)this.getControl("org");
        orgCtrl.setIsOnlyDisplayOrgLeaves(true);
        orgCtrl.addBeforeF7SelectListener(this::orgBeforeF7Select);
        BasedataEdit dereUseCtrl = (BasedataEdit)this.getControl("depreuse");
        dereUseCtrl.addBeforeF7SelectListener(this::depreUseBeforeF7Select);
        BasedataEdit periodCtrl = (BasedataEdit)this.getControl("period");
        periodCtrl.addBeforeF7SelectListener(this::periodBeforeF7Select);
        BasedataEdit realCardCtrl = (BasedataEdit)this.getControl("realcard");
        realCardCtrl.addBeforeF7SelectListener(this::realCardBeforeF7Select);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("org".equals(propName) || "depreuse".equals(propName)) {
            this.setCurPeriodAndDate();
        }
        if ("realcard".equals(propName)) {
            QFilter endPeriodQFilter;
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                return;
            }
            DynamicObject realCard = (DynamicObject)newValue;
            HashSet<Long> realCardIdSet = new HashSet<Long>();
            realCardIdSet.add(realCard.getLong("id"));
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            long orgId = org.getLong("id");
            Date date = (Date)this.getModel().getValue("date");
            Optional checkResult = new FutureBizChecker(null, (Object)orgId, realCardIdSet, date, BusyTypeDetailEnum.FIN_CHG).check();
            if (checkResult.isPresent()) {
                this.getModel().setValue("realcard", oldValue, rowIndex);
                String realCardNumber = realCard.getString("number");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a%s \u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u6216\u8005\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5361\u7247\uff0c\u4e0d\u53ef\u505a\u5f53\u524d\u4e1a\u52a1\u3002", (String)"AbstractWorkLoadPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), realCardNumber));
            }
            Object depreUseObj = this.getModel().getValue("depreuse");
            DynamicObject depreUseDynObj = (DynamicObject)depreUseObj;
            long depreUseId = depreUseDynObj.getLong("id");
            QFilter depreUseQFilter = new QFilter("depreuse", "=", (Object)depreUseId);
            QFilter realCardIdQFilter = new QFilter("realcardmasterid", "=", (Object)realCard.getLong("id"));
            DynamicObject finCardWorkLoadUnitDyn = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)"workloadunit", (QFilter[])new QFilter[]{realCardIdQFilter, depreUseQFilter, endPeriodQFilter = new QFilter("endperiod", "=", (Object)99999999999L)});
            if (Objects.nonNull(finCardWorkLoadUnitDyn)) {
                Long workUnit = finCardWorkLoadUnitDyn.getLong("workloadunit") == 0L ? null : Long.valueOf(finCardWorkLoadUnitDyn.getLong("workloadunit"));
                this.getModel().setValue("workloadunitid", (Object)workUnit, rowIndex);
            }
        }
        IDataModel model = this.getModel();
        if (propName.equals("depreuse")) {
            if (e.getChangeSet()[0].getNewValue() == null) {
                return;
            }
            if (this instanceof FaWorkLoadEditPlugin) {
                Object depreUseObj = this.getModel().getValue("depreuse");
                DynamicObject realcard = (DynamicObject)this.getModel().getValue("realcard");
                DynamicObject depreUseDynObj = (DynamicObject)depreUseObj;
                long depreUseId = depreUseDynObj.getLong("id");
                QFilter depreUseQFilter = new QFilter("depreuse", "=", (Object)depreUseId);
                QFilter realCardIdQFilter = new QFilter("realcardmasterid", "=", (Object)realcard.getLong("id"));
                DynamicObject finCardWorkLoadUnitDyn = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)"workloadunit", (QFilter[])new QFilter[]{realCardIdQFilter, depreUseQFilter});
                if (Objects.nonNull(finCardWorkLoadUnitDyn)) {
                    Long workUnit = finCardWorkLoadUnitDyn.getLong("workloadunit") == 0L ? null : Long.valueOf(finCardWorkLoadUnitDyn.getLong("workloadunit"));
                    this.getModel().setValue("workloadunitid", (Object)workUnit);
                    this.getModel().setValue("workload", null);
                }
            }
            if (this instanceof FaWorkLoadBatchEditPlugin) {
                DynamicObjectCollection workLoadEntry = model.getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("workloadentry");
                for (int i = 0; i < workLoadEntry.size(); ++i) {
                    Object depreUseObj = this.getModel().getValue("depreuse");
                    DynamicObject realcard = ((DynamicObject)workLoadEntry.get(i)).getDynamicObject("realcard");
                    if (realcard == null) continue;
                    DynamicObject depreUseDynObj = (DynamicObject)depreUseObj;
                    long depreUseId = depreUseDynObj.getLong("id");
                    QFilter depreUseQFilter = new QFilter("depreuse", "=", (Object)depreUseId);
                    QFilter realCardIdQFilter = new QFilter("realcardmasterid", "=", (Object)realcard.getLong("id"));
                    DynamicObject finCardWorkLoadUnitDyn = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)"workloadunit", (QFilter[])new QFilter[]{realCardIdQFilter, depreUseQFilter});
                    if (!Objects.nonNull(finCardWorkLoadUnitDyn)) continue;
                    Long workUnit = finCardWorkLoadUnitDyn.getLong("workloadunit") == 0L ? null : Long.valueOf(finCardWorkLoadUnitDyn.getLong("workloadunit"));
                    this.getModel().setValue("workloadunitid", (Object)workUnit, i);
                    this.getModel().setValue("workload", null, i);
                }
                this.getView().updateView("workloadentry");
            }
        }
        if (propName.equals("period") && this instanceof FaWorkLoadBatchEditPlugin) {
            DynamicObject periodDy = (DynamicObject)this.getModel().getValue("period");
            Object periodId = periodDy.getPkValue();
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period", (String)"enddate");
            Date endDate = period.getDate("enddate");
            endDate = DateUtil.stripTime((Date)endDate);
            this.getModel().setValue("date", (Object)endDate);
        }
    }

    protected abstract QFilter getRealCardFilter();

    protected Set<Long> getUsedRealCardId() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org.getLong("id");
        DynamicObject depreUse = (DynamicObject)this.getModel().getValue("depreuse");
        if (depreUse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6298\u65e7\u7528\u9014\u201d\u3002", (String)"AbstractWorkLoadPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return new HashSet<Long>(4);
        }
        long depreUseId = depreUse.getLong("id");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (period == null) {
            return new HashSet<Long>(0);
        }
        long periodId = period.getLong("id");
        Set depreMethodIds = FaUtils.getDepreMethodByType((String)"5");
        QFilter[] finCardFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("bizperiod", "<=", (Object)periodId), new QFilter("endperiod", ">", (Object)periodId), new QFilter("depremethod", "in", (Object)depreMethodIds)};
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"number", (QFilter[])finCardFilters);
        Set numberSet = finCards.stream().map(v -> v.getString("number")).collect(Collectors.toSet());
        QFilter[] realCardFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("number", "in", numberSet), new QFilter("isbak", "=", (Object)"0"), new QFilter("bizstatus", "=", (Object)"READY")};
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"id", (QFilter[])realCardFilters);
        return realCards.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
    }

    protected void setCurPeriodAndDate() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject depreUse = (DynamicObject)this.getModel().getValue("depreuse");
        if (org == null || depreUse == null) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id")), new QFilter("depreuse", "=", (Object)depreUse.getLong("id"))};
        DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"curperiod", (QFilter[])filters);
        if (book == null) {
            String orgName = org.getString("name");
            String depreUseName = depreUse.getString("name");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u3010%1$s\u3011\u3001\u6298\u65e7\u7528\u9014\u3010%2$s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"AbstractWorkLoadPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), orgName, depreUseName));
            return;
        }
        long curPeriod = book.getLong("curperiod");
        this.getModel().setValue("period", (Object)curPeriod);
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriod, (String)"bd_period", (String)"enddate");
        Date endDate = period.getDate("enddate");
        endDate = DateUtil.stripTime((Date)endDate);
        this.getModel().setValue("date", (Object)endDate);
    }

    private void orgBeforeF7Select(BeforeF7SelectEvent evt) {
        List orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_workload");
        QFilter idFilter = new QFilter("id", "in", (Object)orgIds);
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        filters.add(idFilter);
    }

    private void depreUseBeforeF7Select(BeforeF7SelectEvent evt) {
        ArrayList<Long> depreUseIds = new ArrayList<Long>();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org.getLong("id");
        DynamicObjectCollection assetBooks = FaBizUtils.getAllBookByOrg((Long)orgId);
        if (assetBooks.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u6298\u65e7\u7528\u9014\u3002", (String)"AbstractWorkLoadPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        for (DynamicObject book : assetBooks) {
            depreUseIds.add(book.getLong("depreuse"));
        }
        QFilter idFilter = new QFilter("id", "in", depreUseIds);
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        filters.add(idFilter);
    }

    private void periodBeforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org.getLong("id");
        DynamicObject depreUse = (DynamicObject)this.getModel().getValue("depreuse");
        if (depreUse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6298\u65e7\u7528\u9014\u201d\u3002", (String)"AbstractWorkLoadPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        long depreUseId = depreUse.getLong("id");
        QFilter[] bookFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId)};
        String selectFields = Fa.join((String)",", (String[])new String[]{"periodtype", "curperiod"});
        DynamicObject assetBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)selectFields, (QFilter[])bookFilters);
        if (assetBook == null) {
            String orgName = org.getString("name");
            String depreUseName = depreUse.getString("name");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u3010%1$s\u3011\u3001\u6298\u65e7\u7528\u9014\u3010%2$s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"AbstractWorkLoadPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), orgName, depreUseName));
            evt.setCancel(true);
            return;
        }
        long periodTypeId = assetBook.getLong("periodtype");
        long curPeriodId = assetBook.getLong("curperiod");
        QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter idFilter = new QFilter("id", ">=", (Object)curPeriodId);
        QFilter adjustPeriodFilter = new QFilter("isadjustperiod", "=", (Object)"0");
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        filters.add(periodTypeFilter);
        filters.add(idFilter);
        filters.add(adjustPeriodFilter);
    }

    private void realCardBeforeF7Select(BeforeF7SelectEvent evt) {
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        QFilter realCardFilter = this.getRealCardFilter();
        if (realCardFilter != null) {
            filters.add(realCardFilter);
        }
    }
}

