/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;
import kd.fi.fa.utils.FaChangeBillUtils;

public class BusinessRecordSectionHandler {
    private final IFormView view;
    private final IDataModel model;
    private final DynamicObject card;
    private boolean monCard = false;
    private DynamicObject monPeriod = null;
    private AbstractBillPlugIn plugin = null;
    private static final String DF = "yyyy-MM-dd";
    private static final String ALGO = "kd.fi.fa.formplugin.BusinessRecordSectionHandler";
    private static final Log logger = LogFactory.getLog(BusinessRecordSectionHandler.class);
    private static final String DEPREFORECAST_ENTRY = "depreforecast_entry";
    private static final String DEPREFORECASTPERIOD = "depreforecastperiod";
    private static final String DEPREFORECASTMOUNT = "depreforecastmount";
    private static final String MONTHADDIDEPREAMOUNT1 = "monthaddidepreamount1";
    private static final String DEPREFORECASTRATE = "depreforecastrate";
    private static final String YEARDPPREFORCAST = "yeardppreforcast";
    private static final String TOTALDEPREFORECASTMOUNT = "totaldepreforecastmount";
    private static final String SPLIT_MERGE_ENTRY = "split_merge_entry";
    private static final String IN_SELECT_MERGE_FIELDS = Fa.join((String)",", (String[])new String[]{"id", "billno", "type", "remark", "mergedate", "inentryentity.inoriginalval", "inentryentity.inaccumdepre", "inentryentity.indepredamount", "inentryentity.indecval"});
    private static final String OUT_SELECT_MERGE_FIELDS = Fa.join((String)",", (String[])new String[]{"id", "billno", "type", "remark", "mergedate", "inentryentity.outentryentity.outoriginalval", "inentryentity.outentryentity.outaccumdepre", "inentryentity.outentryentity.outdecval"});
    private static final String SM_IN_SELECT_MERGE_FIELDS = Fa.join((String)",", (String[])new String[]{"id", "billno", "type", "remark", "mergedate bizdate", "inentryentity.inoriginalval originalvalchg", "inentryentity.inaccumdepre accumdeprechg", "inentryentity.indecval decvalchg"});
    private static final String SM_OUT_SELECT_MERGE_FIELDS = Fa.join((String)",", (String[])new String[]{"id", "billno", "type", "remark", "mergedate bizdate", "inentryentity.outentryentity.outoriginalval originalvalchg", "inentryentity.outentryentity.outaccumdepre accumdeprechg", "inentryentity.outentryentity.outdecval decvalchg"});
    private static final String SM_OUT_SELECT_SPLIT_FIELDS = Fa.join((String)",", (String[])new String[]{"id", "billno", "biztype type", "remark", "splitdate bizdate", "assetsplitentry.subassetsplitentry.aft_monthorigvalchg originalvalchg", "assetsplitentry.subassetsplitentry.aft_monthaccumdeprechg accumdeprechg", "assetsplitentry.subassetsplitentry.aft_monthdeprechg decvalchg"});

    public BusinessRecordSectionHandler(AbstractBillPlugIn parent, IFormView view) {
        this.view = view;
        this.model = view.getModel();
        this.plugin = parent;
        this.card = this.model.getDataEntity();
        if ("fa_moncard_fin".equals(this.model.getDataEntityType().getName())) {
            this.monCard = true;
            this.monPeriod = this.model.getDataEntity().getDynamicObject("monperiod");
            this.monPeriod = FaBaseDaoFactory.getInstance((String)"bd_period").queryOne("begindate,enddate", this.monPeriod.getPkValue());
        }
    }

    public void handle() {
        if (!BillStatus.C.name().equals(this.model.getValue("billStatus"))) {
            this.fillDepreSplitSetUpTab(null, 0L, 0L, 0L);
            return;
        }
        DynamicObjectCollection realCardCols = QueryServiceHelper.query((String)"fa_card_real", (String)"id,sourceflag,sourceentryid", (QFilter[])new QFilter[]{new QFilter("masterid", "=", this.card.get("realCard.masterid"))});
        if (realCardCols == null || realCardCols.size() == 0) {
            return;
        }
        List<Long> realCards = realCardCols.stream().mapToLong(x -> x.getLong("id")).boxed().collect(Collectors.toList());
        long depreuseId = ((DynamicObject)this.model.getValue("depreuse")).getLong("id");
        long orgId = ((DynamicObject)this.model.getValue("org")).getLong("id");
        long finCardId = this.model.getDataEntity().getLong("id");
        this.fillDepreTab(realCards, depreuseId);
        this.fillDepreAdjustTab(realCards, depreuseId);
        this.fillChangeBillTab(realCards, depreuseId);
        this.fillClearBillTab(realCards, depreuseId);
        this.fillDisptBillTab(realCards, realCardCols);
        this.fillDevalBillTab(realCards, depreuseId);
        this.fillDepreSplitSetUpTab(realCards, finCardId, depreuseId, orgId);
        this.fillAssetsplitbill(realCards);
        this.fillMergeBillTab(realCards, depreuseId);
        this.fillSplitOrMergeTab(realCards, depreuseId);
        boolean collapse = this.model.getEntryRowCount("depre_entry") + this.model.getEntryRowCount("entrychangebill") + this.model.getEntryRowCount("entryclearbill") + this.model.getEntryRowCount("dispatch_entry") == 0;
        ((Container)this.plugin.getControl("flex_bissinessrecord")).setCollapse(collapse);
    }

    private void fillMergeBillTab(List<Long> realCards, long depreuseId) {
        DynamicObject cardEntry;
        QFilter inQfilter = new QFilter("inentryentity.inrealcardmasterid", "in", realCards).and("inentryentity.indepreuse", "=", (Object)depreuseId).and("billstatus", "=", (Object)BillStatus.C);
        QFilter outQfilter = new QFilter("inentryentity.outentryentity.OUTREALCARDMASTERID", "in", realCards).and("inentryentity.outentryentity.outdepreuse", "=", (Object)depreuseId).and("billstatus", "=", (Object)BillStatus.C);
        DataSet inMergeDataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"fa_mergebill", (String)IN_SELECT_MERGE_FIELDS, (QFilter[])inQfilter.toArray(), (String)"mergedate desc");
        DataSet outMergeDataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"fa_mergebill", (String)OUT_SELECT_MERGE_FIELDS, (QFilter[])outQfilter.toArray(), (String)"mergedate desc");
        DynamicObjectCollection cardEntryCol = (DynamicObjectCollection)this.card.get("merge_entry");
        DynamicObjectType type = (DynamicObjectType)((ICollectionProperty)this.model.getProperty("merge_entry")).getItemType();
        for (Row row : outMergeDataSet) {
            cardEntry = new DynamicObject(type);
            cardEntryCol.add((Object)cardEntry);
            cardEntry.set("mergebillid", (Object)row.getLong("id"));
            cardEntry.set("merge_billno", (Object)row.getString("billno"));
            cardEntry.set("billtype", (Object)ResManager.loadKDString((String)"\u8d44\u4ea7\u5408\u5e76", (String)"BusinessRecordSectionHandler_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            cardEntry.set("businesstype", (Object)row.getString("type"));
            cardEntry.set("remark", (Object)row.getString("remark"));
            cardEntry.set("mergedate", (Object)row.getDate("mergedate"));
            cardEntry.set("outoriginalval", (Object)row.getBigDecimal("inentryentity.outentryentity.outoriginalval"));
            cardEntry.set("outaccumdepre", (Object)row.getBigDecimal("inentryentity.outentryentity.outaccumdepre"));
            cardEntry.set("outdecval", (Object)row.getBigDecimal("inentryentity.outentryentity.outdecval"));
        }
        for (Row row : inMergeDataSet) {
            cardEntry = new DynamicObject(type);
            cardEntryCol.add((Object)cardEntry);
            cardEntry.set("mergebillid", (Object)row.getLong("id"));
            cardEntry.set("merge_billno", (Object)row.getString("billno"));
            cardEntry.set("billtype", (Object)ResManager.loadKDString((String)"\u8d44\u4ea7\u5408\u5e76", (String)"BusinessRecordSectionHandler_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            cardEntry.set("businesstype", (Object)row.getString("type"));
            cardEntry.set("remark", (Object)row.getString("remark"));
            cardEntry.set("mergedate", (Object)row.getDate("mergedate"));
            cardEntry.set("inoriginalval", (Object)row.getBigDecimal("inentryentity.inoriginalval"));
            cardEntry.set("inaccumdepre", (Object)row.getBigDecimal("inentryentity.inaccumdepre"));
            cardEntry.set("inpreusingamount", (Object)row.getBigDecimal("inentryentity.indepredamount"));
            cardEntry.set("indecval", (Object)row.getBigDecimal("inentryentity.indecval"));
        }
    }

    private void fillSplitOrMergeTab(List<Long> realCards, long depreuseId) {
        DataSet splitDataSet = this.getDataSet(realCards, depreuseId, "fa_assetsplitbill", null, SM_OUT_SELECT_SPLIT_FIELDS, "splitdate desc");
        DataSet mergeDataSet = this.getDataSet(realCards, depreuseId, "fa_mergebill", SM_IN_SELECT_MERGE_FIELDS, SM_OUT_SELECT_MERGE_FIELDS, "mergedate desc");
        DataSet dataSet = splitDataSet.union(mergeDataSet).orderBy(new String[]{"bizdate desc"});
        DynamicObjectCollection cardEntryCol = (DynamicObjectCollection)this.card.get(SPLIT_MERGE_ENTRY);
        DynamicObjectType type = (DynamicObjectType)((ICollectionProperty)this.model.getProperty(SPLIT_MERGE_ENTRY)).getItemType();
        for (Row row : dataSet) {
            String billType = "fa_assetsplitbill".equals(row.getString("entityname")) ? BizStatusEnum.SPLIT.name() : BizStatusEnum.MERGING.name();
            DynamicObject cardEntry = new DynamicObject(type);
            cardEntryCol.add((Object)cardEntry);
            cardEntry.set("sm_billid", (Object)row.getLong("id"));
            cardEntry.set("sm_billno", (Object)row.getString("billno"));
            cardEntry.set("sm_billtype", (Object)billType);
            cardEntry.set("sm_bustype", (Object)row.getString("type"));
            cardEntry.set("sm_remark", (Object)row.getString("remark"));
            cardEntry.set("sm_busdate", (Object)row.getDate("bizdate"));
            cardEntry.set("sm_originalval", (Object)row.getBigDecimal("originalvalchg"));
            cardEntry.set("sm_accumdepre", (Object)row.getBigDecimal("accumdeprechg"));
            cardEntry.set("sm_decval", (Object)row.getBigDecimal("decvalchg"));
        }
    }

    private DataSet getDataSet(List<Long> realCards, long depreuseId, String entityName, String inSelectFields, String outSelectFields, String order) {
        if ("fa_assetsplitbill".equals(entityName)) {
            QFilter outQfilter = new QFilter("assetsplitentry.subassetsplitentry.aft_realcard", "in", realCards).and("assetsplitentry.subassetsplitentry.aft_depreuse", "=", (Object)depreuseId).and("billstatus", "=", (Object)BillStatus.C);
            DataSet outDataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)entityName, (String)outSelectFields, (QFilter[])outQfilter.toArray(), (String)order);
            return outDataSet.addField("'" + entityName + "'", "entityname");
        }
        QFilter inQfilter = new QFilter("inentryentity.inrealcardmasterid", "in", realCards).and("inentryentity.indepreuse", "=", (Object)depreuseId).and("billstatus", "=", (Object)BillStatus.C);
        QFilter outQfilter = new QFilter("inentryentity.outentryentity.OUTREALCARDMASTERID", "in", realCards).and("inentryentity.outentryentity.outdepreuse", "=", (Object)depreuseId).and("billstatus", "=", (Object)BillStatus.C);
        DataSet inDataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)entityName, (String)inSelectFields, (QFilter[])inQfilter.toArray(), (String)order);
        DataSet outDataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)entityName, (String)outSelectFields, (QFilter[])outQfilter.toArray(), (String)order);
        DataSet resultDataSet = inDataSet.union(outDataSet).orderBy(new String[]{"bizdate desc"});
        return resultDataSet.addField("'" + entityName + "'", "entityname");
    }

    private void fillDepreAdjustTab(List<Long> realCards, long depreuseId) {
        String selectFields = "id, billno,period,entryentity.realcard,entryentity.bfrdepreamount,entryentity.aftdepreamount";
        QFilter[] filters = new QFilter[]{new QFilter("entryentity.realcard", "in", realCards), new QFilter("billstatus", "=", (Object)BillStatus.C.name()), new QFilter("depreuse", "=", (Object)depreuseId)};
        DynamicObject[] depreadjustBills = BusinessDataServiceHelper.load((String)"fa_depreadjustbill", (String)selectFields, (QFilter[])filters, (String)"period desc");
        if (depreadjustBills == null || depreadjustBills.length < 1) {
            return;
        }
        DynamicObjectCollection depreAdjustEntryCol = (DynamicObjectCollection)this.card.get("depreadjustentry");
        for (DynamicObject depreadjustBill : depreadjustBills) {
            DynamicObjectCollection depreAdjustBillEntrys = depreadjustBill.getDynamicObjectCollection("entryentity");
            DynamicObjectType type = (DynamicObjectType)((ICollectionProperty)this.model.getProperty("depreadjustentry")).getItemType();
            for (DynamicObject depreAdjustBill : depreAdjustBillEntrys) {
                if (!realCards.contains(depreAdjustBill.getDynamicObject("realcard").get("id"))) continue;
                DynamicObject depreAdjustBillEntry = new DynamicObject(type);
                depreAdjustEntryCol.add((Object)depreAdjustBillEntry);
                depreAdjustBillEntry.set("depreadjustid", (Object)depreadjustBill.getLong("id"));
                depreAdjustBillEntry.set("depreadjustbillno", (Object)depreadjustBill.getString("billno"));
                depreAdjustBillEntry.set("depreadjustperiod", depreadjustBill.get("period.name"));
                depreAdjustBillEntry.set("bfrdepreamount", depreAdjustBill.get("bfrdepreamount"));
                depreAdjustBillEntry.set("aftdepreamount", depreAdjustBill.get("aftdepreamount"));
            }
        }
    }

    private void fillDisptBillTab(List<Long> realCards, DynamicObjectCollection realCardCols) {
        String selectFields = "id,billno,org,dispatchdate,auditdate,inorg,dispatchentry.realcard";
        QFilter cardFilter = new QFilter("dispatchentry.realcard", "in", realCards);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatus.D.name());
        QFilter[] cardFilters = new QFilter[]{cardFilter, statusFilter};
        DynamicObject dispatchBill = BusinessDataServiceHelper.loadSingle((String)"fa_dispatch_in", (String)selectFields, (QFilter[])this.getTabBillFilter(cardFilters, "dispatchdate"));
        DynamicObjectCollection cardEntryCol = (DynamicObjectCollection)this.card.get("dispatch_entry");
        DynamicObjectType type = (DynamicObjectType)((ICollectionProperty)this.model.getProperty("dispatch_entry")).getItemType();
        if (dispatchBill != null) {
            DynamicObject cardEntry = new DynamicObject(type);
            cardEntryCol.add((Object)cardEntry);
            cardEntry.set("dispatchbillid", (Object)dispatchBill.getLong("id"));
            cardEntry.set("dispatchbillnumber", dispatchBill.get("billno"));
            cardEntry.set("outorg", dispatchBill.get("org"));
            cardEntry.set("dispatchdate", dispatchBill.get("dispatchdate"));
            cardEntry.set("inorg", dispatchBill.get("inorg"));
            cardEntry.set("indispatchdate", dispatchBill.get("auditdate"));
            cardEntry.set("dispatchcard", this.model.getValue("realcard"));
            cardEntry.set("indispatchcard", (Object)this.getTargetCardByPK(((DynamicObject)this.model.getValue("realcard")).get("id")));
        }
        if (!SourceFlagEnum.DISPATCH.name().equals(((DynamicObject)realCardCols.get(0)).get("sourceflag"))) {
            return;
        }
        long sourceCardId = ((DynamicObject)realCardCols.get(0)).getLong("sourceentryid");
        cardFilter = new QFilter("dispatchentry.realcard", "=", (Object)sourceCardId);
        cardFilters = new QFilter[]{cardFilter, statusFilter};
        dispatchBill = BusinessDataServiceHelper.loadSingle((String)"fa_dispatch_in", (String)selectFields, (QFilter[])this.getTabBillFilter(cardFilters, "dispatchdate"));
        if (dispatchBill != null) {
            DynamicObject cardEntry = new DynamicObject(type);
            cardEntryCol.add((Object)cardEntry);
            cardEntry.set("dispatchbillid", (Object)dispatchBill.getLong("id"));
            cardEntry.set("dispatchbillnumber", dispatchBill.get("billno"));
            cardEntry.set("outorg", dispatchBill.get("org"));
            cardEntry.set("dispatchdate", dispatchBill.get("dispatchdate"));
            cardEntry.set("inorg", dispatchBill.get("inorg"));
            cardEntry.set("indispatchdate", dispatchBill.get("auditdate"));
            cardEntry.set("dispatchcard", (Object)this.getcardById(sourceCardId));
            cardEntry.set("indispatchcard", this.model.getValue("realcard"));
        }
    }

    private DynamicObject getcardById(Object cardId) {
        QFilter qFilter = new QFilter("id", "=", cardId);
        DynamicObject card = BusinessDataServiceHelper.loadSingle((String)"fa_card_real_base", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return card;
    }

    private DynamicObject getTargetCardByPK(Object cardId) {
        QFilter qFilter = new QFilter("sourceentryid", "=", cardId);
        DynamicObject targetCard = BusinessDataServiceHelper.loadSingle((String)"fa_card_real_base", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return targetCard;
    }

    private void fillDepreTab(List<Long> realCards, long depreuseId) {
        String sels = String.join((CharSequence)",", "bizperiod.number periodnumber", "bizperiod.name periodname", "monthdepre", "monthdeprerate", "addupyeardepre", "addidepreamount", "accumdepre", "depredamount");
        QFilter depref = new QFilter("depreuse", "=", (Object)depreuseId);
        QFilter realF = new QFilter("realcard", "in", realCards);
        DynamicObjectCollection finCardCols = QueryServiceHelper.query((String)"fa_card_fin", (String)sels, (QFilter[])new QFilter[]{depref, realF});
        List collect = finCardCols.stream().filter(dyn -> dyn.getBigDecimal("monthdepre").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("addidepreamount").compareTo(BigDecimal.ZERO) != 0).sorted(Comparator.comparing(x -> x.getInt("periodnumber"))).collect(Collectors.toList());
        DynamicObjectCollection cardEntryCol = (DynamicObjectCollection)this.card.get("depre_entry");
        DynamicObjectType type = (DynamicObjectType)((ICollectionProperty)this.model.getProperty("depre_entry")).getItemType();
        for (DynamicObject finCardCol : collect) {
            DynamicObject cardDepreEntry = new DynamicObject(type);
            cardEntryCol.add(0, cardDepreEntry);
            cardDepreEntry.set("deprePeriod", (Object)finCardCol.getString("periodname"));
            BigDecimal depreAmount = finCardCol.getBigDecimal("monthdepre");
            cardDepreEntry.set("depreAmount", (Object)depreAmount);
            cardDepreEntry.set("depreRate", (Object)finCardCol.getBigDecimal("monthdeprerate").multiply(BigDecimal.valueOf(100L).setScale(4, 4)));
            cardDepreEntry.set("monthaddidepreamount", (Object)finCardCol.getBigDecimal("addidepreamount"));
            cardDepreEntry.set("yeardppre", (Object)finCardCol.getBigDecimal("addupyeardepre"));
            cardDepreEntry.set("totalDepreAmount", (Object)finCardCol.getBigDecimal("accumdepre"));
            cardDepreEntry.set("workload", (Object)finCardCol.getBigDecimal("addidepreamount"));
            cardDepreEntry.set("entry_sumworkload", (Object)finCardCol.getBigDecimal("depredamount"));
        }
        if (!CollectionUtils.isEmpty(collect)) {
            DynamicObject finCardCol = (DynamicObject)collect.get(collect.size() - 1);
            this.model.setValue("lastdepreperiod", (Object)finCardCol.getString("periodname"));
            this.model.setValue("lastdepreamount", (Object)finCardCol.getBigDecimal("monthdepre"));
            this.model.setValue("lastdeprerate", (Object)finCardCol.getBigDecimal("monthdeprerate").multiply(BigDecimal.valueOf(100L).setScale(4, 4)));
        }
    }

    public void fillDepreForcastTab(List<Long> realCards, long depreuseId, long orgId) {
        this.model.deleteEntryData(DEPREFORECAST_ENTRY);
        DailyDepreImpl dailyDepreImpl = new DailyDepreImpl(Boolean.FALSE, "fa_card_fin");
        DynamicObject book = (DynamicObject)this.model.getValue("assetbook");
        if (null == book) {
            return;
        }
        long periodType = book.getLong("periodtype.id");
        DynamicObject curPeriodId = book.getDynamicObject("curperiod");
        HashSet<String> finCardNumSet = new HashSet<String>();
        DynamicObject realcard = (DynamicObject)this.model.getValue("realcard");
        BigDecimal preusingamount = (BigDecimal)this.model.getValue("preusingamount");
        BigDecimal depredamount = (BigDecimal)this.model.getValue("depredamount");
        BigDecimal lastDepreAmount = preusingamount.subtract(depredamount);
        DynamicObject bizPerodDy = (DynamicObject)this.model.getValue("bizperiod");
        DynamicObject depremethod = (DynamicObject)this.model.getValue("depremethod");
        if (null != depremethod && depremethod.getString("type").equals("5")) {
            return;
        }
        long bizPerod = 0L;
        if (null != bizPerodDy) {
            bizPerod = bizPerodDy.getLong("id");
        } else if (null != curPeriodId) {
            bizPerod = curPeriodId.getLong("id");
        }
        boolean isDayDepre = false;
        if (depremethod != null) {
            isDayDepre = depremethod.getString("type").equals("51");
        }
        Long lastPeroid = this.LastPeroid(lastDepreAmount, periodType, bizPerod, isDayDepre);
        String number = null;
        if (null != realcard) {
            number = realcard.getString("number");
        }
        finCardNumSet.add(number);
        QFilter qPeriodId = new QFilter("id", "=", (Object)lastPeroid);
        DynamicObject predictPeriods = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{qPeriodId});
        if (null == predictPeriods) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d22\u52a1\u5361\u7247\u9884\u8ba1\u4f7f\u7528\u671f\u95f4\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"BusinessRecordSectionHandler_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        Map orgPredictResult = dailyDepreImpl.predictPeriodDepe((Object)orgId, Long.valueOf(depreuseId), predictPeriods, true, false, finCardNumSet);
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.model;
        TableValueSetter setter = new TableValueSetter(new String[0]);
        int index = 0;
        String periodName = "";
        ArrayList list = new ArrayList(orgPredictResult.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Map<String, Map<String, Object>>>>(){

            @Override
            public int compare(Map.Entry<String, Map<String, Map<String, Object>>> o1, Map.Entry<String, Map<String, Map<String, Object>>> o2) {
                return o2.getKey().compareTo(o1.getKey());
            }
        });
        for (Map.Entry entry : list) {
            Map maps = (Map)entry.getValue();
            Long periodId = Long.parseLong(((String)entry.getKey()).split("_")[2]);
            DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"name", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
            if (null != period) {
                periodName = period.getString("name");
            }
            for (Map curPredictRs : maps.values()) {
                setter.set(DEPREFORECASTPERIOD, (Object)periodName, index);
                BigDecimal depreAmount = (BigDecimal)curPredictRs.get("monthdepre");
                setter.set(DEPREFORECASTMOUNT, (Object)depreAmount, index);
                setter.set(YEARDPPREFORCAST, curPredictRs.get("addupyeardepre"), index);
                BigDecimal originalval = (BigDecimal)curPredictRs.get("originalval");
                if (originalval.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal depreforecastrate = depreAmount.divide(originalval, 4, 4).multiply(BigDecimal.valueOf(100L));
                setter.set(DEPREFORECASTRATE, (Object)depreforecastrate, index);
                setter.set(MONTHADDIDEPREAMOUNT1, curPredictRs.get("addidepreamount"), index);
                setter.set(TOTALDEPREFORECASTMOUNT, curPredictRs.get("accumdepre"), index);
                ++index;
            }
        }
        this.fillDepreTabForcast(realCards, depreuseId, book, setter, index);
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow(DEPREFORECAST_ENTRY, setter);
        dataModel.endInit();
    }

    private void fillDepreTabForcast(List<Long> realCards, long depreuseId, DynamicObject book, TableValueSetter setter, int index) {
        String sels = String.join((CharSequence)",", "bizperiod.number periodnumber", "bizperiod.name periodname", "monthdepre", "monthdeprerate", "addupyeardepre", "addidepreamount", "accumdepre", "depredamount");
        QFilter depref = new QFilter("depreuse", "=", (Object)depreuseId);
        QFilter realF = new QFilter("realcard", "in", realCards);
        QFilter qperiod = new QFilter("bizperiod", "<", (Object)book.getLong("curperiod.id"));
        DynamicObjectCollection finCardCols = QueryServiceHelper.query((String)"fa_card_fin", (String)sels, (QFilter[])new QFilter[]{depref, realF, qperiod});
        List collect = finCardCols.stream().filter(dyn -> dyn.getBigDecimal("monthdepre").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("addidepreamount").compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        Collections.sort(collect, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o2.getString("periodnumber").compareTo(o1.getString("periodnumber"));
            }
        });
        for (DynamicObject finCardCol : collect) {
            setter.set(DEPREFORECASTPERIOD, (Object)finCardCol.getString("periodname"), index);
            BigDecimal depreAmount = finCardCol.getBigDecimal("monthdepre");
            setter.set(DEPREFORECASTMOUNT, (Object)depreAmount, index);
            setter.set(DEPREFORECASTRATE, (Object)finCardCol.getBigDecimal("monthdeprerate").multiply(BigDecimal.valueOf(100L).setScale(4, 4)), index);
            setter.set(MONTHADDIDEPREAMOUNT1, (Object)finCardCol.getBigDecimal("addidepreamount"), index);
            setter.set(YEARDPPREFORCAST, (Object)finCardCol.getBigDecimal("addupyeardepre"), index);
            setter.set(TOTALDEPREFORECASTMOUNT, (Object)finCardCol.getBigDecimal("accumdepre"), index);
            ++index;
        }
    }

    private void fillDepreSplitSetUpTab(List<Long> realCards, long finCardId, long depreuseId, long orgId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("fa_card_split_setup");
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey("splitsetuppanelap");
        param.setCustomParam("realCardIds", (Object)SerializationUtils.toJsonString(realCards));
        param.setCustomParam("finCardId", (Object)String.valueOf(finCardId));
        param.setCustomParam("depreUseId", (Object)String.valueOf(depreuseId));
        param.setCustomParam("orgId", (Object)String.valueOf(orgId));
        this.view.showForm(param);
    }

    private void fillChangeBillTab(List<Long> realCardIds, long depreuse) {
        QFilter billStatusFilter;
        QFilter realCardFilter;
        String selectFields = Fa.join((Object[])new String[]{"billno", "changedate", "auditor", "realcard1", "fincard1", "depreuse1", "field", "beforevalue", "aftervalue", "isadjustdepre1", "bizdate1", "remark"}, (String)",");
        DynamicObject[] changeBillArr = BusinessDataServiceHelper.load((String)"fa_change_dept", (String)selectFields, (QFilter[])new QFilter[]{realCardFilter = new QFilter("fieldentry.realcard1", "in", realCardIds), billStatusFilter = new QFilter("billstatus", "=", (Object)BillStatus.C.name())});
        if (changeBillArr.length == 0) {
            return;
        }
        ArrayList<DynamicObject> changeBillLst = new ArrayList<DynamicObject>(Arrays.asList(changeBillArr));
        changeBillLst.sort((v1, v2) -> v2.getDate("changedate").compareTo(v1.getDate("changedate")));
        MainEntityType realType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        MainEntityType finType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
        DynamicObjectCollection cardEntryCol = (DynamicObjectCollection)this.card.get("entrychangebill");
        cardEntryCol.clear();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DF);
        ArrayList<DynamicObject> typeFromCardRows = new ArrayList<DynamicObject>(20);
        HashSet<Long> typeFromCardEntries = new HashSet<Long>();
        HashSet<Long> realCardIdSet = new HashSet<Long>();
        HashSet<Long> finCardIdSet = new HashSet<Long>();
        HashMap<String, String> itemClassTypeNameMap = new HashMap<String, String>();
        HashSet<String> befItemClassTypeSet = new HashSet<String>();
        HashSet<String> aftItemClassTypeSet = new HashSet<String>();
        for (DynamicObject changeBill : changeBillLst) {
            DynamicObjectCollection fieldEntries = changeBill.getDynamicObjectCollection("fieldentry");
            for (DynamicObject fieldEntry : fieldEntries) {
                String displayName;
                DynamicObject entityObj;
                String field = fieldEntry.getString("field");
                Tuple<DynamicProperty, Boolean> propTuple = this.getProperty(realType, finType, fieldEntry);
                DynamicProperty property = (DynamicProperty)propTuple.item1;
                if (property instanceof ItemClassProp) {
                    DynamicObject dobj;
                    ItemClassProp itemClassProp = (ItemClassProp)property;
                    String typePropName = itemClassProp.getTypePropName();
                    String befBaseEntityId = "";
                    String baseEntityId = "";
                    String key = BusinessRecordSectionHandler.genItemClassMapKey(fieldEntry, typePropName, false);
                    for (DynamicObject cpFieldEntry : fieldEntries) {
                        String cpField = cpFieldEntry.getString("field");
                        Tuple<IDataEntityProperty, Boolean> cpFieldTuple = FaChangeBillUtils.parseField(cpField);
                        IDataEntityProperty cpProp = (IDataEntityProperty)cpFieldTuple.item1;
                        String cpKey = BusinessRecordSectionHandler.genItemClassMapKey(cpFieldEntry, cpProp.getName(), false);
                        if (!cpKey.equals(key)) continue;
                        befBaseEntityId = cpFieldEntry.getString("beforevalue");
                        baseEntityId = cpFieldEntry.getString("aftervalue");
                        break;
                    }
                    if (kd.bos.util.StringUtils.isEmpty((String)befBaseEntityId)) {
                        String[] split = field.split("\\.");
                        if ("fa_card_real".equals(split[0])) {
                            long realCard = fieldEntry.getLong("realcard1_id");
                            realCardIdSet.add(realCard);
                        } else {
                            long finCard = fieldEntry.getLong("fincard1_id");
                            finCardIdSet.add(finCard);
                        }
                        typeFromCardRows.add(changeBill);
                        typeFromCardEntries.add(Long.valueOf(fieldEntry.getPkValue().toString()));
                        befItemClassTypeSet.add(fieldEntry.getPkValue().toString());
                    } else {
                        long rawValue = Long.parseLong(fieldEntry.getString("beforevalue"));
                        dobj = BusinessDataServiceHelper.loadSingleFromCache((Object)rawValue, (String)befBaseEntityId, (String)"id,name");
                        if (dobj == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%1$s\u7684%2$s\u3002", (String)"BusinessRecordSectionHandler_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), rawValue, property.getDisplayName()));
                        }
                        fieldEntry.set("beforevalue", (Object)dobj.get("name").toString());
                    }
                    if (kd.bos.util.StringUtils.isEmpty((String)baseEntityId)) {
                        String[] split = field.split("\\.");
                        if ("fa_card_real".equals(split[0])) {
                            long realCard = fieldEntry.getLong("realcard1_id");
                            realCardIdSet.add(realCard);
                        } else {
                            long finCard = fieldEntry.getLong("fincard1_id");
                            finCardIdSet.add(finCard);
                        }
                        if (!typeFromCardRows.contains(changeBill)) {
                            typeFromCardRows.add(changeBill);
                        }
                        typeFromCardEntries.add(Long.valueOf(fieldEntry.getPkValue().toString()));
                        aftItemClassTypeSet.add(fieldEntry.getPkValue().toString());
                    } else {
                        long rawValue = Long.parseLong(fieldEntry.getString("aftervalue"));
                        dobj = BusinessDataServiceHelper.loadSingleFromCache((Object)rawValue, (String)baseEntityId, (String)"id,name");
                        if (dobj == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%1$s\u7684%2$s\u3002", (String)"BusinessRecordSectionHandler_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), rawValue, property.getDisplayName()));
                        }
                        fieldEntry.set("aftervalue", (Object)dobj.get("name").toString());
                    }
                }
                if (!(property instanceof ItemClassTypeProp)) continue;
                String befValue = fieldEntry.getString("beforevalue");
                String aftValue = fieldEntry.getString("aftervalue");
                if (kd.bos.util.StringUtils.isNotEmpty((String)befValue) && !itemClassTypeNameMap.containsKey(befValue)) {
                    entityObj = BusinessDataServiceHelper.loadSingleFromCache((Object)befValue, (String)"bos_entityobject");
                    displayName = entityObj.getString("name");
                    itemClassTypeNameMap.put(befValue, displayName);
                }
                if (!kd.bos.util.StringUtils.isNotEmpty((String)aftValue) || itemClassTypeNameMap.containsKey(aftValue)) continue;
                entityObj = BusinessDataServiceHelper.loadSingleFromCache((Object)aftValue, (String)"bos_entityobject");
                displayName = entityObj.getString("name");
                itemClassTypeNameMap.put(aftValue, displayName);
            }
        }
        Map realCardMap = null;
        if (realCardIdSet.size() > 0) {
            realCardMap = BusinessDataServiceHelper.loadFromCache((Object[])realCardIdSet.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_card_real"));
        }
        Map finCardMap = null;
        if (finCardIdSet.size() > 0) {
            finCardMap = BusinessDataServiceHelper.loadFromCache((Object[])finCardIdSet.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_card_fin"));
        }
        HashMap<String, Map<Long, String>> baseDataNameMap = new HashMap<String, Map<Long, String>>(20);
        for (DynamicObject queryValue : typeFromCardRows) {
            DynamicObjectCollection fieldentries = queryValue.getDynamicObjectCollection("fieldentry");
            for (DynamicObject fieldentry : fieldentries) {
                String aftBaseDataName;
                Object pkValue = fieldentry.getPkValue();
                if (!typeFromCardEntries.contains(pkValue)) continue;
                String field = fieldentry.getString("field");
                Tuple<IDataEntityProperty, Boolean> fieldTuple = FaChangeBillUtils.parseField(field);
                IDataEntityProperty prop = (IDataEntityProperty)fieldTuple.item1;
                if (!(prop instanceof ItemClassProp)) continue;
                ItemClassProp itemClassProp = (ItemClassProp)prop;
                String typePropName = itemClassProp.getTypePropName();
                String billName = itemClassProp.getParent().getExtendName();
                String entityId = null;
                if (realCardMap != null && "fa_card_real".equals(billName)) {
                    Long realcard = fieldentry.getLong("realcard1_id");
                    entityId = ((DynamicObject)realCardMap.get(realcard)).getString(typePropName);
                } else if (finCardMap != null && "fa_card_fin".equals(billName)) {
                    Long fincard = fieldentry.getLong("fincard1_id");
                    entityId = ((DynamicObject)finCardMap.get(fincard)).getString(typePropName);
                }
                if (kd.bos.util.StringUtils.isEmpty(entityId)) continue;
                if (befItemClassTypeSet.contains(fieldentry.getPkValue().toString())) {
                    long befDataId = fieldentry.getLong("beforevalue");
                    aftBaseDataName = BusinessRecordSectionHandler.getRowBaseDataName(baseDataNameMap, entityId, befDataId);
                    fieldentry.set("beforevalue", (Object)aftBaseDataName);
                }
                if (!aftItemClassTypeSet.contains(fieldentry.getPkValue().toString())) continue;
                long aftDataId = fieldentry.getLong("aftervalue");
                aftBaseDataName = BusinessRecordSectionHandler.getRowBaseDataName(baseDataNameMap, entityId, aftDataId);
                fieldentry.set("aftervalue", (Object)aftBaseDataName);
            }
        }
        for (DynamicObject changeBill : changeBillLst) {
            Long changeBillId = changeBill.getLong("id");
            Object changebillnumber = changeBill.get("billno");
            Date changedate = changeBill.getDate("changedate");
            DynamicObject changebillauditor = changeBill.getDynamicObject("auditor");
            DynamicObjectCollection fieldEntries = changeBill.getDynamicObjectCollection("fieldentry");
            for (DynamicObject fieldEntry : fieldEntries) {
                if (!realCardIds.contains(fieldEntry.get("realcard1_id"))) continue;
                Tuple<DynamicProperty, Boolean> propTuple = this.getProperty(realType, finType, fieldEntry);
                DynamicProperty property = (DynamicProperty)propTuple.item1;
                boolean isRealProp = (Boolean)propTuple.item2;
                if (!isRealProp && depreuse != fieldEntry.getLong("depreuse1_id")) continue;
                Object bfrchg = this.parseValue(fieldEntry.getString("beforevalue"), property);
                Object aftchg = this.parseValue(fieldEntry.getString("aftervalue"), property);
                if (property instanceof ItemClassTypeProp) {
                    if (bfrchg != null && kd.bos.util.StringUtils.isNotEmpty((String)bfrchg.toString())) {
                        bfrchg = (String)itemClassTypeNameMap.get(bfrchg) + "(" + bfrchg + ")";
                    }
                    if (aftchg != null && kd.bos.util.StringUtils.isNotEmpty((String)aftchg.toString())) {
                        aftchg = (String)itemClassTypeNameMap.get(aftchg) + "(" + aftchg + ")";
                    }
                }
                if (bfrchg == null && aftchg == null || bfrchg != null && bfrchg.equals(aftchg)) continue;
                DynamicObject cardEntry = cardEntryCol.addNew();
                cardEntry.set("changebillid", (Object)changeBillId);
                cardEntry.set("changebillnumber", changebillnumber);
                cardEntry.set("changetype", (Object)(property == null ? fieldEntry.getString("field") : property.getDisplayName()));
                cardEntry.set("bfrchg", bfrchg);
                cardEntry.set("aftchg", aftchg);
                cardEntry.set("changedate", (Object)dateFormat.format(changedate));
                cardEntry.set("changebillauditor", (Object)changebillauditor.getString("name"));
                Object bizdate = fieldEntry.get("bizdate1");
                cardEntry.set("bizdate", (Object)(bizdate == null ? " " : dateFormat.format(bizdate)));
                cardEntry.set("isadjustdepre", fieldEntry.get("isadjustdepre1"));
            }
        }
    }

    private static String genItemClassMapKey(DynamicObject row, String fieldKey, boolean containsId) {
        StringBuilder key = new StringBuilder();
        if (containsId) {
            key.append(row.getLong("id")).append("-");
        }
        key.append(row.getLong("realcard1_id")).append("-");
        key.append(row.getLong("depreuse1_id")).append("-");
        key.append(fieldKey);
        return key.toString();
    }

    private static String getRowBaseDataName(Map<String, Map<Long, String>> baseDataNameMap, String entityId, Long dataId) {
        if (StringUtils.isEmpty((CharSequence)entityId) || dataId == null || dataId.equals(0L)) {
            return null;
        }
        String baseDataName = dataId.toString();
        if (baseDataNameMap.containsKey(entityId)) {
            Map<Long, String> nameMap = baseDataNameMap.get(entityId);
            if (nameMap == null) {
                nameMap = new HashMap<Long, String>(20);
                baseDataNameMap.put(entityId, nameMap);
                DynamicObject befObj = BusinessDataServiceHelper.loadSingleFromCache((Object)dataId, (String)entityId);
                if (befObj != null) {
                    baseDataName = befObj.getString("name");
                    nameMap.put(dataId, baseDataName);
                }
            } else if (!nameMap.containsKey(dataId)) {
                DynamicObject befObj = BusinessDataServiceHelper.loadSingleFromCache((Object)dataId, (String)entityId);
                if (befObj != null) {
                    baseDataName = befObj.getString("name");
                    nameMap.put(dataId, baseDataName);
                }
            } else {
                baseDataName = nameMap.get(dataId);
            }
        } else {
            HashMap<Long, String> nameMap = new HashMap<Long, String>(20);
            baseDataNameMap.put(entityId, nameMap);
            DynamicObject befObj = BusinessDataServiceHelper.loadSingleFromCache((Object)dataId, (String)entityId);
            if (befObj != null) {
                baseDataName = befObj.getString("name");
                nameMap.put(dataId, baseDataName);
            }
        }
        return baseDataName;
    }

    private Object parseValue(String rawValue, DynamicProperty property) {
        if (property instanceof ItemClassTypeProp || property instanceof ItemClassProp) {
            return rawValue;
        }
        if (property instanceof BasedataProp) {
            String displayProp;
            if (ObjectUtils.isEmpty((Object)rawValue)) {
                return null;
            }
            BasedataProp basedataProp = (BasedataProp)property;
            DynamicObjectType type = basedataProp.getDynamicComplexPropertyType();
            String entityName = type.getName();
            DynamicObject pobj = QueryServiceHelper.queryOne((String)entityName, (String)(displayProp = ((RefEntityType)type).getNameProperty()), (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(rawValue)).toArray());
            if (pobj == null) {
                return null;
            }
            return pobj.getString(displayProp);
        }
        if (property instanceof AmountProp) {
            String currencyName = ((AmountProp)property).getControlPropName();
            DynamicObject baseCurrency = this.card.getDynamicObject(currencyName);
            int amtprecision = 2;
            String sign = "";
            if (baseCurrency != null) {
                amtprecision = baseCurrency.getInt("amtprecision");
                sign = baseCurrency.getString("sign");
            }
            StringBuilder fmt = new StringBuilder();
            fmt.append(",###,##0");
            for (int i = 0; i < amtprecision; ++i) {
                if (i == 0) {
                    fmt.append('.');
                }
                fmt.append('0');
            }
            DecimalFormat df = new DecimalFormat(fmt.toString());
            return sign + df.format(new BigDecimal(rawValue));
        }
        return rawValue;
    }

    private Tuple<DynamicProperty, Boolean> getProperty(MainEntityType realType, MainEntityType finType, DynamicObject fieldEntry) {
        String[] split = fieldEntry.getString("field").split("\\.");
        if (split[0].equalsIgnoreCase("fa_card_real")) {
            return new Tuple((Object)realType.getProperty(split[1]), (Object)Boolean.TRUE);
        }
        return new Tuple((Object)finType.getProperty(split[1]), (Object)Boolean.FALSE);
    }

    private void fillDevalBillTab(List<Long> realCards, long depreuseId) {
        String selectFields = "id,billno,devalueperiod,changebillentry.decval,changebillentry.fincard, changebillentry.realcard,changebillentry.bizdate";
        QFilter[] cardFilters = new QFilter[]{new QFilter("changebillentry.realcard", "in", realCards), new QFilter("billstatus", "=", (Object)BillStatus.C.name()), new QFilter("depreuse", "=", (Object)depreuseId)};
        DynamicObject[] devalBills = BusinessDataServiceHelper.load((String)"fa_asset_devalue", (String)selectFields, (QFilter[])this.getTabBillFilter(cardFilters, "businessdate"), (String)"devalueperiod desc");
        if (devalBills == null || devalBills.length < 1) {
            return;
        }
        DynamicObjectCollection entryDevalbill = (DynamicObjectCollection)this.card.get("entryDevalbill");
        block0: for (DynamicObject devalBill : devalBills) {
            DynamicObjectCollection clearBillEntrys = devalBill.getDynamicObjectCollection("changebillentry");
            DynamicObjectType type = (DynamicObjectType)((ICollectionProperty)this.model.getProperty("entryDevalbill")).getItemType();
            DynamicObject cardEntry = new DynamicObject(type);
            entryDevalbill.add((Object)cardEntry);
            cardEntry.set("devalueid", (Object)devalBill.getLong("id"));
            cardEntry.set("devaluebillno", (Object)devalBill.getString("billno"));
            cardEntry.set("devalueperiod", (Object)devalBill.getDynamicObject("devalueperiod").getString("name"));
            for (DynamicObject clearBillEntry : clearBillEntrys) {
                long realCardId = clearBillEntry.getLong("realcard_id");
                Date devalBizdate = clearBillEntry.getDate("bizdate");
                if (!realCards.contains(realCardId)) continue;
                BigDecimal decval = clearBillEntry.get("decval") == null ? BigDecimal.ZERO : (BigDecimal)clearBillEntry.get("decval");
                cardEntry.set("decval_deval", (Object)decval);
                cardEntry.set("accumdevalue", (Object)clearBillEntry.getDynamicObject("fincard").getBigDecimal("decval").subtract(decval));
                cardEntry.set("devalbizdate", (Object)devalBizdate);
                continue block0;
            }
        }
    }

    private void fillClearBillTab(List<Long> realCards, long depreuseId) {
        String selectFields = "billno,changemode,detail_entry.realcard,detail_entry.clearincome,detail_entry.clearfare,detail_entry.basecurrency,clearDate,auditor,clearsource,detail_entry.depreuse,detail_entry.bizdate,detail_entry.assetvalue,detail_entry.addupdepre,detail_entry.decval,detail_entry.preresidualval,detail_entry.clearqty,detail_entry.measureunit";
        QFilter[] cardFilters = new QFilter[]{new QFilter("detail_entry.realcard", "in", realCards), new QFilter("billstatus", "=", (Object)BillStatus.C.name()), new QFilter("detail_entry.depreuse", "=", (Object)depreuseId)};
        DynamicObject[] clearBills = BusinessDataServiceHelper.load((String)"fa_clearbill", (String)selectFields, (QFilter[])this.getTabBillFilter(cardFilters, "cleardate"), (String)"clearDate desc");
        String restartSelectFields = "id,billno,addchangemode,restartentity.restclearqty,restartentity.realcard.unit,restartentity.restassetvalue,restartentity.restaddupdepre,restartentity.restdecval,restartentity.restpreresidualval,restartdate,auditor";
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        qFilter.and("restartentity.realcard", "in", realCards);
        qFilter.and("restartentity.entitydepreuse", "=", (Object)depreuseId);
        DynamicObjectCollection restartBills = QueryServiceHelper.query((String)"fa_restartrealbill", (String)restartSelectFields, (QFilter[])qFilter.toArray(), (String)"restartdate desc");
        if (!(clearBills != null && clearBills.length >= 1 || restartBills != null && !restartBills.isEmpty())) {
            return;
        }
        DynamicObjectCollection cardEntryCol = (DynamicObjectCollection)this.card.get("entryclearbill");
        SimpleDateFormat dateFormat = new SimpleDateFormat(DF);
        for (DynamicObject clearBill : clearBills) {
            DynamicObjectCollection clearBillEntrys = clearBill.getDynamicObjectCollection("detail_entry");
            DynamicObjectType type = (DynamicObjectType)((ICollectionProperty)this.model.getProperty("entryclearbill")).getItemType();
            DynamicObject cardEntry = new DynamicObject(type);
            cardEntryCol.add((Object)cardEntry);
            cardEntry.set("clearbillid", (Object)clearBill.getLong("id"));
            cardEntry.set("clearsourcebill", (Object)"fa_clearbill");
            cardEntry.set("clearBillNumber", clearBill.get("billno"));
            cardEntry.set("clearBillAuditor", clearBill.get("auditor"));
            cardEntry.set("changemode", clearBill.get("changemode"));
            Object cleardateObj = clearBill.get("cleardate");
            String cleardate = cleardateObj == null ? "" : dateFormat.format(cleardateObj);
            for (DynamicObject clearBillEntry : clearBillEntrys) {
                if (!realCards.contains(clearBillEntry.getDynamicObject("realcard").get("id")) || clearBillEntry.getDynamicObject("depreuse").getLong("id") != depreuseId) continue;
                cardEntry.set("clearincome", clearBillEntry.get("clearincome"));
                cardEntry.set("clearfare", clearBillEntry.get("clearfare"));
                cardEntry.set("clearassetvalue", (Object)clearBillEntry.getBigDecimal("assetvalue").multiply(BigDecimal.valueOf(-1L)));
                cardEntry.set("clearaddupdepre", (Object)clearBillEntry.getBigDecimal("addupdepre").multiply(BigDecimal.valueOf(-1L)));
                cardEntry.set("cleardecval", (Object)clearBillEntry.getBigDecimal("decval").multiply(BigDecimal.valueOf(-1L)));
                cardEntry.set("clearpreresidualval", (Object)clearBillEntry.getBigDecimal("preresidualval").multiply(BigDecimal.valueOf(-1L)));
                Object bizdateObj = clearBillEntry.get("bizdate");
                String bizdate = bizdateObj == null ? "" : dateFormat.format(bizdateObj);
                cardEntry.set("bizdate_clear", (Object)bizdate);
                cardEntry.set("cleardate_clear", (Object)cleardate);
                cardEntry.set("measureunit", clearBillEntry.get("measureunit"));
                cardEntry.set("clearqty", (Object)clearBillEntry.getBigDecimal("clearqty").multiply(BigDecimal.valueOf(-1L)));
            }
        }
        for (DynamicObject restartBill : restartBills) {
            int index = this.model.createNewEntryRow("entryclearbill");
            this.model.setValue("clearbillid", restartBill.get("id"), index);
            this.model.setValue("clearsourcebill", (Object)"fa_restartrealbill", index);
            this.model.setValue("clearbillnumber", restartBill.get("billno"), index);
            String accountDate = dateFormat.format(restartBill.getDate("restartdate"));
            this.model.setValue("cleardate_clear", (Object)accountDate, index);
            this.model.setValue("clearbillauditor", restartBill.get("auditor"), index);
            this.model.setValue("changemode", restartBill.get("addchangemode"), index);
            String entryStr = "restartentity.";
            this.model.setValue("clearqty", restartBill.get(entryStr + "restclearqty"), index);
            this.model.setValue("measureunit", restartBill.get(entryStr + "realcard" + "." + "unit"), index);
            this.model.setValue("clearassetvalue", restartBill.get(entryStr + "restassetvalue"), index);
            this.model.setValue("clearaddupdepre", restartBill.get(entryStr + "restaddupdepre"), index);
            this.model.setValue("cleardecval", restartBill.get(entryStr + "restdecval"), index);
            this.model.setValue("clearpreresidualval", restartBill.get(entryStr + "restpreresidualval"), index);
        }
    }

    private void fillAssetsplitbill(List<Long> realCards) {
        this.fillAssetSplitSrcBill();
        String selectFields = "billno,splitdate,realcard,bef_originalval,bef_accumdepre,bef_decval,bef_preresidualval,aft_cardnumber,aft_originalval,aft_accumdepre,aft_decval,aft_preresidualval,aft_realcard,bef_fincard.depreuse";
        QFilter qFilterReal = new QFilter("assetsplitentry.realcard_id", "in", realCards);
        QFilter qFilterStatus = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject depreUse = (DynamicObject)this.model.getValue("depreuse");
        DynamicObject[] splitBills = BusinessDataServiceHelper.load((String)"fa_assetsplitbill", (String)selectFields, (QFilter[])new QFilter[]{qFilterReal, qFilterStatus});
        DynamicObjectCollection entrysplibill = (DynamicObjectCollection)this.card.get("entrysplibill");
        for (DynamicObject splitBill : splitBills) {
            DynamicObjectCollection assetsplitentrys = splitBill.getDynamicObjectCollection("assetsplitentry");
            for (DynamicObject assetsplitentry : assetsplitentrys) {
                if (!assetsplitentry.getDynamicObject("bef_fincard").get("depreuse_id").equals(depreUse.getPkValue())) continue;
                DynamicObjectCollection subassetsplitentrys = assetsplitentry.getDynamicObjectCollection("subassetsplitentry");
                for (DynamicObject subassetsplitentry : subassetsplitentrys) {
                    DynamicObject cardEntry = this.createSplitTabEntryRow(splitBill, assetsplitentry, subassetsplitentry);
                    entrysplibill.add((Object)cardEntry);
                }
            }
        }
    }

    private void fillAssetSplitSrcBill() {
        DynamicObject realcard = this.card.getDynamicObject("realcard");
        SourceFlagEnum sourceFlag = SourceFlagEnum.valueOf((String)realcard.getString("sourceflag"));
        if (SourceFlagEnum.SPLIT != sourceFlag) {
            return;
        }
        String selectFields = "billno,splitdate,realcard,bef_originalval,bef_accumdepre,bef_decval,bef_preresidualval,aft_cardnumber,aft_originalval,aft_accumdepre,aft_decval,aft_preresidualval,aft_realcard,bef_fincard.depreuse";
        DynamicObject depreUse = (DynamicObject)this.model.getValue("depreuse");
        QFilter srcFilterReal = new QFilter("assetsplitentry.subassetsplitentry.aft_realcard", "=", realcard.getPkValue());
        QFilter splitCardFilter = new QFilter("split_realcard", "!=", realcard.getPkValue());
        QFilter srcFilterStatus = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject[] srcSplitBills = BusinessDataServiceHelper.load((String)"fa_assetsplitbill", (String)selectFields, (QFilter[])new QFilter[]{srcFilterReal, splitCardFilter, srcFilterStatus});
        if (srcSplitBills.length > 0) {
            DynamicObjectCollection entrysplibill = (DynamicObjectCollection)this.card.get("entrysplibill");
            DynamicObject splitBill = srcSplitBills[0];
            DynamicObjectCollection assetsplitentrys = splitBill.getDynamicObjectCollection("assetsplitentry");
            for (DynamicObject assetsplitentry : assetsplitentrys) {
                if (!assetsplitentry.getDynamicObject("bef_fincard").get("depreuse_id").equals(depreUse.getPkValue())) continue;
                DynamicObjectCollection subassetsplitentrys = assetsplitentry.getDynamicObjectCollection("subassetsplitentry");
                for (DynamicObject subassetsplitentry : subassetsplitentrys) {
                    Object aftRealcardId = subassetsplitentry.get("aft_realcard_id");
                    if (!aftRealcardId.equals(realcard.getPkValue())) continue;
                    DynamicObject cardEntry = this.createSplitTabEntryRow(splitBill, assetsplitentry, subassetsplitentry);
                    entrysplibill.add((Object)cardEntry);
                }
            }
        }
    }

    private DynamicObject createSplitTabEntryRow(DynamicObject splitBill, DynamicObject assetsplitentry, DynamicObject subassetsplitentry) {
        DynamicObjectType type = (DynamicObjectType)((ICollectionProperty)this.model.getProperty("entrysplibill")).getItemType();
        DynamicObject cardEntry = new DynamicObject(type);
        cardEntry.set("spli_billno", (Object)splitBill.getString("billno"));
        cardEntry.set("spli_billid", (Object)splitBill.getLong("id"));
        cardEntry.set("spli_date", (Object)splitBill.getDate("splitdate"));
        cardEntry.set("spli_number", (Object)assetsplitentry.getDynamicObject("realcard").getString("number"));
        cardEntry.set("spli_beforeorginal", (Object)assetsplitentry.getBigDecimal("bef_originalval"));
        cardEntry.set("spli_beforeaccumdepre", (Object)assetsplitentry.getBigDecimal("bef_accumdepre"));
        cardEntry.set("spli_beforeassetname", (Object)assetsplitentry.getDynamicObject("realcard").getString("assetname"));
        cardEntry.set("spli_beforeallowimpair", (Object)assetsplitentry.getBigDecimal("bef_decval"));
        cardEntry.set("spli_beforenetvalue", (Object)assetsplitentry.getBigDecimal("bef_preresidualval"));
        cardEntry.set("spli_afternumber", (Object)subassetsplitentry.getString("aft_cardnumber"));
        cardEntry.set("spli_afterid", (Object)subassetsplitentry.getDynamicObject("aft_realcard").getLong("id"));
        cardEntry.set("spli_afterorginal", (Object)subassetsplitentry.getBigDecimal("aft_originalval"));
        cardEntry.set("spli_afteraccumdepre", (Object)subassetsplitentry.getBigDecimal("aft_accumdepre"));
        cardEntry.set("spli_afterassetname", (Object)subassetsplitentry.getDynamicObject("aft_realcard").getString("assetname"));
        cardEntry.set("spli_afterallowimpair", (Object)subassetsplitentry.getBigDecimal("aft_decval"));
        cardEntry.set("spli_afternetvalue", (Object)subassetsplitentry.getBigDecimal("aft_preresidualval"));
        return cardEntry;
    }

    private QFilter[] getTabBillFilter(QFilter[] filters, String billDate) {
        if (this.monCard) {
            QFilter clearDateFilter = new QFilter(billDate, "<", (Object)this.monPeriod.getDate("enddate"));
            return this.getMonFilter(filters, clearDateFilter);
        }
        return filters;
    }

    private QFilter[] getMonFilter(QFilter[] filters, QFilter monCardFilter) {
        for (int i = 1; i < filters.length; ++i) {
            filters[0].and(filters[i]);
        }
        if (this.monCard) {
            return new QFilter[]{filters[0], monCardFilter};
        }
        return new QFilter[]{filters[0]};
    }

    private Long LastPeroid(BigDecimal lastDepreAmount, Long periodType, Long bizPeriod, boolean isDayDepre) {
        QFilter qtype = new QFilter("periodtype", "=", (Object)periodType);
        QFilter qlastPeriod = new QFilter("id", ">", (Object)bizPeriod);
        QFilter qisadjustPeriod = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection allLastPeriod = QueryServiceHelper.query((String)"bd_period", (String)"id,begindate,enddate", (QFilter[])new QFilter[]{qtype, qlastPeriod, qisadjustPeriod}, (String)"id");
        long lastPeroid = 0L;
        if (isDayDepre) {
            Calendar calendar = Calendar.getInstance();
            int count = 0;
            for (DynamicObject dy : allLastPeriod) {
                Date begindate = dy.getDate("begindate");
                Date enddate = dy.getDate("enddate");
                calendar.setTime(begindate);
                int begindateIndex = calendar.get(6);
                int begindateYear = calendar.get(1);
                calendar.setTime(enddate);
                int enddateIndex = calendar.get(6);
                int enddateYear = calendar.get(1);
                int distanceDay = 0;
                if (begindateYear == enddateYear) {
                    distanceDay = enddateIndex - begindateIndex + 1;
                } else {
                    calendar.set(1, enddateYear);
                    calendar.set(2, 0);
                    calendar.set(5, 1);
                    calendar.set(10, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    calendar.add(6, -1);
                    int begindateYearLastDay = calendar.get(6);
                    distanceDay = begindateYearLastDay - begindateIndex + 1 + enddateIndex;
                }
                if ((count += distanceDay) < lastDepreAmount.intValue()) continue;
                lastPeroid = dy.getLong("id");
                break;
            }
        } else {
            int count = 1;
            for (DynamicObject dy : allLastPeriod) {
                if (count == lastDepreAmount.intValue()) {
                    lastPeroid = dy.getLong("id");
                    break;
                }
                ++count;
            }
        }
        if (allLastPeriod.size() == 0 && lastDepreAmount.intValue() == 0) {
            lastPeroid = bizPeriod;
        }
        if (lastDepreAmount.intValue() == 0) {
            lastPeroid = bizPeriod;
        }
        return lastPeroid;
    }
}

