/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.utils.FaFormCurPeriodBizUtils;
import kd.fi.fa.utils.FaFormUtils;

public class ClearBillFilterList
extends AbstractListPlugin {
    private static final String IS_CLICK_ORG = "isClickOrg";
    private static Log logger = LogFactory.getLog(ClearBillFilterList.class);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!FaUtils.isF7((IFormView)this.getView())) {
            HyperLinkClickEvent hyperClick = args.getHyperLinkClickEvent();
            int rowIndex = args.getHyperLinkClickEvent().getRowIndex();
            args.setCancel(true);
            if ("vounchernumber".equals(hyperClick.getFieldName())) {
                BillList billList = (BillList)this.getControl("BillListAp");
                ListSelectedRowCollection listCol = billList.getSelectedRows();
                if (listCol.size() < 0) {
                    return;
                }
                Object rowPk = FaUtils.getRowPk((Object)listCol.get(0).getPrimaryKeyValue());
                FaUtils.showTabForm((String)"gl_voucher", (String)ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"ClearBillFilterList_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), (Object)rowPk, (IFormView)this.getView());
            } else if ("realcard_billno".equals(hyperClick.getFieldName())) {
                Object realPk = FaUtils.getRowRealCardNo((int)rowIndex, (IFormView)this.getView());
                FaUtils.showTabForm((String)"fa_card_real", (String)ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247", (String)"ClearBillFilterList_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), (Object)realPk, (IFormView)this.getView());
            } else {
                args.setCancel(false);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs filtercontainerinitargs) {
        super.filterContainerInit(filtercontainerinitargs);
        List listFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        Object sFilter = paramMap.get("filter");
        QFilter filters = null;
        QFilter[] filters2 = null;
        if (sFilter != null) {
            filters = QFilter.fromSerializedString((String)(sFilter + ""));
            filters2 = filters.recombine();
        }
        for (FilterColumn listFilter : listFilterColumns) {
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            if ("org.id".equals(commFilter.getFieldName()) || "org.number".equals(commFilter.getFieldName()) || "org.name".equals(commFilter.getFieldName())) {
                String defaultOrgid = "";
                String orgFilterObjId = (String)paramMap.get("org");
                if (orgFilterObjId != null) {
                    defaultOrgid = orgFilterObjId;
                    commFilter.setDefaultValue(defaultOrgid);
                    this.getPageCache().put("org", defaultOrgid);
                    continue;
                }
                String entityId = ((FilterContainer)filtercontainerinitargs.getFilterContainerInitEvent().getSource()).getEntityId();
                List comboItems = FaPermissionUtils.getAllEnableBookAndPermissionOrgsCombosV2((String)this.getView().getPageId(), (String)entityId);
                commFilter.setComboItems(comboItems);
                if (null == comboItems || comboItems.size() <= 0) continue;
                defaultOrgid = this.getDefaultId(comboItems);
                this.getPageCache().put("org", defaultOrgid);
                if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(IS_CLICK_ORG))) continue;
                try {
                    String orgLinkString = FaFormUtils.linkOrgContainerInit(this.getPageCache(), this.getView(), "org");
                    if (StringUtils.isNotEmpty((CharSequence)orgLinkString)) {
                        List orgIds = (List)SerializationUtils.fromJsonString((String)orgLinkString, List.class);
                        commFilter.setDefaultValues(orgIds);
                    } else {
                        commFilter.setDefaultValue(defaultOrgid);
                        commFilter.setDefValue(defaultOrgid);
                    }
                }
                catch (IOException e) {
                    logger.error(ThrowableHelper.toString((Throwable)e));
                }
                if (sFilter != null) {
                    String transOrg = Stream.of(filters2).filter(v -> v.getProperty().equalsIgnoreCase("org")).map(QFilter::getValue).map(Object::toString).reduce("", String::concat);
                    commFilter.setDefaultValue(transOrg);
                }
                commFilter.setMustInput(false);
                continue;
            }
            if (!"cleardate".equals(commFilter.getFieldName())) continue;
            if (sFilter != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                List clearDateDefValue = Stream.of(filters2).filter(v -> v.getProperty().equalsIgnoreCase("cleardate")).map(v -> df.format((Date)v.getValue())).collect(Collectors.toList());
                commFilter.setDefaultValues(clearDateDefValue);
                continue;
            }
            String finaccountdate = (String)paramMap.get("finaccountdate");
            if (!StringUtils.isNotEmpty((CharSequence)finaccountdate) || !finaccountdate.equals("ismainpage")) continue;
            commFilter.setDefaultValue("");
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        List fastlist = (List)map.get("fastfilter");
        if (customlist != null) {
            if (customlist.size() == 0) {
                return;
            }
            for (int i = 0; i < customlist.size(); ++i) {
                Map map1 = (Map)customlist.get(i);
                List listValue = (List)map1.get("Value");
                List listFieldName = (List)map1.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (!listFieldName.get(j).equals("org.id")) continue;
                    String key = CollectionUtils.isEmpty((Collection)listValue) ? "" : (String)listValue.get(j);
                    this.getPageCache().put("org", key);
                    this.getPageCache().put(IS_CLICK_ORG, "yes");
                }
            }
        } else if (schemelist != null ? schemelist.size() == 0 : fastlist != null && fastlist.size() == 0) {
            return;
        }
    }

    private String getDefaultId(List<ComboItem> items) {
        Long currOrgId = RequestContext.get().getOrgId();
        for (int i = 0; i < items.size(); ++i) {
            Long nextId;
            if (null == items.get(i) || items.get(i).getValue().length() == 0 || (nextId = Long.valueOf(Long.parseLong(items.get(i).getValue()))).longValue() != currOrgId.longValue()) continue;
            return currOrgId.toString();
        }
        String defaultStr = items.get(0).getValue();
        return defaultStr;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if ("org.id".equals(field) || "org.number".equals(field) || "org.name".equals(field)) {
            List orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_clearbill");
            e.getQfilters().add(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object sFilter = this.getView().getFormShowParameter().getCustomParams().get("filter");
        if (sFilter != null) {
            e.getQFilters().clear();
            e.getQFilters().add(QFilter.fromSerializedString((String)(sFilter + "")));
        } else {
            FormShowParameter formShowParameter;
            Map paramMap;
            String defortfilter;
            List qFilters = e.getQFilters();
            String notFirst = this.getPageCache().get("notFirst");
            if (!(notFirst != null && notFirst.equals("1") || (defortfilter = (String)(paramMap = (formShowParameter = this.getView().getFormShowParameter()).getCustomParams()).get("defortFilter")) == null || defortfilter.length() <= 0)) {
                qFilters.add(QFilter.fromSerializedString((String)defortfilter));
                this.getPageCache().put("notFirst", "1");
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        FaFormCurPeriodBizUtils.showGuideConfirm4List(evt, this.getView(), "fa_clearbill", (IFormPlugin)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        FaFormCurPeriodBizUtils.guideConfirmCallBack(messageBoxClosedEvent, this.getView());
    }
}

