/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.login.utils.StringUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.formplugin.AbstractDepreSplitSetUpForm;
import kd.fi.fa.formplugin.DSField;
import kd.fi.fa.utils.FaDepreSplitUtil;
import kd.fi.fa.utils.FaF7DeptUtils;

public class DepreSplitSetUpAddNew
extends AbstractDepreSplitSetUpForm {
    private static final String CURRENT_PERIOD = "currentPeriod";
    private static final String KEY_ENTRYENTITY = "entryentity";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject book;
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String createOrgID = (String)showParam.getCustomParam("createorgid");
        IDataModel m = this.getModel();
        long orgid = 0L;
        if (StringUtils.isNotEmpty((String)createOrgID)) {
            orgid = Long.parseLong(createOrgID);
            m.setValue("org", (Object)orgid);
            showParam.setCustomParam("createorgid", null);
        } else {
            DynamicObject orgDo = (DynamicObject)m.getValue("org");
            if (orgDo != null) {
                orgid = orgDo.getLong("id");
            }
        }
        if (orgid != 0L && (book = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"id,depreuse.id,curperiod.id,curperiod.number", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgid), new QFilter("ismainbook", "=", (Object)Boolean.TRUE)})) != null) {
            m.setValue("depreuse", (Object)book.getLong("depreuse.id"));
            m.setValue("beginperiod", (Object)book.getLong("curperiod.id"));
            this.getPageCache().put(CURRENT_PERIOD, book.getString("curperiod.number"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if ("donothing".equals(afterDoOperationEventArgs.getOperateKey())) {
            if (result.isSuccess()) {
                this.getModel().setDataChanged(false);
                this.getView().close();
            } else {
                this.getView().showOperationResult(result);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit beginperiod = (BasedataEdit)this.getControl("beginperiod");
        beginperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("org");
        orgCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit asstype = (BasedataEdit)this.getControl("asstype");
        asstype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit realcard = (BasedataEdit)this.getControl("realcard");
        realcard.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit depreuse = (BasedataEdit)this.getControl("depreuse");
        depreuse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        String adminOrgKey = this.getPageCache().get("cache_admin_org_key");
        if (StringUtils.isNotEmpty((String)adminOrgKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            BasedataEdit adminOrgCtrl = (BasedataEdit)this.getControl(adminOrgKey);
            adminOrgCtrl.addBeforeF7SelectListener(evt -> {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
                DynamicObject selectRow = (DynamicObject)entryEntity.get(evt.getRow());
                DynamicObject realCard = selectRow.getDynamicObject("realcard");
                if (realCard == null) {
                    return;
                }
                DynamicObject assetUnit = realCard.getDynamicObject("assetunit");
                if (assetUnit == null) {
                    return;
                }
                FaF7DeptUtils.beforeDeptSelect(evt, org, assetUnit);
            });
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("exit".equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        ChangeData[] data = e.getChangeSet();
        IDataEntityProperty property = e.getProperty();
        String pkey = property.getName();
        if ("asstype".equalsIgnoreCase(pkey)) {
            DynamicObjectCollection newData = (DynamicObjectCollection)data[0].getNewValue();
            List<DSField> fields = FaDepreSplitUtil.generateFields(newData);
            String dsfieldstr = this.getPageCache().get("DSFields");
            if (StringUtils.isNotEmpty((String)dsfieldstr)) {
                List OldFields = SerializationUtils.fromJsonStringToList((String)dsfieldstr, DSField.class);
                DynamicObjectCollection entries = model.getEntryEntity(KEY_ENTRYENTITY);
                int size = entries.size();
                for (Object field : OldFields) {
                    DSField oldDs = (DSField)field;
                    boolean stay = false;
                    for (DSField newds : fields) {
                        if (!newds.getEntityId().equalsIgnoreCase(oldDs.getEntityId()) || !newds.getFieldKey().equalsIgnoreCase(oldDs.getFieldKey())) continue;
                        stay = true;
                    }
                    if (stay) continue;
                    for (int m = 0; m < size; ++m) {
                        model.setValue(oldDs.getFieldKey(), null, m);
                    }
                }
            }
            this.getPageCache().put("DSFields", SerializationUtils.toJsonString(fields));
            this.saveFactorDataToModel(fields);
            this.reBuildModelAndGrid(fields, model.getDataEntityType(), true);
        } else if ("org".equalsIgnoreCase(pkey)) {
            DynamicObject newOrg = (DynamicObject)data[0].getNewValue();
            if (newOrg != null) {
                DynamicObject book = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"id,depreuse.id,curperiod.id,curperiod.number", (QFilter[])new QFilter[]{new QFilter("org", "=", newOrg.getPkValue()), new QFilter("ismainbook", "=", (Object)Boolean.TRUE)});
                if (book != null) {
                    model.setValue("depreuse", (Object)book.getLong("depreuse.id"));
                    model.setValue("beginperiod", (Object)book.getLong("curperiod.id"));
                    this.getPageCache().put(CURRENT_PERIOD, book.getString("curperiod.number"));
                }
                model.setValue("asstype", null);
                model.deleteEntryData(KEY_ENTRYENTITY);
            }
        } else if ("depreuse".equalsIgnoreCase(pkey)) {
            DynamicObject book;
            DynamicObject newUse = (DynamicObject)data[0].getNewValue();
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (newUse != null && org != null && (book = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"id,depreuse.id,curperiod.id,curperiod.number", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("depreuse", "=", newUse.getPkValue())})) != null) {
                model.setValue("beginperiod", (Object)book.getLong("curperiod.id"));
                this.getPageCache().put(CURRENT_PERIOD, book.getString("curperiod.number"));
            }
        } else if ("percent".equalsIgnoreCase(pkey)) {
            DynamicObject realCard;
            BigDecimal percent = (BigDecimal)data[0].getNewValue();
            BigDecimal total = BigDecimal.ZERO;
            DynamicObject rowData = data[0].getDataEntity();
            if (rowData != null && (realCard = rowData.getDynamicObject("realcard")) != null) {
                Long id = realCard.getLong("id");
                int currIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
                DynamicObjectCollection entrys = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
                DynamicObject each = null;
                DynamicObject eachCard = null;
                for (int i = 0; i < entrys.size(); ++i) {
                    each = (DynamicObject)entrys.get(i);
                    eachCard = each.getDynamicObject("realcard");
                    if (eachCard == null || !id.equals(eachCard.getLong("id"))) continue;
                    total = currIndex == i ? total.add(percent) : total.add(each.getBigDecimal("percent"));
                }
            }
            if (total.compareTo(new BigDecimal("100")) < 0) {
                this.getModel().beginInit();
                DynamicObject entryObj = model.getEntryRowEntity(KEY_ENTRYENTITY, data[0].getRowIndex());
                EntryProp entryp = (EntryProp)model.getDataEntityType().getProperty(KEY_ENTRYENTITY);
                DynamicObjectCollection coll = new DynamicObjectCollection();
                DynamicObject newObj = ORM.create().newDynamicObject(entryObj.getDynamicObjectType());
                newObj.set("realcard", entryObj.get("realcard"));
                newObj.set("orgduty", entryObj.get("orgduty"));
                newObj.set("percent", (Object)new BigDecimal(100).subtract(total));
                coll.add((Object)newObj);
                model.batchInsertEntryRow(entryp, data[0].getRowIndex() + 1, coll);
                model.setValue("percent", (Object)new BigDecimal(100).subtract(total), data[0].getRowIndex() + 1);
                this.getModel().endInit();
                this.getView().updateView(KEY_ENTRYENTITY);
            }
        } else if ("realcard".equalsIgnoreCase(pkey)) {
            String costCenterKey = this.getCostCenterKey();
            if (costCenterKey == null) {
                DynamicObject realcard = (DynamicObject)data[0].getNewValue();
                if (realcard == null) {
                    return;
                }
                DynamicObject useDept = realcard.getDynamicObject("headusedept");
                if (useDept != null) {
                    model.setValue("orgduty", (Object)this.getOrgDutyID(useDept.getLong("id")), data[0].getRowIndex());
                }
            }
            model.setValue("percent", (Object)100, data[0].getRowIndex());
        } else {
            DynamicObject newValue;
            String adminOrgKey;
            DynamicObject costCenter;
            String costCenterKey = this.getCostCenterKey();
            if (pkey.equalsIgnoreCase(costCenterKey) && (costCenter = (DynamicObject)data[0].getNewValue()) != null) {
                DynamicObject orgduty = costCenter.getDynamicObject("orgduty");
                model.setValue("orgduty", (Object)orgduty, data[0].getRowIndex());
            }
            if (pkey.equalsIgnoreCase(adminOrgKey = this.getAdminOrgKey()) && Objects.nonNull(newValue = (DynamicObject)data[0].getNewValue())) {
                Long id = this.getOrgDutyID(newValue.getLong("id"));
                if (id == 0L) {
                    id = null;
                }
                model.setValue("orgduty", (Object)id, data[0].getRowIndex());
            }
        }
    }

    private void saveFactorDataToModel(List<DSField> refList) {
        IDataModel model = this.getModel();
        model.deleteEntryData("fieldmapentry");
        for (DSField field : refList) {
            int rowIndex = model.createNewEntryRow("fieldmapentry");
            model.setValue("datatype", (Object)field.getDataType(), rowIndex);
            model.setValue("entityid", (Object)field.getEntityId(), rowIndex);
            model.setValue("fieldname", (Object)field.getFieldName(), rowIndex);
            model.setValue("fieldkey", (Object)field.getFieldKey(), rowIndex);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this.getPageCache().get("DSFields") != null) {
            List list = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("DSFields"), DSField.class);
            MainEntityType entitytype = e.getOriginalEntityType();
            this.reBuildModelAndGrid(list, entitytype, false);
            e.setNewEntityType(entitytype);
        }
    }

    private void reBuildModelAndGrid(List<DSField> list, MainEntityType mainEntityType, boolean rebuildGrid) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty(KEY_ENTRYENTITY);
        this.setFactorColumnMeta(list, mainEntityType, entry);
        this.drawGrid(list, mainEntityType, rebuildGrid);
    }

    private void drawGrid(List<DSField> refList, MainEntityType mainEntityType, boolean rebuildGrid) {
        String entityId = MetadataDao.getIdByNumber((String)"fa_depresplitaddnew", (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        if (rebuildGrid) {
            cols.add(this.createSeqColumn());
            cols.add(this.createRealCardColumn());
            cols.add(this.createRealCardPropColumn(entitymeta, "assetname", "cardname", ResManager.loadKDString((String)"\u8d44\u4ea7\u540d\u79f0", (String)"DepreSplitSetUpAddNew_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), "200"));
            cols.add(this.createRealCardPropColumn(entitymeta, "headusedept.name", "carddept", ResManager.loadKDString((String)"\u4f7f\u7528\u90e8\u95e8", (String)"DepreSplitSetUpAddNew_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), "200"));
            cols.add(this.createRealCardPropColumn(entitymeta, "headuseperson.name", "carduser", ResManager.loadKDString((String)"\u4f7f\u7528\u4eba", (String)"DepreSplitSetUpAddNew_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), "100"));
            cols.add(this.createRealCardPropColumn(entitymeta, "storeplace.name", "cardaddress", ResManager.loadKDString((String)"\u5b58\u653e\u5730\u70b9", (String)"DepreSplitSetUpAddNew_5", (String)"fi-fa-formplugin", (Object[])new Object[0]), "200"));
            cols.add(this.createDeptUseColumn());
        }
        if (refList != null) {
            for (DSField ref : refList) {
                Map<String, Object> col = this.createBaseDataColumn(ref);
                cols.add(col);
            }
        }
        if (rebuildGrid) {
            Map<String, Object> assCol = this.createPercentColumn();
            if (assCol != null) {
                cols.add(assCol);
            }
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("rk", "rk");
            meta.put("seq", "fseq");
            meta.put("columns", cols);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod(KEY_ENTRYENTITY, "createGridColumns", new Object[]{meta});
        }
    }

    private Map<String, Object> createRealCardPropColumn(EntityMetadata entitymeta, String propName, String propKey, String columnName, String width) {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey(propKey);
        f7Field.setName(new LocaleString(columnName));
        f7Field.setFieldTextAlign("center");
        f7Field.setTextAlign("center");
        f7Field.setAlignSelf("center");
        f7Field.setWidth(new LocaleString(width));
        f7Field.setLock("");
        BasedataPropField basedata = new BasedataPropField();
        basedata.setEntityMetadata(entitymeta);
        basedata.setRefBaseFieldId("realcard");
        basedata.setRefDisplayProp(propName);
        basedata.setKey(propKey);
        f7Field.setField((Field)basedata);
        return (Map)f7Field.createColumns().get(0);
    }

    private Map<String, Object> createRealCardColumn() {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey("realcard");
        f7Field.setName(new LocaleString(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801", (String)"DepreSplitSetUpAddNew_6", (String)"fi-fa-formplugin", (Object[])new Object[0])));
        f7Field.setFieldTextAlign("center");
        f7Field.setTextAlign("center");
        f7Field.setAlignSelf("center");
        f7Field.setWidth(new LocaleString("200"));
        f7Field.setLock("");
        f7Field.setDisplayFormatString("number");
        BasedataField basedata = new BasedataField();
        basedata.setBaseEntityId("fa_card_real_base");
        basedata.setKey("realcard");
        basedata.setDisplayProp("number");
        basedata.setNumberProp("number");
        f7Field.setField((Field)basedata);
        return (Map)f7Field.createColumns().get(0);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        ListFilterParameter filterParam;
        ListShowParameter showParameter;
        List<QFilter> qFilters;
        DynamicObject org;
        ListFilterParameter filterParam2;
        ListShowParameter showParameter2;
        DynamicObject org2;
        ArrayList<QFilter> qFilters2;
        Object source = arg0.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        IDataModel model = this.getModel();
        if ("beginperiod".equals(key)) {
            String currentPeriodNumber;
            qFilters2 = new ArrayList<QFilter>();
            org2 = (DynamicObject)model.getValue("org");
            if (org2 == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DepreSplitSetUpAddNew_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            if (depreuse == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"DepreSplitSetUpAddNew_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            DynamicObject book = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"id,depreuse.id,depresystem.id,depresystem.periodtype,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "=", org2.getPkValue()), new QFilter("depreuse", "=", depreuse.getPkValue())});
            if (book != null) {
                qFilters2.add(new QFilter("periodtype", "=", (Object)book.getLong("periodtype.id")));
            }
            if ((currentPeriodNumber = this.getPageCache().get(CURRENT_PERIOD)) != null) {
                qFilters2.add(new QFilter("number", ">=", (Object)currentPeriodNumber));
            }
            ListShowParameter showParameter3 = (ListShowParameter)arg0.getFormShowParameter();
            ListFilterParameter filterParam3 = showParameter3.getListFilterParameter();
            filterParam3.getQFilters().addAll(qFilters2);
        } else if ("org".equals(key)) {
            qFilters2 = new ArrayList();
            qFilters2.add(new QFilter("id", "in", (Object)FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_depresplitsetup", (String)"47156aff000000ac")));
            showParameter2 = (ListShowParameter)arg0.getFormShowParameter();
            filterParam2 = showParameter2.getListFilterParameter();
            filterParam2.getQFilters().addAll(qFilters2);
        } else if ("asstype".equals(key)) {
            org = (DynamicObject)model.getValue("org");
            if (org == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DepreSplitSetUpAddNew_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            if (depreuse == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"DepreSplitSetUpAddNew_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            qFilters = FaDepreSplitUtil.getAssTypeFilter(org.getLong("id"));
            showParameter = (ListShowParameter)arg0.getFormShowParameter();
            filterParam = showParameter.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters);
        } else if ("realcard".equals(key)) {
            qFilters2 = new ArrayList();
            qFilters2.add(new QFilter("org", "=", ((DynamicObject)model.getValue("org")).getPkValue()));
            qFilters2.add(new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE));
            qFilters2.add(new QFilter("isbak", "=", (Object)false));
            showParameter2 = (ListShowParameter)arg0.getFormShowParameter();
            filterParam2 = showParameter2.getListFilterParameter();
            filterParam2.getQFilters().addAll(qFilters2);
        } else if ("depreuse".equals(key)) {
            org = (DynamicObject)model.getValue("org");
            if (org == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DepreSplitSetUpAddNew_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            List ids = (List)DB.query((DBRoute)DBRoute.of((String)"fa"), (String)"select fdepreuse from t_fa_assetbook where FORGID = ?", (Object[])new Object[]{org.getPkValue()}, e -> {
                ArrayList<Long> depreUseIds = new ArrayList<Long>(e.getRow());
                while (e.next()) {
                    depreUseIds.add(e.getLong("fdepreuse"));
                }
                return depreUseIds;
            });
            qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("id", "in", (Object)ids));
            showParameter = (ListShowParameter)arg0.getFormShowParameter();
            filterParam = showParameter.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters);
        }
        if ("bos_costcenter".equals(this.getPageCache().get(key))) {
            qFilters2 = new ArrayList();
            qFilters2.add(new QFilter("enable", "=", (Object)"1"));
            org2 = (DynamicObject)model.getValue("org");
            boolean departSharing = FaAssetUnitAndUseDeptUnits.checkDepartSharing((DynamicObject)org2);
            if (!departSharing) {
                qFilters2.add(new QFilter("accountorg", "=", org2.getPkValue()));
            }
            showParameter = (ListShowParameter)arg0.getFormShowParameter();
            filterParam = showParameter.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters2);
        }
    }
}

