/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.formplugin.AbstractDepreSplitSetUpForm;
import kd.fi.fa.formplugin.DSField;
import kd.fi.fa.formplugin.importhandler.DepreSplitSetUpImportHandler;
import kd.fi.fa.utils.FaDepreSplitUtil;
import kd.fi.fa.utils.FaF7DeptUtils;

public class DepreSplitSetUpEdit
extends AbstractDepreSplitSetUpForm {
    private static final String KEY_ENTRYENTITY = "assentry";
    private static final Log log = LogFactory.getLog(DepreSplitSetUpEdit.class);

    public void initImportData(InitImportDataEventArgs e) {
        List sourceList = e.getSourceDataList();
        HashSet<String> numberSet = new HashSet<String>(sourceList.size());
        for (Map splitSetUp : sourceList) {
            JSONObject jsonObj = new JSONObject(splitSetUp);
            String realCardNum = jsonObj.getJSONObject("realcard").getString("number");
            if (realCardNum == null) continue;
            numberSet.add(realCardNum);
        }
        HashMap<String, Long> numAndIdMap = new HashMap<String, Long>(numberSet.size());
        if (numberSet.size() > 0) {
            String selectFields = String.join((CharSequence)", ", "id", "number");
            QFilter[] filters = new QFilter[]{new QFilter("number", "in", numberSet), new QFilter("id", "=", (Object)"masterid", true)};
            DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)selectFields, (QFilter[])filters);
            for (DynamicObject realCard : realCards) {
                String number = realCard.getString("number");
                long id = realCard.getLong("id");
                numAndIdMap.put(number, id);
            }
        }
        for (Map row : sourceList) {
            JSONObject jsonObj = new JSONObject(row);
            JSONObject realCard = jsonObj.getJSONObject("realcard");
            String realCardNum = realCard.getString("number");
            realCard.put("importprop", (Object)"id");
            realCard.put("id", numAndIdMap.get(realCardNum));
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        new DepreSplitSetUpImportHandler().beforeImporChecktData(this.getView().getPageId(), e);
        super.beforeImportData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        new DepreSplitSetUpImportHandler().setSourceDataToModel(this.getModel(), this.getView());
        super.afterImportData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        DynamicObject org;
        ArrayList<QFilter> qFilters;
        Object source = arg0.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        IDataModel model = this.getModel();
        if ("asstypes".equals(key)) {
            DynamicObject org2 = (DynamicObject)model.getValue("org");
            List<QFilter> qFilters2 = FaDepreSplitUtil.getAssTypeFilter(org2.getLong("id"));
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters2);
        } else if ("beginperiod".equals(key)) {
            qFilters = new ArrayList<QFilter>();
            org = (DynamicObject)model.getValue("org");
            if (org == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DepreSplitSetUpEdit_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            if (depreuse == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"DepreSplitSetUpEdit_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            DynamicObject book = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"id,depreuse.id,,curperiod.number,periodtype.id", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("depreuse", "=", depreuse.getPkValue())});
            if (book != null) {
                qFilters.add(new QFilter("periodtype", "=", (Object)book.getLong("periodtype.id")));
                String currentPeriodNumber = book.getString("curperiod.number");
                if (currentPeriodNumber != null) {
                    qFilters.add(new QFilter("number", ">=", (Object)currentPeriodNumber));
                }
            }
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters);
        }
        if ("bos_costcenter".equals(this.getPageCache().get(key))) {
            qFilters = new ArrayList();
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            org = (DynamicObject)model.getValue("org");
            boolean departSharing = FaAssetUnitAndUseDeptUnits.checkDepartSharing((DynamicObject)org);
            if (!departSharing) {
                qFilters.add(new QFilter("accountorg", "=", org.getPkValue()));
            }
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tblrepair"});
        BasedataEdit asstype = (BasedataEdit)this.getControl("asstypes");
        asstype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit beginperiod = (BasedataEdit)this.getControl("beginperiod");
        beginperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        String adminOrgKey = this.getPageCache().get("cache_admin_org_key");
        if (StringUtils.isNotEmpty((String)adminOrgKey)) {
            BasedataEdit adminOrgCtrl = (BasedataEdit)this.getControl(adminOrgKey);
            DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
            DynamicObject realCard = (DynamicObject)this.getModel().getValue("realcard");
            adminOrgCtrl.addBeforeF7SelectListener(evt -> {
                if (realCard == null) {
                    return;
                }
                DynamicObject assetUnit = realCard.getDynamicObject("assetunit");
                if (assetUnit == null) {
                    return;
                }
                FaF7DeptUtils.beforeDeptSelect(evt, org, assetUnit);
            });
        }
    }

    public void initialize() {
        super.initialize();
        this.setShortCuts();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblrepair"});
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts") && "[16,77]".equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tblrepair"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("tblrepair".equals(key)) {
            List list;
            String genMsg;
            boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!fromDatabase) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u644a\u8bbe\u7f6e\u5c1a\u672a\u4fdd\u5b58\u65e0\u987b\u4fee\u590d\u3002", (String)"DepreSplitSetUpEdit_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            Object msg = this.getModel().getValue("msg");
            if (msg.equals(genMsg = this.writeMsg(list = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("DSFields"), DSField.class), false))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u644a\u8bbe\u7f6e\u4fe1\u606f\u65e0\u987b\u4fee\u590d\u3002", (String)"DepreSplitSetUpEdit_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_depresplitsetup set fmsg = ? where fid = ?", (Object[])new Object[]{genMsg, this.getModel().getDataEntity().getPkValue()});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u644a\u8bbe\u7f6e\u4fe1\u606f\u4fee\u590d\u6210\u529f\u3002", (String)"DepreSplitSetUpEdit_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        int entrySize = model.getEntryRowCount(KEY_ENTRYENTITY);
        List list = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("DSFields"), DSField.class);
        HashMap<String, String> assFieldKeys = new HashMap<String, String>(list.size());
        for (DSField ds : list) {
            assFieldKeys.put(ds.getEntityId(), ds.getFieldKey());
        }
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject entry = model.getEntryRowEntity(KEY_ENTRYENTITY, i);
            DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("asssubentry");
            for (DynamicObject sub : subEntries) {
                String asstype = sub.getString("asstype");
                String key = (String)assFieldKeys.get(asstype);
                if (key == null) {
                    if ("bos_org".equals(asstype)) {
                        key = (String)assFieldKeys.get("bos_adminorg");
                    } else if ("bos_adminorg".equals(asstype)) {
                        key = (String)assFieldKeys.get("bos_org");
                    }
                }
                if (key == null) {
                    log.info("\u6298\u65e7\u5206\u644a\u8bbe\u7f6e\u6298\u65e7\u5206\u644a\u7ef4\u5ea6\u4e0e\u5b50\u5206\u5f55\u5206\u644a\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u6298\u65e7\u5206\u644a\u7ef4\u5ea6\u96c6\u5408\u4e3a\uff1a" + assFieldKeys.keySet() + "\u5b50\u5206\u5f55\u5206\u644a\u7ef4\u5ea6\u7c7b\u578b\u4e3a\uff1a" + asstype);
                    continue;
                }
                Long assID = sub.getLong("assid");
                model.setValue(key, (Object)assID, i);
            }
        }
        model.setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        ChangeData[] data = e.getChangeSet();
        IDataEntityProperty property = e.getProperty();
        String pkey = property.getName();
        ChangeData changeData = data[0];
        if (pkey.startsWith("basedata") || pkey.startsWith("assistant")) {
            DynamicObject newValue;
            String adminOrgKey;
            DynamicObject costCenter;
            int rowIndex = changeData.getRowIndex();
            List list = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("DSFields"), DSField.class);
            DynamicObject newData = (DynamicObject)data[0].getNewValue();
            long newID = 0L;
            if (newData != null) {
                newID = newData.getLong("id");
            }
            for (DSField ds : list) {
                if (!pkey.equalsIgnoreCase(ds.getFieldKey())) continue;
                DynamicObject dataEntity = model.getDataEntity(true);
                DynamicObjectCollection assEntryColl = dataEntity.getDynamicObjectCollection(KEY_ENTRYENTITY);
                DynamicObject assEntry = (DynamicObject)assEntryColl.get(rowIndex);
                DynamicObjectCollection assSubEntryColl = assEntry.getDynamicObjectCollection("asssubentry");
                boolean exist = false;
                for (int i = 0; i < assSubEntryColl.size(); ++i) {
                    DynamicObject assSubEntry = (DynamicObject)assSubEntryColl.get(i);
                    if (!assSubEntry.getString("asstype").equalsIgnoreCase(ds.getEntityId())) continue;
                    assSubEntry.set("assid", (Object)newID);
                    exist = true;
                }
                if (exist) break;
                DynamicObject assSubEntry = assSubEntryColl.addNew();
                assSubEntry.set("asstype", (Object)ds.getEntityId());
                assSubEntry.set("assid", (Object)newID);
                break;
            }
            this.writeMsg(list, true);
            String costCenterKey = this.getCostCenterKey();
            if (pkey.equalsIgnoreCase(costCenterKey) && (costCenter = (DynamicObject)data[0].getNewValue()) != null) {
                DynamicObject orgduty = costCenter.getDynamicObject("orgduty");
                model.setValue("orgduty", (Object)orgduty, data[0].getRowIndex());
            }
            if (pkey.equalsIgnoreCase(adminOrgKey = this.getAdminOrgKey()) && Objects.nonNull(newValue = (DynamicObject)data[0].getNewValue())) {
                Long id = this.getOrgDutyID(newValue.getLong("id"));
                if (id == 0L) {
                    id = null;
                }
                model.setValue("orgduty", (Object)id, data[0].getRowIndex());
            }
        } else if ("percent".equalsIgnoreCase(pkey)) {
            BigDecimal oldPercent = (BigDecimal)data[0].getOldValue();
            BigDecimal percent = (BigDecimal)data[0].getNewValue();
            if (oldPercent.compareTo(new BigDecimal("100")) == 0) {
                DynamicObject entryObj = model.getEntryRowEntity(KEY_ENTRYENTITY, data[0].getRowIndex());
                EntryProp entryp = (EntryProp)model.getDataEntityType().getProperty(KEY_ENTRYENTITY);
                DynamicObjectCollection coll = new DynamicObjectCollection();
                DynamicObject newObj = ORM.create().newDynamicObject(entryObj.getDynamicObjectType());
                newObj.set("orgduty", entryObj.get("orgduty"));
                newObj.set("percent", (Object)oldPercent.subtract(percent));
                coll.add((Object)newObj);
                model.batchInsertEntryRow(entryp, data[0].getRowIndex() + 1, coll);
                model.setValue("percent", (Object)oldPercent.subtract(percent), data[0].getRowIndex() + 1);
            }
            List list = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("DSFields"), DSField.class);
            this.writeMsg(list, true);
        } else if ("orgduty".equalsIgnoreCase(pkey)) {
            List list = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("DSFields"), DSField.class);
            this.writeMsg(list, true);
        } else if ("asstypes".equalsIgnoreCase(pkey)) {
            DynamicObjectCollection newData = (DynamicObjectCollection)data[0].getNewValue();
            List<DSField> fields = FaDepreSplitUtil.generateFields(newData);
            String dsfieldstr = this.getPageCache().get("DSFields");
            this.getPageCache().put("DSFields", SerializationUtils.toJsonString(fields));
            if (StringUtils.isNotEmpty((String)dsfieldstr)) {
                List OldFields = SerializationUtils.fromJsonStringToList((String)dsfieldstr, DSField.class);
                DynamicObjectCollection entries = model.getEntryEntity(KEY_ENTRYENTITY);
                int size = entries.size();
                for (Object field : OldFields) {
                    DSField oldDs = (DSField)field;
                    boolean stay = false;
                    for (DSField newds : fields) {
                        if (!newds.getEntityId().equalsIgnoreCase(oldDs.getEntityId()) || !newds.getFieldKey().equalsIgnoreCase(oldDs.getFieldKey())) continue;
                        stay = true;
                    }
                    if (stay) continue;
                    for (int m = 0; m < size; ++m) {
                        model.setValue(oldDs.getFieldKey(), null, m);
                        DynamicObject entryData = model.getEntryRowEntity(KEY_ENTRYENTITY, m);
                        DynamicObjectCollection assSubs = entryData.getDynamicObjectCollection("asssubentry");
                        Iterator subIt = assSubs.iterator();
                        while (subIt.hasNext()) {
                            DynamicObject subData = (DynamicObject)subIt.next();
                            if (!oldDs.getEntityId().equalsIgnoreCase(subData.getString("asstype"))) continue;
                            subIt.remove();
                        }
                    }
                }
            }
            this.writeMsg(fields, true);
            this.reBuildModelAndGrid(fields, model.getDataEntityType(), true);
        }
    }

    private String writeMsg(List<DSField> list, boolean updateModel) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity(KEY_ENTRYENTITY);
        DynamicObjectCollection dimEntries = (DynamicObjectCollection)model.getValue("asstypes");
        HashMap<String, String> assTypeNumberMap = new HashMap<String, String>();
        for (Object asstype : dimEntries) {
            DynamicObject realAssType = asstype.getDynamicObject("fbasedataid");
            String fbdtype = realAssType.getString("valuetype");
            if ("1".equals(fbdtype)) {
                assTypeNumberMap.put(realAssType.getString("valuesource.number"), realAssType.getString("number"));
                continue;
            }
            if (!"2".equals(fbdtype)) continue;
            assTypeNumberMap.put("[2]" + realAssType.getString("assistanttype.id"), realAssType.getString("number"));
        }
        StringBuffer msg = new StringBuffer();
        for (DynamicObject entry : entries) {
            if (msg.length() > 0) {
                msg.append("; ");
            }
            msg = msg.append(entry.getString("orgduty.name")).append(' ').append(entry.getBigDecimal("percent").setScale(4, 4)).append("% ");
            int i = 0;
            TreeMap<String, String> assInfoMap = new TreeMap<String, String>();
            TreeMap<String, String> assInfoImportMap = new TreeMap<String, String>();
            for (DSField dSField : list) {
                DynamicObject basedataValue;
                if (i != 0) {
                    msg.append('/');
                }
                if ((basedataValue = entry.getDynamicObject(dSField.getFieldKey())) == null) continue;
                DynamicObjectType dynamicObjectType = basedataValue.getDynamicObjectType();
                String nameProp = "name";
                String numberProp = "number";
                if (dynamicObjectType instanceof BasedataEntityType) {
                    BasedataEntityType entityType = (BasedataEntityType)dynamicObjectType;
                    nameProp = entityType.getNameProperty();
                    numberProp = entityType.getNumberProperty();
                }
                msg.append(dSField.getFieldName()).append('-').append(basedataValue.getString(nameProp));
                assInfoMap.put(dSField.getEntityId(), basedataValue.getString("id"));
                assInfoImportMap.put(dSField.getEntityId(), basedataValue.getString(numberProp));
                ++i;
            }
            StringBuffer assInfoBuf = new StringBuffer();
            for (Map.Entry e : assInfoMap.entrySet()) {
                if (assInfoBuf.length() > 0) {
                    assInfoBuf.append(";");
                }
                assInfoBuf.append((String)e.getKey()).append("|").append((String)e.getValue());
            }
            if (updateModel) {
                entry.set("assinfo", (Object)assInfoBuf.toString());
            }
            StringBuffer stringBuffer = new StringBuffer();
            String importKey = "";
            for (Map.Entry e : assInfoImportMap.entrySet()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                if (StringUtils.isEmpty((String)(importKey = (String)assTypeNumberMap.get(e.getKey())))) {
                    stringBuffer.append("[2]").append((String)assTypeNumberMap.get("[2]" + (String)e.getKey()));
                } else {
                    stringBuffer.append((String)assTypeNumberMap.get(e.getKey()));
                }
                stringBuffer.append(':').append((String)e.getValue());
            }
            if (!updateModel) continue;
            entry.set("assinfoimport", (Object)stringBuffer.toString());
        }
        String msgStr = msg.toString();
        if (msgStr.length() > 500) {
            msgStr = msgStr.substring(0, 496) + "...";
        }
        if (updateModel) {
            model.setValue("msg", (Object)msgStr);
        }
        return msgStr;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this.getPageCache().get("inited") == null) {
            MainEntityType entitytype = e.getOriginalEntityType();
            BaseShowParameter baseparam = (BaseShowParameter)this.getView().getFormShowParameter();
            Object pk = baseparam.getPkId();
            if (pk != null) {
                DynamicObject editdata = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entitytype.getName());
                DynamicObjectCollection assTypesEntries = editdata.getDynamicObjectCollection("asstypes");
                int i = 0;
                int j = 0;
                ArrayList<DSField> list = new ArrayList<DSField>();
                for (DynamicObject asstypeEntry : assTypesEntries) {
                    DynamicObject asstype = asstypeEntry.getDynamicObject("fbasedataid");
                    String fbdtype = asstype.getString("valuetype");
                    DSField sd = new DSField();
                    sd.setDataType(fbdtype);
                    if ("1".equals(fbdtype)) {
                        sd.setEntityId(asstype.getString("valuesource.number"));
                        sd.setFieldKey("basedata" + i);
                        sd.setFieldName(new LocaleString(asstype.getString("valuesource.name")));
                        ++i;
                    } else if ("2".equals(fbdtype)) {
                        sd.setEntityId(asstype.getString("assistanttype.id"));
                        sd.setFieldKey("assistant" + j);
                        sd.setFieldName(new LocaleString(asstype.getString("assistanttype.name")));
                        ++j;
                    }
                    list.add(sd);
                }
                this.reBuildModelAndGrid(list, entitytype, true);
                this.getPageCache().put("DSFields", SerializationUtils.toJsonString(list));
                e.setNewEntityType(entitytype);
            }
            this.getPageCache().put("inited", "true");
        } else if (this.getPageCache().get("DSFields") != null) {
            List list = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("DSFields"), DSField.class);
            MainEntityType entitytype = e.getOriginalEntityType();
            this.reBuildModelAndGrid(list, entitytype, false);
            e.setNewEntityType(entitytype);
        }
    }

    private void reBuildModelAndGrid(List<DSField> list, MainEntityType mainEntityType, boolean rebuildGrid) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty(KEY_ENTRYENTITY);
        this.setFactorColumnMeta(list, mainEntityType, entry);
        this.drawGrid(list, mainEntityType, rebuildGrid);
    }

    private void drawGrid(List<DSField> refList, MainEntityType mainEntityType, boolean rebuildGrid) {
        Map<String, Object> assCol;
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        cols.add(this.createSeqColumn());
        cols.add(this.createDeptUseColumn());
        if (refList != null) {
            for (DSField ref : refList) {
                Map<String, Object> col = this.createBaseDataColumn(ref);
                cols.add(col);
            }
        }
        if ((assCol = this.createPercentColumn()) != null) {
            cols.add(assCol);
        }
        if (rebuildGrid) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("rk", "rk");
            meta.put("seq", "fseq");
            meta.put("columns", cols);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod(KEY_ENTRYENTITY, "createGridColumns", new Object[]{meta});
        }
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }
}

