/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DisposalConvertPlugin
extends AbstractConvertPlugIn {
    private Map<String, String> propertyMap = new HashMap<String, String>(16);
    private String BUYER = "buyer";
    private String BUYERTYPE = "buyertype";

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        String buyerPosition;
        super.afterGetSourceData(e);
        Map properties = e.getFldProperties();
        if (properties.containsKey(this.BUYER)) {
            buyerPosition = ((DynamicProperty)properties.get(this.BUYER)).getName();
            this.propertyMap.put(this.BUYER, buyerPosition);
        }
        if (properties.containsKey(this.BUYERTYPE)) {
            buyerPosition = ((DynamicProperty)properties.get(this.BUYERTYPE)).getName();
            this.propertyMap.put(this.BUYERTYPE, buyerPosition);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject buyer;
            DynamicObject sourcebill;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List scrData = (List)billDataEntity.getValue("ConvertSource");
            if (scrData.size() <= 0 || (sourcebill = (DynamicObject)scrData.get(0)) == null) continue;
            String buyerPosition = this.propertyMap.get(this.BUYER);
            String buyerTypePosition = this.propertyMap.get(this.BUYERTYPE);
            String buyerType = null;
            Long buyerId = 0L;
            if (StringUtils.isNotEmpty((CharSequence)buyerTypePosition)) {
                buyerType = sourcebill.getString(buyerTypePosition);
            }
            if (StringUtils.isNotEmpty((CharSequence)buyerPosition)) {
                buyerId = sourcebill.getLong(buyerPosition);
            }
            if (!StringUtils.isNotEmpty((CharSequence)buyerType) || buyerId == 0L || (buyer = BusinessDataServiceHelper.loadSingle((Object)buyerId, (String)buyerType)) == null) continue;
            targetBill.set("buyer", (Object)buyer);
            String billname = buyer.getString("name");
            targetBill.set("buyername", (Object)billname);
        }
    }
}

