/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.dao.IBdSystemStatusDao;
import kd.fi.fa.business.dao.IFaAssetBookDao;
import kd.fi.fa.business.dao.factory.BdSystemStatusDaoFactory;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.model.ReconciliationParam;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.FunctionMutexHelper;
import kd.fi.fa.common.batch.BatchOneByOne;
import kd.fi.fa.common.batch.BatchResult;
import kd.fi.fa.common.exception.FaException;
import kd.fi.fa.formplugin.FaFilterList;

public class FaAssetBookListPlugin
extends FaFilterList {
    private static final String ALGO = "kd.fi.fa.formplugin.FaAssetBookListPlugin";
    private static IFaAssetBookDao assetBookDao = FaAssetBookDaoFactory.getInstance();

    public void initialize() {
        super.initialize();
    }

    protected Object[] getSelectedPrimaryKays() {
        Object[] pkArr = FaUtils.getSelectedPks((IFormView)this.getView());
        return pkArr;
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("tblenable".equals(evt.getItemKey()) || "tblunable".equals(evt.getItemKey())) {
            Object[] pks = this.getSelectedPrimaryKays();
            if (pks.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAssetBookListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            if ("tblenable".equals(evt.getItemKey())) {
                this.enableOrUnableBook(pks, FaAssetBookListPlugin::enableByAssetBookObj, ResManager.loadKDString((String)"\u542f\u7528", (String)"FaAssetBookListPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            } else if ("tblunable".equals(evt.getItemKey())) {
                this.enableOrUnableBook(pks, FaAssetBookListPlugin::unableByAssetBookObj, ResManager.loadKDString((String)"\u53cd\u542f\u7528", (String)"FaAssetBookListPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static BatchResult<DynamicObject, Void> closeInitAssetBook(Object[] assetBookPks) {
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"id,org.id org,startperiod.id startperiod,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)assetBookPks)});
        HashMap bookMap = new HashMap();
        HashSet recSuccessBookIds = new HashSet();
        HashSet recfailureBookIds = new HashSet();
        HashMap bookErrMsg = new HashMap();
        if (assetBooks.size() > 0) {
            assetBooks.forEach(assetBook -> {
                long assetbookid = assetBook.getLong("id");
                bookMap.put(assetBook.getLong("id"), assetBook);
                ReconciliationParam parm = new ReconciliationParam();
                parm.setInit(true);
                parm.setAppNumber("fa");
                parm.setOrgId(Long.valueOf(assetBook.getLong("org")));
                parm.setBizBookId(Long.valueOf(assetbookid));
                parm.setPeriodId(Long.valueOf(assetBook.getLong("startperiod")));
                String parmJson = JSONObject.toJSONString((Object)parm);
                try {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{parmJson});
                    recSuccessBookIds.add(assetbookid);
                }
                catch (Exception e) {
                    if (e instanceof KDBizException) {
                        KDBizException kdex = (KDBizException)e;
                        if ("3".equals(kdex.getErrorCode().getCode())) {
                            recSuccessBookIds.add(assetbookid);
                        } else if ("2".equals(kdex.getErrorCode().getCode())) {
                            recfailureBookIds.add(assetbookid);
                            bookErrMsg.put(assetbookid, ResManager.loadKDString((String)"\u4e0e\u603b\u8d26\u521d\u59cb\u5316\u5bf9\u8d26\u4e0d\u5e73\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"FaAssetBookListPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                        } else if ("7".equals(kdex.getErrorCode().getCode())) {
                            recfailureBookIds.add(assetbookid);
                            bookErrMsg.put(assetbookid, kdex.getArgs()[0].toString());
                        } else {
                            recfailureBookIds.add(assetbookid);
                            bookErrMsg.put(assetbookid, kdex.getErrorCode().getMessage());
                        }
                    }
                    recSuccessBookIds.add(assetbookid);
                }
            });
        }
        Object[] assetBookObjs = assetBookDao.query(new QFilter("id", "in", recSuccessBookIds));
        BatchOneByOne batch = new BatchOneByOne(assetBookObjs);
        BatchResult result = batch.execute(v -> FaAssetBookListPlugin.withMutex(v, FaAssetBookListPlugin::enableByAssetBookObj), v -> v.getString("name"));
        for (Long recFailureBookId : recfailureBookIds) {
            FaException ex = new FaException((String)bookErrMsg.get(recFailureBookId));
            result.addFailureInfo(bookMap.get(recFailureBookId), (Exception)ex);
        }
        return result;
    }

    public static BatchResult<DynamicObject, Void> antiCloseInitAssetBook(Object[] assetBookPks) {
        Object[] assetBookObjs = assetBookDao.query(new QFilter("id", "in", (Object)assetBookPks));
        BatchOneByOne batch = new BatchOneByOne(assetBookObjs);
        BatchResult result = batch.execute(v -> FaAssetBookListPlugin.withMutex(v, FaAssetBookListPlugin::unableByAssetBookObj), v -> v.getString("name"));
        return result;
    }

    private void enableOrUnableBook(Object[] selectedPks, Consumer<DynamicObject> action, String actionName) {
        Object[] assetBookObjs = assetBookDao.query(new QFilter("id", "in", (Object)selectedPks));
        BatchOneByOne batch = new BatchOneByOne(assetBookObjs);
        BatchResult result = batch.execute(v -> FaAssetBookListPlugin.withMutex(v, action), v -> v.getString("name"));
        this.handleBatchResult((BatchResult<DynamicObject, Void>)result, actionName);
    }

    private void handleBatchResult(BatchResult<DynamicObject, Void> result, String actionName) {
        if (result.hasFailure()) {
            this.getView().showMessage(result.getMessage(actionName), result.getDetailMessage(v -> v.getString("name")), MessageTypes.Default);
        } else {
            this.getView().showSuccessNotification(result.getMessage(actionName));
        }
        if (result.hasSuccess()) {
            ((IListView)this.getView()).refresh();
        }
    }

    private static void withMutex(DynamicObject assetBookObj, Consumer<DynamicObject> action) {
        FunctionMutexHelper.lockWithBook((String)"fa_assetbook", (DynamicObject)assetBookObj, () -> action.accept(assetBookObj));
    }

    private static void enableByAssetBookObj(DynamicObject assetBookObj) {
        try (TXHandle h = TX.requiresNew();){
            try {
                FaAssetBookListPlugin.doValidator(assetBookObj);
                FaAssetBookListPlugin.switchDynDepre(assetBookObj);
                FaAssetBookListPlugin.setEnable(assetBookObj, BillStatus.C);
                IBdSystemStatusDao systemDao = BdSystemStatusDaoFactory.getInstance();
                systemDao.createByAssetBook(assetBookObj);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static void switchDynDepre(DynamicObject assetBookObj) {
        Object bookId = assetBookObj.get("id");
        Object orgId = assetBookObj.get("org_id");
        Object depreuseId = assetBookObj.get("depreuse_id");
        Date beginDate = assetBookObj.getDate("startperiod.beginDate");
        String sql = "select t1.fid realcardId from t_fa_card_real t1 inner join t_fa_card_fin t2 on t1.fid=t2.frealcardid where t2.forg=? and t2.fdepreuseid=? and t2.fdecval > 0 and t1.fid not in (select frealcardid from t_fa_card_dynamic where fassetbookid=? and fentityname='fa_dyndepre')";
        ArrayList<DynamicObject> dynamicCards = new ArrayList<DynamicObject>();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_card_dynamic");
        try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{orgId, depreuseId, bookId});){
            for (Row row : ds) {
                DynamicObject dynamicCard = new DynamicObject((DynamicObjectType)type);
                dynamicCard.set("realcard", row.get("realcardId"));
                dynamicCard.set("assetbook", bookId);
                dynamicCard.set("depreuse", depreuseId);
                dynamicCard.set("date", (Object)beginDate);
                dynamicCard.set("entityname", (Object)"fa_initAutoSwitch");
                dynamicCard.set("changebillid", bookId);
                dynamicCards.add(dynamicCard);
            }
        }
        if (dynamicCards.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicCards.toArray(new DynamicObject[0]));
        }
    }

    private static void unableByAssetBookObj(DynamicObject assetBookObj) {
        try (TXHandle h = TX.requiresNew();){
            try {
                FaAssetBookListPlugin.doUnableValidator(assetBookObj);
                FaAssetBookListPlugin.delAutoSwitchDynDepre(assetBookObj);
                FaAssetBookListPlugin.setEnable(assetBookObj, BillStatus.B);
                IBdSystemStatusDao systemDao = BdSystemStatusDaoFactory.getInstance();
                systemDao.deleteByAssetBook(assetBookObj);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static void delAutoSwitchDynDepre(DynamicObject assetBookObj) {
        Object bookId = assetBookObj.get("id");
        QFilter[] filters = new QFilter[]{new QFilter("changebillid", "=", bookId), new QFilter("entityname", "=", (Object)"fa_initAutoSwitch")};
        DeleteServiceHelper.delete((String)"fa_card_dynamic", (QFilter[])filters);
    }

    private static void setEnable(DynamicObject assetBook, BillStatus status) {
        Object bookId = assetBook.getPkValue();
        assetBookDao.updateStatus(bookId, status);
        if (status.compareTo((Enum)BillStatus.C) == 0) {
            assetBookDao.updateEnable(bookId, "1");
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("assetbook.id", "=", bookId), new QFilter("totaldepreamount", "=", (Object)0)};
            DeleteServiceHelper.delete((String)"fa_depre_sum", (QFilter[])filters);
            assetBookDao.updateEnable(bookId, "0");
        }
    }

    private static void doValidator(DynamicObject assetBookObj) {
        Optional finCardNames;
        Object status;
        ArrayList<String> errMsgLst = new ArrayList<String>();
        if (assetBookObj.get("startperiod") == null || assetBookObj.get("curperiod") == null) {
            errMsgLst.add(ResManager.loadKDString((String)"\u542f\u7528\u671f\u95f4\u672a\u8bbe\u7f6e\u3002", (String)"FaAssetBookListPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        if ("C".equals(status = assetBookObj.get("status"))) {
            errMsgLst.add(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"FaAssetBookListPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        if ((finCardNames = FaFinCardDaoFactory.getInstance().checkExistInitCardUnAudited(assetBookObj.get("org.id"), assetBookObj.getPkValue())).isPresent()) {
            errMsgLst.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u521d\u59cb\u5316\u5b9e\u7269\u5361\u7247\u672a\u751f\u6210\u201c\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\u201d\u6216\u8005\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\u4e3a\u201c\u6682\u5b58\u201d\u72b6\u6001\uff1a%s\u3002", (String)"FaAssetBookListPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]), finCardNames.get()));
        }
        if (errMsgLst.size() > 0) {
            throw new KDBizException(errMsgLst.stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    private static void doUnableValidator(DynamicObject assetBook) {
        ArrayList<String> errMsgLst = new ArrayList<String>();
        Object status = assetBook.get("status");
        if ("B".equals(status)) {
            errMsgLst.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u672a\u542f\u7528\u3002", (String)"FaAssetBookListPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject enablePeriod = (DynamicObject)assetBook.get("startperiod");
            DynamicObject currentperiod = (DynamicObject)assetBook.get("curperiod");
            if (!enablePeriod.getPkValue().equals(currentperiod.getPkValue())) {
                errMsgLst.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\u4e0d\u7b49\u4e8e\u542f\u7528\u671f\u95f4\u3002", (String)"FaAssetBookListPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        }
        if (errMsgLst.size() > 0) {
            throw new KDBizException(errMsgLst.stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator iterator = commonFilterColumns.iterator();
        while (iterator.hasNext()) {
            if (!"useorg.id".equals(((FilterColumn)iterator.next()).getFieldName())) continue;
            iterator.remove();
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        String orderBy = "ORG";
        List qFilters = e.getQFilters();
        String billFormId = this.getView().getFormShowParameter().getParentFormId();
        if ("gl_accountbook".equals(billFormId)) {
            ListIterator<QFilter> iterator = qFilters.listIterator();
            while (iterator.hasNext()) {
                QFilter next = (QFilter)iterator.next();
                if ("status".equals(next.getProperty())) {
                    iterator.remove();
                    iterator.add(new QFilter("status", "in", (Object)new String[]{"B", "C"}));
                    continue;
                }
                if (!"enable".equals(next.getProperty())) continue;
                next.or(new QFilter("enable", "=", (Object)"0"));
            }
        }
        e.setOrderBy(orderBy);
        this.appendFilter(e);
    }
}

