/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.text.SimpleDateFormat;
import java.util.EventObject;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.model.ReturnDataBean;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ImageUtil;

public class FaAssetDetailMobFormPlugin
extends AbstractMobFormPlugin
implements IBillPlugin {
    private static Log log = LogFactory.getLog(FaAssetDetailMobFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"transfer", "drawback", "repair"});
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        String ctrlName = propertyChangedArgs.getProperty().getName();
        if ("real_card".equals(ctrlName)) {
            this.updateRealCardShowInfo();
        }
    }

    public void afterLoadData(EventObject e) {
        this.updateRealCardShowInfo();
        this.controlToolBarView();
    }

    private void controlToolBarView() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String bizStatus = dataEntity.getString("bizstatus");
        boolean exists = QueryServiceHelper.exists((String)"fa_apply_repair", (QFilter[])new QFilter[]{new QFilter(Fa.dot((String[])new String[]{"entryentity", "realcard", "number"}), "=", (Object)dataEntity.getString("number")), new QFilter("billstatus", "=", (Object)BillStatus.B).or("billstatus", "=", (Object)BillStatus.A)});
        if (BizStatusEnum.TRANSFERING.toString().equals(bizStatus) || BizStatusEnum.DRAWBACKING.toString().equals(bizStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"transfer", "drawback"});
        }
        this.getView().setVisible(Boolean.valueOf(!exists), new String[]{"repair"});
    }

    private void updateRealCardShowInfo() {
        DynamicObject realCard = this.getModel().getDataEntity();
        String str = InteServiceHelper.getDateFormat((Long)ContextUtil.getUserId());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(str);
        DynamicObject user = FaBaseDaoFactory.getInstance((String)"bos_user").queryOne(realCard.getDynamicObject("headuseperson").getPkValue());
        this.getLabel("lab_billno").setText(realCard.getString("billno"));
        this.getLabel("lab_number").setText(realCard.getString("number"));
        this.getLabel("lab_model").setText(realCard.getString("model"));
        this.getLabel("lab_assetcat").setText(realCard.getDynamicObject("assetcat").getString("name"));
        this.getLabel("lab_realaccountdate").setText(simpleDateFormat.format(realCard.getDate("realaccountdate")));
        this.getLabel("lab_headuseperson").setText(user.getString("name"));
        this.getLabel("lab_headusedept").setText(realCard.getDynamicObject("headusedept").getString("name"));
        this.getLabel("lab_storeplace").setText(realCard.getDynamicObject("storeplace").getString("name"));
        this.getLabel("lab_usestatus").setText(realCard.getDynamicObject("usestatus").getString("name"));
        if (realCard.getDate("usedate") != null) {
            this.getLabel("lab_usedate").setText(simpleDateFormat.format(realCard.getDate("usedate")));
        } else {
            this.getLabel("lab_usedate").setText("");
        }
        this.getLabel("lab_assetname").setText(realCard.getString("assetname"));
        log.info("\u4eba\u7269\u5934\u50cf------------" + ImageUtil.getImageTruePath((String)user.getString("picturefield")));
        log.info("\u5361\u7247\u56fe\u7247+++++++++++++" + ImageUtil.getImageTruePath((String)realCard.getString("picturefield")));
        this.getImage("head_img").setUrl(ImageUtil.getImageTruePath((String)user.getString("picturefield")));
        this.getImage("real_card_img").setUrl(ImageUtil.getImageTruePath((String)realCard.getString("picturefield")));
    }

    private Label getLabel(String ctrlName) {
        return (Label)this.getView().getControl(ctrlName);
    }

    private Image getImage(String ctrlName) {
        return (Image)this.getView().getControl(ctrlName);
    }

    public void click(EventObject eventObject) {
        super.click(eventObject);
        Object source = eventObject.getSource();
        DynamicObject realCard = this.getModel().getDataEntity();
        if (source instanceof Control) {
            String key;
            Control clickedControl = (Control)source;
            switch (key = clickedControl.getKey()) {
                case "transfer": {
                    if (!this.checkCardStatus(realCard)) break;
                    this.showAssetTransferApplierForm(realCard, "fa_asset_transfer_mob");
                    break;
                }
                case "drawback": {
                    if (!this.checkCardStatus(realCard)) break;
                    this.showAssetTransferApplierForm(realCard, "fa_asset_drawback_mob");
                    break;
                }
                case "repair": {
                    this.showAssetTransferApplierForm(realCard, "fa_apply_repair_mob");
                    break;
                }
            }
        }
    }

    private boolean checkCardStatus(DynamicObject realCard) {
        DynamicObject newRealCard = BusinessDataServiceHelper.loadSingle((String)"fa_card_real", (String)"id,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", realCard.getPkValue())});
        String status = newRealCard.getString("bizstatus");
        if ("TRANSFERING".equalsIgnoreCase(status) || "DRAWBACKING".equalsIgnoreCase(status)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79fb\u4ea4\u9000\u5e93\u4e2d\u7684\u8d44\u4ea7\u5361\u7247\u4e0d\u80fd\u518d\u64cd\u4f5c\u3002", (String)"FaAssetDetailMobFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showAssetTransferApplierForm(DynamicObject realCard, String formId) {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.setFormId(formId);
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        mobileFormShowParameter.setCustomParam("id", realCard.getPkValue());
        mobileFormShowParameter.setCustomParam("assetunit", realCard.getDynamicObject("assetunit").getPkValue());
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof ReturnDataBean) {
            ReturnDataBean returnDataBean = (ReturnDataBean)returnData;
            if (returnDataBean.getActionCode() == ReturnDataBean.ActionCode.Close) {
                this.getView().close();
            } else if (returnDataBean.getActionCode() == ReturnDataBean.ActionCode.CloseAndUpdate) {
                this.getView().returnDataToParent((Object)new ReturnDataBean(ReturnDataBean.ActionCode.Update));
                this.getView().close();
            }
        }
    }
}

