/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.model.ReturnDataBean;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.business.utils.FaUserUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.ImageUtil;

public class FaAssetTransferMobPlugin
extends AbstractMobBillPlugIn
implements IBillPlugin {
    public static final Log log = LogFactory.getLog(FaAssetTransferMobPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_cancel", "btn_submit", "btn_edit"});
        BasedataEdit receiverDeptF7 = (BasedataEdit)this.getControl("receiver_dpt");
        receiverDeptF7.addBeforeF7SelectListener(evt -> {
            Object realCardPKID = this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject realCardDyo = FaBillDaoFactory.getInstance((String)"fa_card_real").queryOne(realCardPKID);
            DynamicObject cardOrg = realCardDyo.getDynamicObject("org");
            DynamicObject assetUnit = (DynamicObject)this.getModel().getValue("assetorg");
            boolean departSharing = FaAssetUnitAndUseDeptUnits.checkDepartSharing((DynamicObject)cardOrg);
            if (!departSharing) {
                FormShowParameter formShowParameter = evt.getFormShowParameter();
                if (assetUnit != null) {
                    Long assetOrgId = cardOrg.getLong("id");
                    List resultList = FaAssetUnitAndUseDeptUnits.queryEnableDeptByOrg((Long)assetOrgId);
                    formShowParameter.setCustomParam("range", (Object)resultList);
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("sender", (Object)ContextUtil.getUserId());
        this.getModel().setValue("sourcetype", (Object)"1");
        this.createANewRealCardEntry();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject sender = (DynamicObject)this.getModel().getValue("sender");
        if (sender != null) {
            ((Image)this.getView().getControl("img_applier")).setUrl(ImageUtil.getImageTruePath((String)sender.getString("picturefield")));
            this.updateLabelByName("lab_applier_name", sender.getString("name"));
            this.updateLabelByName("lab_telephone", sender.getString("phone"));
        }
    }

    private void createANewRealCardEntry() {
        Object realCardPKID = this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject realCardDyo = FaBillDaoFactory.getInstance((String)"fa_card_real").queryOne(realCardPKID);
        if (realCardDyo != null) {
            String bizStatus = realCardDyo.getString("bizstatus");
            if (!"READY".equalsIgnoreCase(bizStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u4e0d\u662f\u5c31\u7eea\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u79fb\u4ea4\u64cd\u4f5c\u3002", (String)"FaAssetTransferMobPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.getView().close();
                return;
            }
            Object storePlace = realCardDyo.get("storeplace");
            this.getModel().setValue("storeplace", storePlace);
            this.getModel().setValue("assetorg", realCardDyo.get("assetunit"));
        }
        int rowIndex = this.getModel().createNewEntryRow("assettransferentry");
        this.getModel().setValue("realcard", realCardPKID, rowIndex);
        this.getModel().setValue("amount", (Object)1, rowIndex);
    }

    private void updateReceiverInfo() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject receiver = dataEntity.getDynamicObject("receiver");
        DynamicObject receiverDept = dataEntity.getDynamicObject("receiver_dpt");
        DynamicObject adminOrg = FaUserUtils.getAdminOrgByUser((DynamicObject)receiver);
        if (!ObjectUtils.isEmpty((Object)receiver) && ObjectUtils.isEmpty((Object)receiverDept) && receiver != null) {
            model.setValue("receiver_dpt", (Object)adminOrg);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String ctrlName;
        switch (ctrlName = e.getProperty().getName()) {
            case "receiver": {
                log.info("\u7531\u53d8\u66f4\u63a5\u6536\u4eba\u89e6\u53d1\u53d8\u66f4\u63a5\u6536\u4eba\u7684\u6240\u5728\u516c\u53f8\u53ca\u90e8\u95e8\uff0c\u5f00\u59cb");
                this.updateReceiverInfo();
            }
        }
    }

    private Label getLabelById(String id) {
        Label result = (Label)this.getView().getControl(id);
        return result;
    }

    private void updateLabelByName(String labId, String value) {
        this.getLabelById(labId).setText(value);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button) {
            Button button = (Button)source;
            switch (button.getKey()) {
                case "btn_edit": {
                    this.showEditTelephoneForm();
                }
            }
        }
    }

    private void showEditTelephoneForm() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        MobileBillShowParameter mobileBillShowParameter = new MobileBillShowParameter();
        mobileBillShowParameter.setFormId("fa_transfer_edit_mob");
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileBillShowParameter.setCustomParam("fld_applier", (Object)ContextUtil.getUserId());
        mobileBillShowParameter.setCustomParam("fld_telephone", dataEntity.get("appliertelephone"));
        mobileBillShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fa_asset_transfer_mob"));
        this.getView().showForm((FormShowParameter)mobileBillShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String billStatus = this.getModel().getDataEntity().getString("billstatus");
            String operateKey = afterDoOperationEventArgs.getOperateKey();
            if ("submit".equals(operateKey) && BillStatus.B.toString().equals(billStatus)) {
                ReturnDataBean returnDataBean = new ReturnDataBean(ReturnDataBean.ActionCode.CloseAndUpdate);
                this.getView().returnDataToParent((Object)returnDataBean);
                this.getView().close();
            }
        }
    }
}

