/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.ImageUtil;
import kd.fi.fa.utils.FaAddHeadPicture;
import kd.fi.fa.utils.FaF7DeptUtils;

public class FaAssetTransferPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit realcard = (BasedataEdit)this.getControl("realcard");
        realcard.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            QFilter quser = new QFilter("headuseperson", "=", (Object)ContextUtil.getUserId());
            filters.add(quser);
            DynamicObject assetOrg = (DynamicObject)this.getModel().getValue("assetorg");
            if (assetOrg != null) {
                QFilter qAssetOrg = new QFilter("assetunit", "=", assetOrg.getPkValue());
                filters.add(qAssetOrg);
            }
            filters.add(new QFilter("sourceflag", "!=", (Object)SourceFlagEnum.DATAASSET.name()));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("assettransferentry");
            Set cardIdSet = entryEntity.stream().map(v -> v.get("realcard.id")).filter(v -> v != null).collect(Collectors.toSet());
            ((QFilter)filters.get(0)).and(new QFilter("id", "not in", cardIdSet));
        });
        BasedataEdit outAssetUnit = (BasedataEdit)this.getControl("receiver");
        outAssetUnit.addBeforeF7SelectListener(this::beforeOutAssetUnitF7Select);
        BasedataEdit receiverDeptF7 = (BasedataEdit)this.getControl("receiver_dpt");
        receiverDeptF7.addBeforeF7SelectListener(evt -> {
            DynamicObject realCardDyo;
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String realcardId = (String)showParameter.getCustomParam("realcardid");
            if (!StringUtils.isEmpty((String)realcardId)) {
                realCardDyo = FaBillDaoFactory.getInstance((String)"fa_card_real").queryOne((Object)realcardId);
            } else {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("assettransferentry");
                if (entryEntity.size() == 0) {
                    return;
                }
                realCardDyo = ((DynamicObject)entryEntity.get(0)).getDynamicObject("realcard");
                if (null == realCardDyo) {
                    return;
                }
            }
            DynamicObject cardOrg = realCardDyo.getDynamicObject("org");
            DynamicObject assetUnit = (DynamicObject)this.getModel().getValue("assetorg");
            FaF7DeptUtils.beforeDeptSelect(evt, cardOrg, assetUnit);
        });
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String realcardId = (String)showParameter.getCustomParam("realcardid");
        String assetunitId = (String)showParameter.getCustomParam("assetunitid");
        String storeplaceid = (String)showParameter.getCustomParam("storeplaceid");
        String cardStatus = (String)showParameter.getCustomParam("cardstatus");
        if (!"READY".equalsIgnoreCase(cardStatus)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u4e0d\u662f\u5c31\u7eea\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u79fb\u4ea4\u64cd\u4f5c\u3002", (String)"FaAssetTransferPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.getModel().setDataChanged(false);
            this.getView().close();
            return;
        }
        Long userId = ContextUtil.getUserId();
        this.getModel().setValue("sender", (Object)userId);
        DynamicObject sender = (DynamicObject)this.getModel().getValue("sender");
        String pictureField = sender.getString("picturefield");
        String imageFullUrl = ImageUtil.getImageTruePath((String)pictureField);
        Image userImage = (Image)this.getControl("picturefield");
        userImage.setUrl(imageFullUrl);
        Map<String, Object> dpt = FaAddHeadPicture.getDptNameByUserId(userId);
        if ((Long)dpt.get("dpt") == 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u90e8\u95e8\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d44\u4ea7\u79fb\u4ea4\u3002", (String)"FaAssetTransferPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        this.getModel().setValue("dptnames", dpt.get("dpt"));
        Map depParent = OrgUnitServiceHelper.getCompanyfromOrg((Object)dpt.get("dpt"));
        if (depParent == null || depParent.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u516c\u53f8\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d44\u4ea7\u79fb\u4ea4\u3002", (String)"FaAssetTransferPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        this.getModel().setValue("org", depParent.get("id"));
        this.getModel().setValue("assetorg", (Object)assetunitId);
        this.getModel().setValue("storeplace", (Object)storeplaceid);
        DynamicObject receiver = (DynamicObject)this.getModel().getValue("receiver");
        if (receiver != null) {
            Map<String, Object> receiver_dpt = FaAddHeadPicture.getDptNameByUserId((Long)receiver.getPkValue());
            this.getModel().setValue("receiver_dpt", receiver_dpt.get("dpt"));
        }
        this.initEntity(realcardId);
    }

    private void initEntity(String realcardId) {
        if (StringUtils.isNotEmpty((String)realcardId)) {
            IDataModel dataModel = this.getModel();
            dataModel.batchCreateNewEntryRow("assettransferentry", 1);
            DynamicObject realCardDyo = FaBillDaoFactory.getInstance((String)"fa_card_real").queryOne((Object)realcardId);
            Object useDept = realCardDyo.get("headusedept");
            dataModel.setValue("realcard", (Object)realcardId, 0);
            dataModel.setValue("usedept", useDept, 0);
            dataModel.setValue("amount", (Object)realCardDyo.getBigDecimal("assetamount"), 0);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "receiver": {
                DynamicObject receiver;
                if (ObjectUtils.isEmpty((Object)this.getModel().getValue("receiver")) || !ObjectUtils.isEmpty((Object)this.getModel().getValue("receiver_dpt")) || (receiver = (DynamicObject)this.getModel().getValue("receiver")) == null) break;
                Map<String, Object> dpt = FaAddHeadPicture.getDptNameByUserId((Long)receiver.getPkValue());
                this.getModel().setValue("receiver_dpt", dpt.get("dpt"));
                break;
            }
            case "realcard": {
                ChangeData changeData = e.getChangeSet()[0];
                int rowIndex = changeData.getRowIndex();
                DynamicObject realCard = (DynamicObject)this.getModel().getValue("realcard");
                if (null != realCard) {
                    DynamicObject headusedept = realCard.getDynamicObject("headusedept");
                    this.getModel().setValue("usedept", (Object)headusedept, rowIndex);
                    this.getModel().setValue("amount", (Object)realCard.getBigDecimal("assetamount"), rowIndex);
                    break;
                }
                this.getModel().setValue("usedept", null);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject sender = (DynamicObject)this.getModel().getValue("sender");
        String pictureField = sender.getString("picturefield");
        String imageFullUrl = ImageUtil.getImageTruePath((String)pictureField);
        Image userImage = (Image)this.getControl("picturefield");
        userImage.setUrl(imageFullUrl);
        Map<String, Object> dpt = FaAddHeadPicture.getDptNameByUserId((Long)sender.getPkValue());
        this.getModel().setValue("dptnames", dpt.get("dpt"));
        this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amount"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().getModel().setDataChanged(false);
        IFormView view = this.getView();
        DynamicObject bill = view.getModel().getDataEntity();
        if (bill.getString("billstatus").equals(BillStatus.D.toString())) {
            view.setVisible(Boolean.FALSE, new String[]{"sava"});
            view.setVisible(Boolean.FALSE, new String[]{"submit"});
        }
    }

    public void beforeOutAssetUnitF7Select(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        List qFilters = param.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("id", "not in", ((DynamicObject)model.getValue("sender")).getPkValue()));
    }
}

