/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.coderule.CodeRuleService;
import kd.fi.fa.common.util.Fa;

public abstract class FaBillBaseFormPlugin
extends AbstractFormPlugin
implements IBillPlugin {
    public void afterCreateNewData(EventObject eventobject) {
        super.afterCreateNewData(eventobject);
        IDataModel model = this.getModel();
        this.setAssetUnit(model);
        this.checkCodeRule(this.getModel());
    }

    private void setAssetUnit(IDataModel model) {
        DynamicObject assetUnit;
        if (this.checkHasField(model, "assetunit").booleanValue() && (assetUnit = (DynamicObject)model.getValue("assetunit")) == null) {
            model.setValue("assetunit", model.getValue("org"));
        }
    }

    private Boolean checkHasField(IDataModel model, String fieldName) {
        Boolean result = false;
        Map fields = model.getDataEntityType().getFields();
        result = fields.containsKey("assetunit");
        return result;
    }

    protected void importCheckCodeRule(String entityType, InitImportDataEventArgs e, String orgKey) {
        HashSet<String> orgNumSet = new HashSet<String>(10);
        List dataList = e.getSourceDataList();
        for (Map dataMap : dataList) {
            Map assetunit = (Map)dataMap.get(orgKey);
            String orgNumber = (String)assetunit.get("number");
            orgNumSet.add(orgNumber);
        }
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", orgNumSet), new QFilter("status", "=", (Object)BillStatus.C)};
        String resultMapFields = Fa.comma((String[])new String[]{"id", "name", "number"});
        DynamicObjectCollection orgColl = QueryServiceHelper.query((String)"bos_org", (String)resultMapFields, (QFilter[])filters);
        Set queryOrgNumber = orgColl.stream().map(v -> v.getString("number")).collect(Collectors.toSet());
        HashSet<String> hasColeRuleOrg = new HashSet<String>(10);
        for (DynamicObject orgObj : orgColl) {
            DynamicObject entity = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityType));
            boolean hasRule = this.hasCodeRule(entity, orgObj.getString("id"));
            if (!hasRule) continue;
            hasColeRuleOrg.add(orgObj.getString("number"));
        }
        int index = -1;
        for (Map dataMap : dataList) {
            ++index;
            Map assetunit = (Map)dataMap.get(orgKey);
            String orgNumber = (String)assetunit.get("number");
            if (queryOrgNumber.contains(orgNumber)) {
                if (hasColeRuleOrg.contains(orgNumber)) continue;
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7f16\u7801\u89c4\u5219\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"FaBillBaseFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                continue;
            }
            e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"FaBillBaseFormPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), orgNumber));
        }
    }

    protected boolean hasCodeRule(DynamicObject entity, String orgId) {
        return CodeRuleService.getInstance((DynamicObject)entity, (String)orgId).isExistRule();
    }

    private void checkCodeRule(IDataModel dataModel) {
        String mainOrgId;
        String mainOrg = this.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrg) && StringUtils.isNotBlank((CharSequence)(mainOrgId = this.getMainOrgId(mainOrg)))) {
            DynamicObject obj = dataModel.getDataEntity();
            if (!CodeRuleService.getInstance((DynamicObject)obj, (String)mainOrgId).isExistRule()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5355\u636e\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0b\u6709\u53ef\u7528\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"FaBillBaseFormPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("noAutoNumber", (IFormPlugin)this));
                return;
            }
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        this.getView().close();
    }

    private String getMainOrg() {
        return this.getModel().getDataEntityType().getMainOrg();
    }

    private String getMainOrgId(String mainOrg) {
        DynamicObject obj = this.getModel().getDataEntity();
        String orgId = null;
        Object orgObj = obj.get(mainOrg);
        if (orgObj == null) {
            return orgId;
        }
        if (orgObj instanceof DynamicObject) {
            orgId = String.valueOf(((DynamicObject)orgObj).getPkValue());
        } else if (orgObj instanceof Long) {
            orgId = String.valueOf(orgObj);
        }
        return orgId;
    }

    public int removeOldRows(String entryName, String fieldName, Set<String> values, Boolean initFalg) {
        int result = 0;
        if (values == null || values.size() == 0) {
            return result;
        }
        IDataModel model = this.getModel();
        int rowcount = model.getEntryRowCount(entryName);
        for (int i = 0; i < rowcount; ++i) {
            Object pk = this.getPK(fieldName, i);
            if (pk != null && !values.contains(pk.toString())) continue;
            if (initFalg.booleanValue()) {
                model.beginInit();
                model.deleteEntryRow(entryName, i);
                model.endInit();
            } else {
                model.deleteEntryRow(entryName, i);
            }
            --i;
            --rowcount;
            ++result;
        }
        this.getView().updateView(entryName);
        return result;
    }

    public Object getPK(String fieldName, int index) {
        IDataModel model = this.getModel();
        Object pk = null;
        Object value = model.getValue(fieldName, index);
        if (value instanceof DynamicObject) {
            pk = ((DynamicObject)value).getPkValue();
        } else if (value instanceof Long) {
            pk = value;
        }
        return pk;
    }

    public Object[] getRealCardByBill(DynamicObject dataEntity, String entryName, String cardName) {
        DynamicObjectCollection entryDys = dataEntity.getDynamicObjectCollection(entryName);
        HashSet<Object> pkSet = new HashSet<Object>();
        for (DynamicObject entryDy : entryDys) {
            DynamicObject realDy = entryDy.getDynamicObject(cardName);
            if (realDy == null) continue;
            pkSet.add(realDy.getPkValue());
        }
        return pkSet.toArray(new Object[0]);
    }
}

