/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.formplugin.DSField;

public class FaCardRealBatchAddPlugin
extends AbstractFormPlugin {
    private static final String FA_REALCARD_BATCH = "fa_card_real_batch_layout";
    private static final String TABAP = "tabap";
    private static final String REALCARD_PAGEID = "realcard_pageid";
    private static final String BATCHADDROW = "batchaddrow";
    private static final String TAB_CANCEL = "tab_cancel";
    private static final String TAB_PRE = "tab_pre";
    private static final String TAB_NEXT = "tab_next";
    private static final String TAB_BATCHADD = "tab_batchadd";
    private static final List<String> BLACKLIST = new ArrayList<String>(16);
    private static final String OTHERINFO = "otherinfo";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap1"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideButton();
        this.loadCardInfo();
        this.initComboEdit();
        this.initVisible();
        List<DSField> staDsFields = new ArrayList<DSField>(16);
        if (this.getPageCache().get("dsFields") != null) {
            staDsFields = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("dsFields"), DSField.class);
        }
        if (staDsFields.size() > 0) {
            this.buildEntry(staDsFields);
        }
    }

    private void hideButton() {
        this.getView().setVisible(Boolean.FALSE, new String[]{TAB_PRE, TAB_BATCHADD});
    }

    private void initComboEdit() {
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl("fieldlist");
        Map allFields = ((EntityType)EntityMetadataCache.getDataEntityType((String)"fa_card_real").getAllEntities().get("fa_card_real")).getFields();
        ArrayList<ComboItem> datalist = new ArrayList<ComboItem>(16);
        for (IDataEntityProperty value : allFields.values()) {
            if (!(value instanceof TextProp) || BLACKLIST.contains(value.getName())) continue;
            datalist.add(new ComboItem(value.getDisplayName(), value.getName()));
        }
        mulComboEdit.setComboItems(datalist);
        this.parseDsFields(datalist);
    }

    private void parseDsFields(List<ComboItem> datalist) {
        int i = 0;
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("barcode");
        list.add("remark");
        ArrayList<DSField> dsFields = new ArrayList<DSField>(datalist.size());
        for (ComboItem comboItem : datalist) {
            DSField dsField = new DSField();
            dsField.setEntityId(comboItem.getValue());
            dsField.setFieldKey("textfield" + i);
            if (list.contains(comboItem.getValue())) {
                dsField.setFieldKey(comboItem.getValue());
            }
            dsField.setFieldName(comboItem.getCaption());
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
            TextProp prop = (TextProp)mainEntityType.findProperty(comboItem.getValue());
            dsField.setMaxLenth(prop.getMaxLenth());
            dsFields.add(dsField);
            ++i;
        }
        this.getPageCache().put("dsFields", SerializationUtils.toJsonString(dsFields));
    }

    private void buildEntry(List<DSField> dsFields) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(OTHERINFO);
        if (dsFields == null) {
            return;
        }
        for (DSField dsField : dsFields) {
            entryGrid.setColumnProperty(dsField.getFieldKey(), "header", (Object)dsField.getFieldName());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        Tab tab = (Tab)this.getView().getControl(TABAP);
        switch (key) {
            case "tab_next": {
                boolean checkResult;
                String realCardPageId = this.getPageCache().get(REALCARD_PAGEID);
                IFormView realCardView = this.getView().getView(realCardPageId);
                IDataModel realCardModel = realCardView.getModel();
                Object headUseDept = realCardModel.getValue("headusedept");
                Object assetUnit = realCardModel.getValue("assetunit");
                Object org = realCardModel.getValue("org");
                if (headUseDept != null && assetUnit != null && !(checkResult = FaAssetUnitAndUseDeptUnits.checkUseDeptByAssetUnit((DynamicObject)((DynamicObject)org), (DynamicObject)((DynamicObject)assetUnit), (Long)((DynamicObject)headUseDept).getLong("id")))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f7f\u7528\u90e8\u95e8\u4e0d\u5728\u5f53\u524d\u8d44\u4ea7\u7ec4\u7ec7\u7684\u53ef\u7528\u8303\u56f4\u4e4b\u5185\u3002", (String)"FaCardRealBatchAddPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    return;
                }
                tab.activeTab("tabpageap1");
                this.getView().setVisible(Boolean.TRUE, new String[]{TAB_PRE, TAB_BATCHADD});
                this.getView().setVisible(Boolean.FALSE, new String[]{TAB_NEXT, TAB_CANCEL});
                break;
            }
            case "tab_pre": {
                tab.activeTab("tabpageap");
                this.getView().setVisible(Boolean.TRUE, new String[]{TAB_NEXT, TAB_CANCEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{TAB_PRE, TAB_BATCHADD});
                break;
            }
            case "tab_batchadd": {
                this.buildCard();
                break;
            }
            case "batchaddrow": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("fa_card_real_batchaddrow");
                parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), BATCHADDROW));
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("fieldlist".equals(key)) {
            this.changeField(changeData);
        }
    }

    private void changeField(ChangeData changeData) {
        String fields = (String)changeData.getNewValue();
        fields = fields == null ? "" : fields;
        List<String> showFields = this.removeBlankItem(fields);
        this.setVisiableFields(showFields);
    }

    private List<String> removeBlankItem(String splitfields) {
        String[] fieldArr = splitfields.trim().split(",");
        ArrayList<String> fieldList = new ArrayList<String>(Arrays.asList(fieldArr));
        List<String> resultList = fieldList.stream().filter(str -> !StringUtils.isEmpty((String)str)).collect(Collectors.toList());
        return resultList;
    }

    private void setVisiableFields(List<String> showFields) {
        this.initVisible();
        ArrayList<String> textNames = new ArrayList<String>(16);
        List staDsFields = new ArrayList(16);
        if (this.getPageCache().get("dsFields") != null) {
            staDsFields = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("dsFields"), DSField.class);
        }
        for (String showField : showFields) {
            for (DSField staDsField : staDsFields) {
                if (!staDsField.getEntityId().equals(showField)) continue;
                textNames.add(staDsField.getFieldKey());
            }
        }
        this.getView().setVisible(Boolean.TRUE, textNames.toArray(new String[0]));
    }

    private void buildCard() {
        List assetUnits;
        IDataModel model = this.getModel();
        String realcardPageId = this.getPageCache().get(REALCARD_PAGEID);
        IFormView realcardView = this.getView().getView(realcardPageId);
        IDataModel realcardModel = realcardView.getModel();
        DynamicObjectCollection entry = model.getEntryEntity(OTHERINFO);
        if (entry.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u5206\u5f55\u3002", (String)"FaCardRealBatchAddPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> realCards = new ArrayList<DynamicObject>(entry.size());
        DynamicObject realCard = realcardModel.getDataEntity(true);
        DynamicObject assetunit = realCard.getDynamicObject("assetunit");
        long assetunitId = 0L;
        if (null != assetunit) {
            assetunitId = assetunit.getLong("id");
        }
        if ((assetUnits = FaPermissionUtils.getAllPermissionAssetUnitsV2((String)this.getView().getPageId(), (String)"fa_card_real", (String)"47156aff000000ac")).size() == 0 || !assetUnits.contains(assetunitId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u7ec4\u7ec7\u5b9e\u7269\u5361\u7247\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaCardRealBatchAddPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        Object fieldList = model.getValue("fieldlist");
        String fieldsStr = fieldList == null ? "" : fieldList.toString();
        List<String> showFields = this.removeBlankItem(fieldsStr);
        List staDsFields = new ArrayList(16);
        if (this.getPageCache().get("dsFields") != null) {
            staDsFields = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("dsFields"), DSField.class);
        }
        Map<String, String> nameMap = staDsFields.stream().collect(Collectors.toMap(DSField::getEntityId, DSField::getFieldKey));
        for (DynamicObject dynamicObject : entry) {
            DynamicObject realCardCopy = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)realCard);
            for (String field : showFields) {
                Object infoField = "";
                if (nameMap.get(field) == null) continue;
                infoField = nameMap.get(field);
                realCardCopy.set(field, dynamicObject.get((String)infoField));
            }
            realCards.add(realCardCopy);
        }
        try (TXHandle h = TX.required();){
            try {
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_card_real", (DynamicObject[])realCards.toArray(new DynamicObject[0]), null);
                if (!result.isSuccess()) {
                    List allError = result.getAllErrorOrValidateInfo();
                    StringBuilder errorInfo = new StringBuilder();
                    if (!CollectionUtils.isEmpty((Collection)allError)) {
                        for (IOperateInfo info : allError) {
                            errorInfo.append(info.getMessage());
                        }
                    }
                    String msg = new LocaleString(String.format("%s%s-%s", ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u4fdd\u5b58\u5931\u8d25", (String)"FaCardRealBatchAddPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), result.getMessage(), errorInfo.toString())).toString();
                    throw new KDBizException(msg);
                }
                HashMap<String, List> returnData = new HashMap<String, List>();
                returnData.put("successIds", result.getSuccessPkIds());
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
            catch (Exception exception) {
                h.markRollback();
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private void loadCardInfo() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(FA_REALCARD_BATCH);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("realcard");
        parameter.setPkId(this.getView().getFormShowParameter().getCustomParam("realcardId"));
        parameter.setCustomParam("updateview", (Object)"true");
        this.getView().showForm((FormShowParameter)parameter);
        this.getPageCache().put(REALCARD_PAGEID, parameter.getPageId());
    }

    private String[] splitString(String str) {
        return str.split("\\n");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if (BATCHADDROW.equals(key) && (returnData = (Map)evt.getReturnData()) != null && returnData.get("quantity") != null) {
            int quantity = (Integer)returnData.get("quantity");
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(OTHERINFO, quantity);
        }
    }

    private void initVisible() {
        IDataModel model = this.getModel();
        MainEntityType entityType = model.getDataEntityType();
        Set fields = ((EntityType)entityType.getAllEntities().get(OTHERINFO)).getFields().keySet();
        String[] fieldsStr = fields.toArray(new String[0]);
        this.getView().setVisible(Boolean.FALSE, fieldsStr);
    }

    static {
        BLACKLIST.add("billno");
        BLACKLIST.add("assetcat");
        BLACKLIST.add("number");
        BLACKLIST.add("srcbillnumber");
        BLACKLIST.add("model");
        BLACKLIST.add("barcoderuleexist");
        BLACKLIST.add("numberruleexist");
        BLACKLIST.add("billnocoderuleexist");
        BLACKLIST.add("assetname");
        BLACKLIST.add("srcbillentityname");
        BLACKLIST.add("numberrecovery");
        BLACKLIST.add("billnorecovery");
        BLACKLIST.add("barcoderecovery");
    }
}

