/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.utils.FaF7CostCenterUtils;
import kd.fi.fa.utils.FaF7DeptUtils;
import kd.fi.fa.utils.FaQFilter;

public class FaChangeApplyEditPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(FaChangeApplyEditPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OrgEdit orgEdit = (OrgEdit)this.getControl("org");
        orgEdit.setIsOnlyDisplayOrgLeaves(true);
        orgEdit.addBeforeF7SelectListener(this::beforeOrgSelect);
        BasedataEdit afterUserDept = (BasedataEdit)this.getControl("aft_headusedept");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        afterUserDept.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("main_changebillentry");
            DynamicObject selectRow = (DynamicObject)entryEntity.get(evt.getRow());
            DynamicObject assetUnit = selectRow.getDynamicObject("realcard").getDynamicObject("assetunit");
            FaF7DeptUtils.beforeDeptSelect(evt, org, assetUnit);
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
        });
        BasedataEdit inUser = (BasedataEdit)this.getControl("aft_headuseperson");
        FaF7DeptUtils.setBaseDataSingleSelect(inUser);
        BasedataEdit inCostCenter = (BasedataEdit)this.getControl("aft_costcentrer");
        inCostCenter.addBeforeF7SelectListener(evt -> FaF7CostCenterUtils.beforeCostCenterSelect(evt, org));
        this.addItemClickListeners(new String[]{"main_change_toolbarap"});
        OrgEdit applyDept = (OrgEdit)this.getControl("applydept");
        applyDept.addBeforeF7SelectListener(evt -> {
            List deptIds = UserServiceHelper.getOrgsUserJoin((long)UserServiceHelper.getCurrentUserId());
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
            qFilters.add(new QFilter("id", "in", (Object)deptIds));
            evt.setCustomQFilters(qFilters);
        });
        BasedataEdit changeType = (BasedataEdit)this.getControl("changetype");
        changeType.addBeforeF7SelectListener(evt -> evt.setCustomQFilters(this.getChangeTypeFilters()));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"id");
        this.getModel().setValue("appliantid", (Object)currentUser.getLong("id"));
        this.getModel().setValue("applydept", (Object)UserServiceHelper.getUserMainOrgId((long)currentUser.getLong("id")));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeFieldInit();
        DynamicObjectCollection changeItemMaps = QueryServiceHelper.query((String)"fa_change_map", (String)"id,leasechgitem,cardchgitem", (QFilter[])new QFilter[0]);
        Set cardChangeMapItems = changeItemMaps.stream().map(t -> t.get("cardchgitem")).collect(Collectors.toSet());
        Long realAccountDataChangeItemId = this.getRealAccountDataChangeItemId();
        cardChangeMapItems.add(realAccountDataChangeItemId);
        String cacheString = SerializationUtils.serializeToBase64(cardChangeMapItems);
        this.getPageCache().put("change_map_cache", cacheString);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        if (org != null) {
            orgIdList.add(org.getLong("id"));
        }
        Map changeEmptyParam = SystemParamHelper.getChangeEmptyParam(orgIdList);
        boolean changeNo = org != null && (Boolean)changeEmptyParam.get(org.getLong("id")) != false;
        this.getPageCache().put("changeNo", String.valueOf(changeNo));
        EntryGrid entryGrid = (EntryGrid)this.getControl("main_changebillentry");
        FaChangeBillUtil.setEntryCellStyleChange((boolean)changeNo, (boolean)true, (IDataModel)this.getModel(), (EntryGrid)entryGrid, (String)"changeitem", (String)"main_changebillentry", (String)"", null, null);
        DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("main_changebillentry");
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)entry.get(i);
            BigDecimal befAssetAmount = entryRow.getBigDecimal("bef_assetamount");
            BigDecimal aftAssetAmount = entryRow.getBigDecimal("aft_assetamount");
            if (aftAssetAmount == null || befAssetAmount.compareTo(aftAssetAmount) != 0) continue;
            this.getModel().setValue("aft_assetamount", null, i);
            this.getModel().setDataChanged(false);
        }
    }

    private Long getRealAccountDataChangeItemId() {
        DynamicObject changeItem = QueryServiceHelper.queryOne((String)"fa_change_item", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"realaccountdate"), new QFilter("topic", "=", (Object)"fa_card_real")});
        return changeItem.getLong("id");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object org;
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if ("changetype".equals(name)) {
            this.getModel().deleteEntryData("main_changebillentry");
            this.setChangeItems();
            this.changeFieldInit();
        } else if ("aft_headuseperson".equals(name)) {
            ChangeData[] changeData;
            for (ChangeData data : changeData = e.getChangeSet()) {
                DynamicObject assetOrgId;
                DynamicObject aftUsePerson = (DynamicObject)data.getNewValue();
                if (aftUsePerson == null) continue;
                Long dpt_id = UserServiceHelper.getUserMainOrgId((long)aftUsePerson.getLong("id"));
                DynamicObject orgId = (DynamicObject)this.getModel().getValue("org");
                if (!FaAssetUnitAndUseDeptUnits.checkUseDeptByAssetUnit((DynamicObject)orgId, (DynamicObject)(assetOrgId = ((DynamicObject)this.getModel().getValue("realcard")).getDynamicObject("assetunit")), (Long)dpt_id)) continue;
                this.getModel().setValue("aft_headusedept", (Object)dpt_id, data.getRowIndex());
            }
        } else if ("org".equals(name) && (org = e.getChangeSet()[0].getNewValue()) == null) {
            this.getModel().deleteEntryData("main_changebillentry");
        }
        if (StringUtils.isNotEmpty((CharSequence)name) && name.startsWith("aft_")) {
            String changeNo = this.getPageCache().get("changeNo");
            List changeDataEntities = Arrays.stream(e.getChangeSet()).map(RowDataEntity::getDataEntity).collect(Collectors.toList());
            EntryGrid entryGrid = (EntryGrid)this.getControl("main_changebillentry");
            FaChangeBillUtil.setEntryCellStyleChange((boolean)Boolean.parseBoolean(changeNo), (boolean)false, (IDataModel)this.getModel(), (EntryGrid)entryGrid, (String)"changeitem", (String)"main_changebillentry", (String)"", changeDataEntities, (String)name);
        }
    }

    private void changeFieldInit() {
        List<String> fields = this.getChangedFields();
        for (String field : fields) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{field});
        }
        DynamicObjectCollection changeItems = (DynamicObjectCollection)this.getModel().getValue("changeitem");
        for (DynamicObject changeItem : changeItems) {
            DynamicObject basedata = changeItem.getDynamicObject("fbasedataid");
            String fieldName = basedata.getString("number");
            String fieldKey = basedata.getString("changeapplykey");
            if (fieldKey != null && !fieldKey.isEmpty() && !fieldKey.equals(" ")) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bef_" + fieldKey, "aft_" + fieldKey});
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bef_" + fieldName, "aft_" + fieldName});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals("main_add_row")) {
            DynamicObject changeType = (DynamicObject)this.getModel().getValue("changetype");
            if (changeType == null) {
                String errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d8\u66f4\u7c7b\u578b\u3002", (String)"FaChangeApplyPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errMsg);
            } else {
                this.showRealCard();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String type = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        List<String> doOperateType = Collections.singletonList("close");
        if (!doOperateType.contains(type) && this.getModel().getDataEntity().getLong("id") != 0L) {
            String changeNo = this.getPageCache().get("changeNo");
            EntryGrid entryGrid = (EntryGrid)this.getControl("main_changebillentry");
            FaChangeBillUtil.setEntryCellStyleChange((boolean)Boolean.parseBoolean(changeNo), (boolean)true, (IDataModel)this.getModel(), (EntryGrid)entryGrid, (String)"changeitem", (String)"main_changebillentry", (String)"", null, null);
            this.getView().updateView("main_changebillentry");
        }
        this.getView().updateView();
    }

    private void beforeOrgSelect(BeforeF7SelectEvent evt) {
        List orgs = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_change_dept", (String)"47156aff000000ac");
        QFilter qFilter = new QFilter("id", "in", (Object)orgs);
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        DynamicObject assetOrg = (DynamicObject)this.getModel().getValue("assetorg");
        if (assetOrg != null) {
            List fromOrgList = OrgUnitServiceHelper.getFromOrgs((String)"09", (Long)assetOrg.getLong("id"), (String)"10", (boolean)true);
            filters.add(new QFilter("id", "in", (Object)fromOrgList));
            filters.add(qFilter);
        } else {
            filters.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        }
    }

    private void showRealCard() {
        ListShowParameter param = ShowFormHelper.createShowListForm((String)"fa_card_real_base", (boolean)true);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "realcard"));
        param.setHasRight(true);
        param.setListFilterParameter(new ListFilterParameter(this.getSelectFilter(), null));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("fa_realcard_listf7");
        this.getView().showForm((FormShowParameter)param);
    }

    private List<QFilter> getSelectFilter() {
        IDataModel model = this.getModel();
        ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>();
        HashSet<Object> realCardIds = new HashSet<Object>();
        Set<Object> mRealCardIds = this.getReadCardIDByEntity("main_changebillentry", null);
        realCardIds.addAll(mRealCardIds);
        if (realCardIds.size() > 0) {
            rangeFilterList.add(new QFilter("id", "not in", realCardIds));
        }
        long orgId = (Long)model.getValue("org_id");
        rangeFilterList.add(new QFilter("org", "=", (Object)orgId));
        FaQFilter.realCardF7CommonFilter(rangeFilterList, orgId, "fa_change_dept");
        String changeMapStr = this.getPageCache().get("change_map_cache");
        Set cardChangeMapItems = (Set)SerializationUtils.deSerializeFromBase64((String)changeMapStr);
        Set<Object> changeItems = this.getChangeItems();
        if (CollectionUtils.containsAny(changeItems, (Collection)cardChangeMapItems)) {
            rangeFilterList.add(new QFilter("sourceflag", "not in", (Object)new String[]{"LEASECONTRACT", "INITLEASECONTRACT"}));
        }
        return rangeFilterList;
    }

    private Set<Object> getChangeItems() {
        DynamicObjectCollection changeItems = (DynamicObjectCollection)this.getModel().getValue("changeitem");
        HashSet<Object> selectItems = new HashSet<Object>();
        for (DynamicObject dataBody : changeItems) {
            DynamicObject item = dataBody.getDynamicObject("fbasedataid");
            selectItems.add(item.getPkValue());
        }
        return selectItems;
    }

    Set<Object> getReadCardIDByEntity(String entityName, Map<String, Long> number2RealIdMap) {
        IDataModel model = this.getModel();
        HashSet<Object> realCardIds = new HashSet<Object>();
        int rowcount = model.getEntryRowCount(entityName);
        for (int i = 0; i < rowcount; ++i) {
            DynamicObject realCard = (DynamicObject)model.getValue("realcard", i);
            if (realCard == null) continue;
            realCardIds.add(realCard.getPkValue());
            if (number2RealIdMap == null) continue;
            number2RealIdMap.put(realCard.getString("number"), realCard.getLong("id"));
        }
        return realCardIds;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if ("realcard".equals(evt.getActionId()) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection returnDataList = (ListSelectedRowCollection)returnData;
            DynamicObjectCollection changeItems = (DynamicObjectCollection)this.getModel().getValue("changeitem");
            HashMap<String, String> assignFieldsMap = new HashMap<String, String>(changeItems.size());
            for (DynamicObject objdata : changeItems) {
                DynamicObject changeItem = objdata.getDynamicObject("fbasedataid");
                if (changeItem.getString("changeapplykey") == null || changeItem.getString("changeapplykey").isEmpty()) continue;
                assignFieldsMap.put(changeItem.getString("number"), changeItem.getString("changeapplykey"));
            }
            List<String> entryFields = this.getEntryFields();
            String changeNo = this.getPageCache().get("changeNo");
            for (ListSelectedRow row : returnDataList) {
                int index = this.getModel().createNewEntryRow("main_changebillentry");
                this.getModel().setValue("realcard", row.getPrimaryKeyValue(), index);
                for (DynamicObject obj : changeItems) {
                    DynamicObject item = obj.getDynamicObject("fbasedataid");
                    String field = item.getString("number");
                    DynamicObject realCard = (DynamicObject)this.getModel().getValue("realcard", index);
                    if (entryFields.contains("bef_" + field)) {
                        this.getModel().setValue("bef_" + field, realCard.get(field), index);
                        if (!entryFields.contains("aft_" + field) || !Boolean.parseBoolean(changeNo)) continue;
                        this.getModel().setValue("aft_" + field, realCard.get(field), index);
                        continue;
                    }
                    if (!assignFieldsMap.containsKey(field)) continue;
                    this.getModel().setValue("bef_" + (String)assignFieldsMap.get(field), realCard.get(field), index);
                }
            }
        }
    }

    private boolean check(DynamicObject changeItem) {
        String changeSource = changeItem.getString("topic");
        List<String> entryFields = this.getEntryFields();
        boolean result = false;
        if ("fa_card_real".equals(changeSource) && !this.getForbiddenList().contains(changeItem.getString("number"))) {
            result = true;
        } else {
            String msg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u7533\u8bf7\u5355\u4e0d\u652f\u6301%s\u53ef\u53d8\u66f4\u9879\u76ee\u7684\u53d8\u66f4\uff0c\u8bf7\u901a\u8fc7\u53d8\u66f4\u5355\u8fdb\u884c\u53d8\u66f4\u3002", (String)"FaChangeApplyPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), changeItem.get("name"));
            this.getView().showTipNotification(msg);
        }
        if (!entryFields.contains("bef_" + changeItem.getString("number")) && !entryFields.contains("bef_" + changeItem.getString("changeapplykey"))) {
            result = false;
        }
        return result;
    }

    private List<String> getEntryFields() {
        ArrayList<String> propertyList = new ArrayList<String>(50);
        DataEntityPropertyCollection properties = ((EntityType)this.getModel().getDataEntityType().getAllEntities().get("main_changebillentry")).getProperties();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            propertyList.add(propertyName);
        }
        return propertyList;
    }

    private List<String> getChangedFields() {
        ArrayList<String> fields = new ArrayList<String>(30);
        List<String> entryFields = this.getEntryFields();
        for (String field : entryFields) {
            if (!field.contains("bef_") && !field.contains("aft_")) continue;
            fields.add(field);
        }
        return fields;
    }

    private void setChangeItems() {
        DynamicObject changeType = (DynamicObject)this.getModel().getValue("changetype");
        if (changeType != null) {
            DynamicObjectCollection changeTypeEntry = changeType.getDynamicObjectCollection("changetypeentry");
            ArrayList<Long> ids = new ArrayList<Long>(changeTypeEntry.size());
            for (DynamicObject entryRow : changeTypeEntry) {
                DynamicObject changeItem = entryRow.getDynamicObject("changeitem");
                ids.add(changeItem.getLong("id"));
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fa_change_item", (String)"id,topic,number,name,changeapplykey", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            ArrayList<Long> setItems = new ArrayList<Long>(query.size());
            for (DynamicObject obj : query) {
                if (!this.check(obj)) continue;
                setItems.add(obj.getLong("id"));
            }
            this.getModel().setValue("changeitem", (Object)setItems.toArray());
        } else {
            this.getModel().setValue("changeitem", null);
        }
    }

    private List<QFilter> getChangeTypeFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>(1);
        List<String> forbiddenList = this.getForbiddenList();
        QFilter qFilter0 = new QFilter("topic", "=", (Object)"fa_card_real").and("number", "not in", forbiddenList);
        DynamicObjectCollection changeItems = QueryServiceHelper.query((String)"fa_change_item", (String)"id", (QFilter[])new QFilter[]{qFilter0});
        ArrayList itemIds = new ArrayList(changeItems.size());
        changeItems.forEach(item -> itemIds.add(item.getLong("id")));
        QFilter qFilter1 = new QFilter("changetypeentry.changeitem", "not in", itemIds);
        DynamicObjectCollection allChangeTypes = QueryServiceHelper.query((String)"fa_change_type", (String)"id", (QFilter[])qFilter1.toArray());
        HashSet<Long> useableChangeTypeIds = new HashSet<Long>();
        for (DynamicObject changeType : allChangeTypes) {
            useableChangeTypeIds.add(changeType.getLong("id"));
        }
        list.add(new QFilter("id", "not in", useableChangeTypeIds));
        return list;
    }

    private List<String> getForbiddenList() {
        ArrayList<String> fields = new ArrayList<String>(28);
        fields.add("barcoderule");
        fields.add("srcbillnumber");
        fields.add("sourceentrysplitseq");
        fields.add("sourceentryid");
        fields.add("numberrule");
        fields.add("numberruleexist");
        fields.add("billnocoderuleexist");
        fields.add("billnocoderuleexist");
        fields.add("isbak");
        fields.add("masterid");
        fields.add("masterid");
        fields.add("sourceflag");
        fields.add("isexischangednumber");
        fields.add("isexischangedbillo");
        fields.add("isexischangedbar");
        fields.add("isimport");
        fields.add("srcbillid");
        fields.add("srcbillentityname");
        fields.add("barcoderecovery");
        fields.add("billnorecovery");
        fields.add("numberrecovery");
        fields.add("billstatus");
        fields.add("mergedcard");
        fields.add("originaldata");
        fields.add("radiogroupfield");
        fields.add("barcoderuleexist");
        fields.add("billnocoderule");
        fields.add("realaccountdate");
        return fields;
    }
}

