/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.coderule.CodeRuleService;
import kd.fi.fa.business.constants.FaChangeItem;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaChangeTypeUtils;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;
import kd.fi.fa.utils.FaChangeBillUtils;

public class FaChangeBillEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(FaChangeBillEditPlugin.class);
    private static final List<String> mustFields = FaChangeBillUtil.hasMustField();
    private static final String finFields = "id,depreuse,realcard,realcardmasterid,currency,basecurrency,finaccountdate,period,assetbook,assetcat,";

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject changeType;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (("m_aft_preusingamount".equals(name) || "o_aft_preusingamount".equals(name)) && !FaChangeTypeUtils.isSystemPreDepreMethodChg4Workload((DynamicObject)(changeType = (DynamicObject)this.getModel().getValue("changetype")))) {
            this.checkAftPreusingAmount(e);
        }
    }

    private void checkAftPreusingAmount(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        BigDecimal newValueBigDecimal = (BigDecimal)changeData.getNewValue();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = changeData.getDataEntity();
        String name = e.getProperty().getName();
        DynamicObject finCardDynObj = null;
        if ("m_aft_preusingamount".equals(name)) {
            finCardDynObj = dataEntity.getDynamicObject("m_fincard");
        }
        if ("o_aft_preusingamount".equals(name)) {
            finCardDynObj = dataEntity.getDynamicObject("o_fincard");
        }
        if (Objects.isNull(finCardDynObj)) {
            return;
        }
        DynamicObject workLoadUnitDyn = finCardDynObj.getDynamicObject("workloadunit");
        if (Objects.nonNull(workLoadUnitDyn)) {
            return;
        }
        newValueBigDecimal = newValueBigDecimal.setScale(0, RoundingMode.DOWN);
        if ("m_aft_preusingamount".equals(name)) {
            model.setValue("m_aft_preusingamount", (Object)newValueBigDecimal);
        }
        if ("o_aft_preusingamount".equals(name)) {
            model.setValue("o_aft_preusingamount", (Object)newValueBigDecimal);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceDataTemp = e.getSourceData();
        JSONObject sourceData = new JSONObject(sourceDataTemp);
        JSONObject rawOrg = sourceData.getJSONObject("org");
        String orgNumber = (String)rawOrg.get((Object)"number");
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
        if (org == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801[%s]\u627e\u4e0d\u5230\u7ec4\u7ec7\u3002", (String)"FaChangeBillEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), orgNumber));
        }
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(org.getLong("id"));
        Map changeEmptyParam = SystemParamHelper.getChangeEmptyParam(orgIdList);
        boolean changeNo = (Boolean)changeEmptyParam.get(org.getLong("id"));
        JSONArray fieldentry = sourceData.getJSONArray("fieldentry");
        HashSet<String> realNumberSet = new HashSet<String>(fieldentry.size());
        int index = -1;
        for (Object row : fieldentry) {
            ++index;
            JSONObject jsonObj = new JSONObject((Map)row);
            String assetnumber = jsonObj.getString("assetnumber");
            realNumberSet.add(assetnumber);
            Object aftervalue = jsonObj.get((Object)"aftervalue");
            String fieldName = jsonObj.getString("field");
            if (changeNo || aftervalue != null) continue;
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u201c\u5141\u8bb8\u53d8\u66f4\u4e3a\u7a7a\u201d\u672a\u5f00\u542f\uff0c%s\u53d8\u66f4\u540e\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FaChangeBillEditPlugin_32", (String)"fi-fa-formplugin", (Object[])new Object[0]), fieldName));
            e.setCancel(true);
        }
        HashMap<String, Long> numAndIdMap = new HashMap<String, Long>(realNumberSet.size());
        String selectFields = String.join((CharSequence)", ", "id", "number");
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", realNumberSet), new QFilter("id", "=", (Object)"masterid", true), new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE.name())};
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)selectFields, (QFilter[])filters);
        for (Object realCard : realCards) {
            String number = realCard.getString("number");
            long id = realCard.getLong("id");
            numAndIdMap.put(number, id);
        }
        HashSet<String> depreuseNumberSet = new HashSet<String>(8);
        for (Object object : fieldentry) {
            JSONObject jsonObj = new JSONObject((Map)object);
            if (jsonObj.getJSONObject("depreuse1") != null) {
                depreuseNumberSet.add(jsonObj.getJSONObject("depreuse1").getString("number"));
            }
            String assetnumber = jsonObj.getString("assetnumber");
            JSONObject realCard1 = jsonObj.getJSONObject("realcard1");
            if (realCard1 == null) continue;
            realCard1.put("importprop", (Object)"id");
            realCard1.put("id", numAndIdMap.get(assetnumber));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fa_depreuse", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", depreuseNumberSet)});
        if (query.isEmpty()) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u6839\u636e\u6298\u65e7\u7528\u9014\u7f16\u7801%s\u627e\u4e0d\u5230\u6298\u65e7\u7528\u9014\u3002", (String)"FaChangeBillEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), depreuseNumberSet));
            e.setCancel(true);
        } else if (query.size() != depreuseNumberSet.size()) {
            depreuseNumberSet.removeAll(query.stream().map(v -> v.getString("number")).collect(Collectors.toSet()));
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u6839\u636e\u6298\u65e7\u7528\u9014\u7f16\u7801%s\u627e\u4e0d\u5230\u6298\u65e7\u7528\u9014\u3002", (String)"FaChangeBillEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), depreuseNumberSet));
            e.setCancel(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void afterImportData(ImportDataEventArgs e) {
        String key;
        String typePropName;
        ItemClassProp itemClassProp;
        Object prop;
        Tuple<IDataEntityProperty, Boolean> fieldTuple;
        String field;
        Object pk;
        boolean isAPI;
        IDataModel model = this.getModel();
        boolean bl = isAPI = e.getOption().get("importtype") == null;
        if (isAPI) {
            model.setValue("sourcetype", (Object)7);
        }
        if (QueryServiceHelper.exists((String)"fa_change_dept", (Object)(pk = model.getDataEntity().getPkValue()))) {
            String billno = model.getDataEntity().getString("billno");
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\u7684\u53d8\u66f4\u5355\u4e0d\u652f\u6301\u66f4\u65b0\u5f15\u5165\u3002", (String)"FaChangeBillEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), billno));
            e.setCancel(true);
            return;
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        String fields = Fa.comma((String[])new String[]{"depreuse", "ismainbook", "curperiod", "curperiod.begindate", "curperiod.enddate", "ismainbook"});
        Map mainbooks = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)fields, (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("status", "=", (Object)"C")});
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(org.getLong("id"));
        Map changeEmptyParam = SystemParamHelper.getChangeEmptyParam(orgIdList);
        boolean changeNo = (Boolean)changeEmptyParam.get(org.getLong("id"));
        model.setValue("billno", null);
        if (!CodeRuleService.getInstance((DynamicObject)model.getDataEntity(), (String)org.getPkValue().toString()).isExistRule()) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53ea\u652f\u6301\u7cfb\u7edf\u7f16\u7801\uff0c\u8bf7\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"FaChangeBillEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        Date changedate = (Date)model.getValue("changedate");
        boolean isFeatureBusy = false;
        if (changedate == null) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaChangeBillEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            for (Map.Entry mainbookEntry : mainbooks.entrySet()) {
                DynamicObject mainbook = (DynamicObject)mainbookEntry.getValue();
                if (mainbook.getBoolean("ismainbook") && changedate.compareTo(mainbook.getDate("curperiod.enddate")) > 0) {
                    isFeatureBusy = true;
                }
                if (changedate.compareTo(mainbook.getDate("curperiod.begindate")) >= 0) continue;
                DynamicObject depreUse = mainbook.getDynamicObject("depreuse");
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u65e9\u4e8e\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c", (String)"FaChangeBillEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]), depreUse.getString("name")));
                e.setCancel(true);
            }
        }
        DynamicObjectCollection fieldEntries = model.getEntryEntity("fieldentry");
        this.checkRepeatChangeField(fieldEntries, e);
        HashMap<String, Boolean> isFutureMap = new HashMap<String, Boolean>(fieldEntries.size());
        HashMap<String, Date> bizDateMap = new HashMap<String, Date>(fieldEntries.size());
        this.handlerIsFutureAndBizDateMap(fieldEntries, isFutureMap, bizDateMap);
        Set cardNumberSet = fieldEntries.stream().map(v -> v.get("assetnumber")).collect(Collectors.toSet());
        QFilter[] filterRCard = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("id", "=", (Object)"masterid", true), new QFilter("number", "in", cardNumberSet), new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE.name())};
        Map cardRealMap = BusinessDataServiceHelper.loadFromCache((String)"fa_card_real", (QFilter[])filterRCard);
        HashSet<Long> rCardIdSet = new HashSet<Long>(cardNumberSet.size());
        HashMap<String, DynamicObject> number_Cards = new HashMap<String, DynamicObject>(cardNumberSet.size());
        for (DynamicObject rCard : cardRealMap.values()) {
            String rCardNumber = (String)rCard.get("number");
            number_Cards.put(rCardNumber, rCard);
            rCardIdSet.add(rCard.getLong("id"));
        }
        DynamicObjectCollection fieldEntryColl = model.getDataEntity().getDynamicObjectCollection("fieldentry");
        Set dePreUseIds = fieldEntryColl.stream().map(v -> v.getDynamicObject("depreuse1").getLong("id")).collect(Collectors.toSet());
        HashSet assetBooks = new HashSet(2);
        for (Map.Entry mainBook : mainbooks.entrySet()) {
            Long depUseId = ((DynamicObject)mainBook.getValue()).getDynamicObject("depreuse").getLong("id");
            if (!dePreUseIds.contains(depUseId)) continue;
            assetBooks.add(mainBook.getValue());
        }
        DynamicObject changeType = (DynamicObject)model.getValue("changetype");
        if (changeType == null) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53d8\u66f4\u7c7b\u578b\u3002", (String)"FaChangeBillEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String fCardFields = fieldEntries.stream().map(v -> FaChangeBillUtils.parseField(v.getString("field"), changeType)).filter(tuple -> (Boolean)tuple.item2 == false).map(tuple -> ((IDataEntityProperty)tuple.item1).getName()).distinct().collect(Collectors.joining(","));
        String queryFields = finFields + fCardFields;
        queryFields = Fa.comma((String[])new String[]{queryFields, "number", "period", "bizperiod", "org", "depremethod"});
        LinkedList<DynamicObject> fCards = new LinkedList<DynamicObject>();
        for (Object assetBook : assetBooks) {
            DynamicObject currentPeriodId = assetBook.getDynamicObject("curperiod");
            Long assetBookId = assetBook.getLong("id");
            DynamicObject[] cards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)queryFields, (QFilter[])new QFilter[]{new QFilter("bizperiod", "<=", currentPeriodId.getPkValue()), new QFilter("endperiod", ">", currentPeriodId.getPkValue()), new QFilter("assetbook", "=", (Object)assetBookId), new QFilter("realcardmasterid", "in", rCardIdSet)});
            fCards.addAll(Arrays.asList(cards));
        }
        HashSet<Long> existFin = new HashSet<Long>(fCards.size());
        for (DynamicObject fCard : fCards) {
            existFin.add(fCard.getLong("realcardmasterid"));
        }
        if (isFeatureBusy) {
            Object changeItemID2TopMap;
            BusyTypeDetailEnum busyTypeEnum;
            HashSet<Long> fuFinSet = new HashSet<Long>(rCardIdSet.size());
            fuFinSet.addAll(rCardIdSet);
            fuFinSet.removeAll(existFin);
            if (fuFinSet.size() > 0 && (busyTypeEnum = FaChangeBillUtil.getChangeTypeDetail4F7((DynamicObject)changeType, (Map)(changeItemID2TopMap = FaChangeBillUtil.getChangeItemMap()))).name().equals(BusyTypeDetailEnum.REAL_CHG.name())) {
                for (DynamicObject assetBook : assetBooks) {
                    DynamicObject currentPeriodId = assetBook.getDynamicObject("curperiod");
                    Long assetBookId = assetBook.getLong("id");
                    DynamicObject[] cards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)queryFields, (QFilter[])new QFilter[]{new QFilter("bizperiod", ">", currentPeriodId.getPkValue()), new QFilter("endperiod", "=", (Object)99999999999L), new QFilter("assetbook", "=", (Object)assetBookId), new QFilter("realcardmasterid", "in", fuFinSet)});
                    fCards.addAll(Arrays.asList(cards));
                }
            }
        }
        HashMap<String, DynamicObject> rId_duId2fcardMap = new HashMap<String, DynamicObject>(fCards.size());
        for (DynamicObject fCard : fCards) {
            StringBuilder key2 = new StringBuilder(fCard.getString("realcardmasterid"));
            key2.append("_");
            key2.append(fCard.getString("depreuse.id"));
            rId_duId2fcardMap.put(key2.toString(), fCard);
        }
        DynamicObjectCollection realEntries = model.getEntryEntity("realentry");
        realEntries.clear();
        HashMap<String, HashSet<Integer>> cardNum2IndexMap = new HashMap<String, HashSet<Integer>>(16);
        for (int i = 0; i < fieldEntries.size(); ++i) {
            DynamicObject entry = (DynamicObject)fieldEntries.get(i);
            String number = (String)entry.get("assetnumber");
            if (!number_Cards.containsKey(number)) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801[%s]\u627e\u4e0d\u5230\u5b9e\u7269\u5361\u7247\u3002", (String)"FaChangeBillEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]), number));
                e.setCancel(true);
                continue;
            }
            HashSet<Integer> cardIndexSet = (HashSet<Integer>)cardNum2IndexMap.get(number);
            if (CollectionUtils.isEmpty((Collection)cardIndexSet)) {
                cardIndexSet = new HashSet<Integer>(16);
                cardNum2IndexMap.put(number, cardIndexSet);
            }
            cardIndexSet.add(i);
        }
        HashSet<Object> rCardAppended = new HashSet<Object>(fCards.size());
        for (DynamicObject fCard : fCards) {
            DynamicObject realcard = fCard.getDynamicObject("realcard");
            String assetNum = realcard.getString("number");
            Set cardIndexSet = (Set)cardNum2IndexMap.get(assetNum);
            if (!"C".equals(realcard.get("billstatus"))) {
                for (Integer index : cardIndexSet) {
                    e.addCancelMessage(index, Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u5361\u7247 %s \u672a\u5ba1\u6838\u3002", (String)"FaChangeBillEditPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetNum));
                }
                e.setCancel(true);
            }
            if (!"READY".equals(realcard.get("bizstatus"))) {
                for (Integer index : cardIndexSet) {
                    e.addCancelMessage(index, Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u5361\u7247 %s \u672a\u5c31\u7eea\u3002", (String)"FaChangeBillEditPlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetNum));
                }
                e.setCancel(true);
            }
            Object rCardPk = realcard.getPkValue();
            DynamicObject realEntry = null;
            if (rCardAppended.add(rCardPk)) {
                realEntry = realEntries.addNew();
                realEntry.set("realcard", (Object)realcard);
            } else {
                realEntry = realEntries.stream().filter(v -> v.get("realcard.id").equals(rCardPk)).findFirst().get();
            }
            Iterator finEntries = realEntry.getDynamicObjectCollection("finentry");
            DynamicObject finEntry = finEntries.addNew();
            finEntry.set("depreuse", fCard.get("depreuse"));
            finEntry.set("currency", fCard.get("currency"));
            finEntry.set("fincard", (Object)fCard);
            DynamicObject depreuse = fCard.getDynamicObject("depreuse");
            if (depreuse == null) continue;
            String key3 = assetNum + "_" + depreuse.getLong("id");
            finEntry.set("isadjustdepre", isFutureMap.get(key3));
            finEntry.set("bizdate", bizDateMap.get(key3));
        }
        HashMap<String, Object> changeFieldCnName2tuple = new HashMap<String, Object>();
        HashMap<String, Object> changeFieldEnName2tuple = new HashMap<String, Object>();
        HashMap<String, HashSet<String>> changeFieldEnName2value = new HashMap<String, HashSet<String>>();
        HashMap<String, String> itemClassTypeMap = new HashMap<String, String>();
        HashMap<Integer, DynamicObject> index2ItemClassEntryMap = new HashMap<Integer, DynamicObject>(16);
        HashMap<String, HashSet<Integer>> basePropFieldVal2IndexSet = new HashMap<String, HashSet<Integer>>(16);
        int index = -1;
        for (DynamicObject entry : fieldEntries) {
            ++index;
            String field2 = entry.getString("field");
            Tuple<IDataEntityProperty, Boolean> fieldTuple2 = FaChangeBillUtils.parseField(field2, changeType);
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)fieldTuple2.item1;
            if (changeFieldCnName2tuple.get(field2) == null) {
                changeFieldCnName2tuple.put(field2, fieldTuple2);
                changeFieldEnName2tuple.put(iDataEntityProperty.getName(), fieldTuple2);
            }
            if (iDataEntityProperty instanceof ItemClassTypeProp) {
                String string = entry.getString("aftervalue");
                if (!StringUtils.isNotEmpty((String)string) || itemClassTypeMap.containsKey(string)) continue;
                if (!QueryServiceHelper.exists((String)"bos_entityobject", (Object)string)) {
                    int left;
                    String string2 = string.replaceAll("\uff08", "(");
                    String baseEntityId = string2.substring((left = string2.lastIndexOf("(")) + 1, string2.length() - 1);
                    if (!QueryServiceHelper.exists((String)"bos_entityobject", (Object)baseEntityId)) continue;
                    itemClassTypeMap.put(string2, baseEntityId);
                    continue;
                }
                itemClassTypeMap.put(string, string);
                continue;
            }
            if (iDataEntityProperty instanceof ItemClassProp) {
                index2ItemClassEntryMap.put(index, entry);
                continue;
            }
            if (!(iDataEntityProperty instanceof BasedataProp)) continue;
            BasedataProp basedataProp = (BasedataProp)iDataEntityProperty;
            String enName = basedataProp.getName();
            HashSet<String> cnValue = (HashSet<String>)changeFieldEnName2value.get(enName);
            if (cnValue == null) {
                cnValue = new HashSet<String>();
                cnValue.add(entry.getString("aftervalue"));
                changeFieldEnName2value.put(enName, cnValue);
            } else {
                cnValue.add(entry.getString("aftervalue"));
            }
            String mapKey = enName + "_" + entry.getString("aftervalue");
            HashSet<Integer> indexSet = (HashSet<Integer>)basePropFieldVal2IndexSet.get(mapKey);
            if (!basePropFieldVal2IndexSet.containsKey(mapKey)) {
                indexSet = new HashSet<Integer>();
                basePropFieldVal2IndexSet.put(mapKey, indexSet);
            }
            indexSet.add(index);
        }
        HashMap itemClassEntityMap = new HashMap();
        HashMap<String, HashSet<Integer>> itemClassEntityIdVal2IndexSet = new HashMap<String, HashSet<Integer>>();
        HashMap<String, String> entryItemClassTypeEntity = new HashMap<String, String>(index2ItemClassEntryMap.size(), 1.0f);
        for (Map.Entry entry : index2ItemClassEntryMap.entrySet()) {
            int n = (Integer)entry.getKey();
            DynamicObject entry2 = (DynamicObject)entry.getValue();
            field = entry2.getString("field");
            fieldTuple = FaChangeBillUtils.parseField(field);
            prop = (IDataEntityProperty)fieldTuple.item1;
            if (!(prop instanceof ItemClassProp)) continue;
            itemClassProp = (ItemClassProp)prop;
            typePropName = itemClassProp.getTypePropName();
            String baseEntityId = "";
            key = FaChangeBillEditPlugin.genItemClassMapKey(entry2, typePropName, false);
            for (DynamicObject cpFieldEntry : fieldEntries) {
                String cpField = cpFieldEntry.getString("field");
                Tuple<IDataEntityProperty, Boolean> cpFieldTuple = FaChangeBillUtils.parseField(cpField);
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)cpFieldTuple.item1;
                String cpKey = FaChangeBillEditPlugin.genItemClassMapKey(cpFieldEntry, iDataEntityProperty.getName(), false);
                if (!cpKey.equals(key)) continue;
                baseEntityId = (String)itemClassTypeMap.get(cpFieldEntry.getString("aftervalue"));
                break;
            }
            if (StringUtils.isEmpty((String)baseEntityId)) {
                String number = (String)entry2.get("assetnumber");
                DynamicObject realCard = (DynamicObject)number_Cards.get(number);
                String billName = itemClassProp.getParent().getExtendName();
                if ("fa_card_real".equals(billName)) {
                    baseEntityId = realCard.getString(typePropName);
                } else {
                    StringBuilder cardKey = new StringBuilder(realCard.getString("id"));
                    cardKey.append("_");
                    cardKey.append(entry2.getString("depreuse1.id"));
                    DynamicObject dynamicObject = (DynamicObject)rId_duId2fcardMap.get(cardKey.toString());
                    baseEntityId = dynamicObject.getString(typePropName);
                }
            }
            if (StringUtils.isEmpty((String)baseEntityId)) {
                e.addCancelMessage(Integer.valueOf(n), Integer.valueOf(0), ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"FaChangeBillEditPlugin_10", (String)"fi-fa-formplugin", (Object[])new Object[]{field}));
                e.setCancel(true);
                return;
            }
            entryItemClassTypeEntity.put(key, baseEntityId);
            if (itemClassEntityMap.containsKey(baseEntityId)) {
                ((Set)itemClassEntityMap.get(baseEntityId)).add(entry2.getString("aftervalue"));
            } else {
                HashSet<String> cnValue = new HashSet<String>();
                cnValue.add(entry2.getString("aftervalue"));
                itemClassEntityMap.put(baseEntityId, cnValue);
            }
            String mapKey = baseEntityId + "#" + entry2.getString("aftervalue");
            Iterator indexSet = (HashSet<Integer>)itemClassEntityIdVal2IndexSet.get(mapKey);
            if (!itemClassEntityIdVal2IndexSet.containsKey(mapKey)) {
                indexSet = new HashSet<Integer>();
                itemClassEntityIdVal2IndexSet.put(mapKey, (HashSet<Integer>)((Object)indexSet));
            }
            indexSet.add(n);
        }
        HashMap<String, String> itemClassCnName_CnValueid = new HashMap<String, String>();
        for (Map.Entry entry : itemClassEntityMap.entrySet()) {
            String entityId = (String)entry.getKey();
            Set fieldValueList = ((Set)entry.getValue()).stream().filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            DynamicObjectCollection dobjList = QueryServiceHelper.query((String)entityId, (String)"id,number,name", (QFilter[])new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)org.getLong("id")), new QFilter("name", "in", (Object)fieldValueList.toArray()).or(new QFilter("number", "in", (Object)fieldValueList.toArray()))});
            for (DynamicObject dobj : dobjList) {
                Set indexSet;
                String name = dobj.getString("name");
                String number = dobj.getString("number");
                if (fieldValueList.contains(name)) {
                    key = entityId + "#" + name;
                    if (itemClassCnName_CnValueid.get(key) != null) {
                        indexSet = (Set)itemClassEntityIdVal2IndexSet.get(key);
                        for (Integer valIndex : indexSet) {
                            e.addCancelMessage(valIndex, Integer.valueOf(0), String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684%2$s\u4e0d\u552f\u4e00\uff0c\u8bf7\u4fee\u6539\u4e3a\u7f16\u7801\u518d\u8fdb\u884c\u5bfc\u5165\u3002", (String)"FaChangeBillEditPlugin_11", (String)"fi-fa-formplugin", (Object[])new Object[0]), name, entityId));
                        }
                        e.setCancel(Boolean.TRUE.booleanValue());
                    }
                    itemClassCnName_CnValueid.put(key, dobj.getString("id"));
                    continue;
                }
                if (!fieldValueList.contains(number)) continue;
                key = entityId + "#" + number;
                if (itemClassCnName_CnValueid.get(key) != null) {
                    indexSet = (Set)itemClassEntityIdVal2IndexSet.get(key);
                    for (Integer valIndex : indexSet) {
                        e.addCancelMessage(valIndex, Integer.valueOf(0), String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684%2$s\u4e0d\u552f\u4e00\uff0c\u8bf7\u4fee\u6539\u4e3a\u540d\u79f0\u518d\u8fdb\u884c\u5bfc\u5165\u3002", (String)"FaChangeBillEditPlugin_12", (String)"fi-fa-formplugin", (Object[])new Object[0]), number, entityId));
                    }
                    e.setCancel(Boolean.TRUE.booleanValue());
                }
                itemClassCnName_CnValueid.put(key, dobj.getString("id"));
            }
        }
        for (Map.Entry entry : index2ItemClassEntryMap.entrySet()) {
            DynamicObject entry3 = (DynamicObject)entry.getValue();
            field = entry3.getString("field");
            fieldTuple = FaChangeBillUtils.parseField(field);
            prop = (IDataEntityProperty)fieldTuple.item1;
            itemClassProp = (ItemClassProp)prop;
            typePropName = itemClassProp.getTypePropName();
            String key4 = FaChangeBillEditPlugin.genItemClassMapKey(entry3, typePropName, false);
            String entityId = (String)entryItemClassTypeEntity.get(key4);
            String baseDataId = (String)itemClassCnName_CnValueid.get(entityId + "#" + entry3.getString("aftervalue"));
            if (StringUtils.isNotEmpty((String)baseDataId)) {
                entry3.set("aftervalue", (Object)baseDataId);
                continue;
            }
            entry3.set("aftervalue", (Object)String.valueOf(0));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entity : changeFieldEnName2value.entrySet()) {
            String enName = (String)entity.getKey();
            Set fieldValueList = ((Set)entity.getValue()).stream().filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            DynamicObject[] fieldTuple3 = (DynamicObject[])changeFieldEnName2tuple.get(enName);
            IDataEntityProperty prop3 = (IDataEntityProperty)fieldTuple3.item1;
            String entityName = "";
            if (prop3 instanceof ItemClassProp) continue;
            BasedataProp basedataProp = (BasedataProp)prop3;
            DynamicObjectType type = basedataProp.getDynamicComplexPropertyType();
            entityName = type.getName();
            DynamicObjectCollection dobjList = QueryServiceHelper.query((String)entityName, (String)"id,number,name", (QFilter[])new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)org.getLong("id")), new QFilter("name", "in", (Object)fieldValueList.toArray()).or(new QFilter("number", "in", (Object)fieldValueList.toArray()))});
            for (DynamicObject dobj : dobjList) {
                String name = dobj.getString("name");
                String number = dobj.getString("number");
                if (fieldValueList.contains(name)) {
                    String key5 = enName + "_" + (String)name;
                    if (hashMap.get(key5) != null) {
                        Set set = (Set)basePropFieldVal2IndexSet.get(key5);
                        for (Integer valIndex : set) {
                            e.addCancelMessage(valIndex, Integer.valueOf(0), String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684%2$s\u4e0d\u552f\u4e00\uff0c\u8bf7\u4fee\u6539\u4e3a\u7f16\u7801\u518d\u8fdb\u884c\u5bfc\u5165\u3002", (String)"FaChangeBillEditPlugin_11", (String)"fi-fa-formplugin", (Object[])new Object[0]), name, entityName));
                        }
                        e.setCancel(Boolean.TRUE.booleanValue());
                    }
                    hashMap.put(key5, dobj.getString("id"));
                    continue;
                }
                if (!fieldValueList.contains(number)) continue;
                String key2 = enName + "_" + number;
                if (hashMap.get(key2) != null) {
                    Set set = (Set)basePropFieldVal2IndexSet.get(key2);
                    for (Integer valIndex : set) {
                        e.addCancelMessage(valIndex, Integer.valueOf(0), String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684%2$s\u4e0d\u552f\u4e00\uff0c\u8bf7\u4fee\u6539\u4e3a\u540d\u79f0\u518d\u8fdb\u884c\u5bfc\u5165\u3002", (String)"FaChangeBillEditPlugin_12", (String)"fi-fa-formplugin", (Object[])new Object[0]), number, entityName));
                    }
                    e.setCancel(Boolean.TRUE.booleanValue());
                }
                hashMap.put(key2, dobj.getString("id"));
            }
        }
        HashSet hashSet = new HashSet();
        QFilter qFilter = new QFilter("topic", "in", (Object)new String[]{"fa_card_real", "fa_card_fin"});
        DynamicObject[] dbChangeItems = BusinessDataServiceHelper.load((String)"fa_change_item", (String)"id,number,topic", (QFilter[])new QFilter[]{qFilter});
        if (dbChangeItems == null || dbChangeItems.length == 0) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u53ef\u53d8\u66f4\u9879\u76ee\u6570\u636e\u5f02\u5e38\u3002", (String)"FaChangeBillEditPlugin_13", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        HashMap<String, Object> dbChangeItemsMap = new HashMap<String, Object>(dbChangeItems.length, 1.0f);
        for (DynamicObject item : dbChangeItems) {
            key = item.getString("topic") + ":" + item.getString("number");
            dbChangeItemsMap.put(key, item.getPkValue());
        }
        DynamicObjectCollection changeItemMaps = QueryServiceHelper.query((String)"fa_change_map", (String)"id,leasechgitem,cardchgitem", (QFilter[])new QFilter[0]);
        Set cardChangeMapItems = changeItemMaps.stream().map(t -> t.get("cardchgitem")).collect(Collectors.toSet());
        int i = -1;
        HashMap<String, Object> unitMap = new HashMap<String, Object>(fieldEntries.size());
        HashMap<Integer, Boolean> mustFieldEmptyMap = new HashMap<Integer, Boolean>(fieldEntries.size());
        Map enableUnitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)Fa.comma((String[])new String[]{"number", "name"}), (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)});
        for (DynamicObject entry : fieldEntries) {
            DynamicObject assetUnit;
            boolean checkResult;
            String afterValue;
            void var58_94;
            Object bChangeItemPK;
            ++i;
            String field3 = entry.getString("field");
            String string = "";
            Tuple fieldTuple4 = (Tuple)changeFieldCnName2tuple.get(field3);
            IDataEntityProperty prop4 = (IDataEntityProperty)fieldTuple4.item1;
            boolean isRealProp = (Boolean)fieldTuple4.item2;
            String prefix = isRealProp ? "fa_card_real" : "fa_card_fin";
            entry.set("field", (Object)(prefix + "." + prop4.getName()));
            model.setValue("changetype", (Object)changeType);
            Object beforeValue = null;
            DynamicObject realcard = (DynamicObject)number_Cards.get(entry.get("assetnumber"));
            String aftValue = entry.getString("aftervalue");
            if ("preusingamount".equals(prop4.getName()) && StringUtils.isEmpty((String)aftValue)) {
                entry.set("aftervalue", (Object)0);
            }
            this.checkafterData(prop4.getName(), entry.getString("aftervalue"));
            if ("workloadunit".equals(prop4.getName()) && !this.checkUnitEnable(aftValue, enableUnitMap)) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5f15\u5165\u65f6\u627e\u4e0d\u5230\u7f16\u7801\u6216\u540d\u79f0\u4e3a%s\u7684\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"FaChangeBillEditPlugin_39", (String)"fi-fa-formplugin", (Object[])new Object[0]), aftValue));
                e.setCancel(Boolean.TRUE.booleanValue());
                entry.set("aftervalue", (Object)0L);
                continue;
            }
            if (realcard == null) {
                mustFieldEmptyMap.put(i, true);
                continue;
            }
            entry.set("realcard1", realcard.get("id"));
            model.setValue("realcard1", realcard.get("id"), i);
            String disPlayName = prop4.getDisplayName().getLocaleValue();
            if (changeNo) {
                boolean exitMustEmpty;
                boolean bl2 = exitMustEmpty = mustFields.contains(prop4.getName()) && FaChangeBillUtil.checkEmptyField((Object)aftValue) != false;
                if (exitMustEmpty) {
                    mustFieldEmptyMap.put(i, true);
                    e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5fc5\u5f55\u5b57\u6bb5%s\u4e0d\u5141\u8bb8\u53d8\u66f4\u4e3a\u7a7a\u3002", (String)"FaChangeBillEditPlugin_33", (String)"fi-fa-formplugin", (Object[])new Object[0]), disPlayName));
                    e.setCancel(Boolean.TRUE.booleanValue());
                    continue;
                }
            }
            if ((bChangeItemPK = dbChangeItemsMap.get(prefix + ":" + prop4.getName())) != null) {
                hashSet.add(bChangeItemPK);
            }
            if (prop4 instanceof QtyProp) {
                QtyProp qtyProp = (QtyProp)prop4;
                String string3 = qtyProp.getRelatedUnit();
                Object relChangeItemPK = dbChangeItemsMap.get(prefix + ":" + string3);
                if (relChangeItemPK != null) {
                    hashSet.add(relChangeItemPK);
                }
            } else if (prop4 instanceof ItemClassProp) {
                ItemClassProp itemClassProp2 = (ItemClassProp)prop4;
                String typePropName2 = itemClassProp2.getTypePropName();
                Object relChangeItemPK = dbChangeItemsMap.get(prefix + ":" + typePropName2);
                if (relChangeItemPK != null) {
                    hashSet.add(relChangeItemPK);
                }
            }
            String sourceFlag = realcard.getString("sourceflag");
            if (("LEASECONTRACT".equalsIgnoreCase(sourceFlag) || "INITLEASECONTRACT".equalsIgnoreCase(sourceFlag)) && cardChangeMapItems.contains(bChangeItemPK)) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8d44\u4ea7%1$s\u7684%2$s\u9700\u8981\u901a\u8fc7\u79df\u8d41\u53d8\u66f4\u8fdb\u884c\u53d8\u66f4\u3002", (String)"FaChangeBillEditPlugin_14", (String)"fi-fa-formplugin", (Object[])new Object[0]), realcard.getString("number"), field3));
                e.setCancel(Boolean.TRUE.booleanValue());
            }
            DynamicObject depreuse = (DynamicObject)entry.get("depreuse1");
            StringBuilder rid_duid_key = new StringBuilder(realcard.getString("id"));
            rid_duid_key.append("_");
            rid_duid_key.append(depreuse.getPkValue());
            DynamicObject fCard = (DynamicObject)rId_duId2fcardMap.get(rid_duid_key.toString());
            if (fCard != null) {
                entry.set("fincard1", (Object)fCard);
                entry.set("currency1", fCard.get("currency"));
                entry.set("basecurrency1", fCard.get("basecurrency"));
                if (changeNo) {
                    boolean noDepre;
                    long assetBookId = fCard.getLong(Fa.id((String)"assetbook"));
                    long assetCatId = fCard.getLong(Fa.id((String)"assetcat"));
                    DynamicObject policyEntry = AssetPolicyUtil.getByBookAndCat((Object)assetBookId, (Object)assetCatId);
                    if (policyEntry != null && !(noDepre = policyEntry.getBoolean("nodepre"))) {
                        boolean noDepreAndEmpty;
                        boolean bl3 = noDepreAndEmpty = "depremethod".equals(prop4.getName()) && Boolean.TRUE.equals(FaChangeBillUtil.checkEmptyField((Object)aftValue)) || "preusingamount".equals(prop4.getName()) && BigDecimal.ZERO.compareTo(entry.getBigDecimal("aftervalue")) == 0;
                        if (noDepreAndEmpty) {
                            mustFieldEmptyMap.put(i, true);
                            e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5361\u7247\u9700\u8ba1\u63d0\uff0c%s\u4e0d\u5141\u8bb8\u53d8\u66f4\u4e3a\u7a7a\u3002", (String)"FaChangeBillEditPlugin_34", (String)"fi-fa-formplugin", (Object[])new Object[0]), disPlayName));
                            e.setCancel(Boolean.TRUE.booleanValue());
                            continue;
                        }
                    }
                }
            } else {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u3002", (String)"FaChangeBillEditPlugin_15", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if (isRealProp) {
                beforeValue = prop4.getValue((Object)realcard);
                if (beforeValue instanceof DynamicObject) {
                    beforeValue = ((DynamicObject)beforeValue).getPkValue().toString();
                }
                if (beforeValue instanceof Timestamp) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    beforeValue = sdf.format(beforeValue);
                }
                if (StringUtils.isNotEmpty((String)var58_94)) {
                    unitMap.put("bef" + (String)var58_94 + realcard.getString("id"), realcard.get((String)var58_94));
                }
            } else {
                beforeValue = prop4.getValue((Object)fCard);
                if (beforeValue instanceof DynamicObject) {
                    beforeValue = ((DynamicObject)beforeValue).getPkValue().toString();
                }
                if (beforeValue instanceof Timestamp) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    beforeValue = sdf.format(beforeValue);
                }
                if (StringUtils.isNotEmpty((String)var58_94)) {
                    unitMap.put("bef" + (String)var58_94 + realcard.getString("id"), fCard.get((String)var58_94));
                }
            }
            if (prop4 instanceof BasedataProp && beforeValue == null) {
                beforeValue = 0L;
            }
            if (beforeValue instanceof BigDecimal) {
                beforeValue = ((BigDecimal)beforeValue).toPlainString();
            }
            entry.set("beforevalue", beforeValue);
            if (prop4 instanceof ItemClassProp) {
                afterValue = this.parseValue(entry.getString("aftervalue"), prop4, itemClassCnName_CnValueid);
                entry.set("aftervalue", (Object)afterValue);
            } else {
                afterValue = this.parseValue(entry.getString("aftervalue"), prop4, hashMap);
                entry.set("aftervalue", (Object)afterValue);
            }
            if (prop4 instanceof AmountProp) {
                int amtPrecision;
                if (((AmountProp)prop4).getControlPropName().equals("basecurrency")) {
                    DynamicObject baseCurrencyDy = entry.getDynamicObject("basecurrency1");
                    if (baseCurrencyDy == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\uff1a%s\u672c\u4f4d\u5e01\u4e0d\u5b58\u5728\u3002", (String)"FaChangeBillEditPlugin_16", (String)"fi-fa-formplugin", (Object[])new Object[0]), realcard.get("number")));
                    }
                    amtPrecision = baseCurrencyDy.getInt("amtprecision");
                    BigDecimal afterValue2 = entry.getBigDecimal("aftervalue");
                    if (afterValue2.compareTo(afterValue2.setScale(amtPrecision, 0)) != 0) {
                        this.addCancelMessage(e, i, String.format(ResManager.loadKDString((String)"%s\uff1a\u53d8\u66f4\u540e\u7684\u91d1\u989d\u7cbe\u5ea6\u8d85\u8fc7\u672c\u4f4d\u5e01\u7cbe\u5ea6\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"FaChangeBillEditPlugin_17", (String)"fi-fa-formplugin", (Object[])new Object[0]), field3));
                    }
                }
                if (((AmountProp)prop4).getControlPropName().equals("currency")) {
                    DynamicObject currencyDy = entry.getDynamicObject("currency1");
                    if (currencyDy == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\uff1a%s\u5e01\u522b\u4e0d\u5b58\u5728\u3002", (String)"FaChangeBillEditPlugin_18", (String)"fi-fa-formplugin", (Object[])new Object[0]), realcard.get("number")));
                    }
                    amtPrecision = currencyDy.getInt("amtprecision");
                    BigDecimal afterValue3 = entry.getBigDecimal("aftervalue");
                    if (afterValue3.compareTo(afterValue3.setScale(amtPrecision, 0)) != 0) {
                        this.addCancelMessage(e, i, String.format(ResManager.loadKDString((String)"%s\uff1a\u53d8\u66f4\u540e\u7684\u91d1\u989d\u7cbe\u5ea6\u8d85\u8fc7\u5e01\u522b\u7cbe\u5ea6\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"FaChangeBillEditPlugin_19", (String)"fi-fa-formplugin", (Object[])new Object[0]), field3));
                    }
                }
            }
            if ("fa_card_real.headusedept".equals(entry.get("field")) && !(checkResult = FaAssetUnitAndUseDeptUnits.checkUseDeptByAssetUnit((DynamicObject)org, (DynamicObject)(assetUnit = realcard.getDynamicObject("assetunit")), (Long)entry.getLong("aftervalue")))) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\uff1a%s\u4f7f\u7528\u90e8\u95e8\u4e0d\u5728\u5f53\u524d\u8d44\u4ea7\u7ec4\u7ec7\u7684\u53ef\u7528\u8303\u56f4\u4e4b\u5185", (String)"FaChangeBillEditPlugin_20", (String)"fi-fa-formplugin", (Object[])new Object[0]), realcard.get("number")));
                e.setCancel(Boolean.TRUE.booleanValue());
            }
            if (!(prop4 instanceof UnitProp)) continue;
            unitMap.put("aft" + prop4.getName() + realcard.getString("id"), entry.getLong("aftervalue"));
        }
        Set unitIds = unitMap.values().stream().filter(Long.class::isInstance).collect(Collectors.toSet());
        if (!unitIds.isEmpty()) {
            Map<Object, DynamicObject> unitDynMap = QueryServiceHelper.query((String)"bd_measureunits", (String)Fa.comma((String[])new String[]{"id", "precision", "precisionaccount"}), (QFilter[])new QFilter[]{new QFilter("id", "in", unitIds)}).stream().collect(Collectors.toMap(v -> v.get("id"), v -> v));
            for (Map.Entry entry : unitMap.entrySet()) {
                if (!unitDynMap.containsKey(entry.getValue())) continue;
                entry.setValue(unitDynMap.get(entry.getValue()));
            }
        }
        i = -1;
        for (DynamicObject fieldEntry : fieldEntries) {
            DynamicObject aftUnit;
            ++i;
            String string = fieldEntry.getString("field");
            String[] splits = string.split("\\.");
            if (splits.length != 2) continue;
            String entityName = splits[0];
            String fieldName = splits[1];
            DynamicProperty prop5 = EntityMetadataCache.getDataEntityType((String)entityName).getProperty(fieldName);
            if (Boolean.TRUE.equals(mustFieldEmptyMap.get(i)) || !(prop5 instanceof QtyProp)) continue;
            String relatedUnit = ((QtyProp)prop5).getRelatedUnit();
            BigDecimal befQty = fieldEntry.getBigDecimal("beforevalue");
            BigDecimal aftQty = fieldEntry.getBigDecimal("aftervalue");
            DynamicObject realCard = fieldEntry.getDynamicObject("realcard1");
            if (realCard == null) continue;
            DynamicObject befUnit = (DynamicObject)unitMap.get("bef" + relatedUnit + realCard.getString("id"));
            if (befUnit != null) {
                befQty = befQty.setScale(befUnit.getInt("precision"), RoundingMode.valueOf(befUnit.getInt("precisionaccount")));
                fieldEntry.set("beforevalue", (Object)befQty);
            }
            if ((aftUnit = (aftUnit = (DynamicObject)unitMap.get("aft" + relatedUnit + realCard.getString("id"))) == null ? befUnit : aftUnit) == null) continue;
            if (aftQty.compareTo(aftQty.setScale(aftUnit.getInt("precision"), RoundingMode.valueOf(aftUnit.getInt("precisionaccount")))) != 0) {
                this.addCancelMessage(e, i, String.format(ResManager.loadKDString((String)"%s\uff1a\u53d8\u66f4\u540e\u7684\u6570\u91cf\u7cbe\u5ea6\u8d85\u8fc7\u5355\u4f4d\u7cbe\u5ea6\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"FaChangeBillEditPlugin_36", (String)"fi-fa-formplugin", (Object[])new Object[0]), prop5.getDisplayName()));
                e.setCancel(Boolean.TRUE.booleanValue());
                continue;
            }
            aftQty = aftQty.setScale(aftUnit.getInt("precision"), RoundingMode.valueOf(aftUnit.getInt("precisionaccount")));
            fieldEntry.set("aftervalue", (Object)aftQty);
        }
        fieldEntries.removeIf(next -> !Boolean.TRUE.equals(mustFieldEmptyMap.get(fieldEntries.indexOf(next))) && !FaChangeBillUtil.checkChangeStatus((DynamicObject)next, (boolean)changeNo));
        this.checkAdjustDepre(e);
        this.checkChangeItems(e);
        model.setValue("changeitem", (Object)hashSet.toArray(new Object[0]));
    }

    private boolean checkUnitEnable(String unitNumberOrName, Map<Object, DynamicObject> allEnableUnitObjs) {
        if (StringUtils.isEmpty((String)unitNumberOrName)) {
            return false;
        }
        if (allEnableUnitObjs == null || allEnableUnitObjs.isEmpty()) {
            return false;
        }
        for (Map.Entry<Object, DynamicObject> unitObjEntry : allEnableUnitObjs.entrySet()) {
            DynamicObject unitObj = unitObjEntry.getValue();
            String number = unitObj.getString("number");
            String name = unitObj.getString("name");
            if (!number.equals(unitNumberOrName) && !name.equals(unitNumberOrName)) continue;
            return true;
        }
        return false;
    }

    private void handlerIsFutureAndBizDateMap(DynamicObjectCollection fieldEntries, Map<String, Boolean> isFutureMap, Map<String, Date> bizDateMap) {
        if (CollectionUtils.isNotEmpty((Collection)fieldEntries)) {
            for (DynamicObject fieldEntry : fieldEntries) {
                String cardNumber = fieldEntry.getString("assetnumber");
                DynamicObject depreuse = fieldEntry.getDynamicObject("depreuse1");
                if (depreuse == null) continue;
                Long depreuseId = depreuse.getLong("id");
                Boolean isFuture = fieldEntry.getBoolean("isadjustdepre1");
                Date bizDate = fieldEntry.getDate("bizdate1");
                String key = cardNumber + "_" + depreuseId;
                isFutureMap.putIfAbsent(key, isFuture);
                bizDateMap.putIfAbsent(key, bizDate);
            }
        }
    }

    private static String genItemClassMapKey(DynamicObject row, String fieldKey, boolean containsId) {
        StringBuilder key = new StringBuilder();
        if (containsId) {
            key.append(row.getLong("id")).append("-");
        }
        key.append(row.getString("assetnumber")).append("-");
        key.append(row.getLong("depreuse1_id")).append("-");
        key.append(fieldKey);
        return key.toString();
    }

    private void checkafterData(String name, String afterValue) {
        switch (name) {
            case "realaccountdate": {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    sdf.parse(afterValue);
                    break;
                }
                catch (Exception ex) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u7c7b\u578b\u9519\u8bef\u3002", (String)"FaChangeBillEditPlugin_21", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
            }
            case "preusingamount": {
                try {
                    double preusingamount = Double.parseDouble(afterValue);
                    if (preusingamount < 0.0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u4f7f\u7528\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"FaChangeBillEditPlugin_22", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                    break;
                }
                catch (Exception ex) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u4f7f\u7528\u671f\u95f4\u5fc5\u987b\u683c\u5f0f\u6b63\u786e\u4e14\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"FaChangeBillEditPlugin_23", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
            }
            case "originalval": {
                try {
                    double preusingamount = Double.parseDouble(afterValue);
                    if (preusingamount < 0.0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u539f\u503c\u5fc5\u987b\u683c\u5f0f\u6b63\u786e\u4e14\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"FaChangeBillEditPlugin_24", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                    break;
                }
                catch (Exception ex) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u539f\u503c\u5fc5\u987b\u683c\u5f0f\u6b63\u786e\u4e14\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"FaChangeBillEditPlugin_24", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
            }
            case "preresidualval": {
                try {
                    double preusingamount = Double.parseDouble(afterValue);
                    if (preusingamount < 0.0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u51c0\u6b8b\u503c\u5fc5\u987b\u683c\u5f0f\u6b63\u786e\u4e14\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"FaChangeBillEditPlugin_25", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                    break;
                }
                catch (Exception ex) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u51c0\u6b8b\u503c\u5fc5\u987b\u683c\u5f0f\u6b63\u786e\u4e14\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"FaChangeBillEditPlugin_25", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
            }
            case "assetamount": {
                try {
                    double assetamount = Double.parseDouble(afterValue);
                    if (assetamount <= 0.0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u4ea7\u6570\u91cf\u5fc5\u987b\u683c\u5f0f\u6b63\u786e\u4e14\u5927\u4e8e0\u3002", (String)"FaChangeBillEditPlugin_35", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                    break;
                }
                catch (Exception ex) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u4ea7\u6570\u91cf\u5fc5\u987b\u683c\u5f0f\u6b63\u786e\u4e14\u5927\u4e8e0\u3002", (String)"FaChangeBillEditPlugin_35", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
            }
            case "depredamount": {
                try {
                    BigDecimal depredAmount;
                    BigDecimal bigDecimal = depredAmount = StringUtils.isEmpty((String)afterValue) ? new BigDecimal("0") : new BigDecimal(afterValue);
                    if (depredAmount.compareTo(BigDecimal.ZERO) < 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5bff\u547d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"FaChangeBillEditPlugin_37", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                    break;
                }
                catch (Exception ex) {
                    if (!(ex instanceof KDBizException)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5bff\u547d\u5fc5\u987b\u683c\u5f0f\u6b63\u786e\u4e14\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"FaChangeBillEditPlugin_38", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                    throw ex;
                }
            }
        }
    }

    private String parseValue(String rawValue, IDataEntityProperty prop, Map<String, String> fieldCnName_CnValue2id) {
        if (prop instanceof ItemClassTypeProp) {
            ItemClassTypeProp type = (ItemClassTypeProp)prop;
            if (!StringUtils.isEmpty((String)rawValue) && !QueryServiceHelper.exists((String)"bos_entityobject", (Object)rawValue)) {
                int left;
                String baseEntityId = (rawValue = rawValue.replaceAll("\uff08", "(")).substring((left = rawValue.lastIndexOf("(")) + 1, rawValue.length() - 1);
                if (!QueryServiceHelper.exists((String)"bos_entityobject", (Object)baseEntityId)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u6216\u540d\u79f0\u4e3a%1$s\u7684%2$s\u3002", (String)"FaChangeBillEditPlugin_26", (String)"fi-fa-formplugin", (Object[])new Object[0]), rawValue, type.getDisplayName()));
                }
                return baseEntityId;
            }
            return rawValue;
        }
        if (prop instanceof ItemClassProp) {
            return rawValue;
        }
        if (prop instanceof BasedataProp) {
            if (StringUtils.isEmpty((String)rawValue)) {
                return String.valueOf(0);
            }
            BasedataProp basedataProp = (BasedataProp)prop;
            DynamicObjectType type = basedataProp.getDynamicComplexPropertyType();
            StringBuilder key = new StringBuilder(prop.getName());
            key.append("_");
            key.append(rawValue);
            String id = fieldCnName_CnValue2id.get(key.toString());
            if (id == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u6216\u540d\u79f0\u4e3a%1$s\u7684%2$s\u3002", (String)"FaChangeBillEditPlugin_26", (String)"fi-fa-formplugin", (Object[])new Object[0]), rawValue, type.getDisplayName()));
            }
            return id;
        }
        return rawValue;
    }

    private void checkRepeatChangeField(DynamicObjectCollection fieldEntry, ImportDataEventArgs e) {
        HashSet<String> changeField = new HashSet<String>(fieldEntry.size());
        int i = 0;
        for (DynamicObject row : fieldEntry) {
            String assetNumber = row.getString("assetnumber");
            String field = row.getString("field");
            long depreuse = row.getLong(Fa.id((String)"depreuse1"));
            boolean addRes = changeField.add(assetNumber + "_" + depreuse + "_" + field);
            if (!addRes) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5361\u7247\u3010%1$s\u3011\u6709\u91cd\u590d\u7684\u53d8\u66f4\u5b57\u6bb5\u3010%2$s\u3011\u3002", (String)"FaChangeBillEditPlugin_27", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetNumber, field));
                e.setCancel(true);
            }
            ++i;
        }
    }

    private void checkAdjustDepre(ImportDataEventArgs e) {
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity("fieldentry");
        HashMap<String, Boolean> adjustDepreMap = new HashMap<String, Boolean>(fieldEntry.size());
        for (int i = 0; i < fieldEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)fieldEntry.get(i);
            String realCardNumber = row.getString("assetnumber");
            long depreUseId = row.getLong(Fa.id((String)"depreuse1"));
            String key = realCardNumber + "_" + depreUseId;
            String changeField = row.getString("field");
            boolean isAdjustDepre = row.getBoolean("isadjustdepre1");
            if (!adjustDepreMap.containsKey(key)) {
                adjustDepreMap.put(key, isAdjustDepre);
            } else if (isAdjustDepre != (Boolean)adjustDepreMap.get(key)) {
                this.addCancelMessage(e, i, ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u76f8\u540c\u7684\u5361\u7247\uff0c\u201c\u672a\u6765\u9002\u7528\u201d\u7684\u503c\u5fc5\u987b\u76f8\u540c\u3002", (String)"FaChangeBillEditPlugin_28", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            if ("fa_card_real.usestatus".equals(changeField) && !isAdjustDepre) {
                this.addCancelMessage(e, i, ResManager.loadKDString((String)"\u53d8\u66f4\u4f7f\u7528\u72b6\u6001\u65f6\uff0c\u53ea\u80fd\u505a\u672a\u6765\u9002\u7528\u7684\u53d8\u66f4\u3002", (String)"FaChangeBillEditPlugin_29", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            boolean isSystemPreChange4Workload = FaChangeTypeUtils.isSystemPreDepreMethodChg4Workload((DynamicObject)((DynamicObject)this.getModel().getValue("changetype")));
            if ("fa_card_real.usestatus".equals(changeField) || FaChangeItem.ENABLE_MODIFY_IS_ADJUST_DEPRE.contains(changeField) || !isAdjustDepre || isSystemPreChange4Workload) continue;
            this.addCancelMessage(e, i, ResManager.loadKDString((String)"\u672c\u5b57\u6bb5\u4e0d\u80fd\u505a\u672a\u6765\u9002\u7528\u7684\u53d8\u66f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FaChangeBillEditPlugin_30", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkChangeItems(ImportDataEventArgs e) {
        DynamicObject changeType = (DynamicObject)this.getModel().getValue("changetype");
        DynamicObjectCollection changeTypeEntry = changeType.getDynamicObjectCollection("changetypeentry");
        HashSet<Object> changeItemIdSet = new HashSet<Object>(changeTypeEntry.size());
        for (DynamicObject row : changeTypeEntry) {
            DynamicObject changeItem = row.getDynamicObject("changeitem");
            changeItemIdSet.add(changeItem.getPkValue());
        }
        Map changItemMap = BusinessDataServiceHelper.loadFromCache((Object[])changeItemIdSet.toArray(new Object[0]), (String)"fa_change_item");
        HashSet<String> changeFieldSet = new HashSet<String>(changItemMap.size());
        for (DynamicObject changeItem : changItemMap.values()) {
            String topic = changeItem.getString("topic");
            String number = changeItem.getString("number");
            changeFieldSet.add(topic + "." + number);
        }
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity("fieldentry");
        for (int i = 0; i < fieldEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)fieldEntry.get(i);
            String field = row.getString("field");
            if (changeFieldSet.contains(field)) continue;
            this.addCancelMessage(e, i, ResManager.loadKDString((String)"\u53d8\u66f4\u5b57\u6bb5\u4e0d\u5728\u53d8\u66f4\u7c7b\u578b\u5305\u542b\u7684\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaChangeBillEditPlugin_31", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private void addCancelMessage(ImportDataEventArgs e, int rowIndex, String msg) {
        e.addCancelMessage(Integer.valueOf(rowIndex), Integer.valueOf(0), msg);
        e.setCancel(true);
    }
}

