/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.productsetting.ProductSettingServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.calc.DataModelWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.enums.lease.LeaseContractDepreTypeEnum;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaOperateLogUtil;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.formplugin.BusinessRecordSectionHandler;
import kd.fi.fa.formplugin.importhandler.FinCardImportHandler;
import kd.fi.fa.utils.AddUpYearDepreUtils;

public class FaCurCardFinEditPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String title = "titlepanelflex";
    private static final Log logger = LogFactory.getLog(FaCurCardFinEditPlugin.class);
    private static final String CACHE_KEY_QUERYORIDATA = "query_ori_data";

    public void afterCreateNewData(EventObject e) {
        IDataModel thisModel = this.getModel();
        Long endPeriodId = thisModel.getDataEntity().getLong("endperiod_id");
        if (endPeriodId == null || endPeriodId == 0L) {
            endPeriodId = 99999999999L;
        }
        thisModel.setValue("endperiod_id", (Object)endPeriodId);
    }

    public void initImportData(InitImportDataEventArgs e) {
        BillModel model = (BillModel)e.getSource();
        String entityKey = model.getDataEntityType().getName();
        boolean isInitCard = "fa_initcard_fin".equals(entityKey);
        List sourceDataList = e.getSourceDataList();
        HashSet<Long> finCardIds = new HashSet<Long>(sourceDataList.size());
        HashSet<String> workLoadUnitNumbers = new HashSet<String>(16);
        for (Map sourceData : sourceDataList) {
            Map workLoadUnitMap;
            String number;
            Object workLoadUnit;
            Long id = (Long)sourceData.get("id");
            if (id != null) {
                finCardIds.add(id);
            }
            if (!Objects.nonNull(workLoadUnit = sourceData.get("workloadunit")) || StringUtils.isBlank((CharSequence)(number = (String)(workLoadUnitMap = (Map)workLoadUnit).get("number")))) continue;
            workLoadUnitNumbers.add(number);
        }
        Set<String> existsWorkLoadUnits = this.getExistsUnitNumberMap(workLoadUnitNumbers);
        String selectFields = "id, org.number, depreuse.number, number, billstatus";
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])new QFilter("id", "in", finCardIds).toArray());
        Map<String, DynamicObject> finCardMap = finCards.stream().collect(Collectors.toMap(v -> v.getString("id"), v -> v));
        for (int i = 0; i < sourceDataList.size(); ++i) {
            Object workLoadUnit;
            String cardNumber;
            Map sourceData = (Map)sourceDataList.get(i);
            if (sourceData.get("id") == null) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u5f15\u5165\u66f4\u65b0\u7f3a\u5c11\u5185\u7801\u3002", (String)"FaCurCardFinEditPlugin_18", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                continue;
            }
            String id = sourceData.get("id").toString();
            DynamicObject finCard = finCardMap.get(id);
            String number = (String)sourceData.get("number");
            if (StringUtils.isBlank((CharSequence)number)) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"%s\uff1a\u8bf7\u586b\u5199\u201c\u8d44\u4ea7\u7f16\u7801\u201d\u3002", (String)"FaCurCardFinEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), number));
            } else if (finCard != null && !number.equals(cardNumber = finCard.getString("number"))) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u8d44\u4ea7\u7f16\u7801\u201d\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FaCurCardFinEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), number));
            }
            Object org = sourceData.get("org");
            if (org == null) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"%s\uff1a\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"FaCurCardFinEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), number));
            } else if (finCard != null) {
                String importOrgNumber = (String)((Map)org).get("number");
                String cardOrgNumber = finCard.getString("org.number");
                if (StringUtils.isEmpty((CharSequence)importOrgNumber) || !importOrgNumber.equals(cardOrgNumber)) {
                    e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FaCurCardFinEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), number));
                }
            }
            Object depreUse = sourceData.get("depreuse");
            if (depreUse == null) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"%s\uff1a\u8bf7\u586b\u5199\u201c\u6298\u65e7\u7528\u9014\u201d\u3002", (String)"FaCurCardFinEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), number));
            } else if (finCard != null) {
                String importDepreUseNum = (String)((Map)depreUse).get("number");
                String cardDepreUseNum = finCard.getString("depreuse.number");
                if (StringUtils.isEmpty((CharSequence)importDepreUseNum) || !importDepreUseNum.equals(cardDepreUseNum)) {
                    e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u6298\u65e7\u7528\u9014\u201d\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FaCurCardFinEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]), number));
                }
            }
            if (!isInitCard && finCard != null) {
                Object yearDepreObj;
                BigDecimal yearDepre;
                String billStatus = finCard.getString("billstatus");
                if (!"A".equals(billStatus)) {
                    e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u80fd\u66f4\u65b0\u6682\u5b58\u72b6\u6001\u7684\u8d22\u52a1\u5361\u7247\u3002", (String)"FaCurCardFinEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]), number));
                }
                BigDecimal bigDecimal = yearDepre = (yearDepreObj = sourceData.get("addupyeardepre")) == null ? null : new BigDecimal(yearDepreObj.toString());
                if (yearDepre != null && BigDecimal.ZERO.compareTo(yearDepre) != 0) {
                    e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8d44\u4ea7\u5361\u7247\u3001\u8d22\u52a1\u5361\u7247\u4e0d\u652f\u6301\u5f15\u5165\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u3002", (String)"FaCurCardFinEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
            }
            if (Objects.isNull(workLoadUnit = sourceData.get("workloadunit"))) {
                sourceData.put("workloadunit", null);
                continue;
            }
            String workLoadUnitNumber = (String)((Map)workLoadUnit).get("number");
            if (StringUtils.isBlank((CharSequence)workLoadUnitNumber) || existsWorkLoadUnits.contains(workLoadUnitNumber)) continue;
            e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u5355\u4f4d\uff1a%s \u4e0d\u5b58\u5728\u3002", (String)"FaCurCardFinEditPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]), workLoadUnitNumber));
        }
    }

    private Set<String> getExistsUnitNumberMap(Set<String> workLoadUnitNumbers) {
        Set<String> existsWorkLoadUnits = new HashSet<String>(workLoadUnitNumbers.size());
        if (workLoadUnitNumbers.size() > 0) {
            QFilter[] qFilters = new QFilter[]{new QFilter("number", "in", workLoadUnitNumbers)};
            String selectProperties = Fa.comma((String[])new String[]{"number"});
            Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)selectProperties, (QFilter[])qFilters);
            existsWorkLoadUnits = map.values().stream().map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toSet());
        }
        return existsWorkLoadUnits;
    }

    public void afterImportData(ImportDataEventArgs e) {
        new FinCardImportHandler().handleImport((BillModel)this.getModel(), e);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"buttonap", "spli_billno", "spli_afternumber", "changebillnumber", "clearbillnumber", "dispatchbillnumber", "devaluebillno", "depreadjustbillno", "merge_billno", "sm_billno"});
        Tab bizTab = (Tab)this.getControl("tb_bissinessrecord");
        bizTab.addTabSelectListener(this::tabSelected);
        IDataModel model = this.getModel();
        BasedataEdit depreuseF7 = (BasedataEdit)this.getControl("depreuse");
        depreuseF7.addBeforeF7SelectListener(e -> {
            long org = (Long)model.getValue("org_id");
            QFilter orgf = new QFilter("org", "=", (Object)org);
            DynamicObjectCollection depreuses = QueryServiceHelper.query((String)"fa_assetbook", (String)"depreuse", (QFilter[])new QFilter[]{orgf});
            ArrayList<Object> depreuseidList = new ArrayList<Object>();
            for (DynamicObject depu : depreuses) {
                Object depreuseid = depu.get("depreuse");
                depreuseidList.add(depreuseid);
            }
            QFilter filter = new QFilter("id", "in", depreuseidList);
            ListShowParameter listShowp = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter listFilterParameter = listShowp.getListFilterParameter();
            listFilterParameter.getQFilters().add(filter);
        });
        FaUtils.showDepreAnalyzeButton((AbstractFormPlugin)this, (String)"depre_entry");
        EntryGrid entrysplibill = (EntryGrid)this.getControl("entrysplibill");
        entrysplibill.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryChangeBill = (EntryGrid)this.getControl("entrychangebill");
        entryChangeBill.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryClearBill = (EntryGrid)this.getControl("entryclearbill");
        entryClearBill.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid dispatchEntry = (EntryGrid)this.getControl("dispatch_entry");
        dispatchEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid devalueBillNo = (EntryGrid)this.getControl("entrydevalbill");
        devalueBillNo.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid depreAdjustEntry = (EntryGrid)this.getControl("depreadjustentry");
        depreAdjustEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid mergeEntry = (EntryGrid)this.getControl("merge_entry");
        mergeEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid splitMergeEntry = (EntryGrid)this.getControl("split_merge_entry");
        splitMergeEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts") && "[16,77]".equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fetchdepreinfo"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("fetchdepreinfo".equals(itemKey)) {
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity();
            long bookid = dataEntity.getLong("assetbook_id");
            Object masterId = dataEntity.get("realcard.masterid");
            HashSet<Object> masterIdSet = new HashSet<Object>();
            masterIdSet.add(masterId);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("fa_deprehelp");
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            data.put("assetBookId", Long.valueOf(bookid));
            data.put("masterids", masterIdSet);
            parameter.setCustomParam("data", data);
            this.getView().showForm(parameter);
        }
    }

    public void beforeBindData(EventObject e) {
        String formId;
        DynamicObject curPeriodDynObj;
        DynamicObject finCardDynObject;
        DynamicObject assetBook;
        BaseShowParameter baseShowParameter;
        Object queryPeriodId;
        super.beforeBindData(e);
        new BusinessRecordSectionHandler(this, this.getView()).handle();
        this.setShortCuts();
        this.getView().setVisible(Boolean.FALSE, new String[]{"fetchdepreinfo"});
        if (ProductSettingServiceHelper.hasBlackFeature((String)"fa", (String)"depre_forecast")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tab_depreforcast"});
        }
        if (this.workLoadDepreMethod()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"monthaddidepreamount"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"workload", "entry_sumworkload"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"workload", "entry_sumworkload"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"monthaddidepreamount"});
        }
        DynamicObject dynObj = this.getModel().getDataEntity();
        DynamicObject currency = dynObj.getDynamicObject("currency");
        DynamicObject basecurrency = dynObj.getDynamicObject("basecurrency");
        if (currency != null && basecurrency != null && !currency.getPkValue().equals(basecurrency.getPkValue())) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.setValue("showcurrency", (Object)Boolean.TRUE);
            model.endInit();
        }
        Long periodId = null;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof BaseShowParameter && Objects.nonNull(queryPeriodId = (baseShowParameter = (BaseShowParameter)formShowParameter).getCustomParam("queryPeriodId"))) {
            periodId = Long.parseLong(queryPeriodId.toString());
        }
        if (Objects.isNull(periodId) && Objects.nonNull(assetBook = (finCardDynObject = this.getModel().getDataEntity()).getDynamicObject("assetbook")) && Objects.nonNull(curPeriodDynObj = assetBook.getDynamicObject("curperiod")) && Objects.nonNull(curPeriodDynObj.getPkValue())) {
            periodId = (Long)curPeriodDynObj.getPkValue();
        }
        if ("fa_card_fin".equals(formId = this.getView().getFormShowParameter().getFormId()) || "fa_asset_card_fin".equals(formId)) {
            this.handleAddUpYearDepre(periodId);
        }
    }

    private void handleAddUpYearDepre(Long periodId) {
        if (Objects.isNull(periodId)) {
            logger.info("\u8d22\u52a1\u5361\u7247\u7f16\u8f91\u9875\u9762\u5904\u7406\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7, \u671f\u95f4\u5165\u53c2\u4e3a\u7a7a");
            return;
        }
        DynamicObject finCardDynObject = this.getModel().getDataEntity();
        DynamicObject assetBook = finCardDynObject.getDynamicObject("assetbook");
        if (Objects.isNull(assetBook)) {
            return;
        }
        long assetBookStartPeriod = (Long)assetBook.getDynamicObject("startperiod").getPkValue();
        Long bizPeriodId = finCardDynObject.getLong(Fa.id((String)"bizperiod"));
        Long endPeriodId = finCardDynObject.getLong(Fa.id((String)"endperiod"));
        long finCardPeriodId = finCardDynObject.getLong(Fa.id((String)"period"));
        boolean isSetAddUpYearDepreZero = AddUpYearDepreUtils.isSetAddUpYearDepreZero(bizPeriodId, endPeriodId, assetBookStartPeriod, periodId, finCardPeriodId);
        if (isSetAddUpYearDepreZero) {
            this.getModel().setValue("addupyeardepre", (Object)BigDecimal.ZERO);
        }
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject dynObj = model.getDataEntity();
        DynamicObject realCurCard = (DynamicObject)dynObj.get("realcard");
        if (!StringUtils.isBlank((Object)realCurCard)) {
            FormShowParameter showParamter = new FormShowParameter();
            showParamter.setFormId("fa_card_fin_realmsg");
            showParamter.getOpenStyle().setShowType(ShowType.InContainer);
            showParamter.getOpenStyle().setTargetKey("cardinformation");
            this.getView().showForm(showParamter);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        try {
            Long orgId;
            this.initData(e);
            String curFormId = this.getView().getFormShowParameter().getFormId();
            if ("fa_card_fin".equals(curFormId) && FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)(orgId = Long.valueOf(this.getModel().getDataEntity().getLong(Fa.id((String)"org")))))) {
                boolean isOriginData = (Boolean)this.getModel().getValue("originaldata");
                if (isOriginData) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "bar_submit", "bar_audit", "baritemap"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit", "bar_audit", "baritemap"});
                }
            }
        }
        catch (Throwable e1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanel"});
            logger.info(ThrowableHelper.toString((Throwable)e1));
            this.getView().showErrorNotification(e1.getMessage());
        }
    }

    private void initData(EventObject e) {
        DynamicObject realCard;
        IDataModel thisModel = this.getModel();
        if (null != this.getModel().getValue("billstatus") && BillStatus.C.toString().equals(this.getModel().getValue("billstatus").toString())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flex_bissinessrecord"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_bissinessrecord"});
        }
        Long assetBookId = 0L;
        Long assetCatId = 0L;
        boolean fromDatabase = thisModel.getDataEntity().getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            DynamicObject finCard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)Fa.join((String)",", (String[])new String[]{"assetbook_id", "assetcat_id"}), (QFilter[])new QFilter("id", "=", (Object)thisModel.getDataEntity().getLong("id")).toArray());
            assetBookId = finCard.getLong("assetbook_id");
            assetCatId = finCard.getLong("assetcat_id");
        } else {
            assetBookId = thisModel.getDataEntity().getLong("assetbook_id");
            assetCatId = thisModel.getDataEntity().getLong("assetcat_id");
        }
        if (assetBookId != 0L && assetCatId != 0L) {
            DynamicObject assetPolicyEntry = AssetPolicyUtil.getByBookAndCat((Object)assetBookId, (Object)assetCatId);
            thisModel.setValue("netresidualvalrate", assetPolicyEntry.get("netresidualvalrate"));
            String decPolicy = assetPolicyEntry.getString("decpolicy");
            boolean noDepre = assetPolicyEntry.getBoolean("nodepre");
            if ("1".equals(decPolicy)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"decval"});
                this.getModel().setValue("decval", (Object)new BigDecimal("0"));
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"decval"});
            }
            if (noDepre) {
                this.getModel().setValue("depredamount", (Object)new BigDecimal("0"));
                this.getModel().setValue("accumdepre", (Object)new BigDecimal("0"));
                this.getView().setEnable(Boolean.FALSE, new String[]{"depredamount"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"accumdepre"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"depredamount"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"accumdepre"});
            }
        }
        this.setCurrencyRateEditable();
        try {
            BigDecimal netAmount;
            BigDecimal netWorth = (BigDecimal)thisModel.getValue("networth");
            if (BigDecimal.ZERO.compareTo(netWorth) == 0) {
                this.setNetWorth();
            }
            if (BigDecimal.ZERO.compareTo(netAmount = (BigDecimal)thisModel.getValue("netamount")) == 0) {
                this.setNetAmount();
            }
        }
        catch (Throwable e1) {
            throw new KDBizException(new ErrorCode("UNKNOWN_ERR", String.format(ResManager.loadKDString((String)"%s\r\n\u8bbe\u7f6e \u51c0\u503c \u51c0\u989d \u5931\u8d25\u3002", (String)"FaCurCardFinEditPlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0]), e1.getMessage())), new Object[0]);
        }
        this.dynamicModifyDepreField();
        String formId = ((BillView)e.getSource()).getFormId();
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if ("A".equals(this.getModel().getValue("billstatus")) && !formId.equals("fa_initcard_fin") && !formId.equals("fa_asset_cardinit_fin") && !"fa_split_asset_cards".equals(parentFormId)) {
            this.setFinDate();
        }
        if ((realCard = this.getRealCard()) != null) {
            if (SourceFlagEnum.INITLEASECONTRACT.name().equals(realCard.getString("sourceflag"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"originalval", "preusingamount", "depredamount", "accumdepre", "addupyeardepre", "depreuse"});
            } else if (SourceFlagEnum.LEASECONTRACT.name().equals(realCard.getString("sourceflag"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"originalval", "preusingamount", "depreuse"});
            }
            String sourceFlag = realCard.getString("sourceflag");
            if (SourceFlagEnum.LEASECONTRACT.name().equals(sourceFlag) || SourceFlagEnum.INITLEASECONTRACT.name().equals(sourceFlag)) {
                this.getModel().setValue("showcurrency", (Object)false);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"showcurrency"});
                Long srcContractId = realCard.getLong("srcbillid");
                DynamicObject contract = QueryServiceHelper.queryOne((String)"fa_lease_contract", (String)"depretype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcContractId)});
                if (contract != null) {
                    String depreType = contract.getString("depretype");
                    if (LeaseContractDepreTypeEnum.DAY.getValue().equals(depreType)) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"depremethod"});
                    }
                }
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void setFinDate() {
        IDataModel model = this.getModel();
        DateEdit dateEndEdit = (DateEdit)this.getControl("finaccountdate");
        DynamicObject book = (DynamicObject)model.getValue("assetbook");
        if (book != null) {
            DynamicObject curperiod = book.getDynamicObject("curperiod");
            DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate", (QFilter[])new QFilter[]{new QFilter("id", "=", curperiod.get("id"))});
            if (period == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u672a\u627e\u5230\u8d26\u7c3f\u7ed1\u5b9a\u7684\u671f\u95f4\uff0c\u8bf7\u786e\u8ba4\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u662f\u5426\u6b63\u786e\u3002", (String)"FaCurCardFinEditPlugin_10", (String)"fi-fa-formplugin", (Object[])new Object[0]), ((DynamicObject)model.getValue("org")).getString("name")));
                this.getView().setEnable(Boolean.FALSE, new String[]{title});
                return;
            }
            Date begindate = (Date)period.get("begindate");
            if (begindate == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u662f\u5426\u5f02\u5e38\u3002", (String)"FaCurCardFinEditPlugin_11", (String)"fi-fa-formplugin", (Object[])new Object[0]), ((DynamicObject)model.getValue("org")).getString("name")));
                this.getView().setEnable(Boolean.FALSE, new String[]{title});
                return;
            }
            dateEndEdit.setMinDate(begindate);
            Date finaccountdate = (Date)model.getValue("finaccountdate");
            if (finaccountdate == null || finaccountdate.before(begindate)) {
                model.setValue("finaccountdate", (Object)begindate);
            }
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{title});
    }

    private void setCurrencyRateEditable() {
        IDataModel thisModel = this.getModel();
        DynamicObject dynObj = thisModel.getDataEntity();
        DynamicObject currencyObj = (DynamicObject)thisModel.getValue("currency");
        DynamicObject assetBookDO = dynObj.getDynamicObject("assetbook");
        if (assetBookDO == null) {
            return;
        }
        DynamicObject baseCurrency = FaAssetBookDaoFactory.getInstance().queryCurrencyByBook(assetBookDO.getPkValue());
        if (baseCurrency == null) {
            return;
        }
        if (currencyObj != null && currencyObj.getString("number").equals(baseCurrency.getString("number"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"currencyrate"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"currencyrate"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String depreuse;
        String propName = e.getProperty().getName();
        IDataModel thisModel = this.getModel();
        if ("workloadunit".equals(propName)) {
            Object depredAmount;
            IFormView formView = this.getView();
            DynamicObject workLoadUnit = (DynamicObject)formView.getModel().getValue("workloadunit");
            int precision = 0;
            String name = "";
            RoundingMode roundingMode = RoundingMode.HALF_UP;
            if (Objects.nonNull(workLoadUnit)) {
                precision = (Integer)workLoadUnit.get("precision");
                name = workLoadUnit.getString("name");
                String precisionAccount = workLoadUnit.getString("precisionaccount");
                if ("2".equals(precisionAccount)) {
                    roundingMode = RoundingMode.DOWN;
                } else if ("3".equals(precisionAccount)) {
                    roundingMode = RoundingMode.UP;
                }
            }
            ((Label)formView.getControl("labelap6")).setText(name);
            Object preUsingaMount = formView.getModel().getValue("preusingamount");
            if (Objects.nonNull(preUsingaMount)) {
                BigDecimal preUsingaMountBigDecimal = (BigDecimal)preUsingaMount;
                preUsingaMountBigDecimal = preUsingaMountBigDecimal.setScale(precision, roundingMode);
                formView.getModel().setValue("preusingamount", (Object)preUsingaMountBigDecimal);
            }
            if (Objects.nonNull(depredAmount = formView.getModel().getValue("depredamount"))) {
                BigDecimal depredAmountBigDecimal = (BigDecimal)depredAmount;
                depredAmountBigDecimal = depredAmountBigDecimal.setScale(precision, roundingMode);
                formView.getModel().setValue("depredamount", (Object)depredAmountBigDecimal);
            }
            HashMap item = new HashMap();
            HashMap<String, String> sc = new HashMap<String, String>();
            sc.put("sc", String.valueOf(precision));
            item.put("item", sc);
            formView.updateControlMetadata("depredamount", item);
            formView.updateControlMetadata("preusingamount", item);
        }
        if (FaUtils.isFieldEmpty((IDataModel)thisModel, (String)"billstatus").booleanValue() || !thisModel.getValue("billstatus").toString().equals(BillStatus.A.toString()) || "accumdepre".equalsIgnoreCase(propName)) {
            // empty if block
        }
        DynamicObject realcard = this.getRealCard();
        if ("showcurrency".equalsIgnoreCase(propName) && !"PURCHASE".equals(realcard.get("sourceflag"))) {
            thisModel.setValue("currency", thisModel.getValue("basecurrency"));
            boolean showcurrency = (Boolean)thisModel.getValue("showcurrency");
            this.getView().setEnable(Boolean.valueOf(!showcurrency), new String[]{"originalval"});
        } else if ("currency".equalsIgnoreCase(propName)) {
            this.setCurrencyRate();
        } else if ("currencyrate".equalsIgnoreCase(propName) || "originalamount".equalsIgnoreCase(propName)) {
            this.setPurOriginalValue();
        } else if ("currency".equalsIgnoreCase(FaUtils.removeString_id((String)propName))) {
            this.setPreResidualVal();
        } else if ("originalval".equalsIgnoreCase(propName)) {
            this.setNetWorth();
            this.setPreResidualVal();
            boolean showcurrency = (Boolean)this.getModel().getValue("showcurrency");
            if (!showcurrency) {
                thisModel.setValue("originalamount", this.getModel().getValue("originalval"));
            }
        } else if ("accumdepre".equalsIgnoreCase(propName)) {
            this.setNetWorth();
        } else if ("networth".equalsIgnoreCase(propName) || "decval".equalsIgnoreCase(propName)) {
            this.setNetAmount();
        } else if ("depremethod".equalsIgnoreCase(propName)) {
            if (this.workLoadDepreMethod()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"workload", "entry_sumworkload"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"monthaddidepreamount"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"workload", "entry_sumworkload"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"monthaddidepreamount"});
            }
            this.dynamicModifyDepreField();
        } else if ("finaccountdate".equals(propName)) {
            long periodType = ((DynamicObject)thisModel.getValue("assetbook")).getLong("periodtype.id");
            DynamicObject pd = PeriodUtil.getPeriodByDate((Date)((Date)thisModel.getValue("finaccountdate")), (String)"id", (long)periodType);
            Long perioid = (Long)thisModel.getValue("period_id");
            Long bizPeriod = (Long)thisModel.getValue("bizperiod_id");
            if (perioid == 0L && bizPeriod == 0L) {
                return;
            }
            if (pd == null) {
                thisModel.setValue("finaccountdate", e.getChangeSet()[0].getOldValue());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5165\u8d26\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u3002", (String)"FaCurCardFinEditPlugin_12", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            thisModel.setValue("period", pd.get("id"));
            thisModel.setValue("bizperiod", pd.get("id"));
            this.setCurrencyRate();
        } else if ("depreuse".equals(propName) && (depreuse = this.getPageCache().get("depreuse")) != null && !depreuse.equals("")) {
            thisModel.setValue("depreuse", (Object)Long.parseLong(this.getPageCache().get("depreuse")));
        }
    }

    private void dynamicModifyDepreField() {
        IFormView formView = this.getView();
        HashMap item = new HashMap();
        HashMap<String, String> sc = new HashMap<String, String>();
        String monthAddiDepreAmountCaption = ResManager.loadKDString((String)"\u672c\u671f\u6298\u65e7\u671f\u6570", (String)"FaCurCardFinEditPlugin_20", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        if (this.workLoadDepreMethod()) {
            formView.setVisible(Boolean.TRUE, new String[]{"workloadunit"});
            DynamicObject workloadunit = (DynamicObject)formView.getModel().getValue("workloadunit");
            int precision = 0;
            String name = "";
            if (workloadunit != null) {
                precision = (Integer)workloadunit.get("precision");
                name = workloadunit.getString("name");
            }
            sc.put("sc", String.valueOf(precision));
            ((Label)formView.getControl("labelap7")).setText("");
            ((Label)formView.getControl("labelap6")).setText(name);
            monthAddiDepreAmountCaption = ResManager.loadKDString((String)"\u672c\u671f\u5de5\u4f5c\u91cf", (String)"FaCurCardFinEditPlugin_22", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"workloadunit"});
            formView.getModel().setValue("workloadunit", null);
            String showLabelName = "";
            if (this.isDayDepre()) {
                showLabelName = ResManager.loadKDString((String)"\u5929", (String)"FaCurCardFinEditPlugin_19", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                monthAddiDepreAmountCaption = ResManager.loadKDString((String)"\u672c\u671f\u6298\u65e7\u5929\u6570", (String)"FaCurCardFinEditPlugin_21", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            } else {
                showLabelName = ResManager.loadKDString((String)"\u671f", (String)"FaCurCardFinEditPlugin_13", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            }
            ((Label)formView.getControl("labelap7")).setText(showLabelName);
            ((Label)formView.getControl("labelap6")).setText(showLabelName);
            sc.put("sc", "0");
        }
        ((DecimalEdit)formView.getControl("monthaddidepreamount")).setCaption(new LocaleString(monthAddiDepreAmountCaption));
        item.put("item", sc);
        formView.updateControlMetadata("depredamount", item);
        formView.updateControlMetadata("preusingamount", item);
    }

    private boolean workLoadDepreMethod() {
        DynamicObject depreDynamic = (DynamicObject)this.getModel().getValue("depremethod");
        String depreMethodType = null;
        if (depreDynamic != null) {
            depreMethodType = depreDynamic.getString("type");
        }
        if (depreMethodType != null) {
            return "5".equals(depreMethodType);
        }
        return false;
    }

    private boolean isDayDepre() {
        DynamicObject depreDynamic = (DynamicObject)this.getModel().getValue("depremethod");
        if (depreDynamic != null) {
            String depreMethodType = depreDynamic.getString("type");
            return "51".equalsIgnoreCase(depreMethodType);
        }
        return false;
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        if ("depreuse".equals(propName)) {
            Object aftDepreUse = e.getChangeSet()[0].getNewValue();
            DynamicObject befDepreUse = (DynamicObject)e.getChangeSet()[0].getOldValue();
            String billstatus = (String)this.getModel().getValue("billstatus");
            if (aftDepreUse == null) {
                this.getPageCache().put("depreuse", befDepreUse.getString("id"));
                return;
            }
            long aftId = 0L;
            aftId = aftDepreUse instanceof Long ? (Long)aftDepreUse : (aftDepreUse instanceof String ? Long.parseLong((String)aftDepreUse) : ((DynamicObject)aftDepreUse).getLong("id"));
            String oldDepre = this.getPageCache().get("befDepreUse");
            if (oldDepre != null && oldDepre.length() > 0 && oldDepre.equals(String.valueOf(aftId))) {
                this.getPageCache().put("befDepreUse", null);
                this.getPageCache().put("aftDepreUse", null);
                return;
            }
            if (befDepreUse == null || befDepreUse.getLong("id") == aftId) {
                this.getPageCache().put("depreuse", "");
                return;
            }
            String parentFormId = this.getView().getFormShowParameter().getParentFormId();
            if ("fa_asset_card".equals(parentFormId) || "fa_asset_initcard".equals(parentFormId) || "fa_split_asset_cards".equals(parentFormId)) {
                this.updateCacheFinCardForAssetCard(befDepreUse);
            }
            if ("A".equals(billstatus) && !"fa_asset_card".equals(parentFormId) && !"fa_split_asset_cards".equals(parentFormId)) {
                this.getPageCache().put("befDepreUse", befDepreUse.getString("id"));
                this.getPageCache().put("aftDepreUse", String.valueOf(aftId));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6298\u65e7\u7528\u9014\u89c6\u4e3a\u9000\u51fa\u5e76\u91cd\u65b0\u6253\u5f00\u65b0\u7684\u8d22\u52a1\u5361\u7247\uff0c\u786e\u5b9a\u8981\u5207\u6362\u5417\uff1f", (String)"FaCurCardFinEditPlugin_14", (String)"fi-fa-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("changeDepreUse", (IFormPlugin)this));
            } else {
                DynamicObject finCard = this.getFinCard(aftId);
                if (finCard == null) {
                    this.getPageCache().put("depreuse", befDepreUse.getString("id"));
                    return;
                }
                model.createNewData((Object)finCard);
                if ("fa_split_asset_cards".equals(parentFormId)) {
                    this.getView().setStatus(OperationStatus.EDIT);
                }
                this.getView().updateView();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IDataModel model = this.getModel();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("changeDepreUse".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                long depreuse = Long.parseLong(this.getPageCache().get("aftDepreUse"));
                DynamicObject fincard = this.getFinCard(depreuse);
                if (fincard == null) {
                    model.setValue("depreuse", (Object)this.getPageCache().get("befDepreUse"));
                    return;
                }
                model.createNewData((Object)fincard);
                this.getView().updateView();
            } else {
                model.setValue("depreuse", (Object)this.getPageCache().get("befDepreUse"));
            }
            this.getPageCache().put("befDepreUse", null);
            this.getPageCache().put("aftDepreUse", null);
        }
    }

    private DynamicObject getFinCard(Long depreuse) {
        Boolean queryOriData;
        IFormView view = this.getView();
        String parentFormId = view.getFormShowParameter().getParentFormId();
        if ("fa_asset_card".equals(parentFormId) || "fa_asset_initcard".equals(parentFormId) || "fa_split_asset_cards".equals(parentFormId)) {
            IFormView parentView = view.getParentView();
            String cacheDepreUseCard = parentView.getPageCache().get("depreUseCard");
            Map depreUseCardMap = (Map)SerializationUtils.deSerializeFromBase64((String)cacheDepreUseCard);
            return (DynamicObject)depreUseCardMap.get(depreuse);
        }
        String number = (String)this.getModel().getValue("number");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgid = org.getLong("id");
        String queryOriDataCacheStr = this.getPageCache().get(CACHE_KEY_QUERYORIDATA);
        if (StringUtils.isEmpty((CharSequence)queryOriDataCacheStr)) {
            queryOriData = (Boolean)this.getModel().getValue("originaldata");
            this.getPageCache().put(CACHE_KEY_QUERYORIDATA, String.valueOf(queryOriData));
        } else {
            queryOriData = Boolean.parseBoolean(queryOriDataCacheStr);
        }
        DynamicObject finCard = queryOriData != false ? FaUtils.getOriFinCardByNumberOrgAndDepreuse((String)number, (long)orgid, (long)depreuse) : FaUtils.getFinCardByNumberOrgAndDepreuse((String)number, (long)orgid, (long)depreuse);
        if (finCard != null) {
            DynamicObject fin = BusinessDataServiceHelper.loadSingle((Object)finCard.getLong("id"), (String)this.getModel().getDataEntityType().getName());
            return fin;
        }
        return null;
    }

    private void updateCacheFinCardForAssetCard(DynamicObject befDepreUse) {
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        List<String> assetCardNames = Arrays.asList("fa_asset_card", "fa_asset_initcard", "fa_split_asset_cards");
        if (!assetCardNames.contains(parentFormId)) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        DynamicObject finCard = this.getModel().getDataEntity(true);
        finCard.set("depreuse", (Object)befDepreUse);
        String cacheDepreUseCard = parentView.getPageCache().get("depreUseCard");
        Map depreUseCardMap = (Map)SerializationUtils.deSerializeFromBase64((String)cacheDepreUseCard);
        depreUseCardMap.put(befDepreUse.getLong("id"), finCard);
        cacheDepreUseCard = SerializationUtils.serializeToBase64((Object)depreUseCardMap);
        parentView.getPageCache().put("depreUseCard", cacheDepreUseCard);
    }

    protected DynamicObject getRealCard() {
        IFormView view = this.getView();
        String parentFormId = view.getFormShowParameter().getParentFormId();
        if ("fa_asset_card".equals(parentFormId) || "fa_asset_initcard".equals(parentFormId) || "fa_split_asset_cards".equals(parentFormId)) {
            IFormView parentView = view.getParentView();
            return parentView.getModel().getDataEntity(true);
        }
        return (DynamicObject)this.getModel().getValue("realcard");
    }

    protected DynamicObject getAssetPolicyEntryByBook(long depresystemId, String assetCatLongNumber) {
        DynamicObject dyn = null;
        dyn = BusinessDataServiceHelper.loadSingle((Object)depresystemId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_depresystem"));
        DynamicObjectCollection entrysDOC = dyn.getDynamicObjectCollection("assetpolicy_entry");
        DynamicObject selectedRow = null;
        int index = 999;
        for (int i = 0; i < entrysDOC.size(); ++i) {
            DynamicObject wholeRow = (DynamicObject)entrysDOC.get(i);
            DynamicObject rowAssetCat = (DynamicObject)wholeRow.get("assetcat");
            String rowAssetCatNumber = rowAssetCat.getString("longnumber");
            if (assetCatLongNumber.indexOf(rowAssetCatNumber) != 0) continue;
            int differenceLength = assetCatLongNumber.length() - rowAssetCatNumber.length();
            if (differenceLength == 0) {
                selectedRow = wholeRow;
                break;
            }
            if (differenceLength >= index) continue;
            index = differenceLength;
            selectedRow = wholeRow;
        }
        return selectedRow;
    }

    private BigDecimal setPurOriginalValue() {
        DataModelWrapper objWrapper = new DataModelWrapper(this.getModel());
        return FinCardCalc.setPurOriginalValue((IObjWrapper)objWrapper);
    }

    private void setCurrencyRate() {
        DataModelWrapper objWrapper = new DataModelWrapper(this.getModel());
        boolean isBaseCurrency = FinCardCalc.setCurrencyRate((IObjWrapper)objWrapper);
        if (isBaseCurrency) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"currencyrate"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"currencyrate"});
        }
    }

    private BigDecimal setPreResidualVal() {
        DynamicObject basecurrency;
        DataModelWrapper objWrapper = new DataModelWrapper(this.getModel());
        BigDecimal preResidualVal = FinCardCalc.setPreResidualVal((IObjWrapper)objWrapper, (boolean)true, (DynamicObject)(basecurrency = (DynamicObject)this.getModel().getValue("basecurrency")));
        if (preResidualVal == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u6839\u636e\u8d44\u4ea7\u7c7b\u522b\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u653f\u7b56\uff0c\u65e0\u6cd5\u786e\u5b9a\u6b8b\u503c\u7387\u8fdb\u800c\u8ba1\u7b97\u9884\u8ba1\u51c0\u6b8b\u503c\u3002", (String)"FaCurCardFinEditPlugin_15", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        return preResidualVal;
    }

    private BigDecimal setNetWorth() {
        DataModelWrapper objWrapper = new DataModelWrapper(this.getModel());
        return FinCardCalc.setNetWorth((IObjWrapper)objWrapper);
    }

    private BigDecimal setNetAmount() {
        DataModelWrapper objWrapper = new DataModelWrapper(this.getModel());
        return FinCardCalc.setNetAmount((IObjWrapper)objWrapper);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String billstatus;
        super.beforeClosed(e);
        OperationStatus s = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)s)) {
            e.setCheckDataChange(false);
        }
        if ("C".equalsIgnoreCase(billstatus = (String)this.getModel().getValue("billstatus"))) {
            e.setCheckDataChange(false);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String linkField = e.getFieldName();
        if ("spli_billno".equals(linkField)) {
            Long id = ((DynamicObject)this.getModel().getEntryEntity("entrysplibill").get(e.getRowIndex())).getLong("spli_billid");
            if (id != null && id != 0L) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("fa_assetsplitbill");
                parameter.setPkId((Object)id);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else if ("spli_afternumber".equals(linkField)) {
            Long id = ((DynamicObject)this.getModel().getEntryEntity("entrysplibill").get(e.getRowIndex())).getLong("spli_afterid");
            if (id != null && id != 0L) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("fa_card_real");
                parameter.setPkId((Object)id);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else if ("changebillnumber".equals(linkField)) {
            Long id = ((DynamicObject)this.getModel().getEntryEntity("entrychangebill").get(e.getRowIndex())).getLong("changebillid");
            if (id != null && id != 0L) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("fa_change_dept");
                parameter.setPkId((Object)id);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else if ("clearbillnumber".equals(linkField)) {
            Long id = ((DynamicObject)this.getModel().getEntryEntity("entryclearbill").get(e.getRowIndex())).getLong("clearbillid");
            String sourceBill = ((DynamicObject)this.getModel().getEntryEntity("entryclearbill").get(e.getRowIndex())).getString("clearsourcebill");
            if (id != null && id != 0L) {
                BillShowParameter parameter = new BillShowParameter();
                if ("fa_clearbill".equals(sourceBill)) {
                    parameter.setFormId("fa_clearbill");
                } else if ("fa_restartrealbill".equals(sourceBill)) {
                    parameter.setFormId("fa_restartrealbill");
                }
                parameter.setPkId((Object)id);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else if ("dispatchbillnumber".equals(linkField)) {
            Long id = ((DynamicObject)this.getModel().getEntryEntity("dispatch_entry").get(e.getRowIndex())).getLong("dispatchbillid");
            if (id != null && id != 0L) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("fa_dispatch_in");
                parameter.setPkId((Object)id);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else if ("devaluebillno".equals(linkField)) {
            Long id = ((DynamicObject)this.getModel().getEntryEntity("entrydevalbill").get(e.getRowIndex())).getLong("devalueid");
            if (id != null && id != 0L) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("fa_asset_devalue");
                parameter.setPkId((Object)id);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else if ("depreadjustbillno".equals(linkField)) {
            Long id = ((DynamicObject)this.getModel().getEntryEntity("depreadjustentry").get(e.getRowIndex())).getLong("depreadjustid");
            if (id != null && id != 0L) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("fa_depreadjustbill");
                parameter.setPkId((Object)id);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else if ("merge_billno".equals(linkField)) {
            Long id = ((DynamicObject)this.getModel().getEntryEntity("merge_entry").get(e.getRowIndex())).getLong("mergebillid");
            if (id != null && id != 0L) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("fa_mergebill");
                parameter.setPkId((Object)id);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else if ("sm_billno".equals(linkField)) {
            Long id = ((DynamicObject)this.getModel().getEntryEntity("split_merge_entry").get(e.getRowIndex())).getLong("sm_billid");
            String type = ((DynamicObject)this.getModel().getEntryEntity("split_merge_entry").get(e.getRowIndex())).getString("sm_billtype");
            if (id != null && id != 0L) {
                BillShowParameter parameter = new BillShowParameter();
                if (BizStatusEnum.MERGING.name().equals(type)) {
                    parameter.setFormId("fa_mergebill");
                } else {
                    parameter.setFormId("fa_assetsplitbill");
                }
                parameter.setPkId((Object)id);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    private void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if ("tab_depreforcast".equals(tabKey) && fromDatabase) {
            DynamicObject realCard = this.getRealCard();
            if (realCard == null) {
                logger.info("FaCurCardFinEditPlugin: real card is null");
                return;
            }
            long masterId = realCard.getLong("masterid");
            DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"id", (QFilter[])new QFilter("masterid", "=", (Object)masterId).toArray());
            List<Long> realCardIds = realCards.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            long orgId = (Long)this.getModel().getValue(Fa.id((String)"org"));
            long depreUseId = (Long)this.getModel().getValue(Fa.id((String)"depreuse"));
            new BusinessRecordSectionHandler(this, this.getView()).fillDepreForcastTab(realCardIds, depreUseId, orgId);
            this.getView().updateView("depreforecast_entry");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        try {
            FormOperate operate = (FormOperate)args.getSource();
            String operateType = operate.getType();
            if (operateType.equals("unaudit") || operateType.equals("delete")) {
                IDataModel thisModel = this.getModel();
                Long perioid = (Long)thisModel.getValue("period_id");
                Long bizPeriod = (Long)thisModel.getValue("bizperiod_id");
                String entityId = operate.getEntityId();
                String operateKey = operate.getOperateKey();
                String orgId = thisModel.getValue("org_id") + "";
                String number = (String)thisModel.getValue("number");
                if (perioid.longValue() != bizPeriod.longValue()) {
                    Long bookId = (Long)thisModel.getValue("assetbook_id");
                    QFilter[] bookFilters = new QFilter[]{new QFilter("id", "=", (Object)bookId)};
                    DynamicObject bookDy = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"curperiod", (QFilter[])bookFilters);
                    Long curBookId = bookDy.getLong("curperiod");
                    if (perioid.longValue() != curBookId.longValue()) {
                        this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801%s\u975e\u672c\u671f\u65b0\u589e\uff0c\u4e0d\u80fd\u505a\u53cd\u5ba1\u6838\u3001\u5220\u9664\u7c7b\u578b\u64cd\u4f5c\u3002", (String)"FaCurCardFinEditPlugin_16", (String)"fi-fa-formplugin", (Object[])new Object[0]), number));
                        args.setCancel(true);
                    }
                } else if (entityId.equals("fa_card_fin") && !operateKey.equals("unaudit")) {
                    String logStr = String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8d22\u52a1\u5361\u7247\u64cd\u4f5c\uff1a\u5bf9\u5355\u636e%1$s\u91c7\u53d6\u975e\u6807\u51c6\u4ea7\u54c1\u64cd\u4f5c%2$s\uff0c\u5bf9\u5e94\u7684\u8d44\u4ea7\u7f16\u7801\u4e3a%3$s\u3002", (String)"FaCurCardFinEditPlugin_17", (String)"fi-fa-formplugin", (Object[])new Object[0]), entityId, operateKey, number);
                    FaOperateLogUtil.insetFaIllegalOperateLog((String)orgId, (String)entityId, (String)operateKey, (String)logStr);
                } else if (entityId.equals("fa_initcard_fin")) {
                    String logStr = String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8d22\u52a1\u5361\u7247\u64cd\u4f5c\uff1a\u5bf9\u5355\u636e%1$s\u91c7\u53d6\u975e\u6807\u51c6\u4ea7\u54c1\u64cd\u4f5c%2$s\uff0c\u5bf9\u5e94\u7684\u8d44\u4ea7\u7f16\u7801\u4e3a%3$s\u3002", (String)"FaCurCardFinEditPlugin_17", (String)"fi-fa-formplugin", (Object[])new Object[0]), entityId, operateKey, number);
                    FaOperateLogUtil.insetFaIllegalOperateLog((String)orgId, (String)entityId, (String)operateKey, (String)logStr);
                }
            }
        }
        catch (Exception e) {
            logger.error("illegal:" + ThrowableHelper.toString((Throwable)e));
        }
    }
}

