/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.business.validator.AssetDeValueValidator;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaQFilter;

public class FaDeValueAsset
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private boolean whenLoadData = true;
    private static final String DEV1 = "2";
    private static final String DEV2 = "3";
    private static final String DEV4 = "4";
    private static Log logger = LogFactory.getLog(FaDeValueAsset.class);
    static String[] selectFields = new String[]{"id", "originalval", "netamount", "networth", "monthdepre", "monthdeprechg", "preresidualval", "accumdepre", "decval", "currency", "depreuse", "bizperiod", "assetbook", "number"};
    static String[] selectImportFields = new String[]{"id", "assetcat", "originalval", "netamount", "networth", "monthdepre", "monthdeprechg", "preresidualval", "accumdepre", "decval", "currency", "depreuse", "bizperiod", "assetbook", "number"};

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"devalue_depttoolbarap"});
        BasedataEdit realCardCtr = (BasedataEdit)this.getControl("realcard");
        realCardCtr.addBeforeF7SelectListener(v -> FaQFilter.realCardQFilter(this.getModel(), v));
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        if (orgF7 != null) {
            orgF7.setIsOnlyDisplayOrgLeaves(true);
            orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit depreuseidF7 = (BasedataEdit)this.getControl("depreuse");
        depreuseidF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            logger.info("org:" + org.toString());
            try {
                this.updateToDepreuse(org);
                DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
                if (depreuse == null || depreuse.getLong("id") == 0L) {
                    model.setValue("devalueperiod", null);
                } else {
                    DynamicObject[] assetBook = FaAssetBookDaoFactory.getInstance().query(new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("depreuse", "=", (Object)depreuse.getLong("id"))});
                    DynamicObject curperiod = assetBook[0].getDynamicObject("curperiod");
                    if (curperiod == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8d44\u4ea7\u8d26\u7c3f\u672a\u8bbe\u7f6e\u201c\u51cf\u503c\u671f\u95f4\u201d\u3002", (String)"FaDeValueAsset_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                    DynamicObject nextPeriod = FaBizUtils.queryNeighborPeriodByDo((DynamicObject)curperiod, (int)1);
                    if (nextPeriod == null) {
                        nextPeriod = curperiod;
                    }
                    this.getModel().setValue("devalueperiod", curperiod.getPkValue());
                    Date endDate = curperiod.getDate("enddate");
                    endDate = DateUtil.stripTime((Date)endDate);
                    this.getModel().setValue("businessdate", (Object)endDate);
                    this.getModel().setValue("bizdate", (Object)nextPeriod.getDate("begindate"), 0);
                    this.setCurrency();
                    this.setBizDateRange(curperiod, nextPeriod);
                }
            }
            catch (Exception exc) {
                this.getView().showErrorNotification(exc.getMessage());
            }
            finally {
                super.afterCreateNewData(e);
            }
        }
    }

    private void updateToDepreuse(DynamicObject org) {
        DynamicObject assetBook = FaAssetBookDaoFactory.getInstance().queryMainBookByOrg(org.getPkValue());
        if (assetBook != null && "1".equals(assetBook.getString("enable"))) {
            this.getModel().setValue("depreuse", assetBook.getDynamicObject("depreuse").getPkValue());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String f7Name = arg.getProperty().getName();
        DynamicObject assetBookOrg = (DynamicObject)this.getModel().getValue("org");
        ListShowParameter cardF7Param = (ListShowParameter)arg.getFormShowParameter();
        ListFilterParameter listFilterParameter = cardF7Param.getListFilterParameter();
        switch (f7Name) {
            case "org": {
                List orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_asset_devalue");
                listFilterParameter.getQFilters().add(new QFilter("id", "in", (Object)orgIds));
                break;
            }
            case "depreuse": {
                DynamicObject[] finCards = FaAssetBookDaoFactory.getInstance().query(new QFilter[]{new QFilter("org", "=", assetBookOrg.getPkValue()), new QFilter("status", "=", (Object)BillStatus.C.toString())});
                Object[] ids = Stream.of(finCards).map(v -> v.getDynamicObject("depreuse").getPkValue()).collect(Collectors.toList()).toArray();
                listFilterParameter.getQFilters().add(new QFilter("id", "in", (Object)ids));
                break;
            }
            case "realcard": {
                DynamicObject depreuse = (DynamicObject)this.getModel().getValue("depreuse");
                if (depreuse == null || depreuse.getLong("id") == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"FaDeValueAsset_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                DynamicObject[] assetBook = FaAssetBookDaoFactory.getInstance().query(new QFilter[]{new QFilter("org", "=", assetBookOrg.getPkValue()), new QFilter("status", "=", (Object)BillStatus.C.toString()), new QFilter("depreuse", "=", depreuse.getPkValue())});
                if (assetBook == null || assetBook.length == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8d44\u4ea7\u8d26\u7c3f\u51fa\u9519\u3002", (String)"FaDeValueAsset_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                DynamicObject currentPeriod = assetBook[0].getDynamicObject("curperiod");
                if (currentPeriod != null) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8d44\u4ea7\u7ec4\u7ec7\u7684\u542f\u7528\u671f\u95f4\u3002", (String)"FaDeValueAsset_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeProperty = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject assetBookOrg = (DynamicObject)this.getModel().getValue("org");
        IDataModel model = this.getModel();
        switch (changeProperty) {
            case "depreuse": {
                DynamicObject newValue = (DynamicObject)changeData.getNewValue();
                if (newValue == null || newValue.getLong("id") == 0L) {
                    this.getModel().setValue("devalueperiod", null);
                } else {
                    DynamicObject[] assetBook = FaAssetBookDaoFactory.getInstance().query(new QFilter[]{new QFilter("org", "=", assetBookOrg.getPkValue()), new QFilter("depreuse", "=", (Object)newValue.getLong("id"))});
                    DynamicObject curperiod = assetBook[0].getDynamicObject("curperiod");
                    if (curperiod == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8d44\u4ea7\u8d26\u7c3f\u672a\u8bbe\u7f6e\u201c\u51cf\u503c\u671f\u95f4\u201d\u3002", (String)"FaDeValueAsset_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                    DynamicObject nextPeriod = FaBizUtils.queryNeighborPeriodByDo((DynamicObject)curperiod, (int)1);
                    if (nextPeriod == null) {
                        nextPeriod = curperiod;
                    }
                    this.getModel().setValue("devalueperiod", curperiod.getPkValue());
                    Date endDate = curperiod.getDate("enddate");
                    endDate = DateUtil.stripTime((Date)endDate);
                    this.getModel().setValue("businessdate", (Object)endDate);
                    this.setBizDateRange(curperiod, nextPeriod);
                    this.setCurrency();
                }
                this.getModel().deleteEntryData("changebillentry");
                break;
            }
            case "org": {
                if (null == assetBookOrg) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"FaDeValueAsset_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("org", changeData.getOldValue());
                    break;
                }
                this.updateToDepreuse(assetBookOrg);
                this.setCurrency();
                break;
            }
            case "realcard": {
                QFilter numberFilter;
                long bizperiod;
                QFilter endPeriodFilter;
                QFilter assetBookFilter;
                DynamicObject preFincard;
                int index = changeData.getRowIndex();
                DynamicObject realCard = (DynamicObject)changeData.getNewValue();
                if (realCard == null || realCard.getLong("id") == 0L) {
                    this.getModel().setValue("fincard", (Object)"", index);
                    break;
                }
                DynamicObject depreuse = (DynamicObject)this.getModel().getValue("depreuse");
                DynamicObject devalueperiod = (DynamicObject)this.getModel().getValue("devalueperiod");
                Date date = (Date)model.getValue("businessdate");
                long orgId = (Long)model.getValue("org_id");
                HashSet<Long> cardIds = new HashSet<Long>(1);
                cardIds.add(realCard.getLong("id"));
                String msg = FaUtils.checkRealCardBizStatus(cardIds);
                if (!msg.isEmpty()) {
                    model.setValue("realcard", null, index);
                    model.setValue("fincard", null, index);
                    model.setValue("networth", null, index);
                    model.setValue("accumdevalue", null, index);
                    model.setValue("decval", null, index);
                    this.getView().showErrorNotification(msg);
                    return;
                }
                Set existCards = FaUtils.getCurRealCard((Date)date, (Long)orgId, (Boolean)false, cardIds, (BusyTypeDetailEnum)BusyTypeDetailEnum.FIN_CHG, (Long)depreuse.getLong("id"));
                if (!existCards.containsAll(cardIds)) {
                    model.setValue("realcard", null, index);
                    model.setValue("fincard", null, index);
                    model.setValue("networth", null, index);
                    model.setValue("accumdevalue", null, index);
                    model.setValue("decval", null, index);
                    FaUtils.showErrorRealCardMsg((int)1, null, (DynamicObject)realCard, (IFormView)this.getView());
                    return;
                }
                QFilter[] filters = new QFilter[]{new QFilter("realcardmasterid", "=", realCard.getPkValue()), new QFilter("bizperiod", "<=", devalueperiod.getPkValue()), new QFilter("endperiod", ">", devalueperiod.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatus.C.toString()), new QFilter("depreuse", "=", depreuse.getPkValue())};
                DynamicObject[] finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)Fa.join((Object[])selectFields, (String)","), (QFilter[])filters);
                if (finCards == null || finCards.length < 1) {
                    return;
                }
                this.getModel().setValue("fincard", finCards[0].getPkValue(), changeData.getRowIndex());
                BigDecimal networth = BigDecimal.ZERO;
                DynamicObject bizperiodOb = finCards[0].getDynamicObject("bizperiod");
                networth = bizperiodOb != null && bizperiodOb.getLong("id") == ((Long)devalueperiod.getPkValue()).longValue() ? ((preFincard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)"networth", (QFilter[])new QFilter[]{assetBookFilter = new QFilter("assetbook", "=", (Object)finCards[0].getLong("assetbook_id")), endPeriodFilter = new QFilter("endperiod", "=", (Object)(bizperiod = finCards[0].getLong("bizperiod_id"))), numberFilter = new QFilter("number", "=", (Object)finCards[0].getString("number"))})) != null ? preFincard.getBigDecimal("networth") : finCards[0].getBigDecimal("networth")) : finCards[0].getBigDecimal("networth");
                this.getModel().setValue("networth", (Object)networth, changeData.getRowIndex());
                this.getModel().setValue("accumdevalue", (Object)finCards[0].getBigDecimal("decval"), changeData.getRowIndex());
                break;
            }
            case "decval": {
                BigDecimal decvalsum = new BigDecimal(0);
                DynamicObjectCollection changebillentry = this.getModel().getEntryEntity("changebillentry");
                for (DynamicObject dynamicObject : changebillentry) {
                    decvalsum = decvalsum.add(dynamicObject.getBigDecimal("decval"));
                }
                this.getModel().setValue("decvalsum", (Object)decvalsum);
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("changebillentry".equals(entryName)) {
            IDataModel model = this.getModel();
            RowDataEntity[] rows = e.getRowDataEntities();
            DynamicObject devaluePeriod = (DynamicObject)model.getValue("devalueperiod");
            DynamicObject nextPeriod = FaBizUtils.queryNeighborPeriod((Object)devaluePeriod.getPkValue(), (int)1);
            if (nextPeriod == null) {
                nextPeriod = devaluePeriod;
            }
            Date begindate = nextPeriod.getDate("begindate");
            Stream.of(rows).forEach(v -> {
                int rowIndex = v.getRowIndex();
                model.setValue("bizdate", (Object)begindate, rowIndex);
            });
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject changeBillEntry;
        DynamicObject finCard;
        DynamicObjectCollection changeBillEntries = this.getModel().getEntryEntity("changebillentry");
        DynamicObject devaluePeriod = (DynamicObject)this.getModel().getValue("devalueperiod");
        for (int i = 0; i < changeBillEntries.size() && (finCard = (changeBillEntry = (DynamicObject)changeBillEntries.get(i)).getDynamicObject("fincard")) != null; ++i) {
            DynamicObject bizPeriod = finCard.getDynamicObject("bizperiod");
            if (bizPeriod != null && bizPeriod.getLong("id") == devaluePeriod.getLong("id")) {
                this.getModel().setValue("networth", (Object)finCard.getBigDecimal("networth").add(finCard.getBigDecimal("monthdepre")), i);
            } else {
                this.getModel().setValue("networth", (Object)finCard.getBigDecimal("networth"), i);
            }
            Object billstatus = this.getModel().getValue("billstatus");
            BigDecimal decval = changeBillEntry.getBigDecimal("decval");
            if ("C".equals(billstatus)) {
                this.getModel().setValue("accumdevalue", (Object)finCard.getBigDecimal("decval").subtract(decval), i);
                continue;
            }
            this.getModel().setValue("accumdevalue", (Object)finCard.getBigDecimal("decval"), i);
        }
        if (devaluePeriod != null) {
            DynamicObject curperiod = BusinessDataServiceHelper.loadSingleFromCache((Object)devaluePeriod.getLong("id"), (String)"bd_period");
            if (curperiod == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8d44\u4ea7\u8d26\u7c3f\u672a\u8bbe\u7f6e\u201c\u51cf\u503c\u671f\u95f4\u201d\u3002", (String)"FaDeValueAsset_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            DynamicObject nextPeriod = FaBizUtils.queryNeighborPeriodByDo((DynamicObject)curperiod, (int)1);
            if (nextPeriod == null) {
                nextPeriod = curperiod;
            }
            this.setBizDateRange(curperiod, nextPeriod);
        }
        this.getModel().setDataChanged(false);
        super.afterBindData(e);
    }

    private void setCurrency() {
        Object org = this.getModel().getValue("org");
        Object depreuse = this.getModel().getValue("depreuse");
        if (org != null && depreuse != null) {
            QFilter orgFilter = new QFilter("org", "=", ((DynamicObject)org).getPkValue());
            QFilter depreuseFilter = new QFilter("depreuse", "=", ((DynamicObject)depreuse).getPkValue());
            Map booskMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"basecurrency", (QFilter[])new QFilter[]{orgFilter, depreuseFilter});
            booskMap.values().stream().forEach(p -> this.getModel().setValue("currency", (Object)p.getDynamicObject("basecurrency")));
        }
    }

    private void setBizDateRange(DynamicObject curperiod, DynamicObject nextPeriod) {
        DateEdit bizdateEdit = (DateEdit)this.getControl("bizdate");
        bizdateEdit.setMinDate(curperiod.getDate("begindate"));
        Date nextPeriodDate = nextPeriod.getDate("enddate");
        bizdateEdit.setMaxDate(nextPeriodDate);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceDataMap = e.getSourceData();
        JSONObject sourceData = new JSONObject(sourceDataMap);
        JSONArray entry = sourceData.getJSONArray("changebillentry");
        HashSet<String> numberSet = new HashSet<String>(entry.size());
        for (Object row : entry) {
            JSONObject jsonObj = new JSONObject((Map)row);
            String realCardNum = jsonObj.getJSONObject("realcard").getString("number");
            numberSet.add(realCardNum);
        }
        HashMap<String, Long> numAndIdMap = new HashMap<String, Long>(numberSet.size());
        String selectFields = String.join((CharSequence)", ", "id", "number");
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", numberSet), new QFilter("id", "=", (Object)"masterid", true)};
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)selectFields, (QFilter[])filters);
        for (DynamicObject realCard : realCards) {
            String number = realCard.getString("number");
            long id = realCard.getLong("id");
            numAndIdMap.put(number, id);
        }
        for (Object row : entry) {
            JSONObject jsonObj = new JSONObject((Map)row);
            JSONObject realCard = jsonObj.getJSONObject("realcard");
            String realCardNum = realCard.getString("number");
            realCard.put("importprop", (Object)"id");
            realCard.put("id", numAndIdMap.get(realCardNum));
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        this.initDataAfterImport();
        long depreUseId = (Long)model.getValue("depreuse_id");
        long orgId = (Long)model.getValue("org_id");
        Date bizDate = this.getDefBizDateByOrgAndDepreUse(orgId, depreUseId);
        if (bizDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u548c\u6298\u65e7\u7528\u9014\u627e\u4e0d\u5230\u8d26\u7c3f\u6216\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u672a\u7ef4\u62a4\u3002", (String)"FaDeValueAsset_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection entries = (DynamicObjectCollection)model.getValue("changebillentry");
        for (DynamicObject entry : entries) {
            QFilter numberFilter;
            long bizPeriodId;
            QFilter endPeriodFilter;
            QFilter depreUseFilter;
            QFilter orgFilter;
            DynamicObject preFinCard;
            DynamicObject finCard = entry.getDynamicObject("fincard");
            entry.set("fincard", (Object)finCard);
            BigDecimal netWorth = null != finCard.getDynamicObject("bizperiod") && finCard.getDynamicObject("bizperiod").getLong("id") == depreUseId ? ((preFinCard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)"networth", (QFilter[])new QFilter[]{orgFilter = new QFilter("org", "=", (Object)orgId), depreUseFilter = new QFilter("depreuse", "=", (Object)depreUseId), endPeriodFilter = new QFilter("endperiod", "=", (Object)(bizPeriodId = finCard.getLong("bizperiod_id"))), numberFilter = new QFilter("number", "=", (Object)finCard.getString("number"))})) != null ? preFinCard.getBigDecimal("networth") : finCard.getBigDecimal("networth")) : finCard.getBigDecimal("networth");
            entry.set("networth", (Object)netWorth);
            entry.set("accumdevalue", (Object)finCard.getBigDecimal("decval"));
            if (entry.get("bizdate") != null) continue;
            entry.set("bizdate", (Object)bizDate);
        }
        boolean enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)((Long)model.getValue("org_id")), (boolean)false);
        List errorInfo = AssetDeValueValidator.validateForImport((DynamicObject)model.getDataEntity(), (Boolean)enableSumMutilVoucher);
        if (!errorInfo.isEmpty()) {
            String errorMsg = String.join((CharSequence)"", errorInfo);
            throw new KDBizException(errorMsg);
        }
        model.setValue("billstatus", (Object)BillStatus.B);
    }

    private Date getDefBizDateByOrgAndDepreUse(long orgId, long depreUseId) {
        DynamicObject[] assetBook = FaAssetBookDaoFactory.getInstance().query(new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId)});
        DynamicObject curperiod = assetBook[0].getDynamicObject("curperiod");
        if (curperiod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u672a\u8bbe\u7f6e\u5f53\u524d\u671f\u95f4\u3002", (String)"FaDeValueAsset_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject nextPeriod = FaBizUtils.queryNeighborPeriodByDo((DynamicObject)curperiod, (int)1);
        if (nextPeriod == null) {
            nextPeriod = curperiod;
        }
        return nextPeriod.getDate("begindate");
    }

    private void initDataAfterImport() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaDeValueAsset_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject depreUse = (DynamicObject)model.getValue("depreuse");
        if (depreUse == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaDeValueAsset_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject currentPeriod = this.queryCurrentPeriod(org.getPkValue(), depreUse.getPkValue());
        if (currentPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u672a\u8bbe\u7f6e\u5f53\u524d\u671f\u95f4\u3002", (String)"FaDeValueAsset_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        model.setValue("devalueperiod", currentPeriod.getPkValue());
        this.setCurrency();
        Date endDate = currentPeriod.getDate("enddate");
        endDate = DateUtil.stripTime((Date)endDate);
        model.setValue("businessdate", (Object)endDate);
        DynamicObjectCollection entry = (DynamicObjectCollection)model.getValue("changebillentry");
        for (DynamicObject row : entry) {
            int seq = row.getInt("seq");
            DynamicObject realCard = row.getDynamicObject("realcard");
            if (realCard == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u7269\u5361\u7247\u3002", (String)"FaDeValueAsset_9", (String)"fi-fa-formplugin", (Object[])new Object[0]), seq));
            }
            DynamicObject finCard = this.queryFinCard(realCard.getString("number"), currentPeriod.getLong("id"), depreUse.getLong("id"));
            if (finCard == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u51cf\u503c\u660e\u7ec6\u7b2c%s\u884c\uff1a\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u3002", (String)"FaDeValueAsset_10", (String)"fi-fa-formplugin", (Object[])new Object[0]), seq));
            }
            model.setValue("fincard", finCard.getPkValue(), seq - 1);
        }
    }

    private DynamicObject queryFinCard(String assetNumber, Long devaluePeriodId, Long depreUseId) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)assetNumber), new QFilter("bizperiod", "<=", (Object)devaluePeriodId), new QFilter("endperiod", ">", (Object)devaluePeriodId), new QFilter("billstatus", "=", (Object)BillStatus.C.toString()), new QFilter("depreuse", "=", (Object)depreUseId)};
        return BusinessDataServiceHelper.loadSingle((String)"fa_card_fin", (String)Fa.join((Object[])selectFields, (String)","), (QFilter[])filters);
    }

    private DynamicObject queryCurrentPeriod(Object orgId, Object depreUseId) {
        String selectFields = "curperiod";
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", orgId), new QFilter("depreuse", "=", depreUseId), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)BillStatus.C)};
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)selectFields, (QFilter[])filters);
        if (assetBook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6838\u7b97\u7ec4\u7ec7\u3001\u6298\u65e7\u7528\u9014\u5bf9\u5e94\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaDeValueAsset_11", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        return assetBook.getDynamicObject("curperiod");
    }
}

