/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.filter.FilterServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.depretask.DepreStatusEnum2;
import kd.fi.fa.business.enums.depre.FaOperationOpTypeEnum;
import kd.fi.fa.business.enums.depre.FaOperationStatusEnum;
import kd.fi.fa.business.po.FaOperationLogInsertPo;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.business.utils.FaDisDepreLogUtils;
import kd.fi.fa.business.utils.FaOperationLogUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.po.FaFinCardPo;

public class FaDepreEditPlugin
extends AbstractFormPlugin
implements ProgresssListener,
HyperLinkClickListener,
CellClickListener,
FilterContainerInitListener,
SearchClickListener,
BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(FaDepreEditPlugin.class);
    private static final String ORG = "org";
    private static final String START_PERIOD = "startperiod";
    private static final String CUR_PERIOD = "curperiod";
    private static final String ENTRYENTITY = "entryentity";
    private static final String STATUS = "status";
    private static final String DEPRE_STATUS = "deprestatus";
    private static final String DEPRE_AMOUNT = "depreamount";
    private static final String ALL_DEPREAMOUNT = "alldepreamount";
    private static final String DEPRE_TIME = "depretime";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String ASSETBOOKID = "assetbookid";
    private static final String DEPREUSE = "depreuse";
    private static final String AUDITOR = "auditor";
    private static final String AUDITDATE = "auditdate";
    private static final String DISLOGID = "dislogid";
    IAppCache cache = AppCache.get((String)"fa");
    private static final String ALGO = "kd.fi.fa.formplugin.FaDepreEditPlugin";
    private static final String[] hideBtns = new String[]{"redepre", "viewlog", "bd_ksql_query_function", "btn_resplit", "btn_resplit_multi", "btn_showid", "btn_repair"};
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"kd.fi.fa.formplugin.FaDepreEditPlugin", (int)DailyDepreImpl.THREAD_SIZE);
    private static final String CACHE_DEPRE_CHECK = "cacheDepreCheck";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IDataModel m = this.getModel();
        if ("tbldepre".equals(key)) {
            this.tbldepreMethod_wkAlert(m);
        } else if ("btnrefresh".equals(key)) {
            this.refreshPage(true);
        } else if ("depresplitsetup".equals(key)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("fa_depresplitsetup");
            parameter.setFormId("bos_list");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        } else if ("viewlog".equals(key)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("fa_disdepre_log");
            parameter.setFormId("bos_list");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (!"bd_ksql_query_function".equals(key)) {
            if ("btn_resplit".equals(key)) {
                this.reSplit(m);
            } else if ("btn_resplit_multi".equals(key)) {
                this.reSplit4Multi(m);
            } else if ("btn_showid".equals(key)) {
                EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
                int[] rows = eg.getSelectRows();
                DynamicObjectCollection entities = m.getEntryEntity(ENTRYENTITY);
                DynamicObject assetBook = null;
                StringBuilder sb = new StringBuilder();
                for (int i : rows) {
                    assetBook = (DynamicObject)entities.get(i);
                    sb.append("org:").append(assetBook.getString("org.name")).append(",ID:").append(assetBook.getLong("org.id")).append(";");
                    sb.append("\r\n");
                    sb.append("depreuse:").append(assetBook.getString("depreuse.name")).append(",ID:").append(assetBook.getLong("depreuse.id")).append(";");
                    sb.append("\r\n");
                    sb.append("assetBookId:").append(assetBook.get(ASSETBOOKID)).append(";");
                    sb.append("\r\n");
                    sb.append("period:").append(assetBook.getLong("curperiod.id")).append(";");
                    sb.append("\r\n");
                }
                this.getView().showMessage("ID", sb.toString(), MessageTypes.Default);
            } else if ("btn_repair".equals(key)) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("fa_fetchdepredata");
                parameter.getOpenStyle().setShowType(ShowType.NewWindow);
                this.getView().showForm(parameter);
            } else if ("dynamicalgorithmcard".equals(key)) {
                this.pageForwardParam("fa_card_dynamic", "bos_list", ShowType.MainNewTabPage, this.getView());
            } else if ("billparam".equals(key)) {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setBillFormId("fa_billparam");
                parameter.setFormId("bos_list");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setCustomParam("bizcloud", (Object)"83bfebc8000002ac");
                parameter.setCustomParam("bizapp", (Object)"83bfebc800001aac");
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    private void reSplit(IDataModel m) {
        DynamicObject[] books;
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        DynamicObjectCollection entities = m.getEntryEntity(ENTRYENTITY);
        HashSet<Long> set = new HashSet<Long>(rows.length);
        for (int i : rows) {
            String assetBookIdStr = (String)((DynamicObject)entities.get(i)).get(ASSETBOOKID);
            set.add(Long.parseLong(assetBookIdStr));
        }
        for (DynamicObject assetBook : books = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_assetbook"))) {
            ThreadPools.executeOnceIncludeRequestContext((String)"FA_RESPLIT_THREAD", () -> {
                Long depreId = assetBook.getLong("depreuse_id");
                Long orgId = assetBook.getLong("org_id");
                Long curperiodId = assetBook.getLong("curperiod_id");
                String orgName = assetBook.getString(Fa.dot((String[])new String[]{ORG, "name"}));
                String depreUseName = assetBook.getString(Fa.dot((String[])new String[]{DEPREUSE, "name"}));
                String assetBookName = assetBook.getString("name");
                String periodName = assetBook.getString(Fa.dot((String[])new String[]{CUR_PERIOD, "name"}));
                try {
                    new DepreSplitSum().repairDepreSplit(orgId, depreId, curperiodId);
                }
                catch (Exception e) {
                    logger.error("\u91cd\u65b0\u5206\u644a", (Throwable)e);
                    String prams = "FaDepreEditPlugin.reSplit -> " + String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7: %1$s, \u6298\u65e7\u7528\u9014\uff1a%2$s, \u671f\u95f4\uff1a%3$s", (String)"FaDepreEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), orgId, depreId, curperiodId);
                    FaOperationLogInsertPo insertPo = new FaOperationLogInsertPo(orgName, depreUseName, assetBookName, periodName, Integer.valueOf(0), "fa_fetchdepredata", prams, FaOperationOpTypeEnum.RESPLIT);
                    FaOperationLogUtils.insertOperationLog((FaOperationLogInsertPo)insertPo, (FaOperationStatusEnum)FaOperationStatusEnum.FAILED, (String)ThrowableHelper.toString((Throwable)e));
                    this.dealCommonException(assetBook, assetBook.getPkValue(), e, "true");
                }
            });
        }
    }

    private void reSplit4Multi(IDataModel m) {
        DynamicObject[] books;
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        DynamicObjectCollection entities = m.getEntryEntity(ENTRYENTITY);
        HashSet<Long> set = new HashSet<Long>(rows.length);
        for (int i : rows) {
            String assetBookIdStr = (String)((DynamicObject)entities.get(i)).get(ASSETBOOKID);
            set.add(Long.parseLong(assetBookIdStr));
        }
        for (DynamicObject assetBook : books = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_assetbook"))) {
            ThreadPools.executeOnceIncludeRequestContext((String)"FA_RESPLIT_THREAD", () -> {
                Long depreId = assetBook.getLong("depreuse_id");
                Long orgId = assetBook.getLong("org_id");
                Long curperiodId = assetBook.getLong("curperiod_id");
                String orgName = assetBook.getString(Fa.dot((String[])new String[]{ORG, "name"}));
                String depreUseName = assetBook.getString(Fa.dot((String[])new String[]{DEPREUSE, "name"}));
                String assetBookName = assetBook.getString("name");
                String periodName = assetBook.getString(Fa.dot((String[])new String[]{CUR_PERIOD, "name"}));
                try {
                    new DepreSplitSum().repairDepreSplit4Multi(orgId, depreId, curperiodId);
                }
                catch (Exception e) {
                    logger.error("\u91cd\u65b0\u5206\u644a", (Throwable)e);
                    String prams = "FaDepreEditPlugin.reSplit4Multi -> " + String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7: %1$s, \u6298\u65e7\u7528\u9014\uff1a%2$s, \u671f\u95f4\uff1a%3$s", (String)"FaDepreEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), orgId, depreId, curperiodId);
                    FaOperationLogInsertPo insertPo = new FaOperationLogInsertPo(orgName, depreUseName, assetBookName, periodName, Integer.valueOf(0), "fa_fetchdepredata", prams, FaOperationOpTypeEnum.RESPLIT);
                    FaOperationLogUtils.insertOperationLog((FaOperationLogInsertPo)insertPo, (FaOperationStatusEnum)FaOperationStatusEnum.FAILED, (String)ThrowableHelper.toString((Throwable)e));
                    this.dealCommonException(assetBook, assetBook.getPkValue(), e, "true");
                }
            });
        }
    }

    private void tbldepreMethod_wkAlert(IDataModel m) {
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        DynamicObjectCollection entities = m.getEntryEntity(ENTRYENTITY);
        HashSet<Long> set = new HashSet<Long>(rows.length);
        for (int i : rows) {
            String assetBookIdStr = (String)((DynamicObject)entities.get(i)).get(ASSETBOOKID);
            set.add(Long.parseLong(assetBookIdStr));
        }
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_assetbook"));
        HashSet<DynamicObject> noEnterWkSet = new HashSet<DynamicObject>();
        StringBuilder noEnterWkOrgNames = new StringBuilder();
        for (DynamicObject assetbook : loads) {
            Set<String> checkResult = this.checkWorkLoadIsEnterByBookId(assetbook);
            if (checkResult.size() <= 0) continue;
            noEnterWkSet.add(assetbook);
            noEnterWkOrgNames.append(assetbook.getString("org.name")).append("\u3001");
        }
        if (noEnterWkSet.size() > 0) {
            noEnterWkOrgNames.delete(noEnterWkOrgNames.length() - 1, noEnterWkOrgNames.length());
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff0c\u672c\u671f\u5b58\u5728\u6ca1\u6709\u7ef4\u62a4\u5de5\u4f5c\u91cf\u7684\u5361\u7247\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u7ee7\u7eed\u8ba1\u63d0\u3002", (String)"FaDepreEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), noEnterWkOrgNames.toString()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmWorkLoad", (IFormPlugin)this));
        } else {
            this.tbldepreMethod(m);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String resultName = messageBoxClosedEvent.getResult().name();
        if (resultName.equals(MessageBoxResult.Yes.name()) || resultName.equals(MessageBoxResult.OK.name())) {
            IDataModel m = this.getModel();
            this.tbldepreMethod(m);
        }
    }

    private void tbldepreMethod(IDataModel m) {
        ProgressBar pro = (ProgressBar)this.getControl(PROGRESSBARAP);
        pro.start();
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        DynamicObjectCollection entities = m.getEntryEntity(ENTRYENTITY);
        HashSet<Long> set = new HashSet<Long>(rows.length);
        for (int i : rows) {
            String assetBookIdStr = (String)((DynamicObject)entities.get(i)).get(ASSETBOOKID);
            set.add(Long.parseLong(assetBookIdStr));
            this.getPageCache().put(((DynamicObject)entities.get(i)).getString(ASSETBOOKID), i + "");
        }
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_assetbook"));
        Set canDepres = Arrays.stream(loads).collect(Collectors.toSet());
        HashMap<String, HashSet<DynamicObject>> org2DepreBookMap = new HashMap<String, HashSet<DynamicObject>>(canDepres.size());
        for (DynamicObject load : canDepres) {
            String orgId = load.getString("org.id");
            HashSet<DynamicObject> depreBookList = (HashSet<DynamicObject>)org2DepreBookMap.get(orgId);
            if (depreBookList == null) {
                depreBookList = new HashSet<DynamicObject>(3);
                org2DepreBookMap.put(orgId, depreBookList);
            }
            depreBookList.add(load);
            this.changeStatus((Long)load.getPkValue(), "B", m);
        }
        for (Set depreBooks : org2DepreBookMap.values()) {
            this.depreciateByThread(depreBooks);
        }
        this.getPageCache().put("end", "true");
    }

    private Set<String> checkWorkLoadIsEnterByBookId(DynamicObject bookObj) {
        Long realCardId;
        long bookOrgId = bookObj.getLong("org_id");
        long bookDepreuseId = bookObj.getLong("depreuse_id");
        long bookCurperiodId = bookObj.getLong("curperiod_id");
        QFilter[] depreMethodFilters = new QFilter[]{new QFilter("type", "=", (Object)"5")};
        Map depremethodCacheMap = BusinessDataServiceHelper.loadFromCache((String)"fa_depremethod", (QFilter[])depreMethodFilters);
        HashSet<Long> depremethodId_isWorkLoadSet = new HashSet<Long>();
        for (DynamicObject depremethod : depremethodCacheMap.values()) {
            String type = depremethod.getString("type");
            if (!type.equals("5")) continue;
            depremethodId_isWorkLoadSet.add((Long)depremethod.getPkValue());
        }
        HashMap<String, FaFinCardPo> number_FinCardPoMap = new HashMap<String, FaFinCardPo>();
        ArrayList<Long> realcardIdList = new ArrayList<Long>();
        String sql = "SELECT fid id,frealcardid realcardid, fnumber number ,fdepremethodid depremethodId FROM T_FA_CARD_FIN WHERE fbillstatus=? and forg = ? and fdepreuseid=? and fendperiodid > ? and (fbizperiodid < ? or (fbizperiodid = ? and fisneeddepre='1')) and (fclearperiodid = 0 or fclearperiodid = ?)";
        try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{"C", bookOrgId, bookObj.get("depreuse.id"), bookCurperiodId, bookCurperiodId, bookCurperiodId, bookCurperiodId});){
            for (Row row : ds) {
                Long depremethodId = row.getLong("depremethodId");
                if (!depremethodId_isWorkLoadSet.contains(depremethodId)) continue;
                FaFinCardPo faFinCardPo = new FaFinCardPo();
                faFinCardPo.setRealcardId(row.getLong("realcardid"));
                faFinCardPo.setDepremethodId(row.getLong("depremethodId"));
                faFinCardPo.setNumber(row.getString("number"));
                number_FinCardPoMap.put(row.getString("number"), faFinCardPo);
                realcardIdList.add(row.getLong("realcardid"));
            }
        }
        HashSet<String> noEnterWkNumberSet = new HashSet<String>(100);
        if (realcardIdList.size() == 0) {
            return noEnterWkNumberSet;
        }
        QFilter[] filters = new QFilter[]{new QFilter("period", "=", (Object)bookCurperiodId), new QFilter(ORG, "=", (Object)bookOrgId), new QFilter(DEPREUSE, "=", (Object)bookDepreuseId), new QFilter("realcard", "in", (Object)realcardIdList.toArray(new Long[0]))};
        Map fa_workload_dbmap = BusinessDataServiceHelper.loadFromCache((String)"fa_workload", (QFilter[])filters);
        HashMap<String, DynamicObject> realcardIdPeriodId_wk_map = new HashMap<String, DynamicObject>(fa_workload_dbmap.size());
        for (DynamicObject workload : fa_workload_dbmap.values()) {
            realCardId = workload.getLong("realcard.id");
            Long periodId = workload.getLong("period.id");
            StringBuilder sb = new StringBuilder(realCardId.toString());
            String key = sb.append("_").append(periodId.toString()).toString();
            realcardIdPeriodId_wk_map.put(key, workload);
        }
        for (FaFinCardPo faFinCardPo : number_FinCardPoMap.values()) {
            realCardId = faFinCardPo.getRealcardId();
            StringBuilder sb = new StringBuilder(realCardId.toString());
            String key = sb.append("_").append(bookCurperiodId).toString();
            DynamicObject workload = (DynamicObject)realcardIdPeriodId_wk_map.get(key);
            if (workload != null) continue;
            noEnterWkNumberSet.add(faFinCardPo.getNumber());
        }
        if (noEnterWkNumberSet.size() > 0) {
            logger.info(String.format("bookOrgId:%s,bookDepreuseId:%s,bookCurperiodId:%s\u6709\u5982\u4e0b\u5361\u7247\u6ca1\u6709\u5f55\u5165\u5de5\u4f5c\u91cf:%s", bookOrgId, bookDepreuseId, bookCurperiodId, ((Object)noEnterWkNumberSet).toString()));
        }
        return noEnterWkNumberSet;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"tbldepre"});
        ProgressBar pro = (ProgressBar)this.getControl(PROGRESSBARAP);
        pro.addProgressListener((ProgresssListener)this);
        EntryGrid entryGridd = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGridd.addHyperClickListener((HyperLinkClickListener)this);
        entryGridd.addCellClickListener((CellClickListener)this);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addSearchClickListener((SearchClickListener)this);
    }

    private void changeStatus(Long bookId, String status, IDataModel m) {
        Set<Long> set;
        if (this.getPageCache().get("idcollection") == null) {
            set = new HashSet<Long>();
            set.add(bookId);
        } else {
            set = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("idcollection"), Set.class);
            set.add(bookId);
        }
        this.getPageCache().put("idcollection", SerializationUtils.toJsonString(set));
        this.cache.remove(bookId + "DailyDepreImpl_cacheKey");
        this.getPageCache().put(bookId + "failed", null);
        m.setValue(DEPRE_STATUS, (Object)status, Integer.parseInt(this.getPageCache().get(bookId.toString())));
        m.setValue(DEPRE_AMOUNT, (Object)"", Integer.parseInt(this.getPageCache().get(bookId.toString())));
        m.setValue(ALL_DEPREAMOUNT, (Object)"", Integer.parseInt(this.getPageCache().get(bookId.toString())));
        m.setValue(DEPRE_TIME, (Object)"", Integer.parseInt(this.getPageCache().get(bookId.toString())));
    }

    public void afterCreateNewData(EventObject e) {
        QFilter filter;
        super.afterCreateNewData(e);
        Boolean flag = false;
        FilterScheme scheme = null;
        try {
            scheme = FilterServiceHelper.getDefaultScheme((String)"fa_new_depre");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (scheme != null && (filter = FilterServiceHelper.getQFilterByFilterScheme((FilterScheme)scheme, (String)"fa_new_depre", null)) != null) {
            List nests = filter.getNests(true);
            String pre_property = filter.getProperty();
            if (pre_property.contains("entryentity.")) {
                filter.__setProperty(pre_property.substring(pre_property.indexOf(".") + 1));
            }
            for (QFilter.QFilterNest nest : nests) {
                String property = nest.getFilter().getProperty();
                if (property.contains("entryentity.")) {
                    nest.getFilter().__setProperty(property.substring(property.indexOf(".") + 1));
                }
                if (!property.equals(ENTRYENTITY)) continue;
                nest.remove();
            }
            logger.info("\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a", (Object)filter);
            HashSet<Object> orgSet = new HashSet<Object>();
            HashSet<Object> depreuseSet = new HashSet<Object>();
            flag = this.setOrgAndDepreuse(filter.toArray(), orgSet, depreuseSet);
            this.getPageCache().put("orgSet", SerializationUtils.toJsonString(orgSet));
            this.getPageCache().put("depreuseSet", SerializationUtils.toJsonString(depreuseSet));
        }
        if (!flag.booleanValue()) {
            this.refreshPage(true);
        }
        this.setShortCuts();
        this.getView().setVisible(Boolean.valueOf(false), hideBtns);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"billparam"});
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        JSONObject item4Param = new JSONObject();
        item4Param.put("type", (Object)"keyUp");
        item4Param.put("shortCuts", (Object)"shift+p");
        arrayItem.add((Object)item4Param);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts")) {
            String key = e.getEventArgs();
            if ("[16,77]".equals(key)) {
                this.getView().setVisible(Boolean.valueOf(true), hideBtns);
            } else if ("[16,80]".equals(key)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"billparam"});
            }
        }
    }

    private Set<Long> getSet(String flag) {
        if (this.getPageCache().get(flag) != null) {
            Set set = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(flag), Set.class);
            HashSet<Long> ids = new HashSet<Long>(set.size());
            for (Object id : set) {
                if (!StringUtils.isNotEmpty((CharSequence)String.valueOf(id))) continue;
                ids.add(Long.parseLong(String.valueOf(id)));
            }
            return ids;
        }
        return Collections.emptySet();
    }

    private void refreshPage(boolean isManualRefresh) {
        long startTime = System.currentTimeMillis();
        Set<Long> orgSet = this.getSet("orgSet");
        Set<Long> depreuseSet = this.getSet("depreuseSet");
        SqlBuilder sql = new SqlBuilder();
        sql.append("select a.fid, a.forgid, a.fdepreuse, a.fenableperiodid, a.fcurrentperiodid, b.fdeprestatus, b.fauditdate, b.fauditorid from t_fa_assetbook a left join t_fa_depre b on a.fid = b.fassetbookid and a.fdepreuse = b.fdepreuseid and a.fcurrentperiodid = b.fperiodid", new Object[0]);
        String q = "";
        HasPermOrgResult permOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)this.getView().getFormShowParameter().getAppId(), (String)"fa_new_depre", (String)"/KT7BBQL51C7");
        List orgIds = null;
        if (!permOrgs.hasAllOrgPerm()) {
            orgIds = permOrgs.getHasPermOrgs();
        }
        SqlBuilder sql2 = new SqlBuilder();
        sql2.append("select a.fid, a.fcurrentperiodid, b.fdeprestatus, b.fcreatetime, b.fcreatorid from t_fa_assetbook a left join t_fa_depre b on a.fid = b.fassetbookid and a.fdepreuse = b.fdepreuseid and a.fcurrentperiodid = b.fperiodid and b.fauditorid != 0", new Object[0]);
        HashMap<String, Object[]> bookIdPeriodId2DepreInfo = new HashMap<String, Object[]>(128);
        try (DataSet finDS = DB.queryDataSet((String)"queryFaDepre", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sql2);){
            for (Row row : finDS) {
                Long bookId = row.getLong("fid");
                Long l = row.getLong("fcurrentperiodid");
                String bookIdPeriodId = bookId + "_" + l;
                Object[] depreInfoArr = (Object[])bookIdPeriodId2DepreInfo.get(bookIdPeriodId);
                if (depreInfoArr == null) {
                    depreInfoArr = new Object[]{row.get("fdeprestatus"), row.getDate("fcreatetime"), row.getLong("fcreatorid")};
                    bookIdPeriodId2DepreInfo.put(bookIdPeriodId, depreInfoArr);
                    continue;
                }
                Date depreVoCreateDate = (Date)depreInfoArr[1];
                Date auditDate = row.getDate("fcreatetime");
                if (auditDate == null || depreVoCreateDate != null && !depreVoCreateDate.before(auditDate)) continue;
                depreInfoArr = new Object[]{row.get("fdeprestatus"), row.getDate("fcreatetime"), row.getLong("fcreatorid")};
                bookIdPeriodId2DepreInfo.put(bookIdPeriodId, depreInfoArr);
            }
        }
        SqlBuilder sql3 = new SqlBuilder();
        sql3.append("select a.fid, a.forgid, a.fdepreuse, a.fenableperiodid, a.fcurrentperiodid, b.fstatus, b.fcreatetime, b.fcreatorid, b.fid logId from t_fa_assetbook a left join t_fa_disdepre_log b on a.fid = b.fassetbookid and a.fcurrentperiodid = b.fperiodid and b.fismanual = '1' and b.ffromentityname = 'fa_new_depre' and fisnew = '1'", new Object[0]);
        if (orgIds != null) {
            if (!orgSet.isEmpty()) {
                orgIds.retainAll(orgSet);
            }
            if (orgIds.isEmpty()) {
                AbstractFormDataModel m = (AbstractFormDataModel)this.getModel();
                m.setValue("depreusecount", (Object)0);
                m.deleteEntryData(ENTRYENTITY);
                this.getView().updateView(ENTRYENTITY);
                return;
            }
            sql3.appendIn(" where a.forgid", orgIds.toArray());
        } else if (!orgSet.isEmpty()) {
            sql3.appendIn(" where a.forgid", orgSet.toArray());
        }
        if (!depreuseSet.isEmpty()) {
            q = sql3.toString().contains("where") ? " and " : " where ";
            sql3.appendIn(q + " a.fdepreuse", depreuseSet.toArray());
        }
        sql3.append(" order by b.fcreatetime desc", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sql3);
        if (dataSet.isEmpty()) {
            AbstractFormDataModel m = (AbstractFormDataModel)this.getModel();
            m.setValue("depreusecount", (Object)0);
            m.deleteEntryData(ENTRYENTITY);
            this.getView().updateView(ENTRYENTITY);
            return;
        }
        HashMap<Object, DepreVo> assetBookToRow = new HashMap<Object, DepreVo>();
        while (dataSet.hasNext()) {
            Row row;
            row = dataSet.next();
            Long assetBookId = row.getLong("fid");
            DepreVo depreVo = (DepreVo)assetBookToRow.get(assetBookId);
            if (depreVo == null) {
                assetBookToRow.put(assetBookId, this.rowToDepreVo(row, bookIdPeriodId2DepreInfo));
                continue;
            }
            Date depreVoCreateDate = depreVo.getCreateDate();
            Date createDate = row.getDate("fcreatetime");
            if (createDate == null || depreVoCreateDate != null && !depreVoCreateDate.before(createDate)) continue;
            assetBookToRow.put(assetBookId, this.rowToDepreVo(row, bookIdPeriodId2DepreInfo));
        }
        HashMap<Long, HashSet<Long>> periodIdBookIdsMap4Failed = new HashMap<Long, HashSet<Long>>(16);
        for (Map.Entry entry : assetBookToRow.entrySet()) {
            DepreVo depreVo = (DepreVo)entry.getValue();
            String depreStatus = depreVo.getDepreStatus();
            if (!DepreStatusEnum2.FAI.getValue().equals(depreStatus)) continue;
            Long bookId = depreVo.getAssetBookId();
            Long periodId = depreVo.getCurPeriodId();
            HashSet<Long> bookIds = (HashSet<Long>)periodIdBookIdsMap4Failed.get(periodId);
            if (bookIds == null) {
                bookIds = new HashSet<Long>();
                periodIdBookIdsMap4Failed.put(periodId, bookIds);
            }
            bookIds.add(bookId);
        }
        Map assetBookDisLogMap4Failed = FaDisDepreLogUtils.queryLatestDepreLog4Batch(periodIdBookIdsMap4Failed, (String)"result");
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        abstractFormDataModel.setValue("depreusecount", (Object)assetBookToRow.size());
        abstractFormDataModel.deleteEntryData(ENTRYENTITY);
        abstractFormDataModel.beginInit();
        int row = 0;
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        for (Map.Entry entry : assetBookToRow.entrySet()) {
            DepreVo depreVo = (DepreVo)entry.getValue();
            Long bookId = depreVo.getAssetBookId();
            Long disDepreLogId = depreVo.getDisDepreLogId();
            tvs.set(DISLOGID, (Object)disDepreLogId, row);
            tvs.set(ORG, (Object)depreVo.getOrgId(), row);
            tvs.set(START_PERIOD, (Object)depreVo.getStartPeriodId(), row);
            tvs.set(CUR_PERIOD, (Object)depreVo.getCurPeriodId(), row);
            Date createDate = depreVo.getCreateDate();
            String depreStatus = depreVo.getDepreStatus();
            if (depreStatus == null) {
                depreStatus = "A";
            }
            tvs.set(DEPRE_STATUS, (Object)depreStatus, row);
            String depreAmountView = "";
            if (depreStatus.equals("A") || depreStatus.equals("B")) {
                depreAmountView = "";
            } else if (depreStatus.equals("C")) {
                depreAmountView = ResManager.loadKDString((String)"\u8054\u67e5\u6298\u65e7", (String)"FaDepreEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            } else if (depreStatus.equals("D")) {
                DynamicObject newDisDepreLog = (DynamicObject)assetBookDisLogMap4Failed.get(bookId);
                if (newDisDepreLog != null) {
                    depreAmountView = newDisDepreLog.getString("result");
                }
            } else if (DepreStatusEnum2.NEED_RE_DEPRE.getValue().equals(depreStatus)) {
                depreAmountView = ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e1a\u52a1", (String)"FaDepreEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            }
            tvs.set(DEPRE_AMOUNT, (Object)depreAmountView, row);
            tvs.set(ASSETBOOKID, (Object)bookId, row);
            tvs.set(DEPREUSE, (Object)depreVo.getDepreUseId(), row);
            tvs.set(AUDITDATE, (Object)createDate, row);
            tvs.set(AUDITOR, (Object)depreVo.getCreatorId(), row);
            ++row;
        }
        abstractFormDataModel.batchCreateNewEntryRow(ENTRYENTITY, tvs);
        abstractFormDataModel.endInit();
        this.getView().updateView(ENTRYENTITY);
        logger.info("refreshPage cost [{}] ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private Map<Long, String> getOrgIdAndNames() {
        HasPermOrgResult permOrgs = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)this.getView().getFormShowParameter().getAppId(), (String)"fa_new_depre", (String)"/KT7BBQL51C7");
        HashMap<Long, String> idAndNames = new HashMap<Long, String>();
        DynamicObject[] assetBooks = null;
        if (!permOrgs.hasAllOrgPerm()) {
            List orgIds = permOrgs.getHasPermOrgs();
            if (!orgIds.isEmpty()) {
                assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"org.id, org.name", (QFilter[])new QFilter[]{new QFilter(ORG, "in", (Object)orgIds)});
            }
        } else {
            assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"org.id, org.name", null);
        }
        if (assetBooks != null) {
            for (DynamicObject assetBook : assetBooks) {
                idAndNames.put(assetBook.getLong("org.id"), assetBook.getString("org.name"));
            }
        }
        return idAndNames;
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        int selectRow = e.getRowIndex();
        String depreamountDeal = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow).getString(DEPRE_AMOUNT);
        Long curperiodId = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow).getDynamicObject(CUR_PERIOD).getLong("id");
        Long ordId = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow).getDynamicObject(ORG).getLong("id");
        Long depreuseId = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow).getDynamicObject(DEPREUSE).getLong("id");
        Long periodTypeId = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow).getDynamicObject(CUR_PERIOD).getDynamicObject("periodtype").getLong("id");
        Object assetbookid = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow).get(ASSETBOOKID);
        Long disDepreLog = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow).getLong(DISLOGID);
        this.showView(assetbookid, depreamountDeal, curperiodId, ordId, depreuseId, periodTypeId, disDepreLog);
    }

    private void showView(Object assetbookid, String depreamountDeal, Long curperiodId, Long ordId, Long depreuseId, Long periodTypeId, Long disDepreLogId) {
        if (depreamountDeal.equals(ResManager.loadKDString((String)"\u8054\u67e5\u6298\u65e7", (String)"FaDepreEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]))) {
            FilterInfo filter = new FilterInfo();
            filter.addFilterItem("q_org", (Object)ordId);
            filter.addFilterItem(DEPREUSE, (Object)depreuseId);
            filter.addFilterItem("period_start", (Object)curperiodId);
            filter.addFilterItem("period_end", (Object)curperiodId);
            filter.addFilterItem("periodtype", (Object)periodTypeId);
            filter.addFilterItem("card_range", (Object)"select_1");
            ReportQueryParam queryParam = new ReportQueryParam();
            queryParam.setFilter(filter);
            ReportShowParameter parameter = new ReportShowParameter();
            parameter.setFormId("fa_rpt_depreciation");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setQueryParam(queryParam);
            parameter.setCustomParam("q_org", (Object)ordId);
            parameter.setCustomParam(DEPREUSE, (Object)depreuseId);
            parameter.setCustomParam("fromDepreEditPage", (Object)true);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (depreamountDeal.equals(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e1a\u52a1", (String)"FaDepreEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]))) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("fa_depre_validate_deal");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("asssetbookId", assetbookid);
            map.put("curperiodId", curperiodId);
            map.put("ordId", ordId);
            map.put("depreuseId", depreuseId);
            DynamicObject disLogObj = QueryServiceHelper.queryOne((String)"fa_disdepre_log", (String)"result_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)disDepreLogId)});
            String curBookDepreCheckStr = disLogObj.getString("result_tag");
            Map cacheDepreCheckMap = (Map)SerializationUtils.fromJsonString((String)curBookDepreCheckStr, Map.class);
            if (StringUtils.isBlank((Object)cacheDepreCheckMap) || CollectionUtils.isEmpty((Map)cacheDepreCheckMap)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u63d0\u67e5\u770b\u8df3\u8f6c\u4f20\u9012\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"FaDepreEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            try {
                map.put(CACHE_DEPRE_CHECK, JSONUtils.toString((Object)cacheDepreCheckMap));
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParams(map);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewdeprevalidate"));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object depreAgain = e.getReturnData();
        if ("depreAgain".equals(depreAgain + "")) {
            IDataModel m = this.getModel();
            this.tbldepreMethod(m);
        } else {
            Map resultMap = (Map)depreAgain;
            if (!CollectionUtils.isEmpty((Map)resultMap)) {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setFormId("bos_list");
                String filter = (String)resultMap.get("filter");
                parameter.setCustomParam("filter", resultMap.get("filter"));
                parameter.setBillFormId((String)resultMap.get("pageId"));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getListFilterParameter().getQFilters().add(QFilter.fromSerializedString((String)(filter + "")));
                this.getView().showForm((FormShowParameter)parameter);
            }
            this.refreshPage(true);
        }
    }

    private void depreciateByThread(Set<DynamicObject> assetBookSet) {
        boolean enablePlatformThreadPool = FaBillParamUtils.getBooleanValue(null, null, null, (String)"enableplatformthreadpool");
        if (enablePlatformThreadPool) {
            ThreadService.execute(() -> this.depreciate(assetBookSet), (TaskType)TaskType.FA_DEPRE_EDIT);
        } else {
            THREAD_POOL.execute(() -> this.depreciate(assetBookSet));
        }
    }

    private void depreciate(Set<DynamicObject> assetBookSet) {
        try {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("fromFaDepreEditPlugin", "true");
            OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"fadepreciate", (String)"fa_assetbook", (Object[])assetBookSet.stream().map(DataEntityBase::getPkValue).toArray(), (OperateOption)operateOption);
            if (!executeOperate.isSuccess()) {
                StringBuilder sb = new StringBuilder();
                for (OperateErrorInfo errorInfo : executeOperate.getAllErrorInfo()) {
                    sb.append(errorInfo.getMessage()).append(",");
                }
                throw new KDBizException(sb.toString());
            }
        }
        catch (Exception e) {
            logger.error("\u6298\u65e7", (Throwable)e);
            this.dealCommonException(assetBookSet, e, "true");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("errMsg", e.getMessage());
            for (DynamicObject assetBook : assetBookSet) {
                Object assetBookId = assetBook.getPkValue();
                this.cache.put(assetBookId + "DailyDepreImpl_cacheKey", map);
            }
        }
    }

    private void dealCommonException(Set<DynamicObject> assetBookSet, Exception e, String type) {
        for (DynamicObject assetBook : assetBookSet) {
            Object pkValue = assetBook.getPkValue();
            this.dealCommonException(assetBook, pkValue, e, type);
        }
    }

    private void dealCommonException(DynamicObject assetBook, Object pkValue, Exception e, String type) {
        String failKey = pkValue + "failed";
        this.getPageCache().put(failKey, type);
    }

    public void onProgress(ProgressEvent evt) {
        int value = 60;
        this.getparam();
        evt.setProgress(value);
    }

    private void getparam() {
        String idcollection = this.getPageCache().get("idcollection");
        if (idcollection == null) {
            return;
        }
        Set bookids = (Set)SerializationUtils.fromJsonString((String)idcollection, Set.class);
        if (bookids.isEmpty()) {
            ProgressBar pro = (ProgressBar)this.getControl(PROGRESSBARAP);
            pro.stop();
        }
        HashMap<Long, HashSet<Long>> periodIdBookIdsMap = new HashMap<Long, HashSet<Long>>(bookids.size());
        IDataModel model = this.getModel();
        for (Long bookId : bookids) {
            int row = Integer.parseInt(this.getPageCache().get(bookId.toString()));
            Long periodId = ((DynamicObject)model.getValue(CUR_PERIOD, row)).getLong("id");
            HashSet<Long> groupBookIds = (HashSet<Long>)periodIdBookIdsMap.get(periodId);
            if (groupBookIds == null) {
                groupBookIds = new HashSet<Long>();
                periodIdBookIdsMap.put(periodId, groupBookIds);
            }
            groupBookIds.add(bookId);
        }
        String queryFields = Fa.comma((String[])new String[]{"id", "assetbook", "allcount", "depredcount", "creator", "createtime", "finishtime", STATUS, "result", "result_tag"});
        Map assetBookDisLogMap = FaDisDepreLogUtils.queryLatestDepreLog4Batch(periodIdBookIdsMap, (String)queryFields);
        IDataModel m = this.getModel();
        Iterator iterator = bookids.iterator();
        while (iterator.hasNext()) {
            Long bookid = (Long)iterator.next();
            int row = Integer.parseInt(this.getPageCache().get(bookid.toString()));
            DynamicObject period = (DynamicObject)m.getValue(CUR_PERIOD, row);
            DynamicObject newDisDepreLog = (DynamicObject)assetBookDisLogMap.get(bookid);
            if (newDisDepreLog == null) continue;
            m.setValue(DISLOGID, (Object)newDisDepreLog.getLong("id"), row);
            String cacheFailed = this.getPageCache().get(bookid + "failed");
            if (cacheFailed != null) {
                if (!cacheFailed.equalsIgnoreCase("true")) continue;
                m.setValue(DEPRE_STATUS, (Object)"D", row);
                Map cacheMap = (Map)this.cache.get(bookid + "DailyDepreImpl_cacheKey", Map.class);
                m.setValue(DEPRE_AMOUNT, cacheMap.get("errMsg"), row);
                iterator.remove();
                continue;
            }
            int cardSize = newDisDepreLog.getInt("allcount");
            int finish = newDisDepreLog.getInt("depredcount");
            String taskStatus = newDisDepreLog.getString(STATUS);
            DepreStatusEnum2 statusEm = DepreStatusEnum2.fromString((String)taskStatus);
            if (DepreStatusEnum2.SUC == statusEm) {
                if (cardSize == 0) {
                    m.setValue(DEPRE_AMOUNT, (Object)ResManager.loadKDString((String)"\u672c\u671f\u4e0d\u5b58\u5728\u9700\u8981\u8ba1\u63d0\u6298\u65e7\u7684\u5361\u7247\u3002", (String)"FaDepreEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]), row);
                } else {
                    m.setValue(DEPRE_AMOUNT, (Object)ResManager.loadKDString((String)"\u8054\u67e5\u6298\u65e7", (String)"FaDepreEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), row);
                }
                m.setValue(DEPRE_STATUS, (Object)"C", row);
                m.setValue(ALL_DEPREAMOUNT, (Object)cardSize, row);
                m.setValue(AUDITOR, (Object)newDisDepreLog.getString("creator"), row);
                m.setValue(AUDITDATE, (Object)newDisDepreLog.getDate("createtime"), row);
                iterator.remove();
                continue;
            }
            if (DepreStatusEnum2.INIT == statusEm) continue;
            if (DepreStatusEnum2.DOING == statusEm) {
                m.setValue(DEPRE_AMOUNT, (Object)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u6298\u65e7\u5361\u7247\u6570\uff1a%s\u3002", (String)"FaDepreEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]), finish), row);
                m.setValue(ALL_DEPREAMOUNT, (Object)cardSize, row);
                continue;
            }
            if (DepreStatusEnum2.FAI == statusEm) {
                m.setValue(DEPRE_STATUS, (Object)"D", row);
                m.setValue(DEPRE_AMOUNT, (Object)newDisDepreLog.getString("result"), row);
                iterator.remove();
                continue;
            }
            if (DepreStatusEnum2.INTERRUPT == statusEm) {
                m.setValue(DEPRE_STATUS, (Object)"E", row);
                m.setValue(DEPRE_AMOUNT, (Object)newDisDepreLog.getString("result"), row);
                iterator.remove();
                continue;
            }
            if (DepreStatusEnum2.NEED_RE_DEPRE != statusEm) continue;
            m.setValue(DEPRE_STATUS, (Object)statusEm.getValue(), row);
            m.setValue(DEPRE_AMOUNT, (Object)ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e1a\u52a1", (String)"FaDepreEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), row);
            m.setValue(AUDITOR, (Object)newDisDepreLog.getString("creator"), row);
            m.setValue(AUDITDATE, (Object)newDisDepreLog.getDate("createtime"), row);
            iterator.remove();
        }
        this.getPageCache().put("idcollection", SerializationUtils.toJsonString((Object)bookids));
    }

    private String getDepreStatus(Object deprestatus) {
        if (deprestatus == null) {
            return "A";
        }
        switch (String.valueOf(deprestatus)) {
            case "1": {
                return "B";
            }
            case "2": {
                return "C";
            }
            case "3": {
                return "D";
            }
        }
        return "A";
    }

    public void cellClick(CellClickEvent arg0) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
        int rowInt = evt.getRow();
        if (ORG.equals(fieldKey) && rowInt == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"viewlog"});
        }
    }

    private void pageForwardParam(String billEntityId, String formId, ShowType showType, IFormView view) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(billEntityId);
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(showType);
        view.showForm((FormShowParameter)parameter);
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        CommonFilterColumn orgfilterap = (CommonFilterColumn)this.getControl("orgfilterap");
        List<ComboItem> comboItems = this.getOrgCombos(this.getOrgIdAndNames());
        orgfilterap.setComboItems(comboItems);
        orgfilterap.setDefaultValues(new ArrayList());
    }

    private List<ComboItem> getOrgCombos(Map<Long, String> idAndNames) {
        ArrayList<ComboItem> orgCombos = new ArrayList<ComboItem>(idAndNames.size());
        for (Map.Entry<Long, String> entry : idAndNames.entrySet()) {
            ComboItem c = new ComboItem();
            c.setValue(entry.getKey().toString());
            c.setCaption(new LocaleString(entry.getValue()));
            orgCombos.add(c);
        }
        return orgCombos;
    }

    private Boolean setOrgAndDepreuse(QFilter[] qFilters, Set<Object> orgSet, Set<Object> depreuseSet) {
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"org, depreuse", (QFilter[])qFilters);
        if (assetBooks == null || assetBooks.isEmpty()) {
            AbstractFormDataModel m = (AbstractFormDataModel)this.getModel();
            m.setValue("depreusecount", (Object)0);
            m.deleteEntryData(ENTRYENTITY);
            this.getView().updateView(ENTRYENTITY);
            return true;
        }
        Iterator iterator = assetBooks.stream().iterator();
        while (iterator.hasNext()) {
            DynamicObject assetbook = (DynamicObject)iterator.next();
            Long orgId = assetbook.getLong(ORG);
            Long depreuseId = assetbook.getLong(DEPREUSE);
            orgSet.add(orgId);
            depreuseSet.add(depreuseId);
        }
        return false;
    }

    public void click(SearchClickEvent searchClickEvent) {
        List qFilters;
        Boolean flag;
        HashSet<Object> orgSet = new HashSet<Object>();
        HashSet<Object> depreuseSet = new HashSet<Object>();
        Map filterValues = searchClickEvent.getFilterValues();
        FilterParameter filterParameter = searchClickEvent.getFilterParameter();
        List customlist = (List)filterValues.get("customfilter");
        List schemelist = (List)filterValues.get("schemefilter");
        if (customlist != null) {
            for (int i = 0; i < customlist.size(); ++i) {
                Map map1 = (Map)customlist.get(i);
                List listValue = (List)map1.get("Value");
                List listFieldName = (List)map1.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (listFieldName.get(j).equals("org.id")) {
                        orgSet.addAll(listValue);
                    }
                    if (!listFieldName.get(j).equals("depreuse.id")) continue;
                    depreuseSet.addAll(listValue);
                }
            }
        }
        if (schemelist != null && (flag = this.setOrgAndDepreuse((qFilters = filterParameter.getQFilters()).toArray(new QFilter[0]), orgSet, depreuseSet)).booleanValue()) {
            return;
        }
        this.getPageCache().put("orgSet", SerializationUtils.toJsonString(orgSet));
        this.getPageCache().put("depreuseSet", SerializationUtils.toJsonString(depreuseSet));
        this.refreshPage(true);
    }

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.setEntityId("fa_depre");
        CommonFilterColumn orgfilterap = (CommonFilterColumn)this.getControl("orgfilterap");
        orgfilterap.setFieldName(ORG);
        CommonFilterColumn depreusefilterap = (CommonFilterColumn)this.getControl("depreusefilterap");
        depreusefilterap.setFieldName(DEPREUSE);
        SchemeFilterColumn orgfilterschemeap = (SchemeFilterColumn)this.getControl("orgfilterschemeap");
        orgfilterschemeap.setFieldName("org.name");
        SchemeFilterColumn depreusefilterschemeap = (SchemeFilterColumn)this.getControl("depreusefilterschemeap");
        depreusefilterschemeap.setFieldName("depreuse.name");
        filterContainer.setBillFormId("fa_new_depre");
        filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        String fieldName = beforeFilterF7SelectEvent.getFieldName();
        if (fieldName.contains(ORG)) {
            ArrayList<Long> orgIds = new ArrayList<Long>(this.getOrgIdAndNames().keySet());
            List qfilters = beforeFilterF7SelectEvent.getQfilters();
            qfilters.add(new QFilter("id", "in", orgIds));
        }
    }

    private DepreVo rowToDepreVo(Row row, Map<String, Object[]> bookIdPeriodId2DepreInfo) {
        String key;
        Object[] depreInfo;
        DepreVo vo = new DepreVo().setAssetBookId(row.getLong("fid")).setOrgId(row.getLong("forgid")).setDepreUseId(row.getLong("fdepreuse")).setDisDepreLogId(row.getLong("logId")).setStartPeriodId(row.getLong("fenableperiodid")).setCurPeriodId(row.getLong("fcurrentperiodid")).setDepreStatus(row.getString("fstatus")).setCreatorId(row.getLong("fcreatorid")).setCreateDate(row.getDate("fcreatetime"));
        if (vo.getDepreStatus() == null && (depreInfo = bookIdPeriodId2DepreInfo.get(key = vo.getAssetBookId() + "_" + vo.getCurPeriodId())) != null) {
            String depreStatus = this.getDepreStatus(depreInfo[0]);
            vo.setDepreStatus(depreStatus);
            vo.setCreateDate((Date)depreInfo[1]);
            vo.setCreatorId((Long)depreInfo[2]);
        }
        return vo;
    }

    static class DepreVo {
        private Long assetBookId;
        private Long orgId;
        private Long depreUseId;
        private Long disDepreLogId;
        private Long startPeriodId;
        private Long curPeriodId;
        private String depreStatus;
        private Long creatorId;
        private Date createDate;

        DepreVo() {
        }

        public DepreVo setAssetBookId(Long assetBookId) {
            this.assetBookId = assetBookId;
            return this;
        }

        public DepreVo setOrgId(Long orgId) {
            this.orgId = orgId;
            return this;
        }

        public DepreVo setDepreUseId(Long depreUseId) {
            this.depreUseId = depreUseId;
            return this;
        }

        public DepreVo setStartPeriodId(Long startPeriodId) {
            this.startPeriodId = startPeriodId;
            return this;
        }

        public DepreVo setCurPeriodId(Long curPeriodId) {
            this.curPeriodId = curPeriodId;
            return this;
        }

        public DepreVo setDepreStatus(String depreStatus) {
            this.depreStatus = depreStatus;
            return this;
        }

        public DepreVo setCreatorId(Long creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public DepreVo setCreateDate(Date createDate) {
            this.createDate = createDate;
            return this;
        }

        public DepreVo setDisDepreLogId(Long disDepreLogId) {
            this.disDepreLogId = disDepreLogId;
            return this;
        }

        public Long getDisDepreLogId() {
            return this.disDepreLogId;
        }

        public Long getAssetBookId() {
            return this.assetBookId;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public Long getDepreUseId() {
            return this.depreUseId;
        }

        public Long getStartPeriodId() {
            return this.startPeriodId;
        }

        public Long getCurPeriodId() {
            return this.curPeriodId;
        }

        public String getDepreStatus() {
            return this.depreStatus;
        }

        public Long getCreatorId() {
            return this.creatorId;
        }

        public Date getCreateDate() {
            return this.createDate;
        }
    }
}

