/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.TypeConverUtil;

public class FaDepreSystemEditPlugin
extends AbstractFormPlugin
implements IBillPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object initGuideOrgId = this.getView().getFormShowParameter().getCustomParam("initGuide.orgId");
        if (initGuideOrgId != null) {
            this.getModel().setValue("createorg", initGuideOrgId);
            this.getModel().setValue("useorg", initGuideOrgId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        IDataModel model = this.getModel();
        Long createOrgId = (Long)model.getValue("createorg_id");
        BasedataEdit bde = (BasedataEdit)this.getControl("assetcat");
        bde.addBeforeF7SelectListener(click -> {
            ArrayList<Object> ffList = new ArrayList<Object>();
            DynamicObjectCollection dync = model.getEntryEntity("assetpolicy_entry");
            for (DynamicObject item : dync) {
                DynamicObject filterParam = item.getDynamicObject("assetcat");
                if (filterParam == null) continue;
                ffList.add(filterParam.getString("id"));
            }
            if (!ffList.isEmpty()) {
                ArrayList ffLists = new ArrayList();
                ffList.forEach(r -> ffLists.add(TypeConverUtil.ObjToLong((Object)r)));
                QFilter f = new QFilter("id", "not in", ffLists);
                QFilter createOrgF = BaseDataServiceHelper.getBaseDataFilter((String)"fa_assetcategory", (Long)createOrgId);
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(f);
                filters.add(createOrgF);
                ListShowParameter showParam = (ListShowParameter)click.getFormShowParameter();
                ListFilterParameter filterParam = showParam.getListFilterParameter();
                filterParam.setQFilters(filters);
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
            boolean referenced = checker.isRefrenced((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"fa_depresystem"), model.getValue("id"));
            model.setValue("referenced", (Object)referenced);
        }
        this.setFieldsChanged();
        long useorg = (Long)model.getValue("useorg_id");
        long createorg = (Long)model.getValue("createorg_id");
        if (useorg != createorg) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flex_assetpolicy"});
        }
        DynamicObjectCollection assetPolicyEntry = (DynamicObjectCollection)model.getValue("assetpolicy_entry");
        this.setEnableWorkLoadUnit(assetPolicyEntry);
    }

    public void setEnableWorkLoadUnit(DynamicObjectCollection assetPolicyEntry) {
        if (assetPolicyEntry.isEmpty()) {
            return;
        }
        for (int i = 0; i < assetPolicyEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)assetPolicyEntry.get(i);
            if (Objects.isNull(entry)) {
                return;
            }
            DynamicObject depreMethodDynObj = entry.getDynamicObject("depremethod");
            if (Objects.nonNull(depreMethodDynObj) && "5".equals(depreMethodDynObj.getString("type"))) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"workloadunit"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"workloadunit"});
        }
    }

    private void setFieldsChanged() {
        MainEntityType entityType = this.getModel().getDataEntityType();
        DynamicProperty referencedProp = entityType.getProperty("referenced");
        DataEntityState entityState = this.getModel().getDataEntity().getDataEntityState();
        entityState.setBizChanged(referencedProp.getOrdinal(), false);
    }

    private Set<Object> getOldAssetCatIds() {
        if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            IDataModel model = this.getModel();
            Object id = model.getValue("id");
            DynamicObject depreSystem = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fa_depresystem");
            DynamicObjectCollection assetPolicies = depreSystem.getDynamicObjectCollection("assetpolicy_entry");
            return assetPolicies.stream().map(v -> v.get("assetcat_id")).collect(Collectors.toSet());
        }
        return new HashSet<Object>();
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        e.getSourceDataList().stream().forEach(map -> {
            if (map.containsKey("assetpolicy_entry")) {
                JSONArray array = (JSONArray)map.get("assetpolicy_entry");
                array.stream().forEach(o -> {
                    BigDecimal useYearBigDecimal;
                    BigDecimal expectUseBigDecimal;
                    Object obj;
                    JSONObject object = (JSONObject)o;
                    if (object.containsKey((Object)"nodepre") && object.getBoolean("nodepre").booleanValue()) {
                        object.put("depremethod", null);
                        object.put("depretime", null);
                        object.put("depreeffect", null);
                        object.put("workloadunit", null);
                    }
                    if (Objects.isNull(obj = object.get((Object)"workloadunit"))) {
                        object.put("workloadunit", null);
                    }
                    if (Objects.nonNull(expectUseBigDecimal = object.getBigDecimal("expectuse"))) {
                        BigDecimal useYear = expectUseBigDecimal.setScale(0, RoundingMode.DOWN);
                        object.put("useyear", (Object)useYear);
                    }
                    if (Objects.nonNull(useYearBigDecimal = object.getBigDecimal("useyear"))) {
                        object.put("expectuse", (Object)useYearBigDecimal);
                    }
                });
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject depreMethodDynObj;
        boolean nodepre;
        DynamicObject depreMethodDynObj2;
        if (this.getPageCache().get("canceling") != null) {
            return;
        }
        super.beforePropertyChanged(e);
        String prop = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        IDataModel model = this.getModel();
        if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            if (Fa.join((String)",", (String[])new String[]{"assetcat", "depreeffect", "depretime", "decpolicy", "nodepre", "workloadunit", "depremethod"}).contains(prop)) {
                DynamicObject entry = changeSet[0].getDataEntity();
                Object catid = entry.get("assetcat_id");
                if ("assetcat".equals(prop)) {
                    if (changeSet[0].getOldValue() == null) {
                        return;
                    }
                    catid = ((DynamicObject)changeSet[0].getOldValue()).getPkValue();
                }
                boolean isCheck = this.getOldAssetCatIds().contains(catid);
                if ("workloadunit".equals(prop)) {
                    Object depSystemId = ((DynamicObject)entry.getParent()).getPkValue();
                    DynamicObject targetPolicy = AssetPolicyUtil.getByDepreSystemAndCat((Object)depSystemId, (Object)catid);
                    Object dbOldValueWorkLoadUnit = targetPolicy.get("workloadunit");
                    isCheck = Objects.nonNull(dbOldValueWorkLoadUnit) ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
                }
                if (isCheck) {
                    DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)"org.id", (QFilter[])new QFilter("depresystem", "=", (Object)TypeConverUtil.ObjToLong((Object)model.getValue("id"))).toArray());
                    Set<Object> orgIds = books.stream().map(v -> v.get("org.id")).collect(Collectors.toSet());
                    HashSet orgIdList = new HashSet();
                    orgIds.forEach(r -> orgIdList.add(TypeConverUtil.ObjToLong((Object)r)));
                    boolean exists = QueryServiceHelper.exists((String)"fa_card_real", (QFilter[])new QFilter("assetcat", "=", catid).and(new QFilter("org", "in", orgIdList)).toArray());
                    if (exists) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u7c7b\u522b\u5df2\u88ab\u5361\u7247\u5f15\u7528\uff0c\u4e0d\u53ef\u4fee\u6539\u8d44\u4ea7\u653f\u7b56\u3002", (String)"FaDepreSystemEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                        this.getPageCache().put("canceling", "balabala balabala");
                        model.setValue(prop, changeSet[0].getOldValue(), rowIndex);
                        this.getPageCache().remove("canceling");
                        return;
                    }
                }
            }
        } else {
            Object value;
            if ("assetcat".equalsIgnoreCase(prop) && Objects.nonNull(value = model.getValue("depremethod", rowIndex))) {
                depreMethodDynObj2 = (DynamicObject)value;
                if ("5".equals(depreMethodDynObj2.getString("type"))) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"workloadunit"});
                } else {
                    model.setValue("workloadunit", null, rowIndex);
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"workloadunit"});
                }
            }
            if ("workloadunit".equalsIgnoreCase(prop) && Objects.nonNull(value = model.getValue("depremethod", rowIndex)) && !"5".equals((depreMethodDynObj2 = (DynamicObject)value).getString("type"))) {
                model.setValue("workloadunit", null, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"workloadunit"});
            }
        }
        if (("nodepre".equalsIgnoreCase(prop) || "depremethod".equalsIgnoreCase(prop) || "depretime".equalsIgnoreCase(prop) || "depreeffect".equalsIgnoreCase(prop)) && (nodepre = ((Boolean)model.getValue("nodepre", rowIndex)).booleanValue())) {
            model.setValue("depremethod", null, rowIndex);
            model.setValue("depretime", null, rowIndex);
            model.setValue("depreeffect", null, rowIndex);
            model.setValue("workloadunit", null, rowIndex);
        }
        if ("depremethod".equalsIgnoreCase(prop) && Objects.nonNull(depreMethodDynObj = (DynamicObject)model.getValue("depremethod", rowIndex))) {
            if ("5".equals(depreMethodDynObj.getString("type"))) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"workloadunit"});
            } else {
                model.setValue("workloadunit", null, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"workloadunit"});
                BigDecimal expectUse = (BigDecimal)model.getValue("expectuse");
                if (Objects.nonNull(expectUse)) {
                    expectUse = expectUse.setScale(0, RoundingMode.DOWN);
                    model.setValue("expectuse", (Object)expectUse, rowIndex);
                    model.setValue("useyear", (Object)expectUse, rowIndex);
                }
            }
        }
        if ("expectuse".equalsIgnoreCase(prop)) {
            Object workLoadUnit = model.getValue("workloadunit", rowIndex);
            depreMethodDynObj2 = (DynamicObject)model.getValue("depremethod", rowIndex);
            if (Objects.isNull(workLoadUnit) || Objects.nonNull(depreMethodDynObj2) && !"5".equals(depreMethodDynObj2.getString("type"))) {
                BigDecimal expectUse = (BigDecimal)model.getValue("expectuse", rowIndex);
                if (Objects.nonNull(expectUse)) {
                    expectUse = expectUse.setScale(0, RoundingMode.DOWN);
                    model.setValue("expectuse", (Object)expectUse, rowIndex);
                    model.setValue("useyear", (Object)expectUse, rowIndex);
                }
            } else {
                BigDecimal expectUse = (BigDecimal)model.getValue("expectuse");
                if (Objects.nonNull(expectUse)) {
                    expectUse = expectUse.setScale(0, RoundingMode.DOWN);
                    model.setValue("useyear", (Object)expectUse, rowIndex);
                }
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            return;
        }
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        IDataModel model = this.getModel();
        HashSet<Object> catIds = new HashSet<Object>(rowIndexs.length);
        for (int rowIndex : rowIndexs) {
            catIds.add(model.getValue("assetcat_id", rowIndex));
        }
        catIds.remove(0L);
        catIds.retainAll(this.getOldAssetCatIds());
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)"org.id", (QFilter[])new QFilter("depresystem", "=", (Object)TypeConverUtil.ObjToLong((Object)this.getModel().getValue("id"))).toArray());
        Set<Object> orgIds = books.stream().map(v -> v.get("org.id")).collect(Collectors.toSet());
        HashSet orgIdList = new HashSet();
        orgIds.forEach(r -> orgIdList.add(TypeConverUtil.ObjToLong((Object)r)));
        boolean exists = QueryServiceHelper.exists((String)"fa_card_real", (QFilter[])new QFilter("assetcat", "in", catIds).and(new QFilter("org", "in", orgIdList)).toArray());
        if (exists) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5b58\u5728\u5df2\u88ab\u5361\u7247\u5f15\u7528\u7684\u8d44\u4ea7\u7c7b\u522b\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"FaDepreSystemEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }
}

