/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;

public class FaDisdepreLogListPlugin
extends AbstractListPlugin {
    public void beforeBindData(EventObject e) {
        IFormView formView = this.getView();
        formView.setVisible(Boolean.valueOf(false), new String[]{"allcount", "depredcount"});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new DisDepreLogListDataProvider());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("autodeprelog".equals(key)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("fa_operation_log");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private static class DisDepreLogListDataProvider
    extends ListDataProvider {
        private DisDepreLogListDataProvider() {
        }

        public void setListFields(List<ListField> listFields) {
            ListField e = new ListField("rate");
            e.setFieldName("rate");
            listFields.add(e);
            super.setListFields(listFields);
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            rows.getDynamicObjectType().registerProperty("rate", BigDecimal.class, (Object)BigDecimal.ZERO, false);
            for (DynamicObject row : rows) {
                long depredCount;
                long allCount = row == null ? 0L : row.getLong("allcount");
                long l = depredCount = row == null ? 0L : row.getLong("depredcount");
                if (allCount == 0L || depredCount == 0L) continue;
                row.set("rate", (Object)new BigDecimal(depredCount).multiply(new BigDecimal("100")).divide(new BigDecimal(allCount), 2, RoundingMode.HALF_UP));
            }
            return rows;
        }
    }
}

