/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.DispatchtypeEnum;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeModeConfUtil;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.FaBillBaseFormPlugin;
import kd.fi.fa.utils.FaF7CostCenterUtils;
import kd.fi.fa.utils.FaF7DeptUtils;
import kd.fi.fa.utils.FaQFilter;

public class FaDispatchBillEditPlugin
extends FaBillBaseFormPlugin {
    private static final String CACHE_INIT_FLAG = "cache_init_flag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"changeapplier"});
        this.addClickListeners(new String[]{"changeapplierin"});
        BasedataEdit realcardEdit = (BasedataEdit)this.getView().getControl("realcard");
        realcardEdit.addBeforeF7SelectListener(v -> FaQFilter.realCardQFilter(this.getModel(), v));
        BasedataEdit outAssetUnit = (BasedataEdit)this.getControl("assetunit");
        outAssetUnit.addBeforeF7SelectListener(this::beforeOutAssetUnitF7Select);
        BasedataEdit inAssetUnit = (BasedataEdit)this.getControl("inassetunit");
        inAssetUnit.addBeforeF7SelectListener(this::beforeInAssetUnitF7Select);
        DynamicObject inOrg = (DynamicObject)this.getModel().getValue("inorg");
        DynamicObject inAssetUn = (DynamicObject)this.getModel().getValue("inassetunit");
        BasedataEdit inUserDept = (BasedataEdit)this.getControl("inusedept");
        inUserDept.addBeforeF7SelectListener(evt -> {
            FaF7DeptUtils.beforeDeptSelect(evt, inOrg, inAssetUn);
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
        });
        String entityName = this.getModel().getDataEntity().getDataEntityType().getName();
        if ("fa_dispatch_in".equals(entityName)) {
            BasedataEdit inCostCenter = (BasedataEdit)this.getControl("incostcentrer");
            inCostCenter.addBeforeF7SelectListener(evt -> FaF7CostCenterUtils.beforeCostCenterSelect(evt, this.getModel().getDataEntity().getDynamicObject("inorg")));
        }
    }

    private void selectDefaultOrg(IDataModel model, IPageCache pageCache, String entityName) {
        List orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)entityName, (String)"47156aff000000ac");
        if (orgIds == null || orgIds.size() < 1) {
            return;
        }
        if (pageCache == null) {
            return;
        }
        String defaultOrg = pageCache.get("assetunit");
        if (defaultOrg == null || StringUtils.isEmpty((CharSequence)defaultOrg)) {
            Long orgId = RequestContext.get().getOrgId();
            if (orgIds.contains(orgId)) {
                model.setValue("assetunit", (Object)orgId);
            } else {
                model.setValue("assetunit", orgIds.get(0));
            }
            this.setOrgByAssetUnit(true);
            return;
        }
        DynamicObject orgObject = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(defaultOrg), (String)"bos_org");
        if (null == orgObject) {
            model.setValue("assetunit", orgIds.get(0));
        } else {
            model.setValue("assetunit", orgObject.get("id"));
        }
        this.setOrgByAssetUnit(true);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DynamicObject assetUnit;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Long userId = ContextUtil.getUserId();
        model.setValue("dispatchdate", (Object)new Date());
        model.setValue("appliant", (Object)userId);
        model.setValue("outuser", (Object)userId);
        this.setUserName();
        this.getModel().setValue("inassetunit", null);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        String isInit = this.getPageCache().get(CACHE_INIT_FLAG);
        if (StringUtils.isBlank((CharSequence)isInit) && parentView != null) {
            this.selectDefaultOrg(this.getModel(), (IPageCache)parentView.getService(IPageCache.class), "fa_dispatch");
            this.getPageCache().put(CACHE_INIT_FLAG, "true");
            if (this.getModel().getValue("org") == null) {
                return;
            }
        } else if (StringUtils.isNotBlank((CharSequence)isInit)) {
            this.setOrgByAssetUnit(true);
            if (this.getModel().getValue("org") == null) {
                return;
            }
        }
        if ((assetUnit = (DynamicObject)model.getValue("assetunit")) != null) {
            long assetunitId = assetUnit.getLong("id");
            model.setValue("changemode", (Object)FaChangeModeConfUtil.getChangeModeDefaultValue((Long)assetunitId, (String)"fa_dispatch"));
        }
        DynamicObject mainAssetBook = null;
        try {
            mainAssetBook = FaAssetBookDaoFactory.getInstance().queryMainBookByOrg(((DynamicObject)this.getModel().getValue("org")).getPkValue());
        }
        catch (Exception e1) {
            this.getView().showTipNotification(e1.getMessage());
            this.setButtonEnable(false);
            return;
        }
        this.setButtonEnable(true);
        Long currencyId = mainAssetBook.getDynamicObject("basecurrency").getLong("id");
        model.setValue("currency", (Object)currencyId);
        BigDecimal exchangeRate = BigDecimal.valueOf(1.0);
        model.setValue("currencyrate", (Object)exchangeRate);
        DynamicObject creator = (DynamicObject)this.getModel().getValue("creator");
        if (creator != null) {
            Long creatorId = creator.getLong("id");
            Map<String, Object> dpt = FaDispatchBillEditPlugin.getDptNameByUserId(creatorId);
            model.setValue("dptnames", dpt.get("dpt"));
        }
        FaBizUtils.setDate((IFormView)this.getView(), (String)"dispatchdate", (DateEdit)((DateEdit)this.getControl("dispatchdate")), (boolean)false, (boolean)true);
        this.getView().setVisible(Boolean.FALSE, new String[]{"dispatchtype"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setUserName();
        this.setBillStatus();
    }

    private void setUserName() {
        DynamicObject inuser;
        IFormView formView = this.getView();
        DynamicObject outuser = (DynamicObject)this.getModel().getValue("outuser");
        if (outuser != null) {
            ((Label)formView.getControl("outusername")).setText(outuser.getString("name"));
        }
        if ((inuser = (DynamicObject)this.getModel().getValue("inuser")) != null) {
            ((Label)formView.getControl("inusername")).setText(inuser.getString("name"));
        } else {
            ((Label)formView.getControl("inusername")).setText(null);
        }
    }

    public static Map<String, Object> getDptNameByUserId(Long creatorId) {
        HashMap<String, Object> userDpt = new HashMap<String, Object>();
        userDpt.put("dpt", 0L);
        userDpt.put("dptName", null);
        String selectField = "id,entryentity.dpt,entryentity.ispartjob,entryentity.dpt.name,name";
        QFilter idFilter = new QFilter("id", "=", (Object)creatorId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_user", (String)selectField, (QFilter[])new QFilter[]{idFilter}, (String)"");
        if (collection.isEmpty()) {
            return userDpt;
        }
        for (DynamicObject userObj : collection) {
            boolean ispartjob = userObj.getBoolean("entryentity.ispartjob");
            if (ispartjob) continue;
            userDpt.put("dpt", userObj.get("entryentity.dpt"));
            userDpt.put("dptName", userObj.getString("entryentity.dpt.name"));
            return userDpt;
        }
        return userDpt;
    }

    public void click(EventObject evt) {
        ListShowParameter show;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("changeapplier".equals(key)) {
            show = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)false, (int)2, (boolean)true);
            show.setShowFilter(true);
            show.setShowQuickFilter(true);
            show.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changeouteruser"));
            this.getView().showForm((FormShowParameter)show);
        }
        if ("changeapplierin".equals(key)) {
            show = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)false, (int)2, (boolean)true);
            show.setShowFilter(true);
            show.setShowQuickFilter(true);
            show.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changeouteruserin"));
            this.getView().showForm((FormShowParameter)show);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject dispatchInDy;
        OperationResult result;
        super.beforeDoOperation(args);
        String type = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("faconfirm".equals(type) && this.getModel().getDataChanged() && !(result = OperationServiceHelper.executeOperate((String)"save", (String)"fa_dispatch_in", (DynamicObject[])new DynamicObject[]{dispatchInDy = this.getModel().getDataEntity(Boolean.TRUE.booleanValue())}, null)).isSuccess()) {
            List allError = result.getAllErrorOrValidateInfo();
            result.getAllErrorInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            }
            String msg = new LocaleString(String.format("%s%s%s", ResManager.loadKDString((String)"\u4fdd\u5b58\u8c03\u5165\u5355\u5931\u8d25\u3002", (String)"FaDispatchBillEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), result.getMessage(), errorInfo.toString())).toString();
            throw new KDBizException(msg);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection userId;
        super.closedCallBack(closedCallBackEvent);
        String callBack = closedCallBackEvent.getActionId();
        IDataModel dataModel = this.getModel();
        if ("changeouteruser".equalsIgnoreCase(callBack) && (userId = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            dataModel.setValue("outuser", userId.get(0).getPrimaryKeyValue());
        }
        if ("changeouteruserin".equalsIgnoreCase(callBack) && (userId = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            dataModel.setValue("inuser", userId.get(0).getPrimaryKeyValue());
        }
    }

    private void setBillStatus() {
        String value;
        IDataEntityProperty property = this.getModel().getProperty("billstatus");
        if (property != null && "D".equals(value = (String)this.getModel().getValue("billstatus"))) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel dataModel = this.getModel();
        String propertyName = e.getProperty().getName();
        if ("realcard".equals(propertyName)) {
            ChangeData[] changeDatas;
            for (ChangeData changeData : changeDatas = e.getChangeSet()) {
                int changeRowIndex = changeData.getRowIndex();
                DynamicObject card = changeData.getDataEntity().getDynamicObject("realcard");
                if (card != null) {
                    Date date = (Date)dataModel.getValue("dispatchdate");
                    long orgId = (Long)dataModel.getValue("org_id");
                    HashSet<Long> cardIds = new HashSet<Long>(1);
                    cardIds.add(card.getLong("id"));
                    String msg = FaUtils.checkRealCardBizStatus(cardIds);
                    if (!msg.isEmpty()) {
                        dataModel.setValue("measurement", null, changeRowIndex);
                        dataModel.setValue("dispatchqty", null, changeRowIndex);
                        this.getView().showErrorNotification(msg);
                        return;
                    }
                    Set existCards = FaUtils.getCurRealCard((Date)date, (Long)orgId, (Boolean)false, cardIds, (BusyTypeDetailEnum)BusyTypeDetailEnum.REAL_FIN_CHG, null);
                    if (!existCards.containsAll(cardIds)) {
                        this.getModel().deleteEntryRow("dispatchentry", changeRowIndex);
                        this.getModel().batchCreateNewEntryRow("dispatchentry", 1);
                        FaUtils.showErrorRealCardMsg((int)1, null, (DynamicObject)card, (IFormView)this.getView());
                        return;
                    }
                    dataModel.setValue("measurement", card.getDynamicObject("unit").get("id"), changeRowIndex);
                    dataModel.setValue("dispatchqty", card.get("assetamount"), changeRowIndex);
                    continue;
                }
                dataModel.setValue("measurement", null, changeRowIndex);
                dataModel.setValue("dispatchqty", null, changeRowIndex);
            }
        }
        if ("assetunit".equals(propertyName)) {
            this.setOrgByAssetUnit(true);
        }
        if ("inassetunit".equals(propertyName)) {
            this.setOrgByAssetUnit(false);
        }
        if ("org".equals(propertyName) || "inorg".equals(propertyName)) {
            long inorgId;
            dataModel.setValue("dispatchtype", (Object)DispatchtypeEnum.A.name());
            DynamicObjectCollection entries = dataModel.getEntryEntity("dispatchentry");
            for (int i = 0; i < entries.size(); ++i) {
                dataModel.setValue("evaluate", (Object)BigDecimal.ZERO, i);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"evaluate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"dispatchtype"});
            DynamicObject org = (DynamicObject)dataModel.getValue("org");
            DynamicObject inorg = (DynamicObject)dataModel.getValue("inorg");
            if (org == null || org.getLong("id") == 0L) {
                return;
            }
            if (inorg == null || inorg.getLong("id") == 0L) {
                return;
            }
            long orgId = org.getLong("id");
            if (orgId != (inorgId = inorg.getLong("id"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"dispatchtype"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"evaluate"});
            }
        }
        this.setUserName();
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List sourceDataList = e.getSourceDataList();
        sourceDataList.stream().forEach(v -> {
            List entry = (List)v.get("dispatchentry");
            Object org = v.get("org");
            entry.stream().forEach(c -> {
                Object realcard = c.get("realcard");
                if (realcard != null) {
                    Object num = ((Map)realcard).get("number");
                    Object id = ((Map)realcard).get("id");
                    if (id != null) {
                        DynamicObject[] cards = BusinessDataServiceHelper.load((String)"fa_card_real_base", (String)"assetamount,unit.number", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
                        if (cards.length > 0) {
                            HashMap<String, Object> mea = new HashMap<String, Object>(1);
                            DynamicObject card = cards[0];
                            mea.put("number", card.get("unit.number"));
                            c.put("measurement", mea);
                            c.put("dispatchqty", card.get("assetamount"));
                        }
                    } else if (num != null && org != null) {
                        QFilter qFilter;
                        QFilter filter;
                        Object orgnum = ((Map)org).get("number");
                        Object orgid = ((Map)org).get("id");
                        QFilter filterorg = orgid != null ? new QFilter("org.id", "=", orgid) : new QFilter("org.number", "=", orgnum);
                        DynamicObject[] cards = BusinessDataServiceHelper.load((String)"fa_card_real_base", (String)"assetamount,unit.number", (QFilter[])new QFilter[]{filterorg, filter = new QFilter("number", "=", num), qFilter = new QFilter("isbak", "=", (Object)"0")});
                        if (cards.length > 0) {
                            HashMap<String, Object> mea = new HashMap<String, Object>(1);
                            DynamicObject card = cards[0];
                            mea.put("number", card.get("unit.number"));
                            c.put("measurement", mea);
                            c.put("dispatchqty", card.get("assetamount"));
                        }
                    }
                }
            });
        });
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        this.importNumberToId(e);
        super.beforeImportData(e);
    }

    private void importNumberToId(BeforeImportDataEventArgs e) {
        Map sourceDataMap = e.getSourceData();
        JSONObject sourceData = new JSONObject(sourceDataMap);
        String assetUnitNumber = sourceData.getJSONObject("assetunit").getString("number");
        String orgNumber = sourceData.getJSONObject("org").getString("number");
        JSONArray entry = sourceData.getJSONArray("dispatchentry");
        HashSet<String> numberSet = new HashSet<String>(entry.size());
        for (Object row : entry) {
            JSONObject jsonObj = new JSONObject((Map)row);
            String realCardNum = jsonObj.getJSONObject("realcard").getString("number");
            numberSet.add(realCardNum);
        }
        HashMap<String, Long> numAndIdMap = new HashMap<String, Long>(numberSet.size());
        String selectFields = String.join((CharSequence)", ", "id", "number");
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", numberSet), new QFilter("id", "=", (Object)"masterid", true), new QFilter(Fa.dot((String[])new String[]{"assetunit", "number"}), "=", (Object)assetUnitNumber), new QFilter(Fa.dot((String[])new String[]{"org", "number"}), "=", (Object)orgNumber), new QFilter("bizstatus", "=", (Object)"READY"), new QFilter("billstatus", "=", (Object)"C")};
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)selectFields, (QFilter[])filters);
        for (DynamicObject realCard : realCards) {
            String number = realCard.getString("number");
            long id = realCard.getLong("id");
            numAndIdMap.put(number, id);
        }
        for (Object row : entry) {
            JSONObject jsonObj = new JSONObject((Map)row);
            JSONObject realCard = jsonObj.getJSONObject("realcard");
            String realCardNum = realCard.getString("number");
            realCard.put("importprop", (Object)"id");
            realCard.put("id", numAndIdMap.get(realCardNum));
        }
    }

    private void setOrgByAssetUnit(boolean isOutOrg) {
        this.setButtonEnable(true);
        DynamicObject assetUnit = isOutOrg ? (DynamicObject)this.getModel().getValue("assetunit") : (DynamicObject)this.getModel().getValue("inassetunit");
        if (assetUnit == null) {
            if (isOutOrg) {
                this.getModel().setValue("org", null);
            } else {
                this.getModel().setValue("inorg", null);
            }
            return;
        }
        long assetUnitId = assetUnit.getLong("id");
        String assetUnitName = assetUnit.getLocaleString("name").toString();
        List fromOrgList = OrgUnitServiceHelper.getFromOrgs((String)"09", (Long)assetUnitId, (String)"10", (boolean)true);
        if (fromOrgList != null && fromOrgList.size() == 1) {
            Long fromOrg = (Long)fromOrgList.get(0);
            List orgList = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_dispatch", (String)"47156aff000000ac");
            if (!isOutOrg || orgList.contains(fromOrg)) {
                if (isOutOrg) {
                    this.getModel().setValue("org", (Object)fromOrg);
                } else {
                    this.getModel().setValue("inorg", (Object)fromOrg);
                }
            } else {
                this.getModel().setValue("assetunit", null);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u8d44\u4ea7\u7ec4\u7ec7\u3010%s\u3011\u5bf9\u5e94\u6838\u7b97\u7ec4\u7ec7\u7684\u6743\u9650\u6216\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u8d26\u7c3f\u3002", (String)"FaDispatchBillEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetUnitName));
                this.setButtonEnable(false);
            }
        } else {
            if (isOutOrg) {
                this.getModel().setValue("assetunit", null);
            } else {
                this.getModel().setValue("inassetunit", null);
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7ec4\u7ec7\u3010%s\u3011\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaDispatchBillEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetUnitName));
            this.setButtonEnable(false);
        }
    }

    private void setButtonEnable(boolean enable) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"titlepanelflex"});
    }

    private void beforeOutAssetUnitF7Select(BeforeF7SelectEvent evt) {
        List permissionOrgIds = FaPermissionUtils.getAllPermissionAssetUnitsV2((String)this.getView().getPageId(), (String)"fa_dispatch", (String)"47156aff000000ac");
        DynamicObject inAssetUnit = (DynamicObject)this.getModel().getValue("inassetunit");
        if (inAssetUnit != null) {
            long inAssetUnitId = inAssetUnit.getLong("id");
            permissionOrgIds.remove(inAssetUnitId);
        }
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = param.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("id", "in", (Object)permissionOrgIds));
    }

    private void beforeInAssetUnitF7Select(BeforeF7SelectEvent evt) {
        List allAssetOrgId = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"09", (boolean)false);
        List allLeafOrgId = FaPermissionUtils.getLeafOrgs((List)allAssetOrgId, (String)"09");
        DynamicObject outAssetUnit = (DynamicObject)this.getModel().getValue("assetunit");
        if (outAssetUnit != null) {
            long outAssetUnitId = outAssetUnit.getLong("id");
            allLeafOrgId.remove(outAssetUnitId);
        }
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = param.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("id", "in", (Object)allLeafOrgId));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("faconfirm".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObjectCollection dispatchEntry = dataEntity.getDynamicObjectCollection("dispatchentry");
            for (DynamicObject entry : dispatchEntry) {
                DynamicObject inCostCenter = entry.getDynamicObject("incostcentrer");
                if (inCostCenter == null) continue;
                long inCostCenterId = entry.getDynamicObject("incostcentrer").getLong("id");
                entry.set("incostcentrer_id", (Object)inCostCenterId);
            }
        }
    }
}

