/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaOperateLogUtil;
import kd.fi.fa.common.util.Fa;

public class FaDynDepreEditPlugin
extends AbstractFormPlugin {
    private static final String CALLBACK_REALCARD_F7 = "callbackrealcardf7";
    private static final String CACHE_ROW_INDEX = "cache_rowIndex";
    public static final String ENTITYNAME_CARD_DYNAMIC = "fa_card_dynamic";
    private static final String FA_DYNDEPRE = "fa_dyndepre";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object bookid = this.getView().getFormShowParameter().getCustomParam("bookid");
        DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"org,depreuse,startperiod", (QFilter[])new QFilter("id", "=", bookid).toArray());
        Object orgid = book.get("org");
        Object depreuseid = book.get("depreuse");
        Object startPeriodId = book.get("startperiod");
        IDataModel model = this.getModel();
        model.setValue("org", orgid);
        model.setValue("depreuse", depreuseid);
        model.setValue("startperiod", startPeriodId);
        DynamicObjectCollection changeRecords = QueryServiceHelper.query((String)ENTITYNAME_CARD_DYNAMIC, (String)"realcard", (QFilter[])new QFilter[]{new QFilter("entityname", "=", (Object)FA_DYNDEPRE), new QFilter("changebillid", "=", bookid)});
        Set<Object> realcardidset = changeRecords.stream().map(v -> v.get("realcard")).collect(Collectors.toSet());
        this.getPageCache().put(CACHE_ROW_INDEX, "0");
        this.fillEntries(realcardidset);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit realcardEdit = (BasedataEdit)this.getView().getControl("realcard");
        realcardEdit.addBeforeF7SelectListener(this::realcardF7Filter);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void realcardF7Filter(BeforeF7SelectEvent evt) {
        evt.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_REALCARD_F7));
        this.getPageCache().put(CACHE_ROW_INDEX, evt.getRow() + "");
        IDataModel model = this.getModel();
        Object orgid = ((DynamicObject)model.getValue("org")).get("id");
        Object depreUseId = ((DynamicObject)model.getValue("depreuse")).get("id");
        Object bookid = this.getView().getFormShowParameter().getCustomParam("bookid");
        Date begindate = ((DynamicObject)model.getValue("startperiod")).getDate("begindate");
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        Set realCardIdSet_selected = entryEntity.stream().map(v -> v.get("realcard.id")).filter(v -> v != null).collect(Collectors.toSet());
        DynamicObjectCollection initFinCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"realcard.masterid", (QFilter[])new QFilter[]{new QFilter("org", "=", orgid), new QFilter("depreuse", "=", depreUseId), new QFilter("assetbook", "=", bookid), new QFilter("bizperiod", "=", (Object)0L)});
        Set initMasterIdSet = initFinCards.stream().map(v -> v.get("realcard.masterid")).collect(Collectors.toSet());
        DynamicObjectCollection dynCards = QueryServiceHelper.query((String)ENTITYNAME_CARD_DYNAMIC, (String)"realcard.id", (QFilter[])new QFilter[]{new QFilter("assetbook", "=", bookid), new QFilter("entityname", "!=", (Object)FA_DYNDEPRE)});
        Set dynCardIdSet = dynCards.stream().map(v -> v.get("realcard.id")).collect(Collectors.toSet());
        realCardIdSet_selected.addAll(dynCardIdSet);
        initMasterIdSet.removeAll(realCardIdSet_selected);
        QFilter filter = new QFilter("id", "in", initMasterIdSet);
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        List filters = param.getListFilterParameter().getQFilters();
        filters.add(filter);
        filters.add(new QFilter("bizstatus", "=", (Object)BizStatusEnum.READY));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        if (StringUtils.equalsIgnoreCase((CharSequence)evt.getActionId(), (CharSequence)CALLBACK_REALCARD_F7) && (returnData = evt.getReturnData()) instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection returnDataList = (ListSelectedRowCollection)returnData;
            HashSet<Object> realCardIds = new HashSet<Object>();
            for (ListSelectedRow row : returnDataList) {
                realCardIds.add(row.getPrimaryKeyValue());
            }
            this.fillEntries(realCardIds);
        }
    }

    private void fillEntries(Set<Object> realCardIds) {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("entryentity");
        int startIndex = Integer.parseInt(this.getPageCache().get(CACHE_ROW_INDEX));
        model.beginInit();
        for (Object realCardId : realCardIds) {
            if (startIndex >= entryRowCount) {
                startIndex = model.insertEntryRow("entryentity", startIndex);
            }
            model.setValue("realcard", realCardId, startIndex);
            ++startIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("save".equalsIgnoreCase(itemKey)) {
            Object bookid = this.getView().getFormShowParameter().getCustomParam("bookid");
            DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"org,depreuse,startperiod,curperiod,status", (QFilter[])new QFilter("id", "=", bookid).toArray());
            Long orgId = book.getLong("org");
            Long depreuseId = book.getLong("depreuse");
            Long startperiodId = book.getLong("startperiod");
            Long curperiodId = book.getLong("curperiod");
            String status = book.getString("status");
            if (status.equals("C")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u5e94\u8d26\u7c3f\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"FaDynDepreEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            if (startperiodId.longValue() != curperiodId.longValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u7b49\u4e8e\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"FaDynDepreEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            if (FaDepreUtil.hasVoucher((Long)orgId, (Long)depreuseId, (Long)curperiodId, (boolean)true)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaDynDepreEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection oldDynCards = QueryServiceHelper.query((String)ENTITYNAME_CARD_DYNAMIC, (String)"realcard", (QFilter[])new QFilter[]{new QFilter("entityname", "=", (Object)FA_DYNDEPRE), new QFilter("changebillid", "=", bookid)});
            Set realCardPkSetInDb = oldDynCards.stream().map(v -> v.get("realcard")).collect(Collectors.toSet());
            IDataModel model = this.getModel();
            int entryRowCount = model.getEntryRowCount("entryentity");
            HashSet<Object> realCardPkSetInput = new HashSet<Object>(entryRowCount, 1.0f);
            for (int i = 0; i < entryRowCount; ++i) {
                Object realCardPK = model.getValue("realcard_id", i);
                if (realCardPK == null || "0".equals(realCardPK.toString())) continue;
                realCardPkSetInput.add(realCardPK);
            }
            HashSet<Object> realCardPkSetDeleted = new HashSet<Object>(realCardPkSetInDb);
            realCardPkSetDeleted.removeAll(realCardPkSetInput);
            DynamicObject org = (DynamicObject)model.getValue("org");
            DynamicObject startperiod = (DynamicObject)model.getValue("startperiod");
            if (realCardPkSetDeleted.size() > 0) {
                Date begindate = startperiod.getDate("begindate");
                FutureBizChecker futureBizChecker = new FutureBizChecker(null, org.getPkValue(), realCardPkSetDeleted, begindate, BusyTypeDetailEnum.REAL_FIN_CHG);
                futureBizChecker.setCompDate4EndDate(false);
                Optional checkResult = futureBizChecker.check();
                if (checkResult.isPresent()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s\u3002", (String)"FaDynDepreEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), checkResult.get());
                    throw new KDBizException(msg);
                }
            }
            HashSet<Object> realCardPkSetNewInput = new HashSet<Object>(realCardPkSetInput);
            realCardPkSetNewInput.removeAll(realCardPkSetInDb);
            if (realCardPkSetNewInput.size() > 0) {
                Date begindate = startperiod.getDate("begindate");
                FutureBizChecker futureBizChecker = new FutureBizChecker(null, org.getPkValue(), realCardPkSetNewInput, begindate, BusyTypeDetailEnum.REAL_FIN_CHG);
                futureBizChecker.setCompDate4EndDate(false);
                Optional checkResult2 = futureBizChecker.check();
                if (checkResult2.isPresent()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s\u3002", (String)"FaDynDepreEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), checkResult2.get());
                    throw new KDBizException(msg);
                }
            }
            if (realCardPkSetDeleted.size() == 0 && realCardPkSetNewInput.size() == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65e0\u987b\u4fdd\u5b58\uff0c\u6ca1\u6709\u53d8\u5316\u6570\u636e\u3002", (String)"FaDynDepreEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            try (TXHandle h = TX.required((String)"saveFaCardDynamic");){
                try {
                    if (realCardPkSetDeleted.size() > 0) {
                        SqlBuilder delSql = new SqlBuilder();
                        Object depreUseId = model.getValue(Fa.id((String)"depreuse"));
                        delSql.append("delete FROM t_fa_card_dynamic WHERE ", new Object[0]).append(" fdepreuseid = ?", new Object[]{depreUseId}).appendIn(" and frealcardid ", realCardPkSetDeleted.toArray());
                        DB.execute((DBRoute)FaConstants.faDBRoute, (SqlBuilder)delSql);
                    }
                    ArrayList<DynamicObject> dynamicCards = new ArrayList<DynamicObject>(realCardPkSetNewInput.size());
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTITYNAME_CARD_DYNAMIC);
                    for (Object e : realCardPkSetNewInput) {
                        DynamicObject dynamicCard = new DynamicObject((DynamicObjectType)type);
                        dynamicCard.set("realcard", e);
                        dynamicCard.set("assetbook", bookid);
                        dynamicCard.set("depreuse", model.getValue("depreuse"));
                        dynamicCard.set("date", (Object)startperiod.getDate("beginDate"));
                        dynamicCard.set("entityname", (Object)FA_DYNDEPRE);
                        dynamicCard.set("changebillid", bookid);
                        dynamicCards.add(dynamicCard);
                    }
                    IFaFinCardDao fCardDao = FaFinCardDaoFactory.getInstance();
                    String[] stringArray = new String[]{"isneeddepre"};
                    HashSet<Object> realCardPkSetCopy = new HashSet<Object>(realCardPkSetDeleted.size() + realCardPkSetNewInput.size());
                    realCardPkSetCopy.addAll(realCardPkSetDeleted);
                    realCardPkSetCopy.addAll(realCardPkSetNewInput);
                    if (realCardPkSetCopy.size() > 0) {
                        fCardDao.copyFinCards(curperiodId.longValue(), depreuseId.longValue(), realCardPkSetCopy.toArray(), this.getDyFinHandler(), stringArray, null);
                    }
                    if (dynamicCards.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])dynamicCards.toArray(new DynamicObject[0]));
                    }
                    h.commit();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"FaDynDepreEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
            try {
                this.insertLog(realCardPkSetDeleted, realCardPkSetNewInput, orgId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private IBizSetCardDataHandler getDyFinHandler() {
        return card -> this.updateFinHandler(card);
    }

    private void updateFinHandler(DynamicObject card) {
        card.set("isneeddepre", (Object)Boolean.TRUE);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    private void insertLog(Set<Object> realCardPkSetDeleted, Set<Object> realCardPkSetNewInput, Long orgId) {
        String prefix = ResManager.loadKDString((String)"\u5207\u6362\u52a8\u6001\u7b97\u6cd5\u6210\u529f\uff1a", (String)"FaDynDepreEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        String opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"FaDynDepreEditPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        ArrayList<String> opDescList = new ArrayList<String>(realCardPkSetDeleted.size() + realCardPkSetNewInput.size());
        if (!realCardPkSetDeleted.isEmpty()) {
            String deletePrefix = ResManager.loadKDString((String)"\u5220\u9664\u7684\u5b9e\u7269\u5361\u7247\u7f16\u7801\uff1a", (String)"FaDynDepreEditPlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            int maxLength = 255 - prefix.length() - deletePrefix.length();
            Set<String> deleteNums = QueryServiceHelper.query((String)"fa_card_real", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", realCardPkSetDeleted)}).stream().map(v -> v.getString("number")).collect(Collectors.toSet());
            opDescList.addAll(this.getOpDescList(deleteNums, prefix + deletePrefix, maxLength));
        }
        if (!realCardPkSetNewInput.isEmpty()) {
            Set<String> newNums = QueryServiceHelper.query((String)"fa_card_real", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", realCardPkSetNewInput)}).stream().map(v -> v.getString("number")).collect(Collectors.toSet());
            String newPrefix = ResManager.loadKDString((String)"\u65b0\u589e\u7684\u5b9e\u7269\u5361\u7247\u7f16\u7801\uff1a", (String)"FaDynDepreEditPlugin_10", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            int maxLength = 255 - prefix.length() - newPrefix.length();
            opDescList.addAll(this.getOpDescList(newNums, prefix + newPrefix, maxLength));
        }
        ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(opDescList.size());
        for (String opDesc : opDescList) {
            appLogInfos.add(FaOperateLogUtil.buildLogInfo((String)FA_DYNDEPRE, (Long)orgId, (String)opName, (String)opDesc));
        }
        FaOperateLogUtil.addBatchLog(appLogInfos);
    }

    private List<String> getOpDescList(Set<String> nums, String prefix, int length) {
        ArrayList<String> opDescList = new ArrayList<String>(16);
        StringBuilder sb = new StringBuilder();
        for (String newNum : nums) {
            sb.append(newNum).append(",");
            if (sb.length() <= length) continue;
            opDescList.add(prefix + sb.substring(0, sb.indexOf(newNum) - 1));
            sb = new StringBuilder(newNum).append(",");
        }
        String str = sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
        opDescList.add(prefix + str);
        return opDescList;
    }
}

