/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.formplugin.FaBillBaseFormPlugin;
import kd.fi.fa.utils.FaF7CostCenterUtils;
import kd.fi.fa.utils.FaF7DeptUtils;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaQFilter;
import kd.fi.fa.utils.FaTransferUtils;

public class FaEngineerBillEditPlugin
extends FaBillBaseFormPlugin {
    private String changeFlag = "0";

    public void registerListener(EventObject e) {
        BasedataEdit realCardF7;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit assetunit = (BasedataEdit)this.getView().getControl("assetunit");
        assetunit.addBeforeF7SelectListener(evt -> FaFormPermissionUtil.beforeAssetUnitSelectV2(this.getView().getPageId(), evt, "fa_engineeringbill"));
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        if (null != orgF7) {
            orgF7.setIsOnlyDisplayOrgLeaves(true);
            orgF7.addBeforeF7SelectListener(listener -> FaF7DeptUtils.orgDelegateAssetUnit(listener, this.getModel()));
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject assetUnit = (DynamicObject)this.getModel().getValue("assetunit");
        BasedataEdit deptF7 = (BasedataEdit)this.getControl("new_usedepartment");
        if (null != deptF7) {
            deptF7.addBeforeF7SelectListener(evt -> {
                FaF7DeptUtils.beforeDeptSelect(evt, org, assetUnit);
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                listShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
            });
        }
        if (null != (realCardF7 = (BasedataEdit)this.getControl("realcardid"))) {
            realCardF7.addBeforeF7SelectListener(this::beforeF7RealCardSelect);
        }
        BasedataEdit costCenter = (BasedataEdit)this.getControl("costcentrer");
        costCenter.addBeforeF7SelectListener(evt -> FaF7CostCenterUtils.beforeCostCenterSelect(evt, org));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getType();
        IDataModel model = this.getModel();
        if ("submit".equals(operateKey)) {
            if ("0".equals(model.getValue("businesstype"))) {
                this.setAddEntryVisible(Boolean.TRUE);
                this.setChangeEntryVisible(Boolean.FALSE);
            } else if ("1".equals(model.getValue("businesstype"))) {
                this.setAddEntryVisible(Boolean.FALSE);
                this.setChangeEntryVisible(Boolean.TRUE);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject eventobject) {
        super.afterCreateNewData(eventobject);
        this.getModel().setValue("billno", null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        Long[] billId = new Long[]{(Long)model.getValue("id")};
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"fa_engineeringbill", (Long[])billId);
        if (sourceBills.size() > 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"businesstype"});
        }
        Long currencyPk = FaTransferUtils.getBaseCurrencyPK(model);
        model.setValue("basecurrency", (Object)currencyPk);
        if ("0".equals(model.getValue("businesstype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"assetsinfo_detailchange"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"assetsinfo_detailadd"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"assetsinfo_detailadd"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"assetsinfo_detailchange"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        int entryCurrentRowIndex = e.getChangeSet()[0].getRowIndex();
        if ("constractamount".equals(propertyName) || "materialamount".equals(propertyName) || "equipmentamount".equals(propertyName) || "otheramount".equals(propertyName)) {
            this.updatetotalAmt(entryCurrentRowIndex, model);
        } else if ("new_assetcat".equals(propertyName)) {
            this.setUnit(model, entryCurrentRowIndex);
        } else if ("businesstype".equals(propertyName)) {
            if ("0".equals(this.changeFlag)) {
                if ("0".equals(model.getValue("businesstype"))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u7c7b\u578b\u5c06\u6e05\u7a7a\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\u3002", (String)"FaEngineerBillEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("add", (IFormPlugin)this));
                } else {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u7c7b\u578b\u5c06\u6e05\u7a7a\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\u3002", (String)"FaEngineerBillEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("change", (IFormPlugin)this));
                }
            }
        } else if ("realcardid".equals(propertyName)) {
            ChangeData changeData = e.getChangeSet()[0];
            int index = changeData.getRowIndex();
            DynamicObject card = (DynamicObject)model.getValue("realcardid", index);
            if (card != null) {
                HashSet<Long> cardIds = new HashSet<Long>(1);
                cardIds.add(card.getLong("id"));
                String msg = FaUtils.checkRealCardBizStatus(cardIds);
                if (!msg.isEmpty()) {
                    model.setValue("realcardid", null, index);
                    this.getView().showErrorNotification(msg);
                    return;
                }
            }
            FaBizUtils.setDate((IFormView)this.getView(), (String)"bizdate", (DateEdit)((DateEdit)this.getControl("bizdate")), (boolean)false, (boolean)this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW), (int)entryCurrentRowIndex);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        IDataModel model = this.getModel();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("add".equals(callBackId)) {
            if ("Cancel".equals(messageBoxClosedEvent.getResultValue())) {
                this.changeFlag = "1";
                this.getModel().setValue("businesstype", (Object)"1");
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"assetsinfo_detailchange"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"assetsinfo_detailadd"});
                model.deleteEntryData("assetsentrychange");
            }
        } else if ("change".equals(callBackId)) {
            if ("Cancel".equals(messageBoxClosedEvent.getResultValue())) {
                this.changeFlag = "1";
                this.getModel().setValue("businesstype", (Object)"0");
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"assetsinfo_detailadd"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"assetsinfo_detailchange"});
                model.deleteEntryData("assetsentryadd");
            }
        }
    }

    private void beforeF7RealCardSelect(BeforeF7SelectEvent evt) {
        FaQFilter.realCardQFilter(this.getModel(), evt);
    }

    private void updatetotalAmt(int entryCurrentRowIndex, IDataModel model) {
        BigDecimal constractAmount = this.getAmountValue(model.getValue("constractamount", entryCurrentRowIndex));
        BigDecimal materialAmount = this.getAmountValue(model.getValue("materialamount", entryCurrentRowIndex));
        BigDecimal quipmentAmount = this.getAmountValue(model.getValue("equipmentamount", entryCurrentRowIndex));
        BigDecimal otherAmount = this.getAmountValue(model.getValue("otheramount", entryCurrentRowIndex));
        BigDecimal totalAmount = null;
        totalAmount = constractAmount.add(materialAmount).add(quipmentAmount).add(otherAmount);
        this.getModel().setValue("totalamount", (Object)totalAmount.toString(), entryCurrentRowIndex);
    }

    private BigDecimal getAmountValue(Object value) {
        if (value != null) {
            return new BigDecimal(value.toString());
        }
        return BigDecimal.ZERO;
    }

    private void setUnit(IDataModel model, int index) {
        DynamicObject dobj = (DynamicObject)model.getValue("new_assetcat", index);
        if (null == dobj || null == dobj.getDynamicObject("unit")) {
            return;
        }
        model.setValue("new_unit", dobj.getDynamicObject("unit").getPkValue(), index);
    }

    private void setAddEntryVisible(Boolean flag) {
        AmountProp originalval = (AmountProp)this.getModel().getProperty("originalval");
        originalval.setMustInput(flag.booleanValue());
        BasedataProp new_assetcat = (BasedataProp)this.getModel().getProperty("new_assetcat");
        new_assetcat.setMustInput(flag.booleanValue());
        TextProp new_assetname = (TextProp)this.getModel().getProperty("new_assetname");
        new_assetname.setMustInput(flag.booleanValue());
        BasedataProp new_unit = (BasedataProp)this.getModel().getProperty("new_unit");
        new_unit.setMustInput(flag.booleanValue());
        QtyProp new_assetqty = (QtyProp)this.getModel().getProperty("new_assetqty");
        new_assetqty.setMustInput(flag.booleanValue());
        BasedataProp new_storeplace = (BasedataProp)this.getModel().getProperty("new_storeplace");
        new_storeplace.setMustInput(flag.booleanValue());
        BasedataProp new_usedepartment = (BasedataProp)this.getModel().getProperty("new_usedepartment");
        new_usedepartment.setMustInput(flag.booleanValue());
    }

    private void setChangeEntryVisible(Boolean flag) {
        BasedataProp realcardid = (BasedataProp)this.getModel().getProperty("realcardid");
        realcardid.setMustInput(flag.booleanValue());
        AmountProp change_originalval = (AmountProp)this.getModel().getProperty("change_originalval");
        change_originalval.setMustInput(flag.booleanValue());
    }
}

