/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.validate.BillStatus;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.FaFilterAndOperProvide;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaFormUtils;

public class FaFilterList
extends AbstractListPlugin {
    private static Map<String, QFilter> filterMap = new HashMap<String, QFilter>();
    private static final String IS_CLICK_ORG = "isClickOrg";

    public void setFilter(SetFilterEvent e) {
        Map paramMap;
        String defortfilter;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billFormId = ((BillList)e.getSource()).getEntityId();
        List qFilters = e.getQFilters();
        qFilters.removeIf(Objects::isNull);
        this.setDepreUse(qFilters, billFormId, e);
        String notFirst = this.getPageCache().get("notFirst");
        if (!"1".equals(notFirst) && (defortfilter = (String)(paramMap = formShowParameter.getCustomParams()).get("defortFilter")) != null && defortfilter.length() > 0) {
            qFilters.add(QFilter.fromSerializedString((String)defortfilter));
            this.getPageCache().put("notFirst", "1");
        }
        this.originalFilterHandler(qFilters);
        QFilter defaultFilter = null;
        LinkQueryPkIdCollection linkQueryPkIdCollection = ((ListShowParameter)formShowParameter).getLinkQueryPkIdCollection();
        if ("fa_card_fin".equals(billFormId)) {
            Optional<QFilter> originFilterOption = qFilters.stream().filter(v -> "originaldata".equals(v.getProperty())).findFirst();
            if (originFilterOption.isPresent()) {
                QFilter originFilter = originFilterOption.get();
                String cp = originFilter.getCP();
                Object value = originFilter.getValue();
                if ("fa_new_depre".equals(formShowParameter.getParentFormId())) {
                    value = "1";
                    qFilters.removeIf(qFilter -> "originaldata".equals(qFilter.getProperty()));
                }
                if (StringUtils.isEmpty((CharSequence)cp) || "=".equals(cp) || "in".equals(cp)) {
                    if ("0".equals(value)) {
                        defaultFilter = this.getDefaultFilter(billFormId);
                    }
                } else if ("!=".equals(cp) || "not in".equals(cp) || "<>".equals(cp)) {
                    if ("1".equals(value)) {
                        defaultFilter = this.getDefaultFilter(billFormId);
                    }
                } else {
                    defaultFilter = this.getDefaultFilter(billFormId);
                }
            } else if (!"gl_periodclosedetails".equals(formShowParameter.getParentFormId()) && (linkQueryPkIdCollection == null || linkQueryPkIdCollection.isEmpty())) {
                defaultFilter = this.getDefaultFilter(billFormId);
            }
            if (defaultFilter != null || "botp_lookuptracker".equals(formShowParameter.getParentFormId())) {
                this.getPageCache().put("hideVchBtn", "true");
            } else {
                this.getPageCache().put("hideVchBtn", "false");
                qFilters.add(new QFilter(Fa.dot((String[])new String[]{"realcard", "sourceflag"}), "!=", (Object)"SPLIT"));
            }
        } else {
            defaultFilter = this.getDefaultFilter(billFormId);
        }
        if (defaultFilter != null) {
            qFilters.add(defaultFilter);
        }
        this.appendFilter(e);
    }

    private void originalFilterHandler(List<QFilter> qFilters) {
        Optional<QFilter> originFilterOption = qFilters.stream().filter(v -> "originaldata".equals(v.getProperty())).findFirst();
        QFilter oriDataFilter = null;
        if (originFilterOption.isPresent()) {
            oriDataFilter = originFilterOption.get();
        }
        QFilter.QFilterNest nestOriFilter = null;
        for (QFilter qFilter : qFilters) {
            Optional<QFilter.QFilterNest> nestOriFilterOption;
            List nests = qFilter.getNests(false);
            if (!CollectionUtils.isNotEmpty((Collection)nests) || !(nestOriFilterOption = nests.stream().filter(v -> "originaldata".equals(v.getFilter().getProperty())).findFirst()).isPresent()) continue;
            nestOriFilter = nestOriFilterOption.get();
            nests.remove(nestOriFilter);
            break;
        }
        if (nestOriFilter != null) {
            if (oriDataFilter != null) {
                qFilters.remove(oriDataFilter);
            }
            qFilters.add(nestOriFilter.getFilter());
        }
    }

    private void setDepreUse(List<QFilter> qFilters, String billFormId, SetFilterEvent e) {
        boolean hasDepreUse = qFilters.stream().anyMatch(v -> "depreuse.id".equals(v.getProperty()));
        if (!hasDepreUse && billFormId.equalsIgnoreCase("fa_card_fin")) {
            QFilter mainOrgQFilter = e.getMainOrgQFilter();
            if (mainOrgQFilter == null) {
                return;
            }
            List org = (List)e.getMainOrgQFilter().getValue();
            Map assetBooks = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"depreuse_id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)org)});
            Set depreUses = assetBooks.values().stream().map(v -> v.getLong("depreuse_id")).collect(Collectors.toSet());
            qFilters.add(new QFilter("depreuse.id", "in", depreUses));
        }
        if (qFilters.isEmpty()) {
            this.getPageCache().put("DepreAdjustBillList depreUseId", null);
            return;
        }
        for (QFilter qFilter : qFilters) {
            String property = qFilter.getProperty();
            if (!"depreuse.id".equals(property)) continue;
            this.getPageCache().put("DepreAdjustBillList depreUseId", qFilter.getValue().toString());
            return;
        }
    }

    protected void disposeClosePeriod(SetFilterEvent e) {
        String filterStr;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("filter") != null && StringUtils.isNotBlank((CharSequence)(filterStr = (String)customParams.get("filter")))) {
            QFilter filter = QFilter.fromSerializedString((String)filterStr);
            e.getQFilters().clear();
            e.getQFilters().add(filter);
        }
    }

    protected void appendFilter(SetFilterEvent e) {
        String filterStr;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("appendedFilter") != null && StringUtils.isNotBlank((CharSequence)(filterStr = (String)customParams.get("appendedFilter")))) {
            QFilter filter = QFilter.fromSerializedString((String)filterStr);
            e.getQFilters().add(filter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new FaFilterAndOperProvide());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!FaUtils.isF7((IFormView)this.getView())) {
            BillList billList = (BillList)this.getControl("BillListAp");
            HyperLinkClickEvent hyperClick = args.getHyperLinkClickEvent();
            if ("vounchernumber".equals(hyperClick.getFieldName())) {
                Object rowPk = FaUtils.getRowPk((Object)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue());
                args.setCancel(true);
                FaUtils.showTabForm((String)"gl_voucher", (String)ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"FaFilterList_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), (Object)rowPk, (IFormView)this.getView());
            }
        }
    }

    private QFilter getDefaultFilter(String billFormId) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("bos_call_source_type") && "botp_track".equals(customParams.get("bos_call_source_type"))) {
            return null;
        }
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (null != parentFormId && "gl_vchralt_form".equals(parentFormId)) {
            return null;
        }
        for (Map.Entry<String, QFilter> entry : filterMap.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(billFormId)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static QFilter and(QFilter a, QFilter b) {
        return a.and(b);
    }

    public void filterContainerInit(FilterContainerInitArgs filtercontainerinitargs) {
        super.filterContainerInit(filtercontainerinitargs);
        String entityName = ((FilterContainer)filtercontainerinitargs.getFilterContainerInitEvent().getSource()).getEntityId();
        List listFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        Object sFilter = paramMap.get("filter");
        QFilter filters = null;
        QFilter[] filters2 = null;
        if (sFilter != null) {
            filters = QFilter.fromSerializedString((String)(sFilter + ""));
            filters2 = filters.recombine();
        }
        for (FilterColumn listFilter : listFilterColumns) {
            List billStatusFilters;
            String finaccountdate;
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            String field = commFilter.getFieldName();
            if ("org.name".equals(field) || "assetunit.name".equals(field) || "org.number".equals(field) || "org.id".equals(field)) {
                String defaultOrgid = "";
                String orgFilterObjId = (String)paramMap.get("org");
                List<Long> linkQueryOrgIds = FaFormUtils.getLinkQueryId(this.getPageCache(), "org", entityName);
                String billFormID = ((FilterContainer)filtercontainerinitargs.getFilterContainerInitEvent().getSource()).getEntityId();
                List comboItems = FaPermissionUtils.getAllEnableBookAndPermissionOrgsCombosV2((String)this.getView().getPageId(), (String)billFormID);
                commFilter.setComboItems(comboItems);
                if (null == comboItems || comboItems.size() <= 0) continue;
                if (orgFilterObjId != null) {
                    defaultOrgid = orgFilterObjId;
                    commFilter.setDefaultValue(defaultOrgid);
                } else if (linkQueryOrgIds.size() > 0) {
                    ArrayList orgIds = new ArrayList(linkQueryOrgIds.size());
                    linkQueryOrgIds.forEach(r -> orgIds.add(r));
                    defaultOrgid = null;
                    commFilter.setDefaultValue(orgIds.get(0).toString());
                } else {
                    defaultOrgid = FaUtils.getDefaultOrgId((List)comboItems);
                    commFilter.setDefaultValue(defaultOrgid);
                }
                this.getPageCache().put("org", defaultOrgid);
                if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(IS_CLICK_ORG)) || sFilter == null) continue;
                String transOrg = Stream.of(filters2).filter(v -> v.getProperty().equalsIgnoreCase("org")).map(v -> v.getValue()).map(Object::toString).reduce("", String::concat);
                commFilter.setDefaultValue(transOrg);
                continue;
            }
            if ("finaccountdate".equals(field)) {
                if (sFilter != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    List finaccountdateDefValue = Stream.of(filters2).filter(v -> v.getProperty().equalsIgnoreCase("finaccountdate")).map(v -> df.format((Date)v.getValue())).collect(Collectors.toList());
                    commFilter.setDefaultValues(finaccountdateDefValue);
                    continue;
                }
                finaccountdate = (String)paramMap.get("finaccountdate");
                if (!StringUtils.isNotEmpty((CharSequence)finaccountdate) || !finaccountdate.equals("ismainpage")) continue;
                commFilter.setDefaultValue("");
                continue;
            }
            if ("changedate".equals(field)) {
                finaccountdate = (String)paramMap.get("finaccountdate");
                if (!StringUtils.isNotEmpty((CharSequence)finaccountdate) || !finaccountdate.equals("ismainpage")) continue;
                commFilter.setDefaultValue("");
                continue;
            }
            if ("depreuse.name".equals(field)) {
                List<Long> linkQueryDepreuseIds = FaFormUtils.getLinkQueryId(this.getPageCache(), "depreuse", entityName);
                if (linkQueryDepreuseIds.size() > 0) {
                    ArrayList depreuseIds = new ArrayList(linkQueryDepreuseIds.size());
                    linkQueryDepreuseIds.forEach(r -> depreuseIds.add(String.valueOf(r)));
                    commFilter.setDefaultValues(depreuseIds);
                    continue;
                }
                if (paramMap.containsKey("depreuse")) {
                    commFilter.setDefaultValue(paramMap.get("depreuse").toString());
                    continue;
                }
                List depreuses = commFilter.getComboItems();
                if (filters2 != null) {
                    String depreUseId = Stream.of(filters2).filter(v -> v.getProperty().equalsIgnoreCase("depreuse")).map(v -> v.getValue()).map(Object::toString).reduce("", String::concat);
                    commFilter.setDefaultValue(depreUseId);
                    continue;
                }
                if (depreuses == null || depreuses.size() <= 0) continue;
                commFilter.setDefaultValue(((ComboItem)depreuses.get(0)).getValue());
                continue;
            }
            if (!"billstatus".equals(field) || filters2 == null || (billStatusFilters = Stream.of(filters2).filter(v -> v.getProperty().equals("billstatus")).collect(Collectors.toList())).isEmpty()) continue;
            String cp = ((QFilter)billStatusFilters.get(0)).getCP();
            String value = ((QFilter)billStatusFilters.get(0)).getValue().toString();
            ArrayList defaultVals = new ArrayList(4);
            if ("!=".equals(cp)) {
                commFilter.getComboItems().stream().filter(item -> !item.getValue().equals(value)).forEach(item -> defaultVals.add(item.getValue()));
            } else {
                commFilter.getComboItems().stream().filter(item -> item.getValue().equals(value)).forEach(item -> defaultVals.add(item.getValue()));
            }
            commFilter.setDefaultValues(defaultVals);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        List fastlist = (List)map.get("fastfilter");
        if (customlist != null) {
            if (customlist.size() == 0) {
                return;
            }
            for (int i = 0; i < customlist.size(); ++i) {
                Map map1 = (Map)customlist.get(i);
                List listValue = (List)map1.get("Value");
                List listFieldName = (List)map1.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (!listFieldName.get(j).equals("org.id")) continue;
                    String key = (String)listValue.get(j);
                    this.getPageCache().put("org", key);
                    this.getPageCache().put(IS_CLICK_ORG, "yes");
                }
            }
        } else if (schemelist != null ? schemelist.size() == 0 : fastlist != null && fastlist.size() == 0) {
            return;
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        FaFormPermissionUtil.filterContainerBeforeF7SelectV2(e, this.getView().getPageId(), "fa_card_fin");
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        parameter.setCustomParam("depreuse", (Object)this.getPageCache().get("DepreAdjustBillList depreUseId"));
    }

    static {
        filterMap.put("fa_purchasebill", null);
        filterMap.put("fa_card_fin", new QFilter("endperiod", "=", (Object)99999999999L).and(new QFilter("clearperiod", "=", (Object)0L)));
        filterMap.put("fa_clearapplybill", null);
        filterMap.put("fa_clearbill", null);
        filterMap.put("fa_assetcategory", null);
        filterMap.put("fa_usestatus", null);
        filterMap.put("fa_storeplace", null);
        filterMap.put("fa_assetbook", null);
        filterMap.put("fa_depre", new QFilter("status", "=", (Object)BillStatus.C.toString()));
        filterMap.put("fa_periodclose", new QFilter("status", "=", (Object)BillStatus.C.toString()));
        filterMap.put("fa_test_geninsertsql", null);
        filterMap.put("fa_depre_sum", null);
        filterMap.put("fa_dispatch", null);
        filterMap.put("fa_dispatch_in", FaFilterList.and(new QFilter("billstatus", "!=", (Object)BillStatus.A.toString()), new QFilter("billstatus", "!=", (Object)BillStatus.B.toString())));
        filterMap.put("fa_depremethod", null);
        filterMap.put("fa_depre_workload", new QFilter(FaDaoOrmImpl.dot((String[])new String[]{"fincard", "depremethod", "type"}), "=", (Object)"5"));
        filterMap.put("fa_rpt_card", null);
        filterMap.put("fa_changemode", null);
    }
}

