/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.fa.business.dao.factory.FaInitRealCardDaoFactory;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.ContextUtil;

public class FaFinCardRealMsg
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        IDataModel thisModel = parentView.getModel();
        DynamicObject dynObj = thisModel.getDataEntity();
        DynamicObject realCurCard = (DynamicObject)dynObj.get("realcard");
        this.getModel().setValue("realcard", (Object)realCurCard.getLong("id"));
        if (realCurCard != null) {
            FaFinCardRealMsg.loadLabelInfo(realCurCard, this.getView());
        }
    }

    public static void loadLabelInfo(DynamicObject realCurCard, IFormView formView) {
        ((Label)formView.getControl("l_org")).setText(realCurCard.getString("org.name"));
        ((Label)formView.getControl("l_assetname")).setText(realCurCard.getString("assetname"));
        ((Label)formView.getControl("l_assetname1")).setText(realCurCard.getString("assetname"));
        ((Label)formView.getControl("l_model")).setText((String)realCurCard.get("model"));
        ((Label)formView.getControl("l_number")).setText((String)realCurCard.get("number"));
        ((Label)formView.getControl("l_assetcat")).setText(realCurCard.getString("assetcat.name"));
        String dateFormat = InteServiceHelper.getDateFormat((Long)ContextUtil.getUserId());
        ((Label)formView.getControl("l_realaccountdate")).setText(FaUtils.parseDateByFormatString((Date)realCurCard.getDate("realaccountdate"), (String)dateFormat));
        ((Label)formView.getControl("l_originmethod")).setText(realCurCard.getString("originmethod.name"));
        ((Label)formView.getControl("l_storeplace")).setText(realCurCard.getString("storeplace.name"));
        ((Label)formView.getControl("l_headusedept")).setText(realCurCard.getString("headusedept.name"));
        ((Label)formView.getControl("l_supplier")).setText(realCurCard.getString("supplier.name"));
        formView.setEnable(Boolean.valueOf(realCurCard.getBoolean("isfacility")), new String[]{"buttonap"});
        Long unitID = (Long)realCurCard.get("unit.id");
        if (unitID != null) {
            DynamicObject unit = BusinessDataServiceHelper.loadSingleFromCache((Object)unitID, (String)"bd_measureunits", (String)"precision");
            int unitPrecision = unit.getInt("precision");
            ((Label)formView.getControl("l_assetamount")).setText(realCurCard.getBigDecimal("assetamount").setScale(unitPrecision, 4).toString());
        } else {
            ((Label)formView.getControl("l_assetamount")).setText(realCurCard.getBigDecimal("assetamount").stripTrailingZeros().toPlainString());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap"});
        this.addClickListeners(new String[]{"l_number"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        IDataModel dataModel = this.getModel();
        DynamicObject realcard = FaInitRealCardDaoFactory.getInstance().queryOne(dataModel.getDataEntity().getDynamicObject("realcard").getPkValue());
        String contryKey = control.getKey();
        if ("buttonap".equals(contryKey)) {
            DynamicObjectCollection advs = realcard.getDynamicObjectCollection("facility_entry");
            FormShowParameter param = new FormShowParameter();
            param.setFormId("fa_additiondevice");
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCustomParam("entry", (Object)advs);
            this.getView().showForm(param);
            return;
        }
        if ("l_number".equals(contryKey)) {
            Object realPk = realcard.getPkValue();
            FaUtils.showTabForm((String)"fa_card_real", (String)ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247", (String)"FaFinCardRealMsg_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), (Object)realPk, (IFormView)this.getView());
        }
    }
}

