/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.constants.InventoryTaskRule;
import kd.fi.fa.constants.InventoryTaskRuleRow;
import kd.fi.fa.formplugin.FaInventoryTaskList;
import kd.fi.fa.utils.FaFormPermissionUtil;

public class FaInventSchemeEditPlugin
extends AbstractBillPlugIn {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_ASSETUNIT = "assetunit";
    private static final String KEY_TASKRULE = "taskrule";
    private static final String KEY_TASKSTATUS = "taskstatus";
    private static final String PARAMKEY_ASSETUNIT = "assetunit";
    private static final String KEY_CHARGEPERSON = "chargeperson";
    private static final String KEY_SPLITDETAILENTITY = "splitdetailentity";
    private static final String KEY_SPLITFIELDVALUE = "splitfieldvalue";
    private static final String KEY_INVENTPERSON = "inventperson";
    private static final String KEY_ENTRYSTATUS = "entrystatus";
    private static final String KEY_TASKID = "taskid";
    private static final String KEY_SPLITFIELDENTITY = "splitfieldentity";
    private static final String KEY_SPLITFIELD = "splitfield";

    public void preOpenForm(PreOpenFormEventArgs e) {
        LicenseCheckResult result = LicenseServiceHelper.checkByAppAndBizObj((String)"83bfebc800001aac", (String)"fa_inventscheme_new", (Long)Long.valueOf(RequestContext.get().getUserId()));
        if (!result.getHasLicense().booleanValue()) {
            boolean isConstellation = LicenseServiceHelper.getModeType() == 3;
            String version = LicenseServiceHelper.getProductVersion();
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u201d\u4e2d\u201c\u56fa\u5b9a\u8d44\u4ea7\u201d\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaInventSchemeEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            if (isConstellation) {
                switch (version) {
                    case "1.0": 
                    case "2.0": 
                    case "3.0": {
                        msg = ResManager.loadKDString((String)"\u6ca1\u6709\u8d22\u52a1\u4f1a\u8ba1\u4e13\u4e1a\u5206\u7ec4\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaInventSchemeEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                        break;
                    }
                }
            }
            e.setCancel(true);
            e.setCancelMessage(msg);
            e.setCancelFormShowParameter(result.getCancelFormShowParameter());
        } else {
            super.preOpenForm(e);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_TASKRULE});
        BasedataEdit createOrgF7 = (BasedataEdit)this.getControl("createOrg");
        createOrgF7.addBeforeF7SelectListener(listener -> {
            HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)ContextUtil.getUserId());
            if (!userHasPermOrgs.hasAllOrgPerm()) {
                List orgIds = userHasPermOrgs.getHasPermOrgs();
                ListShowParameter param = (ListShowParameter)listener.getFormShowParameter();
                param.setCustomParam("orgFuncId", (Object)"09");
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgIds));
            }
        });
        BasedataEdit assetUnitF7 = (BasedataEdit)this.getControl("assetunit");
        assetUnitF7.addBeforeF7SelectListener(v -> {
            this.setF7Filter(v, this::getAssetUnitF7Filter);
            FaFormPermissionUtil.beforeAssetUnitSelectV2(this.getView().getPageId(), v, "fa_inventscheme_new");
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
            HashSet<Long> orgids = new HashSet<Long>(1);
            if (createorg != null) {
                orgids.add(createorg.getLong("id"));
            }
            Set<Long> childOrgId = FaFormPermissionUtil.getChildOrgId("09", orgids, true);
            ListShowParameter showParam = (ListShowParameter)v.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            showParam.setCustomParam("orgFuncId", (Object)"09");
            filterParam.getQFilters().add(new QFilter("id", "in", childOrgId));
        });
        UserEdit chargeperson = (UserEdit)this.getControl(KEY_CHARGEPERSON);
        chargeperson.addBeforeF7SelectListener(listener -> {
            ListShowParameter showParam = (ListShowParameter)listener.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.getQFilters().add(new QFilter("entryentity.ispartjob", "=", (Object)Boolean.FALSE));
            showParam.setMultiSelect(false);
        });
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object orgId = this.getModel().getValue("createorg");
        this.getModel().setValue("useorg", orgId);
        this.getModel().setValue("org", orgId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        DynamicObject inventScheme = this.getModel().getDataEntity();
        this.fillTaskIdForSplitEntry();
        this.setEnableByStatus(inventScheme);
    }

    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        if (ctlSource.getKey().equalsIgnoreCase(KEY_TASKRULE)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            this.showTaskRuleSet(rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String type = ((AbstractOperate)args.getSource()).getOperateKey();
        if (type.equalsIgnoreCase("save")) {
            IDataModel model = this.getModel();
            DynamicObject inventScheme = model.getDataEntity(true);
            this.setEnableByStatus(inventScheme);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        if ("assign".equalsIgnoreCase(itemKey)) {
            model.clearNoDataRow();
            Object id = model.getValue("id");
            DynamicObject inventScheme = model.getDataEntity(true);
            if ("C".equals(inventScheme.getString("billstate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u4e0b\u8fbe\u4efb\u52a1\u3002", (String)"FaInventSchemeEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            OperationResult opResult = SaveServiceHelper.saveOperate((String)"fa_inventscheme_new", (DynamicObject[])new DynamicObject[]{inventScheme});
            if (!opResult.isSuccess()) {
                String errStr = ResManager.loadKDString((String)"\u76d8\u70b9\u65b9\u6848\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"FaInventSchemeEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(errStr);
                return;
            }
            DynamicObjectCollection entries = inventScheme.getDynamicObjectCollection(KEY_ENTRYENTITY);
            HashSet<Object> pkSet = new HashSet<Object>();
            List<String> statusList = Arrays.asList("A", "Z");
            for (DynamicObject rowDy : entries) {
                DynamicObjectCollection taskDys = rowDy.getDynamicObjectCollection(KEY_SPLITDETAILENTITY);
                for (DynamicObject taskDy : taskDys) {
                    String status = taskDy.getString(KEY_ENTRYSTATUS);
                    if (!statusList.contains(status)) continue;
                    pkSet.add(taskDy.getPkValue());
                }
            }
            if (pkSet.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u6709\u4efb\u52a1\u5747\u5df2\u4e0b\u8fbe\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u8fbe\u3002", (String)"FaInventSchemeEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            } else {
                Object[] taskPks = pkSet.toArray(new Object[pkSet.size()]);
                FaInventoryTaskList.inventoryAssign(taskPks);
                inventScheme = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fa_inventscheme_new");
                this.setEnableByStatus(inventScheme);
                this.refreshTaskStatus(inventScheme);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8fbe\u6210\u529f\uff0c\u53ef\u5728\u76d8\u70b9\u65b9\u6848\u5217\u8868\u754c\u9762\u8054\u67e5\u76d8\u70b9\u4efb\u52a1\u3002", (String)"FaInventSchemeEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.getView().updateView();
            }
        }
    }

    void refreshTaskStatus(DynamicObject inventScheme) {
        HashMap<Long, String> curStatusMap = new HashMap<Long, String>();
        DynamicObjectCollection entries = inventScheme.getDynamicObjectCollection(KEY_ENTRYENTITY);
        for (DynamicObject rowDy : entries) {
            DynamicObjectCollection taskDys = rowDy.getDynamicObjectCollection(KEY_SPLITDETAILENTITY);
            for (DynamicObject taskDy : taskDys) {
                String status = taskDy.getString(KEY_ENTRYSTATUS);
                curStatusMap.put(taskDy.getLong("id"), status);
            }
        }
        DynamicObject curInventScheme = this.getModel().getDataEntity(true);
        DynamicObjectCollection curEntries = curInventScheme.getDynamicObjectCollection(KEY_ENTRYENTITY);
        for (DynamicObject curRowDy : curEntries) {
            DynamicObjectCollection taskDys = curRowDy.getDynamicObjectCollection(KEY_SPLITDETAILENTITY);
            for (DynamicObject taskDy : taskDys) {
                Long id = taskDy.getLong("id");
                if (!curStatusMap.containsKey(id)) continue;
                taskDy.set(KEY_ENTRYSTATUS, curStatusMap.get(id));
            }
        }
    }

    Boolean getTaskStatus(DynamicObject inventScheme) {
        Boolean result = true;
        DynamicObjectCollection entries = inventScheme.getDynamicObjectCollection(KEY_ENTRYENTITY);
        if (entries != null && entries.size() > 0) {
            for (DynamicObject rowDy : entries) {
                DynamicObjectCollection taskDys = rowDy.getDynamicObjectCollection(KEY_SPLITDETAILENTITY);
                for (DynamicObject taskDy : taskDys) {
                    String status = taskDy.getString(KEY_ENTRYSTATUS);
                    if ("A".equalsIgnoreCase(status) || "Z".equalsIgnoreCase(status)) continue;
                    result = false;
                    return result;
                }
            }
        }
        return result;
    }

    void setEnableByStatus(DynamicObject inventScheme) {
        DynamicObjectCollection entries = inventScheme.getDynamicObjectCollection(KEY_ENTRYENTITY);
        if (entries != null && entries.size() > 0) {
            int rowIndex = 0;
            for (DynamicObject rowDy : entries) {
                boolean isEmptyRule;
                Boolean rowEnable = true;
                DynamicObjectCollection taskDys = rowDy.getDynamicObjectCollection(KEY_SPLITDETAILENTITY);
                for (DynamicObject taskDy : taskDys) {
                    String status = taskDy.getString(KEY_ENTRYSTATUS);
                    if ("A".equalsIgnoreCase(status) || "Z".equalsIgnoreCase(status)) continue;
                    rowEnable = false;
                    break;
                }
                if (isEmptyRule = StringUtils.isEmpty((String)rowDy.getString(KEY_TASKRULE))) {
                    if (!rowEnable.booleanValue()) {
                        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"assetunit"});
                        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"finaccountdate"});
                        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{KEY_TASKRULE});
                        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{KEY_CHARGEPERSON});
                    }
                } else {
                    if (!rowEnable.booleanValue()) {
                        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"assetunit"});
                        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"finaccountdate"});
                    }
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{KEY_CHARGEPERSON});
                }
                ++rowIndex;
            }
        }
    }

    private QFilter getAssetUnitF7Filter() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(KEY_ENTRYENTITY);
        HashSet<Long> assetunits = new HashSet<Long>();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject assetunit = (DynamicObject)model.getValue("assetunit", i);
            if (assetunit == null) continue;
            assetunits.add(assetunit.getLong("id"));
        }
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"09");
        QFilter leafFilter = new QFilter("isbizunit", "=", (Object)true);
        QFilter[] filters = new QFilter[]{treeTypeFilter, leafFilter};
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id", (QFilter[])filters);
        HashSet<Long> leafOrgs = new HashSet<Long>();
        for (DynamicObject s : orgs) {
            Long curId = s.getLong("org.id");
            if (assetunits.contains(curId)) continue;
            leafOrgs.add(s.getLong("org.id"));
        }
        return new QFilter("id", "in", leafOrgs);
    }

    private void setF7Filter(BeforeF7SelectEvent e, Supplier<QFilter> filterFn) {
        ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        filterParam.getQFilters().add(filterFn.get());
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (KEY_ENTRYENTITY.equals(e.getEntryProp().getName())) {
            int[] rowIndexs = e.getRowIndexs();
            IDataModel model = this.getModel();
            DynamicObjectCollection entries = model.getEntryEntity(KEY_ENTRYENTITY);
            for (int i : rowIndexs) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                DynamicObjectCollection taskDys = entry.getDynamicObjectCollection(KEY_SPLITDETAILENTITY);
                Boolean rowEnable = true;
                for (DynamicObject taskDy : taskDys) {
                    String status = taskDy.getString(KEY_ENTRYSTATUS);
                    if ("A".equalsIgnoreCase(status) || "Z".equalsIgnoreCase(status)) continue;
                    rowEnable = false;
                    break;
                }
                if (rowEnable.booleanValue()) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u4e0b\u8fbe\u7684\u76d8\u70b9\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FaInventSchemeEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (KEY_TASKRULE.equalsIgnoreCase(actionId)) {
            this.receiveTaskRuleSet(closedCallBackEvent);
        }
    }

    private void receiveTaskRuleSet(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((String)str)) {
                return;
            }
            InventoryTaskRule inventoryTaskRule = (InventoryTaskRule)SerializationUtils.fromJsonString((String)str, InventoryTaskRule.class);
            int rowIndex = model.getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            model.setValue(KEY_TASKRULE, (Object)inventoryTaskRule.getRulename(), rowIndex);
            model.setValue(KEY_CHARGEPERSON, null, rowIndex);
            model.setEntryCurrentRowIndex(KEY_ENTRYENTITY, rowIndex);
            LinkedHashMap rowMap = new LinkedHashMap();
            for (InventoryTaskRuleRow rowEntry : inventoryTaskRule.getEntryRows()) {
                long taskId;
                long l = taskId = rowEntry.getTaskId() == null ? 0L : rowEntry.getTaskId();
                if (rowMap.containsKey(taskId)) {
                    ((List)rowMap.get(taskId)).add(rowEntry);
                    continue;
                }
                ArrayList<InventoryTaskRuleRow> rows = new ArrayList<InventoryTaskRuleRow>();
                rows.add(rowEntry);
                rowMap.put(taskId, rows);
            }
            DynamicObjectCollection entries = model.getEntryEntity(KEY_ENTRYENTITY);
            DynamicObject curDy = (DynamicObject)entries.get(rowIndex);
            DynamicObjectCollection taskRuleEntries = curDy.getDynamicObjectCollection(KEY_SPLITDETAILENTITY);
            HashSet<Long> existsIds = new HashSet<Long>();
            int rowcount = taskRuleEntries.size();
            for (int i = 0; i < rowcount; ++i) {
                long rowId = ((DynamicObject)taskRuleEntries.get(i)).getLong(KEY_TASKID);
                if (rowMap.containsKey(rowId)) {
                    existsIds.add(rowId);
                    continue;
                }
                model.deleteEntryRow(KEY_SPLITDETAILENTITY, i);
                --i;
                --rowcount;
            }
            taskRuleEntries = curDy.getDynamicObjectCollection(KEY_SPLITDETAILENTITY);
            rowcount = taskRuleEntries.size();
            int seq = 1;
            for (int i = 0; i < rowcount; ++i) {
                long rowId = ((DynamicObject)taskRuleEntries.get(i)).getLong(KEY_TASKID);
                InventoryTaskRuleRow rowEntry = (InventoryTaskRuleRow)((List)rowMap.get(rowId)).get(0);
                String fieldValueStr = SerializationUtils.toJsonString(rowEntry.getSplitFieldMap());
                model.setValue(KEY_SPLITFIELDVALUE, (Object)fieldValueStr, i, rowIndex);
                model.setValue(KEY_INVENTPERSON, (Object)rowEntry.getInventperson(), i, rowIndex);
                model.setValue(KEY_ENTRYSTATUS, (Object)rowEntry.getTaskStatus(), i, rowIndex);
                model.setValue(KEY_TASKID, (Object)seq++, i, rowIndex);
            }
            for (InventoryTaskRuleRow rowEntry : inventoryTaskRule.getEntryRows()) {
                if (existsIds.contains(rowEntry.getTaskId())) continue;
                int rowIndex1 = model.createNewEntryRow(KEY_SPLITDETAILENTITY);
                String fieldValueStr = SerializationUtils.toJsonString(rowEntry.getSplitFieldMap());
                model.setValue(KEY_SPLITFIELDVALUE, (Object)fieldValueStr, rowIndex1, rowIndex);
                model.setValue(KEY_INVENTPERSON, (Object)rowEntry.getInventperson(), rowIndex1, rowIndex);
                model.setValue(KEY_ENTRYSTATUS, (Object)rowEntry.getTaskStatus(), rowIndex1, rowIndex);
                model.setValue(KEY_TASKID, (Object)seq++, rowIndex1, rowIndex);
            }
            model.deleteEntryData(KEY_SPLITFIELDENTITY);
            if (!StringUtils.isBlank((String)inventoryTaskRule.getSplitfields())) {
                String[] fieldArr;
                for (String field : fieldArr = inventoryTaskRule.getSplitfields().trim().split(",")) {
                    if (StringUtils.isBlank((String)field)) continue;
                    int rowIndex2 = model.createNewEntryRow(KEY_SPLITFIELDENTITY);
                    model.setValue(KEY_SPLITFIELD, (Object)field, rowIndex2, rowIndex);
                }
            }
        }
    }

    void showTaskRuleSet(int rowIndex) {
        IDataModel model = this.getModel();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fa_inventory_taskrule");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String taskStatus = model.getValue(KEY_TASKSTATUS, rowIndex).toString();
        showParameter.setCustomParam(KEY_TASKSTATUS, (Object)taskStatus);
        InventoryTaskRule taskRuleObj = this.getTaskRuleObj(rowIndex);
        String taskRuleJsonStr = SerializationUtils.toJsonString((Object)taskRuleObj);
        showParameter.setCustomParam("entryjson", (Object)taskRuleJsonStr);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_TASKRULE);
        showParameter.setCloseCallBack(closeCallBack);
        DynamicObject entryentity = (DynamicObject)this.getModel().getEntryEntity(KEY_ENTRYENTITY).get(rowIndex);
        DynamicObject assetunit = entryentity.getDynamicObject("assetunit");
        if (assetunit == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u4ea7\u7ec4\u7ec7\u3002", (String)"FaInventSchemeEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        String assetunitid = assetunit.getString("id");
        showParameter.setCustomParam("assetunit", (Object)assetunitid);
        this.getView().showForm(showParameter);
    }

    InventoryTaskRule getTaskRuleObj(int rowIndex) {
        IDataModel model = this.getModel();
        model.setEntryCurrentRowIndex(KEY_ENTRYENTITY, rowIndex);
        InventoryTaskRule taskRule = new InventoryTaskRule();
        Object ruleName = model.getValue(KEY_TASKRULE, rowIndex);
        taskRule.setRulename(ruleName == null ? "" : ruleName.toString());
        if (!StringUtils.isEmpty((String)taskRule.getRulename())) {
            String splitFieldStr = this.getSplitFieldStr(rowIndex);
            taskRule.setSplitfields(splitFieldStr);
            List<InventoryTaskRuleRow> rowList = this.getTaskRuleEntries(rowIndex);
            taskRule.setEntryRows(rowList);
        } else {
            taskRule.setSplitfields("");
            taskRule.setEntryRows(new ArrayList<InventoryTaskRuleRow>());
        }
        return taskRule;
    }

    List<InventoryTaskRuleRow> getTaskRuleEntries(int rowIndex) {
        IDataModel model = this.getModel();
        ArrayList<InventoryTaskRuleRow> rowList = new ArrayList<InventoryTaskRuleRow>();
        DynamicObjectCollection entries = model.getEntryEntity(KEY_ENTRYENTITY);
        if (entries.size() > 0) {
            DynamicObject curDy = (DynamicObject)entries.get(rowIndex);
            model.setEntryCurrentRowIndex(KEY_ENTRYENTITY, rowIndex);
            DynamicObjectCollection taskRuleEntries = curDy.getDynamicObjectCollection(KEY_SPLITDETAILENTITY);
            for (DynamicObject dy : taskRuleEntries) {
                InventoryTaskRuleRow row = new InventoryTaskRuleRow();
                row.setSplitFieldMap(new LinkedHashMap<String, String>());
                String jsonStr = dy.getString(KEY_SPLITFIELDVALUE);
                if (!StringUtils.isBlank((String)jsonStr)) {
                    LinkedHashMap fieldMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)jsonStr, LinkedHashMap.class);
                    row.setSplitFieldMap(fieldMap);
                }
                if (dy.getDynamicObject(KEY_INVENTPERSON) != null) {
                    row.setInventperson(dy.getDynamicObject(KEY_INVENTPERSON).getLong("id"));
                }
                row.setTaskStatus(dy.getString(KEY_ENTRYSTATUS));
                row.setTaskId(dy.getLong(KEY_TASKID));
                rowList.add(row);
            }
        }
        return rowList;
    }

    private void fillTaskIdForSplitEntry() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject curEntry = (DynamicObject)entries.get(i);
            DynamicObjectCollection splitEntry = curEntry.getDynamicObjectCollection(KEY_SPLITDETAILENTITY);
            int sizeOfSplitEntry = splitEntry.size();
            int j = 0;
            while (j < sizeOfSplitEntry) {
                DynamicObject curSplitEntry = (DynamicObject)splitEntry.get(j);
                curSplitEntry.set(KEY_TASKID, (Object)(++j));
            }
        }
    }

    String getSplitFieldStr(int rowIndex) {
        String result = "";
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity(KEY_ENTRYENTITY);
        if (entries.size() > 0) {
            DynamicObject curDy = (DynamicObject)entries.get(rowIndex);
            model.setEntryCurrentRowIndex(KEY_ENTRYENTITY, rowIndex);
            DynamicObjectCollection splitFieldEntries = curDy.getDynamicObjectCollection(KEY_SPLITFIELDENTITY);
            ArrayList<String> fieldList = new ArrayList<String>();
            for (DynamicObject dy : splitFieldEntries) {
                String str = dy.getString(KEY_SPLITFIELD);
                if (StringUtils.isBlank((String)str)) continue;
                fieldList.add(str);
            }
            result = String.join((CharSequence)",", fieldList);
        }
        return result;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (KEY_TASKRULE.equals(key)) {
            ChangeData changeData = e.getChangeSet()[0];
            if (changeData.getOldValue() != null && "".equals(changeData.getNewValue())) {
                DynamicObject taskEntry = changeData.getDataEntity();
                DynamicObjectCollection subEntries = taskEntry.getDynamicObjectCollection(KEY_SPLITDETAILENTITY);
                for (DynamicObject subEntry : subEntries) {
                    if ("A".equals(subEntry.getString(KEY_ENTRYSTATUS)) || "Z".equals(subEntry.getString(KEY_ENTRYSTATUS))) continue;
                    IDataModel model = this.getModel();
                    this.getPageCache().put("ignorePropertyChanged", "1");
                    model.setValue(KEY_TASKRULE, changeData.getOldValue(), changeData.getRowIndex());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u62c6\u5206\u89c4\u5219\u4e2d\u5b58\u5728\u5df2\u4e0b\u8fbe\u4efb\u52a1\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"FaInventSchemeEditPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    return;
                }
                taskEntry.set(KEY_SPLITDETAILENTITY, null);
                taskEntry.set(KEY_SPLITFIELDENTITY, null);
                this.getView().setEnable(Boolean.TRUE, changeData.getRowIndex(), new String[]{KEY_CHARGEPERSON});
            }
            if (changeData.getOldValue() == null && StringUtils.isNotEmpty((String)((String)changeData.getNewValue()))) {
                String ignoreFlag = this.getPageCache().get("ignorePropertyChanged");
                if (ignoreFlag != null) {
                    if ("1".equals(ignoreFlag)) {
                        this.getPageCache().put("ignorePropertyChanged", "2");
                        return;
                    }
                    if ("2".equals(ignoreFlag)) {
                        this.getPageCache().remove("ignorePropertyChanged");
                        return;
                    }
                }
                DynamicObject taskEntry = changeData.getDataEntity();
                taskEntry.set(KEY_SPLITDETAILENTITY, null);
                taskEntry.set(KEY_SPLITFIELDENTITY, null);
                this.getModel().setValue(KEY_CHARGEPERSON, null);
                this.getView().setEnable(Boolean.FALSE, changeData.getRowIndex(), new String[]{KEY_CHARGEPERSON});
            }
        } else if (KEY_CHARGEPERSON.equals(key)) {
            int rowindex = e.getChangeSet()[0].getRowIndex();
            IDataModel model = this.getModel();
            Object taskruleObj = model.getValue(KEY_TASKRULE, rowindex);
            if (null != taskruleObj && StringUtils.isNotEmpty((String)taskruleObj.toString())) {
                model.setValue(KEY_CHARGEPERSON, null, rowindex);
            }
        }
    }
}

