/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.inventory.InventoryBackLogEnum;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FapUtils;

public class FaInventoryBacklogList
extends AbstractListPlugin {
    private static final String CALL_BACK_REFRESH = "call_back_refresh";
    private static final String CONFIRM_OP = "confirm";
    private static final String RESTART_OP = "restart";
    private static final String NOFOUND_OP = "nofound";
    private static final String CONFIRM_ENTITYNAME = "fa_inventory_confirm";
    private static final String RENEW_ENTITYNAME = "fa_inventory_renew";
    private static final String NOFOUND_ENTITYNAME = "fa_inventory_nofound";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        qFilters.add(FapUtils.FindInventoryRecordByUserId(ContextUtil.getUserId()));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        List recordIdList = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", recordIdList), new QFilter("inventorystate", "=", (Object)InventoryBackLogEnum.B)};
        switch (operateKey) {
            case "restart": {
                filters = new QFilter[]{new QFilter("id", "in", recordIdList), new QFilter("inventorystate", "=", (Object)InventoryBackLogEnum.A), new QFilter("billstate", "!=", (Object)InventoryBackLogEnum.C)};
                this.openForm(RENEW_ENTITYNAME, filters);
                break;
            }
            case "confirm": {
                this.openForm(CONFIRM_ENTITYNAME, filters);
                break;
            }
            case "nofound": {
                this.openForm(NOFOUND_ENTITYNAME, filters);
                break;
            }
        }
    }

    private void openForm(String formId, QFilter[] qFilters) {
        DynamicObjectCollection records = QueryServiceHelper.query((String)"fa_inventory_record", (String)Fa.comma((String[])new String[]{"id", "unit", "bookquantity"}), (QFilter[])qFilters);
        FormShowParameter param = new FormShowParameter();
        param.setFormId(formId);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("records", (Object)records);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_REFRESH));
        this.getView().showForm(param);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CALL_BACK_REFRESH.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new InventoryBackLogDataProvider());
    }

    private static class InventoryBackLogDataProvider
    extends ListDataProvider {
        private InventoryBackLogDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            if (((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"inventoryentrust")) {
                DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)ContextUtil.getUserId(), (String)"bos_user");
                user.set("name", null);
                for (DynamicObject row : rows) {
                    String id = row.getString("inventoryentrust.consignor.id");
                    if (StringUtils.isNotEmpty((CharSequence)id) && id.equals(String.valueOf(ContextUtil.getUserId()))) {
                        row.set("inventoryentrust.consignor", (Object)user);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)(id = row.getString("inventoryentrust.consignee.id"))) || !id.equals(String.valueOf(ContextUtil.getUserId()))) continue;
                    row.set("inventoryentrust.consignee", (Object)user);
                }
            }
            return rows;
        }
    }
}

