/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.fs.util.StringUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.utils.FaOperateLogUtil;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaAssetTypeUtils;
import kd.fi.fa.utils.FaInventoryUtils;

public class FaInventoryTaskList
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(FaInventoryTaskList.class);
    public static final String ALGOKEY = "kd.fi.fa.formplugin.FaInventoryTaskList";
    private static final int DATA_SIZE = DataManagerUtils.getBatchSize();
    private static final String ASSIGNINVENTORY = "assigninventory";
    private Map<Long, Map<String, Set<Long>>> idAndBaseDataMap = new HashMap<Long, Map<String, Set<Long>>>(16);
    private Map<String, Map<Long, String>> resultMap = new HashMap<String, Map<Long, String>>(16);
    private Map<String, Map<String, Object>> baseEntityIdMap = FaInventoryUtils.getBaseEntityIdMap();
    private Map<String, String> baseNameMap = new HashMap<String, String>(this.baseEntityIdMap.size(), 1.0f);
    private Set<String> columnNames = new HashSet<String>(16);
    private Map<Long, Map<String, Integer>> map = null;
    private Set<String> splitFields = null;

    public void preOpenForm(PreOpenFormEventArgs e) {
        LicenseCheckResult result = LicenseServiceHelper.checkByAppAndBizObj((String)"83bfebc800001aac", (String)"fa_inventscheme_new", (Long)Long.valueOf(RequestContext.get().getUserId()));
        if (!result.getHasLicense().booleanValue()) {
            boolean isConstellation = LicenseServiceHelper.getModeType() == 3;
            String version = LicenseServiceHelper.getProductVersion();
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u201d\u4e2d\u201c\u56fa\u5b9a\u8d44\u4ea7\u201d\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaInventoryTaskList_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            if (isConstellation) {
                switch (version) {
                    case "1.0": 
                    case "2.0": 
                    case "3.0": {
                        msg = ResManager.loadKDString((String)"\u6ca1\u6709\u8d22\u52a1\u4f1a\u8ba1\u4e13\u4e1a\u5206\u7ec4\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaInventoryTaskList_1", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                        break;
                    }
                }
            }
            e.setCancel(true);
            e.setCancelMessage(msg);
            e.setCancelFormShowParameter(result.getCancelFormShowParameter());
        } else {
            super.preOpenForm(e);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.setDefaultQuerySelect(args);
    }

    public void setFilter(SetFilterEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object schemeId = customParams.get("schemeId");
        e.getQFilters().add(new QFilter("status", "!=", (Object)"Z"));
        if (schemeId == null) {
            e.getQFilters().add(new QFilter("status", "!=", (Object)"A"));
            Long userId = ContextUtil.getUserId();
            QFilter qfInventory = new QFilter("inventperson", "=", (Object)userId);
            qfInventory.or(new QFilter("inventorychecker.fbasedataid", "=", (Object)userId));
            e.getQFilters().add(qfInventory);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"inventoryassign"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"inventorywithdrawal"});
            LicenseCheckResult result = LicenseServiceHelper.checkByAppAndBizObj((String)"/OSOW2CPH91+", (String)"fap_apphome", (Long)userId);
            if (result != null && !result.getHasLicense().booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"inventorynotice"});
            }
        } else {
            e.getQFilters().add(new QFilter("inventsscopeid.inventschemeentry", "=", schemeId));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"inventorycreaterecord"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"inventorynotice"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"inventorydelete"});
        }
        ArrayList filters = new ArrayList(e.getQFilters());
        String selectFields = Fa.comma((String[])new String[]{"id", "inventschemeid", "splitfieldvalue", Fa.dot((String[])new String[]{"inventsscopeid", "assetunit", "id"}), "status"});
        DynamicObjectCollection inventoryTasks = QueryServiceHelper.query((String)"fa_inventory_task", (String)selectFields, (QFilter[])filters.toArray(filters.toArray(new QFilter[0])));
        this.map = FaInventoryUtils.updateProgress(inventoryTasks);
        this.splitFields = FaInventoryUtils.getSplitFields(inventoryTasks);
        this.initbaseNameMap(this.splitFields);
        this.setColumnVisible(this.splitFields);
        this.setColumnName();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("name".equalsIgnoreCase(key)) {
            Object rowPk = ((IListView)this.getView()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
            this.viewInventoryRecord(rowPk);
        }
        super.click(evt);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!FaUtils.isF7((IFormView)this.getView())) {
            BillList billList = (BillList)this.getControl("BillListAp");
            HyperLinkClickEvent hyperClick = args.getHyperLinkClickEvent();
            if ("inventsscopeid_assetunit_name".equals(hyperClick.getFieldName())) {
                Object rowPk = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                args.setCancel(true);
                this.viewInventoryRecord(rowPk);
            }
        }
    }

    private void viewInventoryRecord(Object rowPk) {
        String selectFields = "inventschemeid, inventsscopeid.assetunit";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", rowPk)};
        DynamicObject inventTask = QueryServiceHelper.queryOne((String)"fa_inventory_task", (String)selectFields, (QFilter[])filters);
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setCaption(ResManager.loadKDString((String)"\u76d8\u70b9\u8bb0\u5f55", (String)"FaInventoryTaskList_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam("inventorytaskid", rowPk);
        parameter.setCustomParam("inventschemaid", (Object)String.valueOf(inventTask.getLong("inventschemeid")));
        parameter.setCustomParam("inventassetunitid", (Object)String.valueOf(inventTask.getLong("inventsscopeid.assetunit")));
        Object schemeId = this.getView().getFormShowParameter().getCustomParam("schemeId");
        parameter.setCustomParam("showAuditBar", (Object)(schemeId == null ? 1 : 0));
        parameter.setBillFormId("fa_inventory_record");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new FaInventoryTaskListProvide());
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ColumnDesc) {
            ColumnDesc columnDesc = (ColumnDesc)e.getSource();
            String columnName = columnDesc.getKey();
            long rowId = e.getRowData().getLong("id");
            if (this.baseNameMap.containsKey(columnName)) {
                Map<String, Set<Long>> baseDataMap = this.idAndBaseDataMap.get(rowId);
                if (baseDataMap.size() == 0 || null == baseDataMap.get(this.baseNameMap.get(columnName)) || baseDataMap.get(this.baseNameMap.get(columnName)).size() == 0) {
                    return;
                }
                Set<Long> ids = baseDataMap.get(this.baseNameMap.get(columnName));
                ArrayList<String> names = new ArrayList<String>(ids.size());
                Map<Long, String> idAndNamesMap = this.resultMap.get(this.baseNameMap.get(columnName));
                for (Long id : ids) {
                    names.add(idAndNamesMap.get(id));
                }
                e.setFormatValue((Object)FaInventoryUtils.getAllNamesString(names));
            }
            if ("inventprogress".equals(columnName) && !this.map.isEmpty() && this.map.get(rowId) != null) {
                e.setFormatValue((Object)this.map.get(rowId).get("inventRate"));
            }
            if ("auditprogress".equals(columnName) && !this.map.isEmpty() && this.map.get(rowId) != null) {
                e.setFormatValue((Object)this.map.get(rowId).get("auditRate"));
            }
        }
        super.packageData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IListView view = (IListView)this.getView();
        String opMsg = ResManager.loadKDString((String)"\u6210\u529f", (String)"FaInventoryTaskList_3", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (selectedRows.size() < 1 && !key.equals("tblrefresh") && !key.equals("tblclose")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u64cd\u4f5c\u3002", (String)"FaInventoryTaskList_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("inventorynotice".equals(key)) {
            int rowNum = this.isSchemeClose(selectedRows);
            if (rowNum != -1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7b2c%s\u884c\uff1a\u76d8\u70b9\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u8fdb\u884c\u76d8\u70b9\u901a\u77e5\u3002", (String)"FaInventoryTaskList_5", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowNum));
                return;
            }
            ArrayList<Long> inventoryTaskPks = new ArrayList<Long>();
            for (ListSelectedRow selectedRow : selectedRows) {
                DynamicObject everyRow = BusinessDataServiceHelper.loadSingle((Object)String.valueOf(selectedRow), (String)"fa_inventory_task");
                String status = (String)everyRow.get("status");
                if (!BillStatus.C.toString().equals(status)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u76d8\u70b9\u8bb0\u5f55\u3002", (String)"FaInventoryTaskList_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                inventoryTaskPks.add((Long)selectedRow.getPrimaryKeyValue());
            }
            try {
                this.getPageCache().put("inventoryTaskPks", JSONUtils.toString(inventoryTaskPks));
            }
            catch (IOException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u76d8\u70b9\u901a\u77e5\u6709\u8bef\u3002", (String)"FaInventoryTaskList_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            FormShowParameter para = new FormShowParameter();
            para.setFormId("fa_countingreport_message");
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "getmessage"));
            this.getView().showForm(para);
            return;
        }
        if ("inventoryassign".equals(key)) {
            int rowNum = this.isSchemeClose(selectedRows);
            if (rowNum != -1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7b2c%s\u884c\uff1a\u76d8\u70b9\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u4e0b\u8fbe\u4efb\u52a1\u3002", (String)"FaInventoryTaskList_8", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowNum));
                return;
            }
            StringBuilder notRightStatus = new StringBuilder();
            FaOperateLogUtil.OpNameInfo opNameInfo = new FaOperateLogUtil.OpNameInfo("assign a mission", new MultiLangEnumBridge("\u4e0b\u8fbe\u4efb\u52a1", "FaInventoryTaskList_9", "fi-fa-formplugin"));
            for (ListSelectedRow selectedRow : selectedRows) {
                FaOperateLogUtil.OpDescriptionInfo opDescriptionInfo;
                DynamicObject inventoryTask = BusinessDataServiceHelper.loadSingle((Object)String.valueOf(selectedRow), (String)"fa_inventory_task");
                String assetUnitName = inventoryTask.getDynamicObject("inventsscopeid").getDynamicObject("assetunit").getString("name");
                long assetUnitId = inventoryTask.getDynamicObject("inventsscopeid").getDynamicObject("assetunit").getLong("id");
                String status = inventoryTask.getString("status");
                if (!BillStatus.A.toString().equals(status)) {
                    notRightStatus.append(assetUnitName).append(' ');
                    opDescriptionInfo = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("%s\u4e0b\u8fbe\u5931\u8d25,\u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u672a\u4e0b\u8fbe\u3002", "FaInventoryTaskList_10", "fi-fa-formplugin"), new String[]{assetUnitName});
                    FaOperateLogUtil.addLog((String)"fa_inventory_task", (Long)assetUnitId, (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo);
                    continue;
                }
                inventoryTask.set("status", (Object)BillStatus.B.toString());
                SaveServiceHelper.save((IDataEntityType)inventoryTask.getDataEntityType(), (Object[])new DynamicObject[]{inventoryTask});
                opDescriptionInfo = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("\u76d8\u70b9\u4efb\u52a1\uff08\u7f16\u7801\uff1a%s\uff09\u4e0b\u8fbe\u6210\u529f\u3002", "FaInventoryTaskList_11", "fi-fa-formplugin"), new String[]{assetUnitName});
                FaOperateLogUtil.addLog((String)"fa_inventory_task", (Long)assetUnitId, (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo);
            }
            if (notRightStatus.length() > 0) {
                opMsg = String.format(ResManager.loadKDString((String)"%s\u4e0b\u8fbe\u5931\u8d25,\u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u672a\u4e0b\u8fbe\u3002", (String)"FaInventoryTaskList_10", (String)"fi-fa-formplugin", (Object[])new Object[0]), notRightStatus);
                this.getView().showTipNotification(opMsg);
            } else {
                opMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u4e0b\u8fbe\u6210\u529f\u3002", (String)"FaInventoryTaskList_12", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(opMsg);
            }
            this.getView().invokeOperation("refresh");
            return;
        }
        if ("inventorywithdrawal".equals(key)) {
            int rowNum = this.isSchemeClose(selectedRows);
            if (rowNum != -1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7b2c%s\u884c\uff1a\u76d8\u70b9\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u64a4\u9500\u4efb\u52a1\u3002", (String)"FaInventoryTaskList_13", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowNum));
                return;
            }
            StringBuilder notRightStatus = new StringBuilder();
            FaOperateLogUtil.OpNameInfo opNameInfo = new FaOperateLogUtil.OpNameInfo("cancel task", new MultiLangEnumBridge("\u64a4\u9500\u4efb\u52a1", "FaInventoryTaskList_14", "fi-fa-formplugin"));
            for (ListSelectedRow selectedRow : selectedRows) {
                DynamicObject inventoryTask = BusinessDataServiceHelper.loadSingle((Object)String.valueOf(selectedRow), (String)"fa_inventory_task");
                String assetUnitName = inventoryTask.getDynamicObject("inventsscopeid").getDynamicObject("assetunit").getString("name");
                long assetUnitId = inventoryTask.getDynamicObject("inventsscopeid").getDynamicObject("assetunit").getLong("id");
                String status = inventoryTask.getString("status");
                if (!BillStatus.B.toString().equals(status)) {
                    notRightStatus.append(assetUnitName).append(' ');
                    FaOperateLogUtil.OpDescriptionInfo opDescriptionInfo4Failed = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("\u76d8\u70b9\u4efb\u52a1\uff08\u7f16\u7801\uff1a%s\uff09\u64a4\u9500\u5931\u8d25\uff0c\u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u201c\u5df2\u4e0b\u8fbe\u201d\u3002", "FaInventoryTaskList_15", "fi-fa-formplugin"), new String[]{assetUnitName});
                    FaOperateLogUtil.addLog((String)"fa_inventory_task", (Long)assetUnitId, (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo4Failed);
                    continue;
                }
                inventoryTask.set("status", (Object)"A");
                inventoryTask.set("inventorychecker", null);
                SaveServiceHelper.save((IDataEntityType)inventoryTask.getDataEntityType(), (Object[])new DynamicObject[]{inventoryTask});
                FaOperateLogUtil.OpDescriptionInfo opDescriptionInfo4Success = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("\u76d8\u70b9\u4efb\u52a1\uff08\u7f16\u7801\uff1a%s\uff09\u64a4\u9500\u4efb\u52a1\u6210\u529f\u3002", "FaInventoryTaskList_16", "fi-fa-formplugin"), new String[]{assetUnitName});
                FaOperateLogUtil.addLog((String)"fa_inventory_task", (Long)assetUnitId, (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo4Success);
            }
            if (notRightStatus.length() > 0) {
                opMsg = String.format(ResManager.loadKDString((String)"\u76d8\u70b9\u4efb\u52a1\uff08\u7f16\u7801\uff1a%s\uff09\u64a4\u9500\u5931\u8d25\uff0c\u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u201c\u5df2\u4e0b\u8fbe\u201d\u3002", (String)"FaInventoryTaskList_15", (String)"fi-fa-formplugin", (Object[])new Object[0]), notRightStatus);
                this.getView().showTipNotification(opMsg);
            } else {
                opMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u64a4\u9500\u6210\u529f\u3002", (String)"FaInventoryTaskList_17", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(opMsg);
            }
            this.getView().invokeOperation("refresh");
            return;
        }
        if ("inventorycreaterecord".equals(key)) {
            int rowNum = this.isSchemeClose(selectedRows);
            if (rowNum != -1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7b2c%s\u884c\uff1a\u76d8\u70b9\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u751f\u6210\u76d8\u70b9\u8bb0\u5f55\u3002", (String)"FaInventoryTaskList_18", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowNum));
                return;
            }
            StringBuilder notRightStatus = new StringBuilder();
            FaOperateLogUtil.OpNameInfo opNameInfo = new FaOperateLogUtil.OpNameInfo("generate inventory records", new MultiLangEnumBridge("\u751f\u6210\u76d8\u70b9\u8bb0\u5f55", "FaInventoryTaskList_19", "fi-fa-formplugin"));
            for (ListSelectedRow selectedRow : selectedRows) {
                DynamicObject inventoryTask = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"fa_inventory_task");
                DynamicObject inventorySope = inventoryTask.getDynamicObject("inventsscopeid");
                if (inventorySope == null) {
                    return;
                }
                String status = inventoryTask.getString("status");
                Object assetUnitId = inventorySope.get("assetunit_id");
                String unitName = inventoryTask.getDynamicObject("inventsscopeid").getDynamicObject("assetunit").getString("name");
                if (!BillStatus.B.toString().equals(status)) {
                    notRightStatus.append(unitName).append(' ');
                    FaOperateLogUtil.OpDescriptionInfo opDescriptionInfo = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("%s\u751f\u6210\u5931\u8d25,\u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u5df2\u4e0b\u8fbe\u3002", "FaInventoryTaskList_20", "fi-fa-formplugin"), new String[]{unitName});
                    FaOperateLogUtil.addLog((String)"fa_inventory_task", (Long)((Long)assetUnitId), (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo);
                    continue;
                }
                MainEntityType inventoryRecordType = EntityMetadataCache.getDataEntityType((String)"fa_inventory_record");
                Date finaccountdate = inventorySope.getDate("finaccountdate");
                QFilter timeLimitCond = new QFilter("realaccountdate", "<=", (Object)finaccountdate);
                QFilter billstatusCond = new QFilter("billstatus", "=", (Object)BillStatus.C.toString());
                QFilter assetunitCond = new QFilter("assetunit_id", "=", assetUnitId);
                QFilter bizstatusDeleteCond = new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE);
                QFilter notIsBackAndOther = new QFilter("isbak", "=", (Object)false);
                String splitfieldvalue = inventoryTask.getString("splitfieldvalue");
                if (!StringUtils.isBlank((String)splitfieldvalue)) {
                    Map maps = (Map)JSON.parse((String)splitfieldvalue);
                    for (Map.Entry entry : maps.entrySet()) {
                        Set idSet;
                        String keySet = (String)entry.getKey();
                        Object valueSet = entry.getValue();
                        if (valueSet == null) continue;
                        ArrayList idList = null;
                        String assetcatIds = (String)valueSet;
                        if (!StringUtils.isBlank((String)assetcatIds) && (idList = new ArrayList(idSet = Arrays.asList(assetcatIds.split(",")).stream().map(s -> Long.parseLong(StringUtils.isBlank((String)s) ? "0" : s.trim())).collect(Collectors.toSet()))).size() == 1 && ((Long)idList.get(0)).equals(0L)) {
                            idList = null;
                        }
                        QFilter assetIds = null;
                        if (idList != null) {
                            assetIds = "assetcat".equals(keySet) ? new QFilter("assetcat_id", "in", FaAssetTypeUtils.getAllSubAssetTypes(idList)) : new QFilter(keySet + "_id", "in", idList);
                        }
                        if (assetIds == null) continue;
                        notIsBackAndOther.and(assetIds);
                    }
                }
                String sicOnlyId = Fa.join((String)",", (String[])new String[]{"id"});
                String sic = Fa.join((String)",", (String[])new String[]{"id,number,barcode,assetname,model,assetamount,unit,headuseperson"});
                DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)sicOnlyId, (QFilter[])new QFilter[]{assetunitCond, timeLimitCond, billstatusCond, bizstatusDeleteCond, notIsBackAndOther});
                HashSet<Long> cardIds = new HashSet<Long>();
                for (DynamicObject realCard : realCards) {
                    cardIds.add(realCard.getLong("id"));
                }
                int i = 0;
                HashSet<Long> cardId = new HashSet<Long>();
                try {
                    Iterator ite = cardIds.iterator();
                    while (ite.hasNext()) {
                        if (i == DATA_SIZE) {
                            this.createInventoryRedords(inventoryRecordType, inventoryTask, sic, cardId);
                            cardId = new HashSet();
                            i = 0;
                            continue;
                        }
                        cardId.add((Long)ite.next());
                        ++i;
                    }
                    if (!cardId.isEmpty()) {
                        this.createInventoryRedords(inventoryRecordType, inventoryTask, sic, cardId);
                    }
                    inventoryTask.set("status", (Object)"C");
                    SaveServiceHelper.save((IDataEntityType)inventoryTask.getDataEntityType(), (Object[])new DynamicObject[]{inventoryTask});
                    FaOperateLogUtil.OpDescriptionInfo opDescriptionInfo4Success = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("\u76d8\u70b9\u4efb\u52a1\uff08\u7f16\u7801\uff1a%s\uff09\u751f\u6210\u76d8\u70b9\u8bb0\u5f55\u6210\u529f\u3002", "FaInventoryTaskList_21", "fi-fa-formplugin"), new String[]{unitName});
                    FaOperateLogUtil.addLog((String)"fa_inventory_task", (Long)((Long)assetUnitId), (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo4Success);
                }
                catch (Exception e) {
                    FaOperateLogUtil.OpDescriptionInfo opDescriptionInfo4Error = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("%1$s\u751f\u6210\u76d8\u70b9\u8bb0\u5f55\u4e8b\u52a1\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\uff1a%2$s\u3002", "FaInventoryTaskList_22", "fi-fa-formplugin"), new String[]{unitName, e.getMessage()});
                    FaOperateLogUtil.addLog((String)"fa_inventory_task", (Long)((Long)assetUnitId), (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo4Error);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u751f\u6210\u76d8\u70b9\u8bb0\u5f55\u4e8b\u52a1\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\uff1a%2$s\u3002", (String)"FaInventoryTaskList_22", (String)"fi-fa-formplugin", (Object[])new Object[0]), unitName, e.getMessage()));
                }
            }
            if (notRightStatus.length() > 0) {
                int unSuccess = notRightStatus.toString().split(" ").length;
                int success = selectedRows.size() - unSuccess;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f%1$d\u6761\uff0c\u5931\u8d25%2$d\u6761\uff0c\u5176\u4e2d[%3$s]\u751f\u6210\u5931\u8d25,\u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u5df2\u4e0b\u8fbe\u3002", (String)"FaInventoryTaskList_23", (String)"fi-fa-formplugin", (Object[])new Object[0]), success, unSuccess, notRightStatus));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u76d8\u70b9\u8bb0\u5f55\u6210\u529f\u3002", (String)"FaInventoryTaskList_24", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
            return;
        }
        if ("inventorydelete".equals(key)) {
            int rowNum = this.isSchemeClose(selectedRows);
            if (rowNum != -1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7b2c%s\u884c\uff1a\u76d8\u70b9\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u6e05\u9664\u76d8\u70b9\u8bb0\u5f55\u3002", (String)"FaInventoryTaskList_25", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowNum));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u6e05\u9664\u4efb\u52a1\u4e0b\u6240\u6709\u7684\u76d8\u70b9\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\u3002", (String)"FaInventoryTaskList_26", (String)"fi-fa-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener("inventorydelete", (IFormPlugin)this));
            return;
        }
        if (ASSIGNINVENTORY.equals(key)) {
            int rowNum = this.isSchemeClose(selectedRows);
            if (rowNum != -1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7b2c%s\u884c\uff1a\u76d8\u70b9\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u6307\u5b9a\u76d8\u70b9\u4eba\u3002", (String)"FaInventoryTaskList_27", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowNum));
                return;
            }
            this.assignInventory();
        }
    }

    private int isSchemeClose(ListSelectedRowCollection selectedRows) {
        DynamicObject[] selectDynamicObject;
        for (DynamicObject selectDO : selectDynamicObject = this.getSelectDynamicObjcet()) {
            if (!"C".equals(selectDO.getString("inventschemeid.billstate"))) continue;
            for (ListSelectedRow selectRow : selectedRows) {
                if (selectDO.getLong("id") != ((Long)selectRow.getPrimaryKeyValue()).longValue()) continue;
                return selectRow.getRowKey() + 1;
            }
        }
        return -1;
    }

    private void assignInventory() {
        DynamicObject[] selectDys = this.getSelectDynamicObjcet();
        if (selectDys == null) {
            return;
        }
        long userId = ContextUtil.getUserId();
        for (DynamicObject dy : selectDys) {
            if (userId == dy.getLong("inventperson_id") || userId == dy.getDynamicObject("inventschemeid").getDynamicObject("creator").getLong("id")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u76d8\u70b9\u8d1f\u8d23\u4eba\u548c\u65b9\u6848\u521b\u5efa\u4eba\u6307\u5b9a\u76d8\u70b9\u4eba\u3002", (String)"FaInventoryTaskList_28", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showUserForm();
    }

    private void showUserForm() {
        ListShowParameter param = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ASSIGNINVENTORY));
        param.setCustomParam("skipCheckSelectRows", (Object)true);
        DynamicObject[] selectDys = this.getSelectDynamicObjcet();
        ArrayList selectids = new ArrayList(10);
        Arrays.asList(selectDys).stream().forEach(v -> {
            List collect = v.getDynamicObjectCollection("inventorychecker").stream().map(t -> t.getLong("fbasedataid_id")).collect(Collectors.toList());
            selectids.addAll(collect);
        });
        param.setSelectedRows(selectids.toArray());
        this.getView().showForm((FormShowParameter)param);
    }

    private void createInventoryRedords(MainEntityType inventoryRecordType, DynamicObject inventoryTask, String sic, Set<Long> cardId) {
        try (TXHandle h = TX.requiresNew();){
            try {
                DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)sic, (QFilter[])new QFilter[]{new QFilter("id", "in", cardId)});
                DynamicObject inventoryRecordEntity = (DynamicObject)inventoryRecordType.createInstance();
                ArrayList<DynamicObject> inventoryRecordList = new ArrayList<DynamicObject>();
                for (DynamicObject realCard : realCards) {
                    DynamicObject inventoryRecordInstance = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityType)inventoryRecordType, (Object)inventoryRecordEntity);
                    inventoryRecordInstance.set("realCard_id", realCard.get("id"));
                    inventoryRecordInstance.set("number", (Object)realCard.getString("number"));
                    inventoryRecordInstance.set("barcode", (Object)realCard.getString("barcode"));
                    inventoryRecordInstance.set("name", (Object)realCard.getString("assetname"));
                    inventoryRecordInstance.set("model", (Object)realCard.getString("model"));
                    inventoryRecordInstance.set("bookquantity", (Object)realCard.getBigDecimal("assetamount"));
                    inventoryRecordInstance.set("unit_id", realCard.get("unit"));
                    inventoryRecordInstance.set("inventoryquantity", (Object)BigDecimal.ZERO);
                    inventoryRecordInstance.set("difference", (Object)BigDecimal.ZERO);
                    inventoryRecordInstance.set("inventorystate", (Object)BillStatus.B.toString());
                    inventoryRecordInstance.set("reason", (Object)" ");
                    inventoryRecordInstance.set("inventorytask_id", inventoryTask.getPkValue());
                    inventoryRecordInstance.set("inventschemeentry_id", inventoryTask.getDynamicObject("inventsscopeid").getDynamicObject("inventschemeentry").getPkValue());
                    inventoryRecordInstance.set("billstatus", (Object)"C");
                    inventoryRecordInstance.set("billstate", (Object)"A");
                    inventoryRecordList.add(inventoryRecordInstance);
                }
                if (inventoryRecordList.size() > 0) {
                    SaveServiceHelper.save((IDataEntityType)inventoryRecordType, (Object[])inventoryRecordList.toArray(new DynamicObject[0]));
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("inventorydelete".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            StringBuilder notRightStatus = new StringBuilder();
            StringBuilder notBillStatus = new StringBuilder();
            FaOperateLogUtil.OpNameInfo opNameInfo = new FaOperateLogUtil.OpNameInfo("clearing inventory record", new MultiLangEnumBridge("\u6e05\u9664\u76d8\u70b9\u8bb0\u5f55", "FaInventoryTaskList_29", "fi-fa-formplugin"));
            for (ListSelectedRow selectedRow : selectedRows) {
                DynamicObject inventoryTask = BusinessDataServiceHelper.loadSingle((Object)String.valueOf(selectedRow), (String)"fa_inventory_task");
                DynamicObject inventorySope = inventoryTask.getDynamicObject("inventsscopeid");
                if (inventorySope == null) {
                    return;
                }
                Object assetunitId = inventorySope.get("assetunit_id");
                String assetUnitName = inventorySope.getDynamicObject("assetunit").getString("name");
                String status = inventoryTask.getString("status");
                if (!BillStatus.C.toString().equals(status)) {
                    notRightStatus.append(assetUnitName).append(' ');
                    FaOperateLogUtil.OpDescriptionInfo opDescriptionInfo = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("%s\u5220\u9664\u76d8\u70b9\u8bb0\u5f55\u5931\u8d25,\u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u5df2\u751f\u6210\u3002", "FaInventoryTaskList_30", "fi-fa-formplugin"), new String[]{assetUnitName});
                    FaOperateLogUtil.addLog((String)"fa_inventory_task", (Long)((Long)assetunitId), (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo);
                    continue;
                }
                QFilter qfBillStatus = new QFilter("billstate", "=", (Object)"C");
                QFilter qfInventoryTask = new QFilter("inventorytask", "=", inventoryTask.getPkValue());
                boolean exists = QueryServiceHelper.exists((String)"fa_inventory_record", (QFilter[])new QFilter[]{qfInventoryTask, qfBillStatus});
                if (exists) {
                    notBillStatus.append(assetUnitName).append(' ');
                    FaOperateLogUtil.OpDescriptionInfo opDescriptionInfo = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("%s\u5220\u9664\u76d8\u70b9\u8bb0\u5f55\u5931\u8d25,\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u76d8\u70b9\u8bb0\u5f55\u3002", "FaInventoryTaskList_31", "fi-fa-formplugin"), new String[]{assetUnitName});
                    FaOperateLogUtil.addLog((String)"fa_inventory_task", (Long)((Long)assetunitId), (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo);
                    continue;
                }
                Object inventoryTaskPk = selectedRow.getPrimaryKeyValue();
                QFilter inventoryTaskPkCond = new QFilter("inventorytask_id", "=", inventoryTaskPk);
                DeleteServiceHelper.delete((String)"fa_inventory_record", (QFilter[])new QFilter[]{inventoryTaskPkCond});
                QFilter qInventoryTaskPk = new QFilter("inventorytask_id", "=", inventoryTaskPk);
                DeleteServiceHelper.delete((String)"fa_inventory_entrust", (QFilter[])new QFilter[]{qInventoryTaskPk});
                inventoryTask.set("status", (Object)BillStatus.B.toString());
                SaveServiceHelper.save((IDataEntityType)inventoryTask.getDataEntityType(), (Object[])new DynamicObject[]{inventoryTask});
                FaOperateLogUtil.OpDescriptionInfo opDescriptionInfo4Success = new FaOperateLogUtil.OpDescriptionInfo(new MultiLangEnumBridge("%s\u5220\u9664\u76d8\u70b9\u8bb0\u5f55\u6210\u529f\u3002", "FaInventoryTaskList_32", "fi-fa-formplugin"), new String[]{assetUnitName});
                FaOperateLogUtil.addLog((String)"fa_inventory_task", (Long)((Long)assetunitId), (FaOperateLogUtil.OpNameInfo)opNameInfo, (FaOperateLogUtil.OpDescriptionInfo)opDescriptionInfo4Success);
            }
            if (notBillStatus.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5220\u9664\u76d8\u70b9\u8bb0\u5f55\u5931\u8d25,\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u76d8\u70b9\u8bb0\u5f55\u3002", (String)"FaInventoryTaskList_31", (String)"fi-fa-formplugin", (Object[])new Object[0]), notRightStatus));
            } else if (notRightStatus.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5220\u9664\u76d8\u70b9\u8bb0\u5f55\u5931\u8d25\uff0c\u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u5df2\u751f\u6210\u3002", (String)"FaInventoryTaskList_33", (String)"fi-fa-formplugin", (Object[])new Object[0]), notRightStatus));
            } else {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u5220\u9664\u76d8\u70b9\u8bb0\u5f55\u6210\u529f\u3002", (String)"FaInventoryTaskList_32", (String)"fi-fa-formplugin", (Object[])new Object[0]), ""));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (ASSIGNINVENTORY.equals(closedCallBackEvent.getActionId())) {
            DynamicObjectCollection proto = this.buildMulBasedata((ListSelectedRowCollection)returnData);
            DynamicObject[] selectDys = this.getSelectDynamicObjcet();
            CloneUtils c = new CloneUtils(true, true);
            for (DynamicObject dy : selectDys) {
                ArrayList<DynamicObject> collection = new ArrayList<DynamicObject>(10);
                for (DynamicObject protoDy : proto) {
                    collection.add((DynamicObject)c.clone(((DynamicObject)proto.get(0)).getDataEntityType(), (Object)protoDy));
                }
                dy.set("inventorychecker", collection);
            }
            SaveServiceHelper.save((DynamicObject[])selectDys);
            this.getView().updateView();
            return;
        }
        if ("getmessage".equals(closedCallBackEvent.getActionId())) {
            IAppCache cacheDepreCheck = AppCache.get((String)"fa");
            String title = (String)cacheDepreCheck.get("countingreport_message_title", String.class);
            this.sendMessage(returnData.toString(), title);
        }
    }

    private DynamicObjectCollection buildMulBasedata(ListSelectedRowCollection selectedRows) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        MainEntityType mainInventory = EntityMetadataCache.getDataEntityType((String)"fa_inventory_task");
        MulBasedataProp mulBasedataProp = (MulBasedataProp)mainInventory.findProperty("inventorychecker");
        DynamicObjectType dynamicCollectionItemPropertyType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        for (ListSelectedRow row : selectedRows) {
            DynamicObject dy = new DynamicObject(dynamicCollectionItemPropertyType);
            dy.set("fbasedataid", row.getPrimaryKeyValue());
            dy.set("fbasedataid_id", row.getPrimaryKeyValue());
            collection.add((Object)dy);
        }
        return collection;
    }

    public static void inventoryAssign(Object[] pkArray) {
        QFilter filtersPk = new QFilter("id", "in", (Object)pkArray);
        DynamicObject[] inventoryTasks = BusinessDataServiceHelper.load((String)"fa_inventory_task", (String)"status", (QFilter[])new QFilter[]{filtersPk});
        ArrayList<DynamicObject> inventoryTasksNeedChange = new ArrayList<DynamicObject>(inventoryTasks.length);
        for (DynamicObject inventoryTask : inventoryTasks) {
            inventoryTask.set("status", (Object)BillStatus.B.toString());
            inventoryTasksNeedChange.add(inventoryTask);
        }
        if (inventoryTasksNeedChange.size() > 0) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)inventoryTasksNeedChange.get(0)).getDataEntityType(), (Object[])inventoryTasksNeedChange.toArray());
        }
    }

    private void sendMessage(String content, String title) {
        MessageInfo message = new MessageInfo();
        message.setType("message");
        if (StringUtils.isNotEmpty((String)title)) {
            message.setTitle(title);
        } else {
            message.setTitle(ResManager.loadKDString((String)"\u4eba\u4eba\u8d44\u4ea7-\u76d8\u70b9", (String)"FaInventoryTaskList_34", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        List inventoryTaskPks = (List)SerializationUtils.fromJsonString((String)String.valueOf(this.getPageCache().get("inventoryTaskPks")), List.class);
        for (Long inventoryTaskPk : inventoryTaskPks) {
            List<Long> assetInventors = this.getAssetInventors(inventoryTaskPk);
            message.setUserIds(assetInventors);
            message.setSenderId(ContextUtil.getUserId());
            message.setSendTime(new Date(System.currentTimeMillis()));
            message.setEntityNumber("fa_inventory_task");
            Long pkid = inventoryTaskPk;
            message.setBizDataId(pkid);
            message.setTag(ResManager.loadKDString((String)"\u4eba\u4eba\u8d44\u4ea7", (String)"FaInventoryTaskList_35", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            String clientUrl = UrlService.getDomainContextUrl();
            StringBuilder urlWithEncodedParams = new StringBuilder(clientUrl);
            if (!clientUrl.trim().endsWith("/")) {
                urlWithEncodedParams.append("/");
            }
            String strMobContentUrl = "%sintegration/yzjShareOpen.do?mb_formId=fa_mobile_inventpage&pkId=%s&device=mob&accountId=%s";
            message.setMobContentUrl(String.format(strMobContentUrl, urlWithEncodedParams.toString(), pkid, RequestContext.get().getAccountId()));
            log.info("FaInventoryTaskList-message-MobContentUrl-is " + message.getMobContentUrl());
            String strContentUrl = "%sindex.html?formId=fa_inventory_task&pkId=%s";
            message.setContentUrl(String.format(strContentUrl, urlWithEncodedParams.toString(), pkid));
            log.info("FaInventoryTaskList-message-ContentUrl-is " + message.getContentUrl());
            message.setContent(content);
            log.info("FaInventoryTaskList-message-Content-is " + message.getContent());
            message.setPubaccNumber("systempubacc");
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            this.getView().showMessage(ResManager.loadKDString((String)"\u53d1\u9001\u666e\u901a\u6d88\u606f\u7ed9\u201c\u7cfb\u7edf\u7ea7\u6d88\u606f\u52a9\u624b\u201d\u6210\u529f\u3002", (String)"FaInventoryTaskList_36", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Long> getAssetInventors(Long inventoryTaskPk) {
        HashSet<Long> assetInventors = new HashSet<Long>();
        String sic = Fa.join((String)",", (String[])new String[]{"realcard.headuseperson.id"});
        QFilter filters1 = new QFilter("inventorytask", "=", (Object)inventoryTaskPk);
        filters1.and("inventorystate", "=", (Object)BillStatus.B);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)FaInventoryTaskList.class.getName(), (String)"fa_inventory_record", (String)sic, (QFilter[])new QFilter[]{filters1}, null);
        for (Row row : dataSet) {
            assetInventors.add(row.getLong("realcard.headuseperson.id"));
        }
        return new ArrayList<Long>(assetInventors);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private void setDefaultQuerySelect(FilterContainerInitArgs filtercontainerinitargs) {
        List listFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getCommonFilterColumns();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object schemeId = customParams.get("schemeId");
        Long userId = ContextUtil.getUserId();
        ArrayList<ComboItem> comboItemsStatus = new ArrayList<ComboItem>();
        ComboItem a = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u672a\u4e0b\u8fbe", (String)"FaInventoryTaskList_37", (String)"fi-fa-formplugin", (Object[])new Object[0])), BillStatus.A.toString());
        ComboItem b = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5df2\u4e0b\u8fbe", (String)"FaInventoryTaskList_38", (String)"fi-fa-formplugin", (Object[])new Object[0])), BillStatus.B.toString());
        ComboItem c = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5df2\u751f\u6210", (String)"FaInventoryTaskList_39", (String)"fi-fa-formplugin", (Object[])new Object[0])), "C");
        if (schemeId != null) {
            this.getPageCache().put("schemeIds", SerializationUtils.serializeToBase64(schemeId));
            ListIterator deleteListFilterColumns = listFilterColumns.listIterator();
            while (deleteListFilterColumns.hasNext()) {
                String fieldName = ((FilterColumn)deleteListFilterColumns.next()).getFieldName();
                if (!"inventsscopeid.inventschemeentry.name".equals(fieldName)) continue;
                deleteListFilterColumns.remove();
            }
        } else {
            for (FilterColumn listFilter : listFilterColumns) {
                CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                String fieldName = commFilter.getFieldName();
                if ("inventsscopeid.inventschemeentry.name".equals(fieldName)) {
                    HashSet<ComboItem> comboItemsTrys = new HashSet<ComboItem>();
                    QFilter filtersUserid = new QFilter("inventperson", "=", (Object)userId);
                    filtersUserid.or(new QFilter("inventorychecker.fbasedataid", "=", (Object)userId));
                    QFilter filterStatus = new QFilter("status", "!=", (Object)"A");
                    QFilter filterStatusZ = new QFilter("status", "!=", (Object)"Z");
                    DynamicObjectCollection invenTasks = QueryServiceHelper.query((String)"fa_inventory_task", (String)"inventsscopeid", (QFilter[])new QFilter[]{filtersUserid, filterStatus, filterStatusZ});
                    Set scopeIds = invenTasks.stream().map(s -> s.getLong("inventsscopeid")).collect(Collectors.toSet());
                    QFilter scopeIdsQ = new QFilter("id", "in", scopeIds);
                    DynamicObjectCollection invenschemeetry = QueryServiceHelper.query((String)"fa_inventory_sope", (String)"inventschemeentry", (QFilter[])new QFilter[]{scopeIdsQ}, (String)"createtime desc");
                    Set schemeIds = invenschemeetry.stream().map(s -> s.getLong("inventschemeentry")).collect(Collectors.toSet());
                    this.getPageCache().put("schemeIds", SerializationUtils.serializeToBase64(schemeIds));
                    QFilter schemeIdsQ = new QFilter("id", "in", schemeIds);
                    DynamicObjectCollection inventschemes = QueryServiceHelper.query((String)"fa_inventscheme_new", (String)"id,name,entryentity.splitfieldentity.splitfield splitfield", (QFilter[])new QFilter[]{schemeIdsQ}, (String)"createtime desc");
                    for (DynamicObject inventscheme : inventschemes) {
                        ComboItem item = new ComboItem(new LocaleString(inventscheme.getString("name")), inventscheme.getString("id"));
                        comboItemsTrys.add(item);
                    }
                    if (!CollectionUtils.isEmpty((Collection)inventschemes)) {
                        commFilter.setDefaultValue(((DynamicObject)inventschemes.get(0)).getString("id"));
                    }
                    ArrayList allInventoryName = new ArrayList(comboItemsTrys);
                    commFilter.setComboItems(allInventoryName);
                    commFilter.setMustInput(true);
                    continue;
                }
                if (!"status".equals(fieldName)) continue;
                comboItemsStatus.add(a);
                comboItemsStatus.add(b);
                comboItemsStatus.add(c);
                commFilter.setComboItems(comboItemsStatus);
            }
        }
    }

    private DynamicObject[] getSelectDynamicObjcet() {
        QFilter qfIds = new QFilter("id", "in", (Object)this.getSelectedRows().getPrimaryKeyValues());
        return BusinessDataServiceHelper.load((String)"fa_inventory_task", (String)"inventorychecker,inventperson,inventschemeid", (QFilter[])new QFilter[]{qfIds});
    }

    private void initbaseNameMap(Set<String> splitfields) {
        int k = 0;
        for (String splitfield : splitfields) {
            String columnName = "entrytext" + k++;
            this.baseNameMap.put(columnName, splitfield);
        }
    }

    private void setColumnVisible(Set<String> splitfields) {
        for (String splitfield : splitfields) {
            for (Map.Entry<String, String> entry : this.baseNameMap.entrySet()) {
                if (!splitfield.equals(entry.getValue())) continue;
                this.columnNames.add(entry.getKey());
            }
        }
        BillList list = (BillList)this.getControl("billlistap");
        FaInventoryUtils.setColumnVisible(list.getView(), this.columnNames);
    }

    private void setColumnName() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        BeforeCreateListColumnsArgs args = billList.getBeforeCreateListColumnsArgs();
        if (null == args) {
            return;
        }
        for (String columnName : this.columnNames) {
            String entityId = this.baseNameMap.get(columnName);
            Map<String, Object> map = this.baseEntityIdMap.get(entityId);
            IListColumn listColumn = billList.getBeforeCreateListColumnsArgs().getListColumn(columnName);
            if (null == listColumn || null == map.get("displayName")) continue;
            listColumn.setCaption((LocaleString)map.get("displayName"));
        }
    }

    private class FaInventoryTaskListProvide
    extends ListDataProvider {
        private FaInventoryTaskListProvide() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            HashMap<String, Set<Long>> queryMap = new HashMap<String, Set<Long>>(FaInventoryTaskList.this.baseEntityIdMap.size(), 1.0f);
            for (String s : FaInventoryTaskList.this.baseEntityIdMap.keySet()) {
                queryMap.put(s, new HashSet());
            }
            for (DynamicObject row : rows) {
                Map<Object, Object> baseDataMap = new HashMap(16);
                String splitFieldObj = row.getString("splitfieldvalue");
                if (StringUtils.isNotEmpty((String)splitFieldObj)) {
                    baseDataMap = FaInventoryUtils.transferSplitFieldValue(splitFieldObj);
                }
                for (Map.Entry entry : baseDataMap.entrySet()) {
                    Set ids = (Set)queryMap.get(entry.getKey());
                    ids.addAll((Collection)entry.getValue());
                    queryMap.put((String)entry.getKey(), ids);
                }
                FaInventoryTaskList.this.idAndBaseDataMap.put(row.getLong("id"), baseDataMap);
            }
            FaInventoryUtils.setResultMapValue(queryMap, FaInventoryTaskList.this.baseEntityIdMap, FaInventoryTaskList.this.resultMap);
            return rows;
        }
    }
}

