/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FaInventoryTaskRuleFilterPlugin
extends AbstractFormPlugin {
    public void initialize() {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String assetUnit = (String)this.getView().getFormShowParameter().getCustomParam("assetunit");
        if (StringUtils.isEmpty((CharSequence)assetUnit)) {
            return;
        }
        this.addSelectListener(assetUnit, "headusedept");
        this.addSelectListener(assetUnit, "assetcat");
        this.addSelectListener(assetUnit, "storeplace");
    }

    private void addSelectListener(String assetUnit, String field) {
        BasedataEdit headUseDept = (BasedataEdit)this.getControl(field);
        headUseDept.addBeforeF7SelectListener(listener -> {
            ListShowParameter formShowParameter = (ListShowParameter)listener.getFormShowParameter();
            ListFilterParameter listFilter = formShowParameter.getListFilterParameter();
            String cacheStr = this.getPageCache().get(field);
            if (StringUtils.isEmpty((CharSequence)cacheStr)) {
                Set<Long> ids = this.queryGroupByProperty(field, assetUnit);
                listFilter.getQFilters().add(new QFilter("id", "in", ids));
                cacheStr = SerializationUtils.toJsonString(ids);
                this.getPageCache().put(field, cacheStr);
            } else {
                Set ids = (Set)SerializationUtils.fromJsonString((String)cacheStr, Set.class);
                listFilter.getQFilters().add(new QFilter("id", "in", (Object)ids));
            }
        });
    }

    private Set<Long> queryGroupByProperty(String prop, String assetUnit) {
        QFilter qFilter = new QFilter("assetunit", "in", (Object)Long.parseLong(assetUnit));
        HashSet<Long> props = new HashSet<Long>(10);
        try (DataSet propDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"fa_card_real", (String)prop, (QFilter[])new QFilter[]{qFilter}, null).groupBy(new String[]{prop}).finish();){
            while (propDs.hasNext()) {
                Row row = propDs.next();
                props.add(row.getLong(prop));
            }
        }
        return props;
    }
}

